/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2024 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Define the template match patterns */
/*
 * List of protocol matches
 */
struct bnxt_ulp_class_match_info ulp_class_match_list[] = {
	[1] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB800000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		},
	},
	[2] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[3] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[4] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA40000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[5] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA78000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		},
	},
	[6] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA36000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		},
	},
	[7] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[8] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[9] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[10] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[11] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49E00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 11,
		[54] = 12,
		[56] = 13,
		[58] = 14,
		[60] = 15,
		[62] = 16,
		[64] = 17,
		[66] = 18,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[12] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48D80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 11,
		[34] = 12,
		[36] = 13,
		[38] = 14,
		[40] = 15,
		[42] = 16,
		[44] = 17,
		[46] = 18,
		[48] = 19,
		[50] = 20,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[13] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 5,
		[84] = 6,
		[86] = 7,
		[88] = 8,
		[90] = 9,
		[92] = 10,
		[94] = 11,
		[96] = 12,
		[98] = 13,
		},
	},
	[14] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 5,
		[102] = 6,
		[104] = 7,
		[106] = 8,
		},
	},
	[15] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 8,
		[84] = 9,
		[86] = 10,
		[88] = 11,
		[90] = 12,
		[92] = 13,
		[94] = 14,
		[96] = 15,
		[98] = 16,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[16] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 8,
		[102] = 9,
		[104] = 10,
		[106] = 11,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[17] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 8,
		[84] = 9,
		[86] = 10,
		[88] = 11,
		[90] = 12,
		[92] = 13,
		[94] = 14,
		[96] = 15,
		[98] = 16,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[18] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 8,
		[102] = 9,
		[104] = 10,
		[106] = 11,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[19] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 11,
		[84] = 12,
		[86] = 13,
		[88] = 14,
		[90] = 15,
		[92] = 16,
		[94] = 17,
		[96] = 18,
		[98] = 19,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[20] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 11,
		[102] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[21] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[82] = 13,
		[84] = 14,
		[86] = 15,
		[88] = 16,
		[90] = 17,
		[92] = 18,
		[94] = 19,
		[96] = 20,
		[98] = 21,
		},
	},
	[22] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[82] = 15,
		[84] = 16,
		[86] = 17,
		[88] = 18,
		[90] = 19,
		[92] = 20,
		[94] = 21,
		[96] = 22,
		[98] = 23,
		},
	},
	[23] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		},
	},
	[24] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		},
	},
	[25] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[82] = 16,
		[84] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[26] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[82] = 18,
		[84] = 19,
		[86] = 20,
		[88] = 21,
		[90] = 22,
		[92] = 23,
		[94] = 24,
		[96] = 25,
		[98] = 26,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[27] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[100] = 16,
		[102] = 17,
		[104] = 18,
		[106] = 19,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[28] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[100] = 18,
		[102] = 19,
		[104] = 20,
		[106] = 21,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[29] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[82] = 16,
		[84] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[30] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[82] = 18,
		[84] = 19,
		[86] = 20,
		[88] = 21,
		[90] = 22,
		[92] = 23,
		[94] = 24,
		[96] = 25,
		[98] = 26,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[31] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[100] = 16,
		[102] = 17,
		[104] = 18,
		[106] = 19,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[32] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[100] = 18,
		[102] = 19,
		[104] = 20,
		[106] = 21,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[33] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 11,
		[54] = 12,
		[56] = 13,
		[58] = 14,
		[60] = 15,
		[62] = 16,
		[64] = 17,
		[66] = 18,
		[82] = 19,
		[84] = 20,
		[86] = 21,
		[88] = 22,
		[90] = 23,
		[92] = 24,
		[94] = 25,
		[96] = 26,
		[98] = 27,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[34] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 11,
		[34] = 12,
		[36] = 13,
		[38] = 14,
		[40] = 15,
		[42] = 16,
		[44] = 17,
		[46] = 18,
		[48] = 19,
		[50] = 20,
		[82] = 21,
		[84] = 22,
		[86] = 23,
		[88] = 24,
		[90] = 25,
		[92] = 26,
		[94] = 27,
		[96] = 28,
		[98] = 29,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[35] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 11,
		[54] = 12,
		[56] = 13,
		[58] = 14,
		[60] = 15,
		[62] = 16,
		[64] = 17,
		[66] = 18,
		[100] = 19,
		[102] = 20,
		[104] = 21,
		[106] = 22,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[36] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 11,
		[34] = 12,
		[36] = 13,
		[38] = 14,
		[40] = 15,
		[42] = 16,
		[44] = 17,
		[46] = 18,
		[48] = 19,
		[50] = 20,
		[100] = 21,
		[102] = 22,
		[104] = 23,
		[106] = 24,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[37] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A100000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[38] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[39] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[40] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[41] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105800000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[53] = 21,
		[54] = 6,
		[55] = 22,
		[56] = 7,
		[57] = 23,
		[58] = 8,
		[59] = 24,
		[60] = 9,
		[61] = 25,
		[62] = 10,
		[63] = 26,
		[64] = 11,
		[65] = 27,
		[66] = 12,
		[67] = 28,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[42] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841600000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[43] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101600000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[44] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840580000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[33] = 23,
		[34] = 6,
		[35] = 24,
		[36] = 7,
		[37] = 25,
		[38] = 8,
		[39] = 26,
		[40] = 9,
		[41] = 27,
		[42] = 10,
		[43] = 28,
		[44] = 11,
		[45] = 29,
		[46] = 12,
		[47] = 30,
		[48] = 13,
		[49] = 31,
		[50] = 14,
		[51] = 32,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[45] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170B00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[53] = 24,
		[54] = 6,
		[55] = 25,
		[56] = 7,
		[57] = 26,
		[58] = 8,
		[59] = 27,
		[60] = 9,
		[61] = 28,
		[62] = 10,
		[63] = 29,
		[64] = 11,
		[65] = 30,
		[66] = 12,
		[67] = 31,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[46] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2C0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 26,
		[55] = 27,
		[57] = 28,
		[59] = 29,
		[61] = 30,
		[63] = 31,
		[65] = 32,
		[67] = 33,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[47] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702C0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[33] = 24,
		[35] = 25,
		[37] = 26,
		[39] = 27,
		[41] = 28,
		[43] = 29,
		[45] = 30,
		[47] = 31,
		[49] = 32,
		[51] = 33,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[48] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0B0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[33] = 26,
		[34] = 6,
		[35] = 27,
		[36] = 7,
		[37] = 28,
		[38] = 8,
		[39] = 29,
		[40] = 9,
		[41] = 30,
		[42] = 10,
		[43] = 31,
		[44] = 11,
		[45] = 32,
		[46] = 12,
		[47] = 33,
		[48] = 13,
		[49] = 34,
		[50] = 14,
		[51] = 35,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[49] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 21,
		[85] = 22,
		[87] = 23,
		[89] = 24,
		[91] = 25,
		[93] = 26,
		[95] = 27,
		[97] = 28,
		[99] = 29,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[50] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[83] = 23,
		[85] = 24,
		[87] = 25,
		[89] = 26,
		[91] = 27,
		[93] = 28,
		[95] = 29,
		[97] = 30,
		[99] = 31,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[51] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 21,
		[102] = 14,
		[103] = 22,
		[104] = 15,
		[105] = 23,
		[106] = 16,
		[107] = 24,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[52] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[101] = 23,
		[102] = 16,
		[103] = 24,
		[104] = 17,
		[105] = 25,
		[106] = 18,
		[107] = 26,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[53] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 24,
		[85] = 25,
		[87] = 26,
		[89] = 27,
		[91] = 28,
		[93] = 29,
		[95] = 30,
		[97] = 31,
		[99] = 32,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[54] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[83] = 26,
		[85] = 27,
		[87] = 28,
		[89] = 29,
		[91] = 30,
		[93] = 31,
		[95] = 32,
		[97] = 33,
		[99] = 34,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[55] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 24,
		[102] = 14,
		[103] = 25,
		[104] = 15,
		[105] = 26,
		[106] = 16,
		[107] = 27,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[56] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[101] = 26,
		[102] = 16,
		[103] = 27,
		[104] = 17,
		[105] = 28,
		[106] = 18,
		[107] = 29,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[57] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[53] = 21,
		[54] = 6,
		[55] = 22,
		[56] = 7,
		[57] = 23,
		[58] = 8,
		[59] = 24,
		[60] = 9,
		[61] = 25,
		[62] = 10,
		[63] = 26,
		[64] = 11,
		[65] = 27,
		[66] = 12,
		[67] = 28,
		[83] = 29,
		[85] = 30,
		[87] = 31,
		[89] = 32,
		[91] = 33,
		[93] = 34,
		[95] = 35,
		[97] = 36,
		[99] = 37,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[58] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[83] = 31,
		[85] = 32,
		[87] = 33,
		[89] = 34,
		[91] = 35,
		[93] = 36,
		[95] = 37,
		[97] = 38,
		[99] = 39,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[59] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 31,
		[85] = 32,
		[87] = 33,
		[89] = 34,
		[91] = 35,
		[93] = 36,
		[95] = 37,
		[97] = 38,
		[99] = 39,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[60] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[33] = 23,
		[34] = 6,
		[35] = 24,
		[36] = 7,
		[37] = 25,
		[38] = 8,
		[39] = 26,
		[40] = 9,
		[41] = 27,
		[42] = 10,
		[43] = 28,
		[44] = 11,
		[45] = 29,
		[46] = 12,
		[47] = 30,
		[48] = 13,
		[49] = 31,
		[50] = 14,
		[51] = 32,
		[83] = 33,
		[85] = 34,
		[87] = 35,
		[89] = 36,
		[91] = 37,
		[93] = 38,
		[95] = 39,
		[97] = 40,
		[99] = 41,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[61] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[53] = 21,
		[54] = 6,
		[55] = 22,
		[56] = 7,
		[57] = 23,
		[58] = 8,
		[59] = 24,
		[60] = 9,
		[61] = 25,
		[62] = 10,
		[63] = 26,
		[64] = 11,
		[65] = 27,
		[66] = 12,
		[67] = 28,
		[100] = 13,
		[101] = 29,
		[102] = 14,
		[103] = 30,
		[104] = 15,
		[105] = 31,
		[106] = 16,
		[107] = 32,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[62] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[100] = 15,
		[101] = 31,
		[102] = 16,
		[103] = 32,
		[104] = 17,
		[105] = 33,
		[106] = 18,
		[107] = 34,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[63] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 31,
		[102] = 14,
		[103] = 32,
		[104] = 15,
		[105] = 33,
		[106] = 16,
		[107] = 34,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[64] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[33] = 23,
		[34] = 6,
		[35] = 24,
		[36] = 7,
		[37] = 25,
		[38] = 8,
		[39] = 26,
		[40] = 9,
		[41] = 27,
		[42] = 10,
		[43] = 28,
		[44] = 11,
		[45] = 29,
		[46] = 12,
		[47] = 30,
		[48] = 13,
		[49] = 31,
		[50] = 14,
		[51] = 32,
		[100] = 15,
		[101] = 33,
		[102] = 16,
		[103] = 34,
		[104] = 17,
		[105] = 35,
		[106] = 18,
		[107] = 36,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[65] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[53] = 24,
		[54] = 6,
		[55] = 25,
		[56] = 7,
		[57] = 26,
		[58] = 8,
		[59] = 27,
		[60] = 9,
		[61] = 28,
		[62] = 10,
		[63] = 29,
		[64] = 11,
		[65] = 30,
		[66] = 12,
		[67] = 31,
		[83] = 32,
		[85] = 33,
		[87] = 34,
		[89] = 35,
		[91] = 36,
		[93] = 37,
		[95] = 38,
		[97] = 39,
		[99] = 40,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[66] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 26,
		[55] = 27,
		[57] = 28,
		[59] = 29,
		[61] = 30,
		[63] = 31,
		[65] = 32,
		[67] = 33,
		[83] = 34,
		[85] = 35,
		[87] = 36,
		[89] = 37,
		[91] = 38,
		[93] = 39,
		[95] = 40,
		[97] = 41,
		[99] = 42,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[67] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[33] = 24,
		[35] = 25,
		[37] = 26,
		[39] = 27,
		[41] = 28,
		[43] = 29,
		[45] = 30,
		[47] = 31,
		[49] = 32,
		[51] = 33,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 34,
		[85] = 35,
		[87] = 36,
		[89] = 37,
		[91] = 38,
		[93] = 39,
		[95] = 40,
		[97] = 41,
		[99] = 42,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[68] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[33] = 26,
		[34] = 6,
		[35] = 27,
		[36] = 7,
		[37] = 28,
		[38] = 8,
		[39] = 29,
		[40] = 9,
		[41] = 30,
		[42] = 10,
		[43] = 31,
		[44] = 11,
		[45] = 32,
		[46] = 12,
		[47] = 33,
		[48] = 13,
		[49] = 34,
		[50] = 14,
		[51] = 35,
		[83] = 36,
		[85] = 37,
		[87] = 38,
		[89] = 39,
		[91] = 40,
		[93] = 41,
		[95] = 42,
		[97] = 43,
		[99] = 44,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[69] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[53] = 24,
		[54] = 6,
		[55] = 25,
		[56] = 7,
		[57] = 26,
		[58] = 8,
		[59] = 27,
		[60] = 9,
		[61] = 28,
		[62] = 10,
		[63] = 29,
		[64] = 11,
		[65] = 30,
		[66] = 12,
		[67] = 31,
		[100] = 13,
		[101] = 32,
		[102] = 14,
		[103] = 33,
		[104] = 15,
		[105] = 34,
		[106] = 16,
		[107] = 35,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[70] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 26,
		[55] = 27,
		[57] = 28,
		[59] = 29,
		[61] = 30,
		[63] = 31,
		[65] = 32,
		[67] = 33,
		[100] = 15,
		[101] = 34,
		[102] = 16,
		[103] = 35,
		[104] = 17,
		[105] = 36,
		[106] = 18,
		[107] = 37,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[71] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[33] = 24,
		[35] = 25,
		[37] = 26,
		[39] = 27,
		[41] = 28,
		[43] = 29,
		[45] = 30,
		[47] = 31,
		[49] = 32,
		[51] = 33,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 34,
		[102] = 14,
		[103] = 35,
		[104] = 15,
		[105] = 36,
		[106] = 16,
		[107] = 37,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[72] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[33] = 26,
		[34] = 6,
		[35] = 27,
		[36] = 7,
		[37] = 28,
		[38] = 8,
		[39] = 29,
		[40] = 9,
		[41] = 30,
		[42] = 10,
		[43] = 31,
		[44] = 11,
		[45] = 32,
		[46] = 12,
		[47] = 33,
		[48] = 13,
		[49] = 34,
		[50] = 14,
		[51] = 35,
		[100] = 15,
		[101] = 36,
		[102] = 16,
		[103] = 37,
		[104] = 17,
		[105] = 38,
		[106] = 18,
		[107] = 39,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[73] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x200A000000000000,
	.field_opt_bitmap = 0x9000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[74] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x2002800000000000,
	.field_opt_bitmap = 0x9000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[75] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301800000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[52] = 2,
		[53] = 21,
		[54] = 3,
		[55] = 22,
		[56] = 4,
		[57] = 23,
		[58] = 5,
		[59] = 24,
		[60] = 6,
		[61] = 25,
		[62] = 7,
		[63] = 26,
		[64] = 8,
		[65] = 27,
		[66] = 9,
		[67] = 28,
		[100] = 10,
		[102] = 11,
		[104] = 12,
		[106] = 13,
		[120] = 14,
		[121] = 15,
		[122] = 16,
		[123] = 17,
		},
	},
	[76] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[32] = 2,
		[34] = 3,
		[36] = 4,
		[38] = 5,
		[40] = 6,
		[42] = 7,
		[44] = 8,
		[46] = 9,
		[48] = 10,
		[50] = 11,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[100] = 12,
		[102] = 13,
		[104] = 14,
		[106] = 15,
		[120] = 16,
		[121] = 17,
		[122] = 18,
		[123] = 19,
		},
	},
	[77] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 2,
		[54] = 3,
		[56] = 4,
		[58] = 5,
		[60] = 6,
		[62] = 7,
		[64] = 8,
		[66] = 9,
		[100] = 10,
		[102] = 11,
		[104] = 12,
		[106] = 13,
		[120] = 14,
		[121] = 15,
		[122] = 16,
		[123] = 17,
		},
	},
	[78] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0180000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[32] = 2,
		[33] = 23,
		[34] = 3,
		[35] = 24,
		[36] = 4,
		[37] = 25,
		[38] = 5,
		[39] = 26,
		[40] = 6,
		[41] = 27,
		[42] = 7,
		[43] = 28,
		[44] = 8,
		[45] = 29,
		[46] = 9,
		[47] = 30,
		[48] = 10,
		[49] = 31,
		[50] = 11,
		[51] = 32,
		[100] = 12,
		[102] = 13,
		[104] = 14,
		[106] = 15,
		[120] = 16,
		[121] = 17,
		[122] = 18,
		[123] = 19,
		},
	},
	[79] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[52] = 2,
		[53] = 21,
		[54] = 3,
		[55] = 22,
		[56] = 4,
		[57] = 23,
		[58] = 5,
		[59] = 24,
		[60] = 6,
		[61] = 25,
		[62] = 7,
		[63] = 26,
		[64] = 8,
		[65] = 27,
		[66] = 9,
		[67] = 28,
		[83] = 29,
		[85] = 30,
		[87] = 31,
		[89] = 32,
		[91] = 33,
		[93] = 34,
		[95] = 35,
		[97] = 36,
		[99] = 37,
		[100] = 10,
		[102] = 11,
		[104] = 12,
		[106] = 13,
		[120] = 14,
		[121] = 15,
		[122] = 16,
		[123] = 17,
		},
	},
	[80] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[32] = 2,
		[34] = 3,
		[36] = 4,
		[38] = 5,
		[40] = 6,
		[42] = 7,
		[44] = 8,
		[46] = 9,
		[48] = 10,
		[50] = 11,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[83] = 31,
		[85] = 32,
		[87] = 33,
		[89] = 34,
		[91] = 35,
		[93] = 36,
		[95] = 37,
		[97] = 38,
		[99] = 39,
		[100] = 12,
		[102] = 13,
		[104] = 14,
		[106] = 15,
		[120] = 16,
		[121] = 17,
		[122] = 18,
		[123] = 19,
		},
	},
	[81] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 2,
		[54] = 3,
		[56] = 4,
		[58] = 5,
		[60] = 6,
		[62] = 7,
		[64] = 8,
		[66] = 9,
		[83] = 31,
		[85] = 32,
		[87] = 33,
		[89] = 34,
		[91] = 35,
		[93] = 36,
		[95] = 37,
		[97] = 38,
		[99] = 39,
		[100] = 10,
		[102] = 11,
		[104] = 12,
		[106] = 13,
		[120] = 14,
		[121] = 15,
		[122] = 16,
		[123] = 17,
		},
	},
	[82] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C01E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[32] = 2,
		[33] = 23,
		[34] = 3,
		[35] = 24,
		[36] = 4,
		[37] = 25,
		[38] = 5,
		[39] = 26,
		[40] = 6,
		[41] = 27,
		[42] = 7,
		[43] = 28,
		[44] = 8,
		[45] = 29,
		[46] = 9,
		[47] = 30,
		[48] = 10,
		[49] = 31,
		[50] = 11,
		[51] = 32,
		[83] = 33,
		[85] = 34,
		[87] = 35,
		[89] = 36,
		[91] = 37,
		[93] = 38,
		[95] = 39,
		[97] = 40,
		[99] = 41,
		[100] = 12,
		[102] = 13,
		[104] = 14,
		[106] = 15,
		[120] = 16,
		[121] = 17,
		[122] = 18,
		[123] = 19,
		},
	},
	[83] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[52] = 2,
		[53] = 21,
		[54] = 3,
		[55] = 22,
		[56] = 4,
		[57] = 23,
		[58] = 5,
		[59] = 24,
		[60] = 6,
		[61] = 25,
		[62] = 7,
		[63] = 26,
		[64] = 8,
		[65] = 27,
		[66] = 9,
		[67] = 28,
		[100] = 10,
		[101] = 29,
		[102] = 11,
		[103] = 30,
		[104] = 12,
		[105] = 31,
		[106] = 13,
		[107] = 32,
		[120] = 14,
		[121] = 15,
		[122] = 16,
		[123] = 17,
		},
	},
	[84] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[32] = 2,
		[34] = 3,
		[36] = 4,
		[38] = 5,
		[40] = 6,
		[42] = 7,
		[44] = 8,
		[46] = 9,
		[48] = 10,
		[50] = 11,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[100] = 12,
		[101] = 31,
		[102] = 13,
		[103] = 32,
		[104] = 14,
		[105] = 33,
		[106] = 15,
		[107] = 34,
		[120] = 16,
		[121] = 17,
		[122] = 18,
		[123] = 19,
		},
	},
	[85] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 2,
		[54] = 3,
		[56] = 4,
		[58] = 5,
		[60] = 6,
		[62] = 7,
		[64] = 8,
		[66] = 9,
		[100] = 10,
		[101] = 31,
		[102] = 11,
		[103] = 32,
		[104] = 12,
		[105] = 33,
		[106] = 13,
		[107] = 34,
		[120] = 14,
		[121] = 15,
		[122] = 16,
		[123] = 17,
		},
	},
	[86] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C01E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[32] = 2,
		[33] = 23,
		[34] = 3,
		[35] = 24,
		[36] = 4,
		[37] = 25,
		[38] = 5,
		[39] = 26,
		[40] = 6,
		[41] = 27,
		[42] = 7,
		[43] = 28,
		[44] = 8,
		[45] = 29,
		[46] = 9,
		[47] = 30,
		[48] = 10,
		[49] = 31,
		[50] = 11,
		[51] = 32,
		[100] = 12,
		[101] = 33,
		[102] = 13,
		[103] = 34,
		[104] = 14,
		[105] = 35,
		[106] = 15,
		[107] = 36,
		[120] = 16,
		[121] = 17,
		[122] = 18,
		[123] = 19,
		},
	},
	[87] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_ICMP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[23] = 31,
		[25] = 32,
		[27] = 33,
		[29] = 34,
		[31] = 35,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 2,
		[54] = 3,
		[56] = 4,
		[58] = 5,
		[60] = 6,
		[62] = 7,
		[64] = 8,
		[66] = 9,
		[100] = 10,
		[102] = 11,
		[104] = 12,
		[106] = 13,
		[120] = 14,
		[121] = 15,
		[122] = 16,
		[123] = 17,
		},
	},
	[88] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_ICMP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0180000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[23] = 33,
		[25] = 34,
		[27] = 35,
		[29] = 36,
		[31] = 37,
		[32] = 2,
		[33] = 23,
		[34] = 3,
		[35] = 24,
		[36] = 4,
		[37] = 25,
		[38] = 5,
		[39] = 26,
		[40] = 6,
		[41] = 27,
		[42] = 7,
		[43] = 28,
		[44] = 8,
		[45] = 29,
		[46] = 9,
		[47] = 30,
		[48] = 10,
		[49] = 31,
		[50] = 11,
		[51] = 32,
		[100] = 12,
		[102] = 13,
		[104] = 14,
		[106] = 15,
		[120] = 16,
		[121] = 17,
		[122] = 18,
		[123] = 19,
		},
	},
	[89] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_GENEVE |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xA002800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 5,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		},
	},
	[90] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB800000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		},
	},
	[91] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[92] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[93] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA40000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[94] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA78000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		},
	},
	[95] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA36000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		},
	},
	[96] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[97] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[98] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[99] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[100] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49E00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 11,
		[54] = 12,
		[56] = 13,
		[58] = 14,
		[60] = 15,
		[62] = 16,
		[64] = 17,
		[66] = 18,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[101] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48D80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 11,
		[34] = 12,
		[36] = 13,
		[38] = 14,
		[40] = 15,
		[42] = 16,
		[44] = 17,
		[46] = 18,
		[48] = 19,
		[50] = 20,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[102] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 5,
		[84] = 6,
		[86] = 7,
		[88] = 8,
		[90] = 9,
		[92] = 10,
		[94] = 11,
		[96] = 12,
		[98] = 13,
		},
	},
	[103] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 5,
		[102] = 6,
		[104] = 7,
		[106] = 8,
		},
	},
	[104] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 8,
		[84] = 9,
		[86] = 10,
		[88] = 11,
		[90] = 12,
		[92] = 13,
		[94] = 14,
		[96] = 15,
		[98] = 16,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[105] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 8,
		[102] = 9,
		[104] = 10,
		[106] = 11,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[106] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 8,
		[84] = 9,
		[86] = 10,
		[88] = 11,
		[90] = 12,
		[92] = 13,
		[94] = 14,
		[96] = 15,
		[98] = 16,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[107] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 8,
		[102] = 9,
		[104] = 10,
		[106] = 11,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[108] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[82] = 11,
		[84] = 12,
		[86] = 13,
		[88] = 14,
		[90] = 15,
		[92] = 16,
		[94] = 17,
		[96] = 18,
		[98] = 19,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[109] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[100] = 11,
		[102] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[110] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[82] = 13,
		[84] = 14,
		[86] = 15,
		[88] = 16,
		[90] = 17,
		[92] = 18,
		[94] = 19,
		[96] = 20,
		[98] = 21,
		},
	},
	[111] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[82] = 15,
		[84] = 16,
		[86] = 17,
		[88] = 18,
		[90] = 19,
		[92] = 20,
		[94] = 21,
		[96] = 22,
		[98] = 23,
		},
	},
	[112] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		},
	},
	[113] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		},
	},
	[114] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[82] = 16,
		[84] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[115] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[82] = 18,
		[84] = 19,
		[86] = 20,
		[88] = 21,
		[90] = 22,
		[92] = 23,
		[94] = 24,
		[96] = 25,
		[98] = 26,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[116] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[100] = 16,
		[102] = 17,
		[104] = 18,
		[106] = 19,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[117] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[100] = 18,
		[102] = 19,
		[104] = 20,
		[106] = 21,
		[108] = 5,
		[112] = 6,
		[116] = 7,
		},
	},
	[118] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[82] = 16,
		[84] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[119] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[82] = 18,
		[84] = 19,
		[86] = 20,
		[88] = 21,
		[90] = 22,
		[92] = 23,
		[94] = 24,
		[96] = 25,
		[98] = 26,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[120] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 8,
		[54] = 9,
		[56] = 10,
		[58] = 11,
		[60] = 12,
		[62] = 13,
		[64] = 14,
		[66] = 15,
		[100] = 16,
		[102] = 17,
		[104] = 18,
		[106] = 19,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[121] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 8,
		[34] = 9,
		[36] = 10,
		[38] = 11,
		[40] = 12,
		[42] = 13,
		[44] = 14,
		[46] = 15,
		[48] = 16,
		[50] = 17,
		[100] = 18,
		[102] = 19,
		[104] = 20,
		[106] = 21,
		[109] = 5,
		[113] = 6,
		[117] = 7,
		},
	},
	[122] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 11,
		[54] = 12,
		[56] = 13,
		[58] = 14,
		[60] = 15,
		[62] = 16,
		[64] = 17,
		[66] = 18,
		[82] = 19,
		[84] = 20,
		[86] = 21,
		[88] = 22,
		[90] = 23,
		[92] = 24,
		[94] = 25,
		[96] = 26,
		[98] = 27,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[123] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 11,
		[34] = 12,
		[36] = 13,
		[38] = 14,
		[40] = 15,
		[42] = 16,
		[44] = 17,
		[46] = 18,
		[48] = 19,
		[50] = 20,
		[82] = 21,
		[84] = 22,
		[86] = 23,
		[88] = 24,
		[90] = 25,
		[92] = 26,
		[94] = 27,
		[96] = 28,
		[98] = 29,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[124] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 11,
		[54] = 12,
		[56] = 13,
		[58] = 14,
		[60] = 15,
		[62] = 16,
		[64] = 17,
		[66] = 18,
		[100] = 19,
		[102] = 20,
		[104] = 21,
		[106] = 22,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[125] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 11,
		[34] = 12,
		[36] = 13,
		[38] = 14,
		[40] = 15,
		[42] = 16,
		[44] = 17,
		[46] = 18,
		[48] = 19,
		[50] = 20,
		[100] = 21,
		[102] = 22,
		[104] = 23,
		[106] = 24,
		[108] = 5,
		[109] = 8,
		[112] = 6,
		[113] = 9,
		[116] = 7,
		[117] = 10,
		},
	},
	[126] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A100000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[127] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[128] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[129] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[130] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105800000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[53] = 21,
		[54] = 6,
		[55] = 22,
		[56] = 7,
		[57] = 23,
		[58] = 8,
		[59] = 24,
		[60] = 9,
		[61] = 25,
		[62] = 10,
		[63] = 26,
		[64] = 11,
		[65] = 27,
		[66] = 12,
		[67] = 28,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[131] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[132] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[133] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840580000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[33] = 23,
		[34] = 6,
		[35] = 24,
		[36] = 7,
		[37] = 25,
		[38] = 8,
		[39] = 26,
		[40] = 9,
		[41] = 27,
		[42] = 10,
		[43] = 28,
		[44] = 11,
		[45] = 29,
		[46] = 12,
		[47] = 30,
		[48] = 13,
		[49] = 31,
		[50] = 14,
		[51] = 32,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[134] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170B00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[53] = 24,
		[54] = 6,
		[55] = 25,
		[56] = 7,
		[57] = 26,
		[58] = 8,
		[59] = 27,
		[60] = 9,
		[61] = 28,
		[62] = 10,
		[63] = 29,
		[64] = 11,
		[65] = 30,
		[66] = 12,
		[67] = 31,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[135] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2C0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 26,
		[55] = 27,
		[57] = 28,
		[59] = 29,
		[61] = 30,
		[63] = 31,
		[65] = 32,
		[67] = 33,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[136] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702C0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[33] = 24,
		[35] = 25,
		[37] = 26,
		[39] = 27,
		[41] = 28,
		[43] = 29,
		[45] = 30,
		[47] = 31,
		[49] = 32,
		[51] = 33,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[137] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0B0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[33] = 26,
		[34] = 6,
		[35] = 27,
		[36] = 7,
		[37] = 28,
		[38] = 8,
		[39] = 29,
		[40] = 9,
		[41] = 30,
		[42] = 10,
		[43] = 31,
		[44] = 11,
		[45] = 32,
		[46] = 12,
		[47] = 33,
		[48] = 13,
		[49] = 34,
		[50] = 14,
		[51] = 35,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[138] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 21,
		[85] = 22,
		[87] = 23,
		[89] = 24,
		[91] = 25,
		[93] = 26,
		[95] = 27,
		[97] = 28,
		[99] = 29,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[139] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[83] = 23,
		[85] = 24,
		[87] = 25,
		[89] = 26,
		[91] = 27,
		[93] = 28,
		[95] = 29,
		[97] = 30,
		[99] = 31,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[140] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 21,
		[102] = 14,
		[103] = 22,
		[104] = 15,
		[105] = 23,
		[106] = 16,
		[107] = 24,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[141] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[101] = 23,
		[102] = 16,
		[103] = 24,
		[104] = 17,
		[105] = 25,
		[106] = 18,
		[107] = 26,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[142] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 24,
		[85] = 25,
		[87] = 26,
		[89] = 27,
		[91] = 28,
		[93] = 29,
		[95] = 30,
		[97] = 31,
		[99] = 32,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[143] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[83] = 26,
		[85] = 27,
		[87] = 28,
		[89] = 29,
		[91] = 30,
		[93] = 31,
		[95] = 32,
		[97] = 33,
		[99] = 34,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[144] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 24,
		[102] = 14,
		[103] = 25,
		[104] = 15,
		[105] = 26,
		[106] = 16,
		[107] = 27,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[145] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[101] = 26,
		[102] = 16,
		[103] = 27,
		[104] = 17,
		[105] = 28,
		[106] = 18,
		[107] = 29,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[146] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[53] = 21,
		[54] = 6,
		[55] = 22,
		[56] = 7,
		[57] = 23,
		[58] = 8,
		[59] = 24,
		[60] = 9,
		[61] = 25,
		[62] = 10,
		[63] = 26,
		[64] = 11,
		[65] = 27,
		[66] = 12,
		[67] = 28,
		[83] = 29,
		[85] = 30,
		[87] = 31,
		[89] = 32,
		[91] = 33,
		[93] = 34,
		[95] = 35,
		[97] = 36,
		[99] = 37,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[147] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[83] = 31,
		[85] = 32,
		[87] = 33,
		[89] = 34,
		[91] = 35,
		[93] = 36,
		[95] = 37,
		[97] = 38,
		[99] = 39,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[148] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 31,
		[85] = 32,
		[87] = 33,
		[89] = 34,
		[91] = 35,
		[93] = 36,
		[95] = 37,
		[97] = 38,
		[99] = 39,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[149] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[33] = 23,
		[34] = 6,
		[35] = 24,
		[36] = 7,
		[37] = 25,
		[38] = 8,
		[39] = 26,
		[40] = 9,
		[41] = 27,
		[42] = 10,
		[43] = 28,
		[44] = 11,
		[45] = 29,
		[46] = 12,
		[47] = 30,
		[48] = 13,
		[49] = 31,
		[50] = 14,
		[51] = 32,
		[83] = 33,
		[85] = 34,
		[87] = 35,
		[89] = 36,
		[91] = 37,
		[93] = 38,
		[95] = 39,
		[97] = 40,
		[99] = 41,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[150] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[52] = 5,
		[53] = 21,
		[54] = 6,
		[55] = 22,
		[56] = 7,
		[57] = 23,
		[58] = 8,
		[59] = 24,
		[60] = 9,
		[61] = 25,
		[62] = 10,
		[63] = 26,
		[64] = 11,
		[65] = 27,
		[66] = 12,
		[67] = 28,
		[100] = 13,
		[101] = 29,
		[102] = 14,
		[103] = 30,
		[104] = 15,
		[105] = 31,
		[106] = 16,
		[107] = 32,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[151] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 23,
		[55] = 24,
		[57] = 25,
		[59] = 26,
		[61] = 27,
		[63] = 28,
		[65] = 29,
		[67] = 30,
		[100] = 15,
		[101] = 31,
		[102] = 16,
		[103] = 32,
		[104] = 17,
		[105] = 33,
		[106] = 18,
		[107] = 34,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[152] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 21,
		[35] = 22,
		[37] = 23,
		[39] = 24,
		[41] = 25,
		[43] = 26,
		[45] = 27,
		[47] = 28,
		[49] = 29,
		[51] = 30,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 31,
		[102] = 14,
		[103] = 32,
		[104] = 15,
		[105] = 33,
		[106] = 16,
		[107] = 34,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[153] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[33] = 23,
		[34] = 6,
		[35] = 24,
		[36] = 7,
		[37] = 25,
		[38] = 8,
		[39] = 26,
		[40] = 9,
		[41] = 27,
		[42] = 10,
		[43] = 28,
		[44] = 11,
		[45] = 29,
		[46] = 12,
		[47] = 30,
		[48] = 13,
		[49] = 31,
		[50] = 14,
		[51] = 32,
		[100] = 15,
		[101] = 33,
		[102] = 16,
		[103] = 34,
		[104] = 17,
		[105] = 35,
		[106] = 18,
		[107] = 36,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[154] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[53] = 24,
		[54] = 6,
		[55] = 25,
		[56] = 7,
		[57] = 26,
		[58] = 8,
		[59] = 27,
		[60] = 9,
		[61] = 28,
		[62] = 10,
		[63] = 29,
		[64] = 11,
		[65] = 30,
		[66] = 12,
		[67] = 31,
		[83] = 32,
		[85] = 33,
		[87] = 34,
		[89] = 35,
		[91] = 36,
		[93] = 37,
		[95] = 38,
		[97] = 39,
		[99] = 40,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[155] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 26,
		[55] = 27,
		[57] = 28,
		[59] = 29,
		[61] = 30,
		[63] = 31,
		[65] = 32,
		[67] = 33,
		[83] = 34,
		[85] = 35,
		[87] = 36,
		[89] = 37,
		[91] = 38,
		[93] = 39,
		[95] = 40,
		[97] = 41,
		[99] = 42,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[156] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[33] = 24,
		[35] = 25,
		[37] = 26,
		[39] = 27,
		[41] = 28,
		[43] = 29,
		[45] = 30,
		[47] = 31,
		[49] = 32,
		[51] = 33,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[83] = 34,
		[85] = 35,
		[87] = 36,
		[89] = 37,
		[91] = 38,
		[93] = 39,
		[95] = 40,
		[97] = 41,
		[99] = 42,
		[100] = 13,
		[102] = 14,
		[104] = 15,
		[106] = 16,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[157] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[33] = 26,
		[34] = 6,
		[35] = 27,
		[36] = 7,
		[37] = 28,
		[38] = 8,
		[39] = 29,
		[40] = 9,
		[41] = 30,
		[42] = 10,
		[43] = 31,
		[44] = 11,
		[45] = 32,
		[46] = 12,
		[47] = 33,
		[48] = 13,
		[49] = 34,
		[50] = 14,
		[51] = 35,
		[83] = 36,
		[85] = 37,
		[87] = 38,
		[89] = 39,
		[91] = 40,
		[93] = 41,
		[95] = 42,
		[97] = 43,
		[99] = 44,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[158] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[52] = 5,
		[53] = 24,
		[54] = 6,
		[55] = 25,
		[56] = 7,
		[57] = 26,
		[58] = 8,
		[59] = 27,
		[60] = 9,
		[61] = 28,
		[62] = 10,
		[63] = 29,
		[64] = 11,
		[65] = 30,
		[66] = 12,
		[67] = 31,
		[100] = 13,
		[101] = 32,
		[102] = 14,
		[103] = 33,
		[104] = 15,
		[105] = 34,
		[106] = 16,
		[107] = 35,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[159] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[53] = 26,
		[55] = 27,
		[57] = 28,
		[59] = 29,
		[61] = 30,
		[63] = 31,
		[65] = 32,
		[67] = 33,
		[100] = 15,
		[101] = 34,
		[102] = 16,
		[103] = 35,
		[104] = 17,
		[105] = 36,
		[106] = 18,
		[107] = 37,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[160] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[33] = 24,
		[35] = 25,
		[37] = 26,
		[39] = 27,
		[41] = 28,
		[43] = 29,
		[45] = 30,
		[47] = 31,
		[49] = 32,
		[51] = 33,
		[52] = 5,
		[54] = 6,
		[56] = 7,
		[58] = 8,
		[60] = 9,
		[62] = 10,
		[64] = 11,
		[66] = 12,
		[100] = 13,
		[101] = 34,
		[102] = 14,
		[103] = 35,
		[104] = 15,
		[105] = 36,
		[106] = 16,
		[107] = 37,
		[120] = 17,
		[121] = 18,
		[122] = 19,
		[123] = 20,
		},
	},
	[161] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[32] = 5,
		[33] = 26,
		[34] = 6,
		[35] = 27,
		[36] = 7,
		[37] = 28,
		[38] = 8,
		[39] = 29,
		[40] = 9,
		[41] = 30,
		[42] = 10,
		[43] = 31,
		[44] = 11,
		[45] = 32,
		[46] = 12,
		[47] = 33,
		[48] = 13,
		[49] = 34,
		[50] = 14,
		[51] = 35,
		[100] = 15,
		[101] = 36,
		[102] = 16,
		[103] = 37,
		[104] = 17,
		[105] = 38,
		[106] = 18,
		[107] = 39,
		[120] = 19,
		[121] = 20,
		[122] = 21,
		[123] = 22,
		},
	},
	[162] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_GENEVE |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB002800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[32] = 5,
		[34] = 6,
		[36] = 7,
		[38] = 8,
		[40] = 9,
		[42] = 10,
		[44] = 11,
		[46] = 12,
		[48] = 13,
		[50] = 14,
		[100] = 15,
		[102] = 16,
		[104] = 17,
		[106] = 18,
		},
	}
};

