//  Copyright (c) 2014 Anton Bikineev
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 3>, 864> bessel_yv_prime_data = {{
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.177219114266335964202880859375e-2), SC_(359.25306691468182462382237111287002162553866747579) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.22177286446094512939453125e-2), SC_(287.08013716324049922227602244564319388641879278396) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.7444499991834163665771484375e-2), SC_(85.531475792801076416765903757627138355150815768381) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1433600485324859619140625e-1), SC_(44.43035679632993650721736060153716759038322379723) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1760916970670223236083984375e-1), SC_(36.179654804596195073472668375517619276826453027816) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.6152711808681488037109375e-1), SC_(10.413780184730641117297885590055203070917628378544) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.11958599090576171875e0), SC_(5.4277607095532821471185956360419186047556753959012) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.15262925624847412109375e0), SC_(4.2920266800823007910164892097244973768547846351371) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.408089816570281982421875e0), SC_(1.7509153497269689499030148640443708410615525473524) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.6540834903717041015625e0), SC_(1.1712794472938520666850107533401801762567425673398) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1097540378570556640625e1), SC_(0.70138648105516834583393514421333924350925740962504) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.30944411754608154296875e1), SC_(-0.34749828407729174130100909185824276870624530573172) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.51139926910400390625e1), SC_(-0.10986116293007483043606802975095346477573689745585) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.95070552825927734375e1), SC_(-0.20378601019764953872142029007731936626447427024392) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.24750102996826171875e2), SC_(0.064700725186337701986731085937025374356981361835941) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.637722015380859375e2), SC_(0.098672834379112400010944568868782489693261838065595) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1252804412841796875e3), SC_(0.027913781978643615009047750009636168838479193347638) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.25554705810546875e3), SC_(-0.04780881743198587298231695276364404056179232533175) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.503011474609375e3), SC_(0.032325270488727463019860406722316462375064083905752) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.10074598388671875e4), SC_(0.0052012686169753781931485875545710147005519624143894) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1185395751953125e4), SC_(-0.022577498856801507605595835038635382331015497697766) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.353451806640625e4), SC_(-0.011358296273412421720490300072404002932735855560398) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.80715478515625e4), SC_(-0.0088806977171749850238952666167111790987748939321371) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1622925e5), SC_(0.00335331650999886871984157216400084691169190356345) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.3206622265625e5), SC_(-0.0030987860388094542027981684852371310749661034262822) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.3636794921875e5), SC_(0.0041689695099571798078503972547393292264317537185944) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.177219114266335964202880859375e-2), SC_(359.26533728538776366509474053133533307586229635913) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.22177286446094512939453125e-2), SC_(287.08921637154798496281292076850380987394085518871) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.7444499991834163665771484375e-2), SC_(85.533146645088550608502277739916424359004343336472) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1433600485324859619140625e-1), SC_(44.43098524576237653184367498965422147553862710847) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1760916970670223236083984375e-1), SC_(36.180112164703042011439433637606469649465975324508) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.6152711808681488037109375e-1), SC_(10.413849488813765046067013925290595202964441035058) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.11958599090576171875e0), SC_(5.4278107962203418944781035199372633462886191141604) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.15262925624847412109375e0), SC_(4.2920825538295737959088050162943746783032954850028) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.408089816570281982421875e0), SC_(1.7510517471771296869441766472247915798444928092357) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.6540834903717041015625e0), SC_(1.1714932778725264264492038485427581871125406753861) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1097540378570556640625e1), SC_(0.70171347129696306321421648791219764087618145201066) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.30944411754608154296875e1), SC_(-0.34728549175374248702810137805247545330678632309601) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.51139926910400390625e1), SC_(-0.11009752053125087496840861386621624153790113475449) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.95070552825927734375e1), SC_(-0.20367376011493060664075031914622840182372793862664) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.24750102996826171875e2), SC_(0.064597973933861490895674774983095378504990464398256) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.637722015380859375e2), SC_(0.098683815824621789326075155716559154126027874873011) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1252804412841796875e3), SC_(0.027867870127454387792608895641557952520679288199781) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.25554705810546875e3), SC_(-0.047818839046928044568149355329247460363523211579449) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.503011474609375e3), SC_(0.032314865769536025453551159457231378233190509770099) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.10074598388671875e4), SC_(0.0052184792284391194770251514307298821432923503112623) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1185395751953125e4), SC_(-0.022581150607424172490344786625158021348090029161792) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.353451806640625e4), SC_(-0.011353290475374159470937910615557953572808040810715) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.80715478515625e4), SC_(-0.008880746439508476088352237888148520706285994682475) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1622925e5), SC_(0.003349613631518740020185089462548698579892864718393) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.3206622265625e5), SC_(-0.00309654458296089787536174505713483571740660332384) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.3636794921875e5), SC_(0.0041692155869161578021403556938091137539037204390053) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.177219114266335964202880859375e-2), SC_(359.61538516010303429557658299626785767048487215928) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.22177286446094512939453125e-2), SC_(287.3482632934110565450988413586642462415027703712) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.7444499991834163665771484375e-2), SC_(85.580836749038216771643230460325586605437799707848) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1433600485324859619140625e-1), SC_(44.448874749485195727832237621603297382004678832416) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1760916970670223236083984375e-1), SC_(36.193095162394224258170247650816839299131334919513) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.6152711808681488037109375e-1), SC_(10.41547795489898084622114106169838305734284722828) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.11958599090576171875e0), SC_(5.428544467991402442892411572453620791558207454213) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.15262925624847412109375e0), SC_(4.2927869398771675483835338866815905152014836769703) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.408089816570281982421875e0), SC_(1.7525954103110133126427687987590047392024346080671) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.6540834903717041015625e0), SC_(1.1739517773917065091895115133259215128920140054728) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1097540378570556640625e1), SC_(0.70551511286563702949844068537777076253588549797454) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.30944411754608154296875e1), SC_(-0.3447778647140080736625302955544256584154698214685) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.51139926910400390625e1), SC_(-0.11286522881024518833855970957081289522204885907218) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.95070552825927734375e1), SC_(-0.20234971785850488371460924340135923598729438315703) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.24750102996826171875e2), SC_(0.063390298155983207860286527518495960577457577765314) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.637722015380859375e2), SC_(0.098809028954653841294534256159790392315349697927185) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1252804412841796875e3), SC_(0.027328255089583247350619008880283157773769362996017) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.25554705810546875e3), SC_(-0.047934655310875030626250164717877857179974640795257) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.503011474609375e3), SC_(0.03219162386979542860049172297428628386619285510695) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.10074598388671875e4), SC_(0.0054201900281237392214400487682391896688902770907816) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1185395751953125e4), SC_(-0.022623164219523180927407705809901243282181817362125) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.353451806640625e4), SC_(-0.01129415096191462399990818616022695053279134929122) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.80715478515625e4), SC_(-0.0088809931882399207490219045625853338251765939932529) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1622925e5), SC_(0.0033060517162921985094437212052452189059014774971163) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.3206622265625e5), SC_(-0.0030701362389974827696571501159824604578897162969859) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.3636794921875e5), SC_(0.0041719498830685294134638940872532813635403694135636) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.177219114266335964202880859375e-2), SC_(360.66384061259237753668362244272874098606053080663) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.22177286446094512939453125e-2), SC_(288.12434956336918749148381184410998242806714632079) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.7444499991834163665771484375e-2), SC_(85.723960125296433931898348273346093728706850120965) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1433600485324859619140625e-1), SC_(44.502586688687185565689378984302581969399816592778) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1760916970670223236083984375e-1), SC_(36.232057404874933537262424656710203236234671818828) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.6152711808681488037109375e-1), SC_(10.419998917129290157487213633756026253309650723181) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.11958599090576171875e0), SC_(5.4299541104044942149195917045739093203074088673901) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.15262925624847412109375e0), SC_(4.2938751170009501761640512662106951369512572393543) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.408089816570281982421875e0), SC_(1.7544762226506229224129009964489977536109094806026) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.6540834903717041015625e0), SC_(1.1770541874629339256442960271295095388698272685524) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1097540378570556640625e1), SC_(0.71043099666084467317131573557871350821623832343284) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.30944411754608154296875e1), SC_(-0.34144010093943447988580665820071305106009560561805) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.51139926910400390625e1), SC_(-0.11649989459160086125501383673328056886424521236721) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.95070552825927734375e1), SC_(-0.20058383156493147817487315062845002803857807014306) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.24750102996826171875e2), SC_(0.061791708005526098625369433443618222560798057148848) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.637722015380859375e2), SC_(0.098963932512610019724934165680742537835689194246184) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1252804412841796875e3), SC_(0.026613984401818061459950909137074671180828361541644) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.25554705810546875e3), SC_(-0.04808241719353037822485667130892809307081182735904) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.503011474609375e3), SC_(0.032025815263534101023988027811330255550490790798804) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.10074598388671875e4), SC_(0.0056855843265044880392879989690136437111848068412733) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1185395751953125e4), SC_(-0.022676227763002577396052585795844990126249039103109) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.353451806640625e4), SC_(-0.011215012546475940980046233548530189561070550223441) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.80715478515625e4), SC_(-0.0088804035250864756776127960991405171487351624941717) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1622925e5), SC_(0.0032482751451286971731524515398767259243396958750959) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.3206622265625e5), SC_(-0.0030350007829066575702606363618478813226415287101618) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.3636794921875e5), SC_(0.004175125193984142075431036813024989618112709179213) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.177219114266335964202880859375e-2), SC_(361.39885869140428926563450809503978987518553748568) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.22177286446094512939453125e-2), SC_(288.66852117067831275503229721433776811287755190912) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.7444499991834163665771484375e-2), SC_(85.824458116117548434939562785417210132394340549105) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1433600485324859619140625e-1), SC_(44.540342802225198520038150525423461203565319469734) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1760916970670223236083984375e-1), SC_(36.259453528024862504261603207260325557534763911952) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.6152711808681488037109375e-1), SC_(10.423129058340310606495844681509750462172582098904) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.11958599090576171875e0), SC_(5.4308147247981241154060274553135851823942873075757) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.15262925624847412109375e0), SC_(4.2944659591814224293544779814887793365490488023015) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.408089816570281982421875e0), SC_(1.7553101849291556050200804653075666663387916802958) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.6540834903717041015625e0), SC_(1.1784731508050615047018720430474765540337629428657) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1097540378570556640625e1), SC_(0.71272751425771993082388850343486913499109778758389) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.30944411754608154296875e1), SC_(-0.33984243179892016255118407998615855039387492880549) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.51139926910400390625e1), SC_(-0.11822029780756370720683988753629246736261909652297) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.95070552825927734375e1), SC_(-0.19973715375513322254858611528399110158532438306824) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.24750102996826171875e2), SC_(0.061030000020425648817673633411490747439312664692857) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.637722015380859375e2), SC_(0.099033441205285337176320919426893196796059222419234) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1252804412841796875e3), SC_(0.026273648290559597711675444462910401390799076819571) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.25554705810546875e3), SC_(-0.048150624366161609562254581490868410787675374787586) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.503011474609375e3), SC_(0.031945748218642913687454092005024560498410141081415) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.10074598388671875e4), SC_(0.0058114032014403196644662434564349550870953181840864) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1185395751953125e4), SC_(-0.022700500191737844497049067954073904134709647152363) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.353451806640625e4), SC_(-0.011176964379109078613504863918071497409300798232056) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.80715478515625e4), SC_(-0.0088797589512821173317664642517805553382789774643408) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1622925e5), SC_(0.0032207000500322758933566501584837056803050482269527) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.3206622265625e5), SC_(-0.0030181881448739497032218111525083821586937851784797) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.3636794921875e5), SC_(0.004176461978507367126012448525308201945717868996491) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.177219114266335964202880859375e-2), SC_(386.84649815922821247444250423264016778541524808689) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.22177286446094512939453125e-2), SC_(307.51742581669983807258619363423952844503782032945) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.7444499991834163665771484375e-2), SC_(89.324980236516642617302222791111509895996221287717) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1433600485324859619140625e-1), SC_(45.863623613665329823897416995006839150714846722558) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1760916970670223236083984375e-1), SC_(37.222103852737206148763622334937227913603855763059) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.6152711808681488037109375e-1), SC_(10.534244176093712123036020745326404625615243928344) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.11958599090576171875e0), SC_(5.4574192115104466221201578143304986274266413115245) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.15262925624847412109375e0), SC_(4.3092271993470203883468061907561601476287615809357) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.408089816570281982421875e0), SC_(1.7632810658420813076346740513796339118243704824142) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.6540834903717041015625e0), SC_(1.1943076368861111409669974787132785018002242333416) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1097540378570556640625e1), SC_(0.7411934822589645568652368938323340840053195715481) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.30944411754608154296875e1), SC_(-0.31766852082023584617681204897750598671067224318376) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.51139926910400390625e1), SC_(-0.14091386910438217783591376037730250289819886206938) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.95070552825927734375e1), SC_(-0.18789502459935321284529134779157478777377780719868) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.24750102996826171875e2), SC_(0.050668270192389957152921922377008360111815519770089) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.637722015380859375e2), SC_(0.099712197814510543128736976397984451480066249448177) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1252804412841796875e3), SC_(0.021644183884026277875426401246200102025210504151707) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.25554705810546875e3), SC_(-0.048941983886641909429584531299032597597252698181249) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.503011474609375e3), SC_(0.030790682274716372147098576314085976745514129618533) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.10074598388671875e4), SC_(0.00748337944192267624984635578046622499451685888106) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1185395751953125e4), SC_(-0.022967900814519221017200373747436452809908607893011) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.353451806640625e4), SC_(-0.010638289076751052438411545168702801101126681444409) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.80715478515625e4), SC_(-0.0088484223641687186870543948377859292082059164571873) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1622925e5), SC_(0.0028427696828550781605194869210140361122280027720056) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.3206622265625e5), SC_(-0.0027850673515846116643446090339571435347806218111091) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.3636794921875e5), SC_(0.0041837100262804939435742763330834077746535764640674) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.177219114266335964202880859375e-2), SC_(471.07904511807757075529924713648874787656532654322) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.22177286446094512939453125e-2), SC_(369.83352126079564563860539146868232210845788323318) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.7444499991834163665771484375e-2), SC_(100.8926788327655449826259228351575101502208705438) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1433600485324859619140625e-1), SC_(50.261950308865397704005994179636304699196657576525) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1760916970670223236083984375e-1), SC_(40.431844419369554479783619258165562485952533201559) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.6152711808681488037109375e-1), SC_(10.920579593589712357414374566697768662600622348816) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.11958599090576171875e0), SC_(5.5521814058115922162447517806422398220949784162506) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.15262925624847412109375e0), SC_(4.3599577290739748726526571952163210388465594359489) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.408089816570281982421875e0), SC_(1.7672057260098948814151540267766634502013932425863) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.6540834903717041015625e0), SC_(1.2071653250923299679723515026059530579680864317675) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1097540378570556640625e1), SC_(0.77236114699440006062612193362413588801187987846086) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.30944411754608154296875e1), SC_(-0.28643887517065773532763251656474766980306151168022) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.51139926910400390625e1), SC_(-0.16968162503198222096438626113719559830413159833904) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.95070552825927734375e1), SC_(-0.17094413777740873672840617190633571913200892015987) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.24750102996826171875e2), SC_(0.036627953698520287429288017498608161131502514416576) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.637722015380859375e2), SC_(0.099881902737741908306480993497521975621492594080957) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1252804412841796875e3), SC_(0.015371470768524316617881866353098600568702240322117) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.25554705810546875e3), SC_(-0.04963034228262876371804578205589108739868110580251) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.503011474609375e3), SC_(0.029040030696563383380289380952236904242666145653059) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.10074598388671875e4), SC_(0.0096377145586381776734165293928561358672297115944294) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1185395751953125e4), SC_(-0.023153568193852186048368046757085257379972844916655) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.353451806640625e4), SC_(-0.0098489577440119141787150788876695200654788145387557) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.80715478515625e4), SC_(-0.0087424427313086426024754918639954473239490575861777) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1622925e5), SC_(0.0023227013597311819710582480572446504089298495687209) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.3206622265625e5), SC_(-0.0024567419656302508128366677593241788873826542064012) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.3636794921875e5), SC_(0.004162752148050053512734448924102518998011369573107) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.177219114266335964202880859375e-2), SC_(550.26983980430300795570862133344187404338307846886) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.22177286446094512939453125e-2), SC_(428.25246898381446247296435092483885980684499918501) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.7444499991834163665771484375e-2), SC_(111.62788160294517172695194837986488777298263881601) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1433600485324859619140625e-1), SC_(54.342305109375287570895327633246927669657529711615) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1760916970670223236083984375e-1), SC_(43.412413502953209603578086791256699258893358964544) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.6152711808681488037109375e-1), SC_(11.288819259762530259494036299842482325827549359741) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.11958599090576171875e0), SC_(5.6466231487812259457698143373095128556780206364717) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.15262925624847412109375e0), SC_(4.4118804277399167225019419615188927964201066316479) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.408089816570281982421875e0), SC_(1.7677012441743138980885091080989685415934667776206) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.6540834903717041015625e0), SC_(1.2110810092940371469660474682502975627515775842208) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1097540378570556640625e1), SC_(0.78699083998149574014107080585343021107382102965251) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.30944411754608154296875e1), SC_(-0.26781470910974245508263413514155283463548537332397) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.51139926910400390625e1), SC_(-0.18535454013537162257020785594906652095581957749481) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.95070552825927734375e1), SC_(-0.16069242582867043420069338816809641072513152283757) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.24750102996826171875e2), SC_(0.028503904659008941717273668637883762097262105583801) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.637722015380859375e2), SC_(0.099608444452234011572244150378374660744547394746412) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1252804412841796875e3), SC_(0.011741918935922294310508405252507810691919397336666) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.25554705810546875e3), SC_(-0.049838212134286025175418132213709462398523186971761) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.503011474609375e3), SC_(0.027934974417967150611305604047933898077687813200384) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.10074598388671875e4), SC_(0.010829144113104392943053168995242057812690303049445) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1185395751953125e4), SC_(-0.023173350843985777008007809301579387375382411735428) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.353451806640625e4), SC_(-0.0093627265423414040389771424653406200136691569708208) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.80715478515625e4), SC_(-0.0086496001026921847096999315302254639667186295759534) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1622925e5), SC_(0.0020178091515072894683595128306113599815065909120087) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.3206622265625e5), SC_(-0.0022605812577422975690730468923255101930476445803036) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.3636794921875e5), SC_(0.0041353523220570854251273344068201291405951580242932) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.177219114266335964202880859375e-2), SC_(2809.139381848949790092311073572950685536265870062) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.22177286446094512939453125e-2), SC_(2049.1117816330690160487379151275609993367828109138) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.7444499991834163665771484375e-2), SC_(373.60967138493206445456136065075241144313419576668) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1433600485324859619140625e-1), SC_(149.04897679554750749212281783270446164820376529513) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1760916970670223236083984375e-1), SC_(111.7689260632989075663641089841735509694401263023) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.6152711808681488037109375e-1), SC_(19.648420171615241396309587197842528470296325875333) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.11958599090576171875e0), SC_(7.9835446411526951511089215502958763370640452699352) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.15262925624847412109375e0), SC_(5.7929684997302984899106591310500084810549592853415) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.408089816570281982421875e0), SC_(1.8207235745479932290366383033888580925138751671281) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.6540834903717041015625e0), SC_(1.2008779259180674185688409091279604543152560724219) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1097540378570556640625e1), SC_(0.837614941591401019782015338640924337176173532208) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.30944411754608154296875e1), SC_(-0.11064711705072711614058714393818215651199538001876) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.51139926910400390625e1), SC_(-0.28560995909618471544090026339476669165072848134316) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.95070552825927734375e1), SC_(-0.070320984672870005817728985530953767875125991319117) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.24750102996826171875e2), SC_(-0.034969855732851056137566937072255524574642681084442) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.637722015380859375e2), SC_(0.088677144416535225538191548554109604507495924859443) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1252804412841796875e3), SC_(-0.016614652840629411537374200278934530527325437058532) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.25554705810546875e3), SC_(-0.046944334382395546709632575390166819033582321948395) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.503011474609375e3), SC_(0.017116142571799432034701524060787891096131089201616) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.10074598388671875e4), SC_(0.018828574082540147866960492373486563516775788326714) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1185395751953125e4), SC_(-0.021247101553723907098877939105543222595830665515636) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.353451806640625e4), SC_(-0.0048635505422505591990131409267328924039478993174781) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.80715478515625e4), SC_(-0.0071758642836929329094700510491105467653588351588077) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1622925e5), SC_(-0.00045835118596448456694461339889831018785535996025304) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.3206622265625e5), SC_(-0.00058126704896481903444252448714716390857360657086926) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.3636794921875e5), SC_(0.0035586446178247562819935941307530103708418783440628) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.177219114266335964202880859375e-2), SC_(16050.38317360809551888938504983474985293160801774) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.22177286446094512939453125e-2), SC_(11075.474833652655826402428695168041854400243425914) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.7444499991834163665771484375e-2), SC_(1493.3520265993270406594462917895846831577416183501) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1433600485324859619140625e-1), SC_(504.65866477200025446723672377988930824936031598734) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1760916970670223236083984375e-1), SC_(358.9699899894927971183451476285730108716842050335) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.6152711808681488037109375e-1), SC_(45.049531821826955476217700733408544214729619609096) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.11958599090576171875e0), SC_(14.953018059789110109230235211782508250278109497326) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.15262925624847412109375e0), SC_(9.9984084883063557994328768932355598203674429447502) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.408089816570281982421875e0), SC_(2.1628346776155896248941680110962194808055022509467) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.6540834903717041015625e0), SC_(1.2241890433279414278848901109404364366605307486566) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1097540378570556640625e1), SC_(0.82180664373429894332866487122791267605582421636705) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.30944411754608154296875e1), SC_(0.044675080045786969790818564300127484879691098875366) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.51139926910400390625e1), SC_(-0.34066161710064763933405631930974050215206263274676) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.95070552825927734375e1), SC_(0.025279517162904135307876954052617902402748135408623) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.24750102996826171875e2), SC_(-0.090685309650963474356486311781322418897812936256153) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.637722015380859375e2), SC_(0.064942436489617320631067333196664005473803454000455) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1252804412841796875e3), SC_(-0.041454008854004394363570818770662565478534523565037) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.25554705810546875e3), SC_(-0.037110752614692532342266079408093865632303854148972) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.503011474609375e3), SC_(0.0041099858161033520279163939328389324914564882393675) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.10074598388671875e4), SC_(0.023715905593422533973756873083505240985084087011249) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1185395751953125e4), SC_(-0.016195361774610209197373515825994471151376824315886) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.353451806640625e4), SC_(0.00020849611809697413674038503905187432006662011536559) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.80715478515625e4), SC_(-0.0046749771354633334559191782870168348698715450497592) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1622925e5), SC_(-0.0027785137336625658484552616537140551599570292113774) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.3206622265625e5), SC_(0.0011264066494484881923127415165846939844989443003573) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.3636794921875e5), SC_(0.0024670930993175706597412516662826368794970898949289) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.177219114266335964202880859375e-2), SC_(420549.00565578585217844170022600339360674204746323) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.22177286446094512939453125e-2), SC_(262736.02273345136929437225440146527357933924109683) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.7444499991834163665771484375e-2), SC_(20717.567154895063186385933922987838896837374901969) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1433600485324859619140625e-1), SC_(5239.8840323087611778628248298435555289362598803612) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1760916970670223236083984375e-1), SC_(3403.6237990217096409180648488295846252274494152365) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.6152711808681488037109375e-1), SC_(246.06799429750170656200838876063743271774569815426) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.11958599090576171875e0), SC_(60.664269094051608132306552264948069124653571248546) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.15262925624847412109375e0), SC_(36.209509373985192927555409650039338477663584281534) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.408089816570281982421875e0), SC_(4.4904643003886809538972415667679825782210399118612) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.6540834903717041015625e0), SC_(1.7392082989829522212161833106915805503513209352404) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1097540378570556640625e1), SC_(0.80804263408486677695753124532504451674609833647153) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.30944411754608154296875e1), SC_(0.27486789663634540077998910731331544511708208065808) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.51139926910400390625e1), SC_(-0.3311530242873152102759376791638878383789329890577) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.95070552825927734375e1), SC_(0.17674571189112211198241994658970948163147263333846) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.24750102996826171875e2), SC_(-0.15369831803775493913087335537067262738556684163042) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.637722015380859375e2), SC_(0.001704482575723577869396002876361597604592619586957) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1252804412841796875e3), SC_(-0.068948421759941961963817558699276057764301993063986) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.25554705810546875e3), SC_(-0.0071261043854053510222168178178771819529617670601821) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.503011474609375e3), SC_(-0.01949685525328205660550868857692389923252871839616) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.10074598388671875e4), SC_(0.023541780242584428256657272128066582042400229012058) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1185395751953125e4), SC_(-0.001794951969021907689978973392894118764616461278775) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.353451806640625e4), SC_(0.0087684663484144324872919882274646553530351676024288) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.80715478515625e4), SC_(0.0012583502777049075297035273080686534564283700171024) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1622925e5), SC_(-0.0057325097954444456246445287286467068786922086200511) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.3206622265625e5), SC_(0.0036298824050581388514794912675299427968056540958183) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.3636794921875e5), SC_(-0.00027562998382408631822568420763933666703028686414107) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.177219114266335964202880859375e-2), SC_(3391545133501.4516931987809585785521003110936529221) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.22177286446094512939453125e-2), SC_(1353966407219.138321443993314997453485974808839431) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.7444499991834163665771484375e-2), SC_(9511108319.9201515071688747654641741231431322861275) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1433600485324859619140625e-1), SC_(650109028.2364396033571939115753560204516595733237) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1760916970670223236083984375e-1), SC_(280098346.16689364311723096495909021102229217480038) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.6152711808681488037109375e-1), SC_(1670132.5943817477823784680066015756820469270348202) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.11958599090576171875e0), SC_(109959.15153508370360364621926034453508766078276484) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.15262925624847412109375e0), SC_(40509.686836062513335821480369053983142523273759595) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.408089816570281982421875e0), SC_(726.62810028624515929874041454723508145946147428373) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.6540834903717041015625e0), SC_(106.3774719798964526065105639663716541846948764394) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1097540378570556640625e1), SC_(13.102373226768759304451267722885643343839590474978) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.30944411754608154296875e1), SC_(0.36967843771438008963595655204204882662024738650235) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.51139926910400390625e1), SC_(0.27557658390483526585671270868958942256887223240373) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.95070552825927734375e1), SC_(-0.074159030639947439937675443911875361793505281222441) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.24750102996826171875e2), SC_(0.14293791097469486796900662340082600303015838712552) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.637722015380859375e2), SC_(-0.008735590856522435069227973451881274129809601427742) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1252804412841796875e3), SC_(0.068196105841696842955528878460447572453338370681135) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.25554705810546875e3), SC_(0.0081737789383989378233041482429943203690124992780472) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.503011474609375e3), SC_(0.019102541801644442843873515029994938059173596190126) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.10074598388671875e4), SC_(-0.02362030033990815467318372830667323015089360393774) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1185395751953125e4), SC_(0.0019889426674162547899367406778513638354742356162382) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.353451806640625e4), SC_(-0.0087068113531057214266717984949385481968986089784591) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.80715478515625e4), SC_(-0.001210975029745259603420182216254516980231557400112) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1622925e5), SC_(0.0057195018179326354700516550426518824513127283073225) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.3206622265625e5), SC_(-0.0036169201743391952793649852285156386235495024647391) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.3636794921875e5), SC_(0.00025482232504725337907846809750736007133416017205992) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.177219114266335964202880859375e-2), SC_(106918985978343797084.72950055556416943102084155766) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.22177286446094512939453125e-2), SC_(27137207262798484851.60848132892194219665932449742) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.7444499991834163665771484375e-2), SC_(16521571249167309.104234857149099178081598900433656) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1433600485324859619140625e-1), SC_(300646844086095.3197792002000498951409386281606878) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1760916970670223236083984375e-1), SC_(85509254577506.496588563700764526503895414887296382) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.6152711808681488037109375e-1), SC_(40753735167.090318984255886188913306064769590266735) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.11958599090576171875e0), SC_(701058293.98085773093579257060760439790519987064172) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.15262925624847412109375e0), SC_(157788515.59600070385487516055382714526563086738171) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.408089816570281982421875e0), SC_(388131.86771125959390317577830015906895496438017832) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.6540834903717041015625e0), SC_(21905.245280680641726461711805532197805556083613564) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1097540378570556640625e1), SC_(951.87931350871451694668135280513324188456923310773) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.30944411754608154296875e1), SC_(2.2075589384659261663009906898628710523066875120047) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.51139926910400390625e1), SC_(0.25738242896490476870485851791366442873172284271611) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.95070552825927734375e1), SC_(-0.13303692885373470624284509856539948023046460716567) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.24750102996826171875e2), SC_(-0.11393701726483652254763907862081527017766430096693) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.637722015380859375e2), SC_(0.018544012578028149288526110616867210717785566195635) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1252804412841796875e3), SC_(-0.067400612589857305732310610113281538531016660409411) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.25554705810546875e3), SC_(-0.0082582019391245362665393096179535027657118165096686) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.503011474609375e3), SC_(-0.019527428253184371098614808010711842764928807749458) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.10074598388671875e4), SC_(0.023420855373505628683155407193874109191745302120552) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1185395751953125e4), SC_(-0.0014407835973963459215717612484881544679271081272541) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.353451806640625e4), SC_(0.0089929740547860102269597940356430624245018559918435) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.80715478515625e4), SC_(0.0014715691051611061440142229773869339708246305794065) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1622925e5), SC_(-0.0057939617281395892420572413705025954641850446968186) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.3206622265625e5), SC_(0.0036944740017887806479795521770457260653640035094738) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.3636794921875e5), SC_(-0.00038198733144786886816588026349301975009236456029349) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.7444499991834163665771484375e-2), SC_(6122029771695938838386343306130.723180189121183243) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1433600485324859619140625e-1), SC_(6261331681250645607369452518.8494126758018754944342) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1760916970670223236083984375e-1), SC_(721564046898090189247949366.54709564778717195593112) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.6152711808681488037109375e-1), SC_(1411028513707016323186.6474102288935190658360168694) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.11958599090576171875e0), SC_(1309668290013286109.3110238621745299323662808249106) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.15262925624847412109375e0), SC_(100913867016020563.87338486661445299958991839272881) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.408089816570281982421875e0), SC_(3293384727121.3008906983228350236868526517574014956) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.6540834903717041015625e0), SC_(23314073803.68995622555301463350948579525896214971) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1097540378570556640625e1), SC_(103181373.51505157300353452256015501959238829039471) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.30944411754608154296875e1), SC_(2336.665624469349582344960023288941381043246878401) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.51139926910400390625e1), SC_(17.587577764123338912151855727781950280833852590986) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.95070552825927734375e1), SC_(0.16627256317568584992003589509512169555825232033046) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.24750102996826171875e2), SC_(-0.01485479944711446079400154649012855117103009498783) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.637722015380859375e2), SC_(0.0073944137241097124127881314344151444298851716839877) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1252804412841796875e3), SC_(-0.071150108581815896255646428186237849480610247779432) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.25554705810546875e3), SC_(0.015955060403507418621314889639043839298873662197357) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.503011474609375e3), SC_(-0.03224210754963775567277904950598560557775824359381) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.10074598388671875e4), SC_(0.014473141044961703047900788739969995796477348628079) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1185395751953125e4), SC_(0.011677562775536394072531190829417073129260441745562) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.353451806640625e4), SC_(0.013072920896565434668766321250778455487380981105514) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.80715478515625e4), SC_(0.0062452437137323443987668446486395216189783945247822) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1622925e5), SC_(-0.0061039608531858605293384069760280888143165899386692) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.3206622265625e5), SC_(0.0044545009653792482822926993453507670554093504970126) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.3636794921875e5), SC_(-0.0027207407386124459692652547797540334653165900425075) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1097540378570556640625e1), SC_(5718553577647879187931291011818.7946764848233729687) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.30944411754608154296875e1), SC_(15878777825219167762.144886426384737114183211489929) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.51139926910400390625e1), SC_(44958401611350.290738485323614921053503242018517081) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.95070552825927734375e1), SC_(9868355.2763611133230732195834007953438070882712918) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.24750102996826171875e2), SC_(0.085939360138629434929722984850867373778435508597328) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.637722015380859375e2), SC_(-0.072850481518146108065838686876820992131521109230954) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1252804412841796875e3), SC_(0.070160757390693750538171164394157976562012329449746) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.25554705810546875e3), SC_(-0.047338977361566779740372206987909679446432156844763) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.503011474609375e3), SC_(0.019292512630911767948585791930425630909124162444358) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.10074598388671875e4), SC_(0.022165424839488624220708588390451452334422885852239) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1185395751953125e4), SC_(-0.017876688473146613380715828015625080730433998072684) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.353451806640625e4), SC_(0.0010693972648003514741646456307105954615290774458076) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.80715478515625e4), SC_(-0.0037944543712168337905744354838420171575440093035987) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1622925e5), SC_(-0.0034929491520362219350513545058558481575238318214516) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.3206622265625e5), SC_(0.0017222225790822953699920654857163649240149142028344) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.3636794921875e5), SC_(0.0019625188824867646732219715045686792093423050857075) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.24750102996826171875e2), SC_(1486148656368761070.3067733844917058726059583983625) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.637722015380859375e2), SC_(0.045189931883718917408167275365893010471043211873347) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.1252804412841796875e3), SC_(-0.06581972460262217347722274582602663017350618550533) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.25554705810546875e3), SC_(0.035145134250840266972183346243554000297148827123326) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.503011474609375e3), SC_(-0.02374859617775163187750390759231779161100655913186) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.10074598388671875e4), SC_(-0.020719695818735983484527087390833652120332537225185) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.1185395751953125e4), SC_(0.015496522240116026481722490484497581678501431029051) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.353451806640625e4), SC_(-0.012491015571813182765931031420861539161956446140634) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.80715478515625e4), SC_(-0.0072241856761737258664718437206977035929990472262747) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.1622925e5), SC_(0.0054355372892278911133842354420139570675516109454546) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.3206622265625e5), SC_(-0.00414162872986641906144084373647012786077325298471) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.3636794921875e5), SC_(0.0036696794378347763526831803598432472735786591825062) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.637722015380859375e2), SC_(64102172241568824738554.313263350114698921047196772) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.1252804412841796875e3), SC_(0.028669238001530090689986006367248558097853103415176) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.25554705810546875e3), SC_(0.0086999380966712056598392177684646351595019277735002) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.503011474609375e3), SC_(0.027271758647694884211566608239602403957250495063858) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.10074598388671875e4), SC_(0.016141775478522711854777275263441811758647060616602) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.1185395751953125e4), SC_(-0.0030635230742808967538045995250934011949006412667526) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.353451806640625e4), SC_(-0.012604139540247484489057033643549269878760876662526) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.80715478515625e4), SC_(-0.004586542550492894529277899627109170231179153614758) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.1622925e5), SC_(-0.0051305871820827624082209062944730578025923147157859) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.3206622265625e5), SC_(0.0037365916400430047935400180004006615422072551137795) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.3636794921875e5), SC_(-0.00057330575929745016401046943957745325290212372520893) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.25554705810546875e3), SC_(0.017766650910435412684435760937753147061994369085142) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.503011474609375e3), SC_(-0.024325616495675311208035244731930336804994792603747) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.10074598388671875e4), SC_(-0.024582497986727221372552547965786483736549342375886) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.1185395751953125e4), SC_(0.021730858609225527575770318318161444155928679806303) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.353451806640625e4), SC_(0.01339702862091482673641196596293105625416321146924) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.80715478515625e4), SC_(-0.00049465174084520803262683775733830308872161776075095) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.1622925e5), SC_(-0.000933620597704013531624931933992030157830409342785) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.3206622265625e5), SC_(-0.002660827356362891346188043930348526306264436777364) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.3636794921875e5), SC_(-0.00052488789711522735514504794775813103935505668982484) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.503011474609375e3), SC_(0.011289762099551717248612541581290857268034004081815) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.10074598388671875e4), SC_(0.018957471118648139743738649848349257872826670914768) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.1185395751953125e4), SC_(0.021382395080443600371474508582326204061583298243121) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.353451806640625e4), SC_(-0.0087949231255564610946734959046177407099631532527087) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.80715478515625e4), SC_(0.00032225001969151733882499156513067126227484996133431) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.1622925e5), SC_(-0.0029556736454925350507654290351439466019573510047438) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.3206622265625e5), SC_(5.8810063830100588942189982214386061437765703929018e-05) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.3636794921875e5), SC_(0.001653571805753760571440908719135196005533283054502) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.10074598388671875e4), SC_(0.0070963049520524650359255225433582224381000869333882) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.1185395751953125e4), SC_(-0.0051304638840093393823990164818950901784972219079358) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.353451806640625e4), SC_(-0.012327377284362278212335128280853519756443595480627) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.80715478515625e4), SC_(-0.0049035375011303551186928362971450944848120299430156) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.1622925e5), SC_(0.0059949585379281504355184876907688550844554560613162) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.3206622265625e5), SC_(0.0043910538184415458371451841004922167499887738886412) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.3636794921875e5), SC_(-0.0028627761975582626974487823797858365541987882314106) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.10074598388671875e4), SC_(44868427803786761636385922114.58108958856157509048) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.1185395751953125e4), SC_(0.0063656881274797971054768070414638577443137742829087) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.353451806640625e4), SC_(0.013018347079077163518853409413222379351409473572263) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.80715478515625e4), SC_(0.0086615022132978743577656505687624304612611855703458) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.1622925e5), SC_(-0.0046782501071068694757284612616039733987681968118273) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.3206622265625e5), SC_(-0.0044426762202439584740923487499612317656385701863522) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.3636794921875e5), SC_(-0.00026549739925744064595230336690649967211941010649194) }},
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.177219114266335964202880859375e-2), SC_(359.25299832500584105012706119664623720552832749052) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.22177286446094512939453125e-2), SC_(287.08008188993616436603252786849600135687262083916) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.7444499991834163665771484375e-2), SC_(85.531443286064272175547921480269833916710999889614) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.1433600485324859619140625e-1), SC_(44.430311568893419682014678482118097726479847863616) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.1760916970670223236083984375e-1), SC_(36.17960165906683090877873349112060863353613193172) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.6152711808681488037109375e-1), SC_(10.41360816088979288676530213980540352052572997596) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.11958599090576171875e0), SC_(5.4274280748433743002309559109175574317184829791475) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.15262925624847412109375e0), SC_(4.2916028009615631379978356088929851716183549940195) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.408089816570281982421875e0), SC_(1.7498027657917779527551986186959719996503038512811) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.6540834903717041015625e0), SC_(1.1695542754050435557964056123165018475588523528546) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.1097540378570556640625e1), SC_(0.69876872533854610831144477047749738007759407829826) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.30944411754608154296875e1), SC_(-0.34918569077025695835143072245796651545505228925536) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.51139926910400390625e1), SC_(-0.10797846567918618794696147744841751654356954215666) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.95070552825927734375e1), SC_(-0.20467554567946649947135761132365871073976582546117) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.24750102996826171875e2), SC_(0.065517050394558586520793550807245491384128094920489) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.637722015380859375e2), SC_(0.098583750846927265994965441613646436091055991381092) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.1252804412841796875e3), SC_(0.028278539138060396239930753064638545927242984173035) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.25554705810546875e3), SC_(-0.047728258429237986122070865732482950692468569918037) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.503011474609375e3), SC_(0.032407478918457242739931204640048415169728840912696) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.10074598388671875e4), SC_(0.0050642629033195315734544103343262529422455459899302) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.1185395751953125e4), SC_(-0.022548054316915388250160693583461756984235414071622) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.353451806640625e4), SC_(-0.011397920520857409413066477800620620940456638825982) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.80715478515625e4), SC_(-0.0088801551797002160899436334527728467353177502057152) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.1622925e5), SC_(0.0033827153490835739121192787060890566751418089198844) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.3206622265625e5), SC_(-0.0031165633278924209437739417670780830576424789546487) }}, 
      {{ SC_(-0.177219114266335964202880859375e-2), SC_(0.3636794921875e5), SC_(0.0041669391702775144730402590345991484617112397161904) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.177219114266335964202880859375e-2), SC_(359.26520636180226965328227016370406444311764248295) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.22177286446094512939453125e-2), SC_(287.08911242321766598374360514770374856217915065659) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.7444499991834163665771484375e-2), SC_(85.533097619607190995742806451807343308695669208798) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.1433600485324859619140625e-1), SC_(44.430924879228687603395266008269860652303965750294) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.1760916970670223236083984375e-1), SC_(36.180042734257847205638057019775366630221793013615) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.6152711808681488037109375e-1), SC_(10.41363363037254235749195060176084656438822404653) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.11958599090576171875e0), SC_(5.4273943005151092051811912552731669123015083187232) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.15262925624847412109375e0), SC_(4.2915519442051110942571276781199920737019715158371) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.408089816570281982421875e0), SC_(1.7496594198184395094520653407598681499291859179785) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.6540834903717041015625e0), SC_(1.1693343758706516051854342997709075200509024146944) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.1097540378570556640625e1), SC_(0.69843759661472548448560404589166967619764977462679) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.30944411754608154296875e1), SC_(-0.34939711835541827829167697915781913103916905455461) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.51139926910400390625e1), SC_(-0.10774150562536111111921794863432894591509293971735) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.95070552825927734375e1), SC_(-0.20478692820456204250066864981311504320661834570657) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.24750102996826171875e2), SC_(0.065619526519432064135803483194548402188504301056405) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.637722015380859375e2), SC_(0.098572336329625959373671615781327538597721818047414) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.1252804412841796875e3), SC_(0.028324328681754907670940253764512238811151104879231) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.25554705810546875e3), SC_(-0.047718027190283735905332736591579193151440423255859) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.503011474609375e3), SC_(0.032417741724090558295665413469024297839754534081834) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.10074598388671875e4), SC_(0.0050470297350562115516262153623738069662275148652258) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.1185395751953125e4), SC_(-0.022544303593333434286730280833263732678284988333885) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.353451806640625e4), SC_(-0.01140287641573288536894734714092614888984214356435) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.80715478515625e4), SC_(-0.0088800675059543586977482721680460531390702753744392) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.1622925e5), SC_(0.0033864034553262220029796238561486753247309974346469) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.3206622265625e5), SC_(-0.0031187911530127908326241778886033832968048936118235) }}, 
      {{ SC_(-0.22177286446094512939453125e-2), SC_(0.3636794921875e5), SC_(0.0041666748117892051933944422983928882640892577666923) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.177219114266335964202880859375e-2), SC_(359.61064410335791530802965043842634211184358799672) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.22177286446094512939453125e-2), SC_(287.34459654108932765106825081403006955411702778289) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.7444499991834163665771484375e-2), SC_(85.57987605387485305379253574495150380107095343135) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.1433600485324859619140625e-1), SC_(44.448312650121809995654879435851731769480436992265) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.1760916970670223236083984375e-1), SC_(36.192583221625640339215858724122794456705743657892) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.6152711808681488037109375e-1), SC_(10.414697378603728193884341556137445975215580248966) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.11958599090576171875e0), SC_(5.4271239577199076233163644325468564222072564957563) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.15262925624847412109375e0), SC_(4.2909900256693915477169039185393566524520334285759) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.408089816570281982421875e0), SC_(1.7479183481292359926125757895564528030576201920385) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.6540834903717041015625e0), SC_(1.1667034618365773987031262181809847989646180908947) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.1097540378570556640625e1), SC_(0.69451838549334920539807916244850481031033333439116) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.30944411754608154296875e1), SC_(-0.35186597410577995092669814214138286523633384932917) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.51139926910400390625e1), SC_(-0.10495668238768015624826522626474654300466312797064) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.95070552825927734375e1), SC_(-0.20608632387151405716539748226887287640564365478661) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.24750102996826171875e2), SC_(0.066819386149424140447563890677467856447126832713572) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.637722015380859375e2), SC_(0.09843482001372553427840890233667226794570511650849) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.1252804412841796875e3), SC_(0.028860469070460964231105427792223807723846972948115) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.25554705810546875e3), SC_(-0.047596255693715348739125981731594920127765945207111) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.503011474609375e3), SC_(0.032536951985084549279403212451755661684476849528364) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.10074598388671875e4), SC_(0.004844678116712827361119595634415653594140947684695) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.1185395751953125e4), SC_(-0.022499478247012417889494551226853674513312345564722) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.353451806640625e4), SC_(-0.011460598224470380464325202763577086916843497064869) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.80715478515625e4), SC_(-0.0088787141820492350102324674589156776540236511447843) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.1622925e5), SC_(0.0034295457043507556712247005419318755776344545907984) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.3206622265625e5), SC_(-0.0031448122600442200004364983501508566898550885165975) }}, 
      {{ SC_(-0.7444499991834163665771484375e-2), SC_(0.3636794921875e5), SC_(0.0041634211535581451602063197171722326567496218874864) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.177219114266335964202880859375e-2), SC_(360.63005655871388286749890568891010683796835133004) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.22177286446094512939453125e-2), SC_(288.09827443737360670883795212803159171334071170796) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.7444499991834163665771484375e-2), SC_(85.717549689069268047637985507323158869927050073542) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.1433600485324859619140625e-1), SC_(44.499445593371407999556292782010162227892686260629) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.1760916970670223236083984375e-1), SC_(36.229474507874275469207480775008453738478963562888) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.6152711808681488037109375e-1), SC_(10.418175263551095802170293707273555349839707319603) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.11958599090576171875e0), SC_(5.4270903152201630587023274986422004922255562232365) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.15262925624847412109375e0), SC_(4.2903245734506770700283021455356824529889587281897) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.408089816570281982421875e0), SC_(1.7454507498973461007832435596838439970881948688124) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.6540834903717041015625e0), SC_(1.1630886208450235443575321429517059683144524352945) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.1097540378570556640625e1), SC_(0.68925309348827818917113985250334199618187543611007) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.30944411754608154296875e1), SC_(-0.35508850524015001638507352469550964755059464003344) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.51139926910400390625e1), SC_(-0.10127115257101476219631333933260950963461954502728) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.95070552825927734375e1), SC_(-0.2077789592357481356108406400964319438792262826854) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.24750102996826171875e2), SC_(0.068394746285939271381415969891222140467198874295434) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.637722015380859375e2), SC_(0.098243351018270004168051386754713570564462956604253) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.1252804412841796875e3), SC_(0.029564412978244128047615710747887808223680057660125) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.25554705810546875e3), SC_(-0.047430794678955799882380694042518053107897521833004) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.503011474609375e3), SC_(0.032690778436524366779146971331303902456454770491851) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.10074598388671875e4), SC_(0.0045773792863949902710051550852836547408179695253383) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.1185395751953125e4), SC_(-0.022438058143391312972192377966560841293783743125765) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.353451806640625e4), SC_(-0.011535523177963979101447298024296346490521973336214) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.80715478515625e4), SC_(-0.0088760150698733116236191854440375484344104599594572) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.1622925e5), SC_(0.0034860750146901716509740599020068094528500986540814) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.3206622265625e5), SC_(-0.0031787968361023244742996530026954831787196509416586) }}, 
      {{ SC_(-0.1433600485324859619140625e-1), SC_(0.3636794921875e5), SC_(0.0041587022826279224158683053532324900624417098742086) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.177219114266335964202880859375e-2), SC_(361.3362286561573994967291659439894270303667910875) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.22177286446094512939453125e-2), SC_(288.62019659539817286558099332814507571634428882777) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.7444499991834163665771484375e-2), SC_(85.812677812169395769095387441980882414802042281261) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.1433600485324859619140625e-1), SC_(44.534721651339198844565438139588177764576171262259) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.1760916970670223236083984375e-1), SC_(36.25491341386244565675269780592274472731211437939) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.6152711808681488037109375e-1), SC_(10.420614717916401357834463618735729114339766303817) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.11958599090576171875e0), SC_(5.4271872799775271997930990282043531855427591739181) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.15262925624847412109375e0), SC_(4.2900275784710838984527440589908677637490448570756) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.408089816570281982421875e0), SC_(1.7442079745946297478096818583207425315452776512113) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.6540834903717041015625e0), SC_(1.1613127019448341227778169746359298932142768808962) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.1097540378570556640625e1), SC_(0.68671319728683330350297297597004020385197601802377) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.30944411754608154296875e1), SC_(-0.35660590329793107922573759733460413440748845728911) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.51139926910400390625e1), SC_(-0.099515320596118663026633042607875173442158196008094) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.95070552825927734375e1), SC_(-0.20857461176837805924036249376867834843706233463945) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.24750102996826171875e2), SC_(0.069140272643325384618052156984024373652804780261895) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.637722015380859375e2), SC_(0.098148371733055213968778289942320767761818862648489) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.1252804412841796875e3), SC_(0.029897555689973648076120825520947427017252584196806) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.25554705810546875e3), SC_(-0.047350258720435459491544020816674471211781385128986) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.503011474609375e3), SC_(0.032762499001302592858156069938588597633399342466885) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.10074598388671875e4), SC_(0.0044502337612335934608234150546520827361165369592996) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.1185395751953125e4), SC_(-0.022407964737052065850671865521355085834169107302623) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.353451806640625e4), SC_(-0.011570636349569756158022641588688172773472938924506) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.80715478515625e4), SC_(-0.0088743687623088542064153922262044128135888991424333) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.1622925e5), SC_(0.0035127812980474207031783928933071269530066581560261) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.3206622265625e5), SC_(-0.0031948077989307385526534348107943888038942667059984) }}, 
      {{ SC_(-0.1760916970670223236083984375e-1), SC_(0.3636794921875e5), SC_(0.0041562902915233444644026971965881851368209494634497) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.177219114266335964202880859375e-2), SC_(384.11269958457846495134712071083220365995951193392) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.22177286446094512939453125e-2), SC_(305.41245274849837844068178543656129749935496660639) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.7444499991834163665771484375e-2), SC_(88.823459288970774968739183848437459738478912170232) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.1433600485324859619140625e-1), SC_(45.636986463353705055963917296067476578414814121028) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.1760916970670223236083984375e-1), SC_(37.04583968939050692524074961774000534306827805816) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.6152711808681488037109375e-1), SC_(10.493456233703345346028061607463988692668363870712) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.11958599090576171875e0), SC_(5.4319634116909611032442105455880503144613079264154) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.15262925624847412109375e0), SC_(4.2847401766367357712604677996761979240703615414046) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.408089816570281982421875e0), SC_(1.7226250485540142457361597033022230105124396195468) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.6540834903717041015625e0), SC_(1.1336182277414330520479443530926068910529441592483) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.1097540378570556640625e1), SC_(0.65016859248782149475136023144177021727485568954023) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.30944411754608154296875e1), SC_(-0.3761123556567000957422583768330631005179799896658) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.51139926910400390625e1), SC_(-0.075645894857413855207306710345733916795162088532633) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.95070552825927734375e1), SC_(-0.21872176251645311408691589727481667407861619733229) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.24750102996826171875e2), SC_(0.078964465852438841770281815940968073398239078036033) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.637722015380859375e2), SC_(0.096623631021184908659928197757035045729476833694518) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.1252804412841796875e3), SC_(0.034288089832843980683176763186240659150655737635758) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.25554705810546875e3), SC_(-0.046149408180613215170050544154478901007872441614199) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.503011474609375e3), SC_(0.033640342243770411291683872092989639869379162293025) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.10074598388671875e4), SC_(0.0027341941010176117013146729006293085977106878288653) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.1185395751953125e4), SC_(-0.021947224591876748300173075437674270413783757569986) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.353451806640625e4), SC_(-0.012011827855462814702553645096306100903907612784953) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.80715478515625e4), SC_(-0.0088296153745606454896123108154673032288542319807063) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.1622925e5), SC_(0.0038618547047753835067034488824940751597417025685721) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.3206622265625e5), SC_(-0.0034013015263179432071114553458245357528789506294111) }}, 
      {{ SC_(-0.6152711808681488037109375e-1), SC_(0.3636794921875e5), SC_(0.0041133300315280546708951325030358563889762341476466) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.177219114266335964202880859375e-2), SC_(449.54314527134381285684683130750717794755356655906) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.22177286446094512939453125e-2), SC_(353.33073921816277433023183919430111182975738809923) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.7444499991834163665771484375e-2), SC_(97.054488777029710653756547808428227286119872943737) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.1433600485324859619140625e-1), SC_(48.551739405224245851341609528487091348807398130225) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.1760916970670223236083984375e-1), SC_(39.109295181313173211567453670573467658631926506455) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.6152711808681488037109375e-1), SC_(10.64978287124112823756960785031854839246029115594) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.11958599090576171875e0), SC_(5.4268529148283261273139623239433626751265082883615) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.15262925624847412109375e0), SC_(4.2592168967650097345678389735506145322693495758875) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.408089816570281982421875e0), SC_(1.6772421773192249551897917768553211123083259592179) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.6540834903717041015625e0), SC_(1.084935786782398882754128148555846659132410315979) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.1097540378570556640625e1), SC_(0.5946885869290481527225607133702905628356000948972) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.30944411754608154296875e1), SC_(-0.39927928279045603098587827311127120285340966121171) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.51139926910400390625e1), SC_(-0.0433412437042419571434469408921640520714702017353) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.95070552825927734375e1), SC_(-0.23055670987126551422671525898155297512729822688332) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.24750102996826171875e2), SC_(0.091382236693359232513530342414761234953497031667098) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.637722015380859375e2), SC_(0.093901776879238397755974191381673564210924357954852) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.1252804412841796875e3), SC_(0.0398399128257443841033878991603658931981913509552) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.25554705810546875e3), SC_(-0.044225694630301616068610600151467208249182665936781) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.503011474609375e3), SC_(0.034554656366653069052474265505148396115173383510418) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.10074598388671875e4), SC_(0.00044693093531981372610618002091612231919862871885485) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.1185395751953125e4), SC_(-0.021178285921304830663407159510240375299216238391373) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.353451806640625e4), SC_(-0.012507067098650319312516290640548265609321573100125) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.80715478515625e4), SC_(-0.0087060446899050531461515557704451730588024468891483) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.1622925e5), SC_(0.0042948665105317768832238015138133516665393668710464) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.3206622265625e5), SC_(-0.0036492976358579613917433187180442624641122676277096) }}, 
      {{ SC_(-0.11958599090576171875e0), SC_(0.3636794921875e5), SC_(0.0040265503317154256285610639556638678258276142219818) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.177219114266335964202880859375e-2), SC_(502.79313140614909952993821047680637484127073435073) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.22177286446094512939453125e-2), SC_(392.0127932844769830485516227288399452426674310884) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.7444499991834163665771484375e-2), SC_(103.35914703739410899825167025552372134229108711783) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.1433600485324859619140625e-1), SC_(50.692054383136537389032694886045502910312065399409) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.1760916970670223236083984375e-1), SC_(40.5977984214163531801380299274906292814326998481) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.6152711808681488037109375e-1), SC_(10.72902084223873934039358159509765927916576932478) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.11958599090576171875e0), SC_(5.4028037392900238062567927243343937222528852155065) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.15262925624847412109375e0), SC_(4.2247570530368145407693708674384623369542318595072) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.408089816570281982421875e0), SC_(1.6409640167790041132026353251167830252564134993545) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.6540834903717041015625e0), SC_(1.0504472792601081863819504196923526318069488291285) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.1097540378570556640625e1), SC_(0.5594168879100208543071017706941721732503123643147) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.30944411754608154296875e1), SC_(-0.41101580438950581260242173247332408361377301357098) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.51139926910400390625e1), SC_(-0.024667400777938504281702149877580459896363299795734) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.95070552825927734375e1), SC_(-0.23644677983305657071866263014800414502889940829286) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.24750102996826171875e2), SC_(0.098122845790253960848561576959175554536214143475595) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.637722015380859375e2), SC_(0.092000895020260269649653972915010359527052646429823) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.1252804412841796875e3), SC_(0.042855185207679229682835298518592499577982069168245) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.25554705810546875e3), SC_(-0.04296533407050571303569049116174303170725522050725) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.503011474609375e3), SC_(0.03494716255932982341509450218001653533462466074369) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.10074598388671875e4), SC_(-0.00085774660117593461155272546328658553789256921033751) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.1185395751953125e4), SC_(-0.020661567173797921493226937363878116427030596720566) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.353451806640625e4), SC_(-0.012742736642873882366913415664877222070117405768315) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.80715478515625e4), SC_(-0.0086033144808666958096139947621772804702774455570406) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.1622925e5), SC_(0.0045255880362311201343216439872994480481870412142347) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.3206622265625e5), SC_(-0.003777019192889240239243448537004716248863698156763) }}, 
      {{ SC_(-0.15262925624847412109375e0), SC_(0.3636794921875e5), SC_(0.0039621596347891595719383346333724485721271674607722) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.177219114266335964202880859375e-2), SC_(814.03509584924176696838413946225241203880242085631) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.22177286446094512939453125e-2), SC_(595.86084780427255671136143667792187371593275799487) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.7444499991834163665771484375e-2), SC_(112.42928794107199124991240015655545971316329186965) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.1433600485324859619140625e-1), SC_(46.541957632033480445153056325830325894479628377535) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.1760916970670223236083984375e-1), SC_(35.456171054579499628090900301554407089810231385783) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.6152711808681488037109375e-1), SC_(7.3196443389735677392943581982778097849784326019056) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.11958599090576171875e0), SC_(3.4243131974591657162530629369863557524067264080481) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.15262925624847412109375e0), SC_(2.6362776598976867809272636872543804066104416663608) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.408089816570281982421875e0), SC_(0.98646798407721847494863211346987162175310197609416) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.6540834903717041015625e0), SC_(0.58544276771367463063229444205656970263559112882377) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.1097540378570556640625e1), SC_(0.19961788068794831016631721830046611567145005559452) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.30944411754608154296875e1), SC_(-0.45973383184044612293390169439532099999212530369807) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.51139926910400390625e1), SC_(0.12039637731021221088776886233837663304252499670103) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.95070552825927734375e1), SC_(-0.25916203683945335414079698628696843982945777428859) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.24750102996826171875e2), SC_(0.14012181063947064881229690470294614681540583187758) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.637722015380859375e2), SC_(0.069385944558508215514276778688217926202821552562561) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.1252804412841796875e3), SC_(0.061721671400726098874181813109421845909900127905762) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.25554705810546875e3), SC_(-0.029619657864513424017316218837618883056721269203799) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.503011474609375e3), SC_(0.034770141070879853846518982918474938660486320846611) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.10074598388671875e4), SC_(-0.010604157681205042774407531312327962814583318506285) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.1185395751953125e4), SC_(-0.014919788616979428784214024763570023301934703487157) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.353451806640625e4), SC_(-0.013375501133717419159384852979220998762882901694749) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.80715478515625e4), SC_(-0.0070592042055368824622779334561000263658539644035193) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.1622925e5), SC_(0.0058572280100888617221186115743543958786907443524148) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.3206622265625e5), SC_(-0.00440026005248504746100906549618842740592327235767) }}, 
      {{ SC_(-0.408089816570281982421875e0), SC_(0.3636794921875e5), SC_(0.0031224658790464873611833255233264203789649325635407) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.177219114266335964202880859375e-2), SC_(-7465.9242723949242183985271524584462727945271330976) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.22177286446094512939453125e-2), SC_(-5150.9581000707274764174086538196562493785191657865) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.7444499991834163665771484375e-2), SC_(-692.75625902285826972706081886810263725826163485475) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.1433600485324859619140625e-1), SC_(-233.08632382616813475404634007244444956498126036433) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.1760916970670223236083984375e-1), SC_(-165.40712868077615280166633190698851018736858587918) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.6152711808681488037109375e-1), SC_(-19.89623273401940928443593043013611738414101777396) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.11958599090576171875e0), SC_(-6.1148584190350538321725634414838557374465161228061) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.15262925624847412109375e0), SC_(-3.8816785795127259693171134455762698112653592739494) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.408089816570281982421875e0), SC_(-0.50574791359651333456983009868089716201582379409663) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.6540834903717041015625e0), SC_(-0.21646120561989140082404672541028296267039495259078) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.1097540378570556640625e1), SC_(-0.25118537166222756543568569678386217738989254164263) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.30944411754608154296875e1), SC_(-0.42408933808358607989704392572268763994290156938553) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.51139926910400390625e1), SC_(0.24362554725097528797096292056584307585044338248108) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.95070552825927734375e1), SC_(-0.23991875641377702908327095507463494533936427432929) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.24750102996826171875e2), SC_(0.159308629983397443774959566801213545142999405091) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.637722015380859375e2), SC_(0.036984545296429369452733584943260137317862283983299) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.1252804412841796875e3), SC_(0.070622042987625150401127447728689231472272895551381) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.25554705810546875e3), SC_(-0.012271274390726855141081392845343553736726635753657) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.503011474609375e3), SC_(0.029364664070479218999548533080405627102141495702681) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.10074598388671875e4), SC_(-0.018413816394759638538574871646359176630151289218086) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.1185395751953125e4), SC_(-0.0071344961122520005757291339703415856030112341305455) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.353451806640625e4), SC_(-0.011974377431417616892484859772761039519406142639713) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.80715478515625e4), SC_(-0.0045077494828207696513060656919262568373333627501374) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.1622925e5), SC_(0.0062612538764210071841272094955972764448908162408833) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.3206622265625e5), SC_(-0.0043398932032891146268017812933509102429055406126388) }}, 
      {{ SC_(-0.6540834903717041015625e0), SC_(0.3636794921875e5), SC_(0.0018427423563445264942525463688476131008332261377262) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.177219114266335964202880859375e-2), SC_(-400958.19425017987898838920700811813492917978038541) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.22177286446094512939453125e-2), SC_(-250496.78671655592514666568849007267217612906543497) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.7444499991834163665771484375e-2), SC_(-19752.549995459836169170758679287169499857975018658) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.1433600485324859619140625e-1), SC_(-4995.8866528745270402323406416658343452406023032087) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.1760916970670223236083984375e-1), SC_(-3245.1689035282817749184700266448912732390075227586) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.6152711808681488037109375e-1), SC_(-234.71777319388648810491785335535930996963629105888) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.11958599090576171875e0), SC_(-57.958028778350385662803308366999327263037460526215) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.15262925624847412109375e0), SC_(-34.644983701765571632602470119294375868174152928549) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.408089816570281982421875e0), SC_(-4.4093975055546187529017497432552069661561562818648) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.6540834903717041015625e0), SC_(-1.7803431767765652567925662689637007254800925908969) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.1097540378570556640625e1), SC_(-0.86392768893827996165705065507449654847742064116806) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.30944411754608154296875e1), SC_(-0.15430783100690909526731368358619791763598423586219) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.51139926910400390625e1), SC_(0.35134929202756481529176644261924129434177064808121) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.95070552825927734375e1), SC_(-0.11162324309133267602021314619685807802651322133805) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.24750102996826171875e2), SC_(0.13275004091078420098222705095256822267037650525971) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.637722015380859375e2), SC_(-0.031759663284849747803662371777066257844565709444984) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.1252804412841796875e3), SC_(0.06027658698173006362299253411219128757762652916964) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.25554705810546875e3), SC_(0.021696255085251583181652132554166970067079742545021) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.503011474609375e3), SC_(0.0096121011199821136174168502421060988561582110843257) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.10074598388671875e4), SC_(-0.025103992866500862651615020574775105275453788386725) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.1185395751953125e4), SC_(0.0086810965955283903861193945917185992389558985598995) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.353451806640625e4), SC_(-0.0052950902616329493319420620116264310595569906267947) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.80715478515625e4), SC_(0.001452271569957275727166282171684065353305766864732) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.1622925e5), SC_(0.0047044109388777505613192460985496534573716235969636) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.3206622265625e5), SC_(-0.0026812905254807178072531130658732513779496008175418) }}, 
      {{ SC_(-0.1097540378570556640625e1), SC_(0.3636794921875e5), SC_(-0.00099657705709124707399658338396922939136127906736164) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.177219114266335964202880859375e-2), SC_(-3243360924524.317040529655664172118581477340885098) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.22177286446094512939453125e-2), SC_(-1294808579993.5744041404979665849881153435637743028) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.7444499991834163665771484375e-2), SC_(-9095546678.4248661611799180368474756255240869159998) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.1433600485324859619140625e-1), SC_(-621704307.5837483528942993449056393539952649803179) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.1760916970670223236083984375e-1), SC_(-267860221.5868788922526856171162823431510836077832) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.6152711808681488037109375e-1), SC_(-1597160.7578031091449716572464081149699615931972075) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.11958599090576171875e0), SC_(-105154.78991580501943851687640993490965375997535518) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.15262925624847412109375e0), SC_(-38739.728121114837740380608673544176422008429679094) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.408089816570281982421875e0), SC_(-694.88244614595796861110727499337913736609965833443) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.6540834903717041015625e0), SC_(-101.73576509835408366254769105298618589498958659041) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.1097540378570556640625e1), SC_(-12.546719226461284741629588311022724853165052900289) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.30944411754608154296875e1), SC_(-0.40434199386964373924944008546001793884901863905456) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.51139926910400390625e1), SC_(-0.21364375503304223990175842739616816442539335723793) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.95070552825927734375e1), SC_(0.00037289076821107294279041249790561871125101273760722) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.24750102996826171875e2), SC_(-0.11580253535323992068392623189310365224856340017194) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.637722015380859375e2), SC_(0.037437051384591246699308707753575381446824109568665) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.1252804412841796875e3), SC_(-0.059158009901810683858591133238306046998718513101517) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.25554705810546875e3), SC_(-0.022211499612919619975011146551772460029306618396243) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.503011474609375e3), SC_(-0.0094937024842299522305703555542694501757349976256561) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.10074598388671875e4), SC_(0.02510300544143421753480292859280798434068027213187) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.1185395751953125e4), SC_(-0.0086523406220575906683270920714867921987705372649207) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.353451806640625e4), SC_(0.0053404847630571419729832701393631595598362878351074) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.80715478515625e4), SC_(-0.001414148505714460915490971749068325294545999302285) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.1622925e5), SC_(-0.0047234228258721247241444816654753882170205600860367) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.3206622265625e5), SC_(0.0026981201301774793461723695022017944942929972803124) }}, 
      {{ SC_(-0.30944411754608154296875e1), SC_(0.3636794921875e5), SC_(0.0009772516632904104145479788608870152289501525491306) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.177219114266335964202880859375e-2), SC_(-100135824762025956382.18151448369580657931769217233) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.22177286446094512939453125e-2), SC_(-25415566806336638999.807483087176198218053554058762) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.7444499991834163665771484375e-2), SC_(-15473408658543013.312889465197305811658648034354136) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.1433600485324859619140625e-1), SC_(-281573187579231.12712966116195044408415281648755689) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.1760916970670223236083984375e-1), SC_(-80084370923972.097783196022776303910054815206381362) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.6152711808681488037109375e-1), SC_(-38168234067.580381028304090476734274930563663176791) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.11958599090576171875e0), SC_(-656581708.39977026021543643746941551244276142250661) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.15262925624847412109375e0), SC_(-147778086.39507350829651316165778824195682864897906) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.408089816570281982421875e0), SC_(-363507.98069208585327526404373282821721811053797264) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.6540834903717041015625e0), SC_(-20515.531354680127269626223194452012524996389347767) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.1097540378570556640625e1), SC_(-891.4906100710526293835392671811104740279416407477) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.30944411754608154296875e1), SC_(-2.0882104084120215337576859858002422372120346344191) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.51139926910400390625e1), SC_(-0.28602540976407359706341228176676494672323609015813) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.95070552825927734375e1), SC_(0.1943231887451960936726222502498194831384858219328) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.24750102996826171875e2), SC_(0.067987344701309405908131472014104566084571427694035) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.637722015380859375e2), SC_(-0.051724287505221958558555278154776244114317071081866) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.1252804412841796875e3), SC_(0.055020212246775311651218052261347314648493791266037) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.25554705810546875e3), SC_(0.024986214920834635857765227666611065885724283480893) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.503011474609375e3), SC_(0.0078657004563103320639065386095037805826049642633255) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.10074598388671875e4), SC_(-0.025135257916721503536168752608936664358478053559981) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.1185395751953125e4), SC_(0.0094565485824219345637004056945283707875401823552465) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.353451806640625e4), SC_(-0.0049306359803731045352113540025581730711413092634329) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.80715478515625e4), SC_(0.0016916612668700076087575312681799510507952321176178) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.1622925e5), SC_(0.0045927277943926769584157043642003010426856921426988) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.3206622265625e5), SC_(-0.002587027449607730431564371556642354886807312433012) }}, 
      {{ SC_(-0.51139926910400390625e1), SC_(0.3636794921875e5), SC_(-0.0011026302313789562142562017092977066887938558290485) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.7444499991834163665771484375e-2), SC_(135682601867412602841201330873.75718166853091681263) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.1433600485324859619140625e-1), SC_(138769951363958034085758685.27213034328405718252117) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.1760916970670223236083984375e-1), SC_(15992030576158256918681785.781264646844955179411953) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.6152711808681488037109375e-1), SC_(31272637864980450969.477067090227233607416914800128) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.11958599090576171875e0), SC_(29026190299466825.478740059843997083443769879955458) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.15262925624847412109375e0), SC_(2236554958379870.5390586121842932402591619734406487) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.408089816570281982421875e0), SC_(72991315852.818526598500820999895280048680673698554) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.6540834903717041015625e0), SC_(516710031.1139502164405977913256636071505769421806) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.1097540378570556640625e1), SC_(2286809.7256732380114803720809497779309874729809509) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.30944411754608154296875e1), SC_(51.787413887502021821993382769196320223010933541336) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.51139926910400390625e1), SC_(0.38428403156032438754606601710261851336703009220869) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.95070552825927734375e1), SC_(-0.083408430729217439908554930611117595772954440612026) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.24750102996826171875e2), SC_(-0.15377056099662549274966865873362815231919709139147) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.637722015380859375e2), SC_(-0.098895016463333905076286264733568182187133360232961) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.1252804412841796875e3), SC_(0.00058843259092942399714403630088870115701774575915117) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.25554705810546875e3), SC_(0.047617041465277373764662672292291359611340560712828) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.503011474609375e3), SC_(-0.015738834981652123876831990900249723632354883827403) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.10074598388671875e4), SC_(-0.020226704880645480514464054523051326431570658658102) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.1185395751953125e4), SC_(0.020270634105326650795101629110145519032181458384458) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.353451806640625e4), SC_(0.0033242998134934382898150078049467075957574843247214) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.80715478515625e4), SC_(0.0064510494250325005180436602704881786281515797092011) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.1622925e5), SC_(0.0012673508202080860519717467052694143794136856732047) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.3206622265625e5), SC_(-4.7029903783527169469935056752767141743335143179281e-06) }}, 
      {{ SC_(-0.95070552825927734375e1), SC_(0.3636794921875e5), SC_(-0.0032379678893095256013860413353047782240811917126882) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.1097540378570556640625e1), SC_(-4044936214810011734586457560485.0402321976700478778) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.30944411754608154296875e1), SC_(-11231623976244934832.842042565222515224317423783235) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.51139926910400390625e1), SC_(-31800675532452.142920849818387682401747726375697492) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.95070552825927734375e1), SC_(-6980238.4634442579100267772514665862965992934890797) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.24750102996826171875e2), SC_(-0.027468190501339713583540312783564971313120900350823) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.637722015380859375e2), SC_(0.095644265554053580415773788463005988943081267195329) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.1252804412841796875e3), SC_(-0.055057555525499643764644734873275212200592589253845) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.25554705810546875e3), SC_(0.044401817698862450558820400668208534464946165436997) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.503011474609375e3), SC_(0.0074642328066488539114929577161285856759350095623202) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.10074598388671875e4), SC_(-0.024054503271907318284232697414888321503567745481546) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.1185395751953125e4), SC_(0.0022232306593505723003473007040971439402941783639994) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.353451806640625e4), SC_(-0.010212933027532137699552366415374324125654017299881) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.80715478515625e4), SC_(-0.0029919660686523849430487759086106791540404340466572) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.1622925e5), SC_(0.0061454974098145064990841305379897407652746155974575) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.3206622265625e5), SC_(-0.004123038408727692995462129904507914931818874296158) }}, 
      {{ SC_(-0.24750102996826171875e2), SC_(0.3636794921875e5), SC_(0.001223798459742576052654700614173717144996996668567) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.24750102996826171875e2), SC_(1121547269545524264.1019071139717894324990909433008) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.637722015380859375e2), SC_(0.017445962592616238218316912710931664585543168317819) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.1252804412841796875e3), SC_(-0.053925914217666550924174454968636545587882170986429) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.25554705810546875e3), SC_(0.0040113509336056070148691667126814340248353321014897) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.503011474609375e3), SC_(-0.035174434903250011671768178834872064287806596218907) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.10074598388671875e4), SC_(-0.024946109956172009621827009993565354998098170097575) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.1185395751953125e4), SC_(0.0004040727865427020824432966608094865007837119611164) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.353451806640625e4), SC_(-0.012644847274498598390174769743409301184069275361352) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.80715478515625e4), SC_(-0.008840876881136097560710595328175280582513640919681) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.1622925e5), SC_(0.0020605516525085933298542819924113644830584163178652) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.3206622265625e5), SC_(-0.0020474238830315961535817479237493471602638459906496) }}, 
      {{ SC_(-0.637722015380859375e2), SC_(0.3636794921875e5), SC_(0.0040878844500492049071231293457142270040757414802682) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.637722015380859375e2), SC_(-40791749865962498889641.758772335484825772334862991) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.1252804412841796875e3), SC_(-0.030791942637606724285634132364607907275069801742772) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.25554705810546875e3), SC_(0.029776888363900201775599353374562772371667477615671) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.503011474609375e3), SC_(-0.00041911859652040121232208438061466873169957839316416) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.10074598388671875e4), SC_(0.0044947317007816697448072476126439120934982293558321) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.1185395751953125e4), SC_(0.019618666983233625702565262259622072894105876321234) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.353451806640625e4), SC_(0.011567245652513954110592408692491003647863135553801) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.80715478515625e4), SC_(0.0087846402008567790960595451907553929501383517940439) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.1622925e5), SC_(0.00049400635966328595904587210816203144904291004466221) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.3206622265625e5), SC_(-0.00050551211601910355104251597948766091859715808211562) }}, 
      {{ SC_(-0.1252804412841796875e3), SC_(0.3636794921875e5), SC_(-0.0028321606224831051933457667753745150792068423483548) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.25554705810546875e3), SC_(-0.007419542876595943561206118102461931289478656159302) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.503011474609375e3), SC_(-0.025664328503457286010453238469575264308540938711427) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.10074598388671875e4), SC_(-0.0062267045060275015911110412975034627238501662223391) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.1185395751953125e4), SC_(0.010346705222465791342142235005234520413619356024001) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.353451806640625e4), SC_(0.0015737216406362832957218879171029808283573666980574) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.80715478515625e4), SC_(0.0086954178238511387130531805326295892103131424885212) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.1622925e5), SC_(0.0059876795114625188310669063203330715269983500547108) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.3206622265625e5), SC_(-0.0039268387046749594917957121763691644511316723630028) }}, 
      {{ SC_(-0.25554705810546875e3), SC_(0.3636794921875e5), SC_(0.0040281937153398713181886730861253869188399153486897) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.503011474609375e3), SC_(-0.011515734275236820828668143441039134675933943442574) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.10074598388671875e4), SC_(-0.019439480098341800814673366562691832471213558168089) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.1185395751953125e4), SC_(-0.021174097195867643939757938843271904387325113584952) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.353451806640625e4), SC_(0.0091512905805963337437024280244577532614685720174285) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.80715478515625e4), SC_(-2.4852061600207231159879566155323077157410992369329e-06) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.1622925e5), SC_(0.0031527029965161190784335345322393725220820961636164) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.3206622265625e5), SC_(0.00010179108699906560722797843767392385793289055305172) }}, 
      {{ SC_(-0.503011474609375e3), SC_(0.3636794921875e5), SC_(-0.0017910037003539369964017786582987701717040365613429) }}, 
      {{ SC_(-0.10074598388671875e4), SC_(0.10074598388671875e4), SC_(-0.0049398782329717876592460550567673509553963200002479) }}, 
      {{ SC_(-0.10074598388671875e4), SC_(0.1185395751953125e4), SC_(0.016539718467912811678329197894004476623857530631913) }}, 
      {{ SC_(-0.10074598388671875e4), SC_(0.353451806640625e4), SC_(-0.0029600624556327821316398455606148101916160223845977) }}, 
      {{ SC_(-0.10074598388671875e4), SC_(0.80715478515625e4), SC_(-0.0066872209878214813981572186345699700655450142149478) }}, 
      {{ SC_(-0.10074598388671875e4), SC_(0.1622925e5), SC_(-0.0025322018148959744231881914267926504736624063470507) }}, 
      {{ SC_(-0.10074598388671875e4), SC_(0.3206622265625e5), SC_(0.00019124192154585238406579711362378893608331179461156) }}, 
      {{ SC_(-0.10074598388671875e4), SC_(0.3636794921875e5), SC_(0.0033860372778232452527323118178415916848865195274708) }}, 
      {{ SC_(-0.1185395751953125e4), SC_(0.10074598388671875e4), SC_(-14433345412437616512607944029.072647289035551633298) }}, 
      {{ SC_(-0.1185395751953125e4), SC_(0.1185395751953125e4), SC_(-0.0055141059821012780423227471142113884188743495547959) }}, 
      {{ SC_(-0.1185395751953125e4), SC_(0.353451806640625e4), SC_(-0.0037578815752865130504932569553495448608719007660249) }}, 
      {{ SC_(-0.1185395751953125e4), SC_(0.80715478515625e4), SC_(-0.0011475525169852833356693334344777583323934790794988) }}, 
      {{ SC_(-0.1185395751953125e4), SC_(0.1622925e5), SC_(0.0054358529086944618531913092820724628012685794425012) }}, 
      {{ SC_(-0.1185395751953125e4), SC_(0.3206622265625e5), SC_(0.001126223979426074413337753504813753247338856879985) }}, 
      {{ SC_(-0.1185395751953125e4), SC_(0.3636794921875e5), SC_(-0.0038670666868434098582685598198227731719990621720596) }},
   }};
