PtrContainer, part of collection of the [Boost C++ Libraries](https://github.com/boostorg), provides containers for holding heap-allocated objects in an exception-safe manner and with minimal overhead.

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++11
* Header Only

### Build Status

<!-- boost-ci/tools/makebadges.sh --project ptr_container --appveyor  --codecov  --coverity  -->
| Branch          | GHA CI | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
| :-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
| [`master`](https://github.com/boostorg/ptr_container/tree/master) | [![Build Status](https://github.com/boostorg/ptr_container/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/ptr_container/actions?query=branch:master) | [![Build status](https://ci.appveyor.com/api/projects/status//branch/master?svg=true)](https://ci.appveyor.com/project/cppalliance/ptr-container/branch/master) | [![Coverity Scan Build Status](https://scan.coverity.com/projects//badge.svg)](https://scan.coverity.com/projects/boostorg-ptr_container) | [![codecov](https://codecov.io/gh/boostorg/ptr_container/branch/master/graph/badge.svg?token=)](https://codecov.io/gh/boostorg/ptr_container/tree/master) | [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/ptr_container.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](https://www.boost.org/doc/libs/master/libs/ptr_container) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](https://www.boost.org/development/tests/master/developer/ptr_container.html)
| [`develop`](https://github.com/boostorg/ptr_container/tree/develop) | [![Build Status](https://github.com/boostorg/ptr_container/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/ptr_container/actions?query=branch:develop) | [![Build status](https://ci.appveyor.com/api/projects/status//branch/develop?svg=true)](https://ci.appveyor.com/project/cppalliance/ptr-container/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects//badge.svg)](https://scan.coverity.com/projects/boostorg-ptr_container) | [![codecov](https://codecov.io/gh/boostorg/ptr_container/branch/develop/graph/badge.svg?token=)](https://codecov.io/gh/boostorg/ptr_container/tree/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/ptr_container.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](https://www.boost.org/doc/libs/develop/libs/ptr_container) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](https://www.boost.org/development/tests/develop/developer/ptr_container.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `doc`       | documentation                  |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](https://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-ptr_container)
* [Report bugs](https://github.com/boostorg/ptr_container/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](https://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](https://www.boost.org/community/policy.html) before posting and add the `[ptr_container]` tag at the beginning of the subject line.

