/*
 * (c) 2006-2008 Thomas Maier-Komor
 * LICENSE: GPLv2, see file COPYING for details
 */

#include <assert.h>
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <unistd.h>

#include "log.h"

verbose_t Verbose = Info;

extern struct job_s *Executing;
extern void clear_job(pid_t p, int i);


void dbug(const char *msg, ...)
{
	va_list val;
	if (Verbose < Debug)
		return;
	va_start(val,msg);
	(void) vfprintf(stderr,msg,val);
	va_end(val);
}


void info(const char *msg, ...)
{
	va_list val;
	char buf[4096];
	int len;

	if (Verbose < Info)
		return;
	va_start(val,msg);
	len = vsnprintf(buf,sizeof(buf),msg,val);
	va_end(val);
	(void) write(STDERR_FILENO,buf,len);
}


void warn(const char *msg, ...)
{
	va_list val;

	if (Verbose < Warning)
		return;
	va_start(val,msg);
	(void) vfprintf(stderr,msg,val);
	va_end(val);
}


void error(const char *msg, ...)
{
	va_list val;

	if (Verbose >= Error) {
		va_start(val,msg);
		(void) vfprintf(stderr,msg,val);
		va_end(val);
	}
	while (Executing) {
		int ret;
		pid_t pid;
		while (-1 != (pid = wait(&ret)) && (errno == EINTR));
		clear_job(pid,ret);
	}
	exit(EXIT_FAILURE);
}


