/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.tinyos.message.Message;
import net.tinyos.message.MessageListener;
import net.tinyos.message.MoteIF;
import net.tinyos.mviz.DDocument;
import net.tinyos.packet.BuildSource;
import net.tinyos.util.Messenger;
import net.tinyos.util.PrintStreamMessenger;

public class MessageInput
implements MessageListener {
    private Vector msgVector = new Vector();
    private MoteIF moteIF;
    private DDocument document;

    public MessageInput(Vector vector, String string, DDocument dDocument) {
        this.document = dDocument;
        this.loadMessages(vector);
        this.createSource(string);
        this.installListeners();
    }

    private void loadMessages(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                Message message = (Message)obj;
                this.msgVector.addElement(message);
                continue;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void createSource(String string) {
        this.moteIF = string != null ? new MoteIF(BuildSource.makePhoenix(string, (Messenger)PrintStreamMessenger.err)) : new MoteIF(BuildSource.makePhoenix(PrintStreamMessenger.err));
    }

    private void addMsgType(Message message) {
        this.moteIF.registerListener(message, this);
    }

    private void installListeners() {
        Enumeration enumeration = this.msgVector.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            this.addMsgType(message);
        }
    }

    public void start() {
    }

    public void messageReceived(int n, Message message) {
        Integer n2;
        Object object;
        Object object2;
        String string;
        Enumeration enumeration;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        Class<?> clazz = message.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            enumeration = methodArray[i];
            string = ((Method)((Object)enumeration)).getName();
            object2 = ((Method)((Object)enumeration)).getParameterTypes();
            object = ((Method)((Object)enumeration)).getReturnType();
            if (((Class<?>[])object2).length != 0 || ((Class)object).isArray()) continue;
            if (string.startsWith("get_") && !string.startsWith("get_link")) {
                string = string.substring(4);
                try {
                    n2 = (Integer)((Method)((Object)enumeration)).invoke(message, null);
                    hashtable.put(string, n2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Unable to access field " + string);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println("Unable to access target " + string);
                }
                continue;
            }
            if (!string.startsWith("get_link_")) continue;
            string = string.substring(9);
            try {
                n2 = (Integer)((Method)((Object)enumeration)).invoke(message, null);
                hashtable2.put(string, n2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Unable to access field " + string);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Unable to access target " + string);
            }
        }
        if (hashtable.containsKey("origin")) {
            Integer n3 = (Integer)hashtable.get("origin");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object2 = (Integer)hashtable.get(string);
                this.document.setMoteValue(n3, string, (Integer)object2);
            }
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!string.endsWith("_value")) continue;
                object2 = (Integer)hashtable2.get(string);
                object = (string = string.substring(0, string.length() - 6)) + "_addr";
                if (!hashtable2.containsKey(object)) continue;
                n2 = (Integer)hashtable2.get(object);
                this.document.setLinkValue(n3, n2, string, (Integer)object2);
            }
        } else {
            System.err.println("Could not find origin field, discarding message.");
        }
    }
}

