/* ====================================================================
 * Copyright (c) 2008  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _NULLDIFFINFOMODEL_H
#define _NULLDIFFINFOMODEL_H

// sc
#include "DiffInfoModel.h"
#include "DiffInfo.h"
#include "Conflict.h"
class TextModel;


class NullDiffInfoModel : public DiffInfoModel
{
public:
  NullDiffInfoModel(); 
  virtual ~NullDiffInfoModel();
    
  // DiffInfoModel
  DiffInfos& getInfos();
  TextModel* getModel( DiffInfoModel::DiffModel dm );
  
  DiffInfo& getInfo( int numBlock );
  DiffInfo& getDiffInfo( int numDiff );
  const BlockInfo& getBlockInfo( int numBlock );
  const BlockInfo& getDiffBlockInfo( int numDiff );
  
  int getDiffCnt();
  int getConflictCnt();
  int setActiveDiff( int num );
  int getActiveDiff();
  int nextDiff();
  int prevDiff();
  bool hasNextDiff();
  bool hasPrevDiff();
};


#endif // _NULLDIFFINFOMODEL_H

