Invalid argument for the `offset_of!` macro.

Erroneous code example:

```compile_fail,E0795
#![feature(offset_of_enum, offset_of_nested)]

let x = std::mem::offset_of!(Option<u8>, Some);
```

The `offset_of!` macro gives the offset of a field within a type. It can
navigate through enum variants, but the final component of its second argument
must be a field and not a variant.

The offset of the contained `u8` in the `Option<u8>` can be found by specifying
the field name `0`:

```
#![feature(offset_of_enum, offset_of_nested)]

let x: usize = std::mem::offset_of!(Option<u8>, Some.0);
```

The discriminant of an enumeration may be read with `core::mem::discriminant`,
but this is not always a value physically present within the enum.

Further information about enum layout may be found at
https://rust-lang.github.io/unsafe-code-guidelines/layout/enums.html.
