// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Webcam.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.webcam {

  public class Image : ICloneable {
    public object Clone() {
      Image copy = new Image();
      copy.format = this.format;
      copy.timestamp = this.timestamp;
      copy.encoding = this.encoding;
      copy.data = this.data;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["format"] = this.format.Encode();
      json["timestamp"] = this.timestamp;
      json["encoding"] = this.encoding;
      json["data"] = this.data;
      return json;
    }

    public static Image Decode(LightJson.JsonObject json, Agent agent) {
      Image inst = new Image();
      inst.format = Com.Raritan.Idl.webcam.Format.Decode(json["format"], agent);
      inst.timestamp = (int)json["timestamp"];
      inst.encoding = (string)json["encoding"];
      inst.data = (string)json["data"];
      return inst;
    }

    public Com.Raritan.Idl.webcam.Format format = new Com.Raritan.Idl.webcam.Format();
    public int timestamp = 0;
    public string encoding = "";
    public string data = "";
  }
}
