% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{use_travis}
\alias{use_appveyor}
\alias{use_gitlab_ci}
\alias{use_circleci}
\title{Continuous integration setup and badges}
\usage{
use_travis(browse = interactive(), ext = c("org", "com"))

use_appveyor(browse = interactive())

use_gitlab_ci()

use_circleci(browse = interactive(), image = "rocker/verse:latest")
}
\arguments{
\item{browse}{Open a browser window to enable automatic builds for the
package.}

\item{ext}{which travis website to use. default to \code{"org"}for
https://travis-ci.org. Change to \code{"com"} for https://travis-ci.com.}

\item{image}{The Docker image to use for build. Must be available on
\href{https://hub.docker.com}{DockerHub}. The
\href{https://hub.docker.com/r/rocker/verse}{rocker/verse} image includes TeX
Live, pandoc, and the tidyverse packages. For a minimal image, try
\href{https://hub.docker.com/r/rocker/r-ver}{rocker/r-ver}. To specify a version
of R, change the tag from \code{latest} to the version you want, e.g.
\code{rocker/r-ver:3.5.3}.}
}
\description{
Sets up continuous integration (CI) services for an R package that is
developed on GitHub. CI services can run \code{R CMD check} automatically on
various platforms, triggered by each push or pull request. These functions
\itemize{
\item Add service-specific configuration files and add them to \code{.Rbuildignore}.
\item Activate a service or give the user a detailed prompt.
\item Provide the markdown to insert a badge into README.
}
}
\section{\code{use_travis()}}{

Adds a basic \code{.travis.yml} to the top-level directory of a package. This is a
configuration file for the \href{https://travis-ci.org/}{Travis CI} continuous
integration service.
}

\section{\code{use_appveyor()}}{

Adds a basic \code{appveyor.yml} to the top-level directory of a package. This is
a configuration file for the \href{https://www.appveyor.com}{AppVeyor} continuous
integration service for Windows.
}

\section{\code{use_gitlab_ci()}}{

Adds a basic \code{.gitlab-ci.yml} to the top-level directory of a package. This is
a configuration file for the \href{https://docs.gitlab.com/ee/ci/}{GitLab CI/CD} continuous
integration service for GitLab.
}

\section{\code{use_circleci()}}{

Adds a basic \code{.circleci/config.yml} to the top-level directory of a package. This is a
configuration file for the \href{https://circleci.com/}{CircleCI} continuous
integration service.
}

