% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{interpolate_aw}
\alias{interpolate_aw}
\alias{st_interpolate_aw}
\alias{st_interpolate_aw.sf}
\title{Areal-weighted interpolation of polygon data}
\usage{
st_interpolate_aw(x, to, extensive, ...)

\method{st_interpolate_aw}{sf}(x, to, extensive, ..., keep_NA = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{object of class \code{sf}, for which we want to aggregate attributes}

\item{to}{object of class \code{sf} or \code{sfc}, with the target geometries}

\item{extensive}{logical; if TRUE, the attribute variables are assumed to be spatially extensive (like population) and the sum is preserved, otherwise, spatially intensive (like population density) and the mean is preserved.}

\item{...}{ignored}

\item{keep_NA}{logical; if \code{TRUE}, return all features in \code{to}, if \code{FALSE} return only those with non-NA values (but with \code{row.names} the index corresponding to the feature in \code{to})}

\item{na.rm}{logical; if \code{TRUE} remove features with \code{NA} attributes from \code{x} before interpolating}
}
\description{
Areal-weighted interpolation of polygon data
}
\details{
if \code{extensive} is \code{TRUE} and \code{na.rm} is set to \code{TRUE}, geometries with \code{NA} are effectively treated as having zero attribute values.
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
g = st_make_grid(nc, n = c(10, 5))
a1 = st_interpolate_aw(nc["BIR74"], g, extensive = FALSE)
sum(a1$BIR74) / sum(nc$BIR74) # not close to one: property is assumed spatially intensive
a2 = st_interpolate_aw(nc["BIR74"], g, extensive = TRUE)
# verify mass preservation (pycnophylactic) property:
sum(a2$BIR74) / sum(nc$BIR74)
a1$intensive = a1$BIR74
a1$extensive = a2$BIR74
\donttest{plot(a1[c("intensive", "extensive")], key.pos = 4)}
}
