% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels-retired.R
\name{unit_format}
\alias{unit_format}
\title{Unit labels}
\usage{
unit_format(
  accuracy = NULL,
  scale = 1,
  prefix = "",
  unit = "m",
  sep = " ",
  suffix = paste0(sep, unit),
  big.mark = NULL,
  decimal.mark = NULL,
  trim = TRUE,
  ...
)
}
\arguments{
\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}

\item{prefix}{Additional text to display before the number. The suffix is
applied to absolute value before \code{style_positive} and \code{style_negative} are
processed so that \code{prefix = "$"} will yield (e.g.) \verb{-$1} and \verb{($1)}.}

\item{unit}{The units to append.}

\item{sep}{The separator between the number and the unit label.}

\item{suffix}{Additional text to display after the number.}

\item{big.mark}{Character used between every 3 digits to separate thousands.
The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.  The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function is kept for backward compatiblity; you should either use
\code{\link[=label_number]{label_number()}} or \code{\link[=label_number_si]{label_number_si()}} instead.
}
\examples{
# Label with units
demo_continuous(c(0, 1), labels = unit_format(unit = "m"))
# Labels in kg, but original data in g
km <- unit_format(unit = "km", scale = 1e-3, digits = 2)
demo_continuous(c(0, 2500), labels = km)
}
\keyword{internal}
