% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_simulation_results.R
\name{SimulationResultsMultiArmSurvival}
\alias{SimulationResultsMultiArmSurvival}
\title{Class for Simulation Results Multi-Arm Survival}
\description{
A class for simulation results survival in multi-arm designs.
}
\details{
Use \code{\link[=getSimulationMultiArmSurvival]{getSimulationMultiArmSurvival()}}
to create an object of this type.
}
\section{Fields}{

\describe{
\item{\code{maxNumberOfIterations}}{The number of simulation iterations. Is a numeric vector of length 1 containing a whole number.}

\item{\code{seed}}{The seed used for random number generation. Is a numeric vector of length 1.}

\item{\code{allocationRatioPlanned}}{The planned allocation ratio (\code{n1 / n2}) for the groups. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control. Is a positive numeric vector of length 1.}

\item{\code{conditionalPower}}{The conditional power at each stage of the trial. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{iterations}}{The number of iterations used for simulations. Is a numeric vector of length 1 containing a whole number.}

\item{\code{futilityPerStage}}{The per-stage probabilities of stopping the trial for futility. Is a numeric matrix.}

\item{\code{futilityStop}}{In simulation results data set: indicates whether trial is stopped for futility or not.}

\item{\code{directionUpper}}{Specifies the direction of the alternative, only applicable for one-sided testing. Default is \code{TRUE} which means that larger values of the test statistics yield smaller p-values. Is a logical vector of length 1.}

\item{\code{plannedEvents}}{Determines the number of cumulated (overall) events in survival designs when the interim stages are planned. For two treatment arms, is the number of events for both treatment arms. For multi-arm designs, refers to the overall number of events for the selected arms plus control. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{minNumberOfEventsPerStage}}{Determines the minimum number of events per stage for data-driven sample size recalculation. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{maxNumberOfEventsPerStage}}{Determines the maximum number of events per stage for data-driven sample size recalculation. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{expectedNumberOfEvents}}{The expected number of events under specified alternative. Is a numeric vector.}

\item{\code{activeArms}}{The number of active treatment arms to be compared with control. Is a numeric vector of length 1 containing a whole number.}

\item{\code{effectMatrix}}{The matrix of effect sizes with \code{activeArms} columns and number of rows reflecting the different situations to consider.}

\item{\code{typeOfShape}}{The shape of the dose-response relationship over the treatment groups. Is a character vector of length 1.}

\item{\code{omegaMaxVector}}{The range of hazard ratios with highest response for \code{"linear"} and \code{"sigmoidEmax"} model. Is a numeric vector.}

\item{\code{gED50}}{The ED50 of the sigmoid Emax model. Only necessary if \code{typeOfShape = "sigmoidEmax"} has been specified. Is a numeric vector of length 1.}

\item{\code{slope}}{The slope of the sigmoid Emax model, if \code{typeOfShape = "sigmoidEmax"} Is a numeric vector of length 1.}

\item{\code{intersectionTest}}{The multiple test used for intersection hypotheses in closed systems of hypotheses. Is a character vector of length 1.}

\item{\code{adaptations}}{Indicates whether or not an adaptation takes place at interim k. Is a logical vector of length \code{kMax} minus 1.}

\item{\code{epsilonValue}}{Needs to be specified if \code{typeOfSelection = "epsilon"}. Is a numeric vector of length 1.}

\item{\code{rValue}}{Needs to be specified if \code{typeOfSelection = "rBest"}. Is a numeric vector of length 1.}

\item{\code{threshold}}{The selection criterion: treatment arm/population is only selected if \code{effectMeasure} exceeds \code{threshold}. Either a single numeric value or a numeric vector of length \code{activeArms} referring to a separate threshold condition for each treatment arm.}

\item{\code{selectArmsFunction}}{An optional function that can be entered to define how treatment arms are selected.}

\item{\code{correlationComputation}}{If \code{"alternative"}, a correlation matrix according to Deng et al. (Biometrics, 2019) accounting for the respective alternative is used for simulating log-rank statistics in the many-to-one design. If \code{"null"}, a constant correlation matrix valid under the null hypothesis is used.}

\item{\code{earlyStop}}{The probability to stopping the trial either for efficacy or futility. Is a numeric vector.}

\item{\code{selectedArms}}{The selected arms in multi-armed designs.}

\item{\code{numberOfActiveArms}}{The number of active arms in a multi-armed design. Is a numeric matrix.}

\item{\code{rejectAtLeastOne}}{The probability to reject at least one of the (multiple) hypotheses. Is a numeric vector.}

\item{\code{rejectedArmsPerStage}}{The simulated number of rejected arms per stage.}

\item{\code{successPerStage}}{The simulated success probabilities per stage where success is defined by user. Is a numeric matrix.}

\item{\code{eventsPerStage}}{Deprecated: use \code{singleEventsPerStage} or \code{cumulativeEventsPerStage} instead Is a numeric matrix.}

\item{\code{singleNumberOfEventsPerStage}}{Deprecated: use \code{singleEventsPerArmAndStage} or \code{singleEventsPerSubsetAndStage} instead}

\item{\code{singleEventsPerArmAndStage}}{The number of events per arm and stage that is used for the analysis.}

\item{\code{singleEventsPerStage}}{The single number of events per stage. Is a numeric matrix.}

\item{\code{cumulativeEventsPerStage}}{The cumulative number of events per stage. Is a numeric matrix.}

\item{\code{conditionalPowerAchieved}}{The calculated conditional power, under the assumption of observed or assumed effect sizes. Is a numeric matrix.}
}}

\keyword{internal}
