% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steroidogenic_toxicity.R
\docType{data}
\name{steroidogenic_toxicity}
\alias{steroidogenic_toxicity}
\title{Predicting steroidogenic toxicity with assay data}
\source{
Maglich, J. M., Kuhn, M., Chapin, R. E., & Pletcher, M. T. (2014). More than
just hormones: H295R cells as predictors of reproductive toxicity.
\emph{Reproductive Toxicology}, 45, 77-86.
}
\value{
A tibble with columns
\itemize{
\item \code{class}: factor(levels: toxic and nontoxic)
\item \code{cyp_11a1}: numeric
\item \code{cyp_11b1}: numeric
\item \code{cyp_11b2}: numeric
\item \code{cyp_17a1}: numeric
\item \code{cyp_19a1}: numeric
\item \code{cyp_21a1}: numeric
\item \code{hsd3b2}: numeric
\item \code{star}: numeric
\item \code{progesterone}: numeric
\item \code{testosterone}: numeric
\item \code{dhea}: numeric
\item \code{cortisol}: numeric
}
}
\description{
A set of \emph{in vitro} assays are used to quantify the risk of reproductive
toxicity via the disruption of steroidogenic pathways.
}
\details{
H295R cells were used to measure the effect with two sets of assay results.
The first includes a set of protein measurements on: cytochrome P450 enzymes
("cyp"s), STAR, and 3BHSD2. The second include hormone measurements for
DHEA, progesterone, testosterone, and cortisol.

Columns:
\itemize{
\item \code{class}: factor (levels: 'toxic' and 'nontoxic')
\item \code{cyp_11a1}: numeric
\item \code{cyp_11b1}: numeric
\item \code{cyp_11b2}: numeric
\item \code{cyp_17a1}: numeric
\item \code{cyp_19a1}: numeric
\item \code{cyp_21a1}: numeric
\item \code{hsd3b2}: numeric
\item \code{star}: numeric
\item \code{progesterone}: numeric
\item \code{testosterone}: numeric
\item \code{dhea}: numeric
\item \code{cortisol}: numeric
}
}
\examples{
data(steroidogenic_toxicity)
str(steroidogenic_toxicity)

}
