% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrenchSource.R
\name{.getHurdle}
\alias{.getHurdle}
\title{Obtains logistic fits for presence/absence and fitted probabilities of a zero occurring.}
\usage{
.getHurdle(mat, hdesign = model.matrix(~-1 + log(colSums(mat))),
  pres.abs.mod = TRUE, thresh = FALSE, thresh.val = 1e-08, ...)
}
\arguments{
\item{mat}{count matrix}

\item{hdesign}{design matrix for the logistic; the default is usually sufficient.}

\item{pres.abs.mod}{TRUE if glm regression is for presence or absence. FALSE if glm regression is for counts.}

\item{thresh}{TRUE if numerically one/zero probability occurrences must be thresholded}

\item{thresh.val}{if thresh is true, the numerically one/zero probability occurrences is thresholded
to this value}

\item{...}{other parameters}
}
\value{
A list with components:
         \itemize{
         \item{pi0.fit -  list with feature-wise glm.fit objects}
         \item{pi0 - matrix with fitted probabilities}
         }
}
\description{
This function is used to derive weights for feature-wise compositional estimates. Our (default)
intention is to derive these based on average occurrences across the dataset, as just a function
of sample depth, and not with particular relevance to groups.
}
