# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models
from .._serialization import Deserializer, Serializer
from ._configuration import StreamAnalyticsManagementClientConfiguration
from .operations import (
    ClustersOperations,
    FunctionsOperations,
    InputsOperations,
    Operations,
    OutputsOperations,
    PrivateEndpointsOperations,
    SkuOperations,
    StreamingJobsOperations,
    SubscriptionsOperations,
    TransformationsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class StreamAnalyticsManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Stream Analytics Client.

    :ivar functions: FunctionsOperations operations
    :vartype functions: azure.mgmt.streamanalytics.aio.operations.FunctionsOperations
    :ivar inputs: InputsOperations operations
    :vartype inputs: azure.mgmt.streamanalytics.aio.operations.InputsOperations
    :ivar outputs: OutputsOperations operations
    :vartype outputs: azure.mgmt.streamanalytics.aio.operations.OutputsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.streamanalytics.aio.operations.Operations
    :ivar streaming_jobs: StreamingJobsOperations operations
    :vartype streaming_jobs: azure.mgmt.streamanalytics.aio.operations.StreamingJobsOperations
    :ivar sku: SkuOperations operations
    :vartype sku: azure.mgmt.streamanalytics.aio.operations.SkuOperations
    :ivar subscriptions: SubscriptionsOperations operations
    :vartype subscriptions: azure.mgmt.streamanalytics.aio.operations.SubscriptionsOperations
    :ivar transformations: TransformationsOperations operations
    :vartype transformations: azure.mgmt.streamanalytics.aio.operations.TransformationsOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.streamanalytics.aio.operations.ClustersOperations
    :ivar private_endpoints: PrivateEndpointsOperations operations
    :vartype private_endpoints:
     azure.mgmt.streamanalytics.aio.operations.PrivateEndpointsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = StreamAnalyticsManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.functions = FunctionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.inputs = InputsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.outputs = OutputsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.streaming_jobs = StreamingJobsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sku = SkuOperations(self._client, self._config, self._serialize, self._deserialize)
        self.subscriptions = SubscriptionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.transformations = TransformationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.clusters = ClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.private_endpoints = PrivateEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "StreamAnalyticsManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
