# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AssignmentScopeValidation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The option whether validate the exemption is at or under the assignment scope."""

    DEFAULT = "Default"
    """This option will validate the exemption is at or under the assignment scope."""
    DO_NOT_VALIDATE = "DoNotValidate"
    """This option will bypass the validation the exemption scope is at or under the policy assignment
    #: scope."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ExemptionCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The policy exemption category. Possible values are Waiver and Mitigated."""

    WAIVER = "Waiver"
    """This category of exemptions usually means the scope is not applicable for the policy."""
    MITIGATED = "Mitigated"
    """This category of exemptions usually means the mitigation actions have been applied to the
    #: scope."""


class SelectorKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The selector kind."""

    RESOURCE_LOCATION = "resourceLocation"
    """The selector kind to filter policies by the resource location."""
    RESOURCE_TYPE = "resourceType"
    """The selector kind to filter policies by the resource type."""
    RESOURCE_WITHOUT_LOCATION = "resourceWithoutLocation"
    """The selector kind to filter policies by the resource without location."""
    POLICY_DEFINITION_REFERENCE_ID = "policyDefinitionReferenceId"
    """The selector kind to filter policies by the policy definition reference ID."""
