/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef WOLFLABEL_H
#define WOLFLABEL_H

#include <QtGui/QGraphicsWidget>

class QTimeLine;
class QGraphicsItemAnimation;

namespace KIO {
    class Job;
};

namespace Plasma {
    class Label;
};

class ScrollAnimation;

class WolfLabel: public QGraphicsWidget
{
    Q_OBJECT

    Q_PROPERTY(qreal xOffset READ xOffset() WRITE setXOffset())

    public:
        enum DIRECTION{
            RIGHT,
            LEFT,
            STOPPED
        };

        WolfLabel(QGraphicsWidget *parent);
        ~WolfLabel();

        void resizeEvent(QGraphicsSceneResizeEvent* event);
        bool isResizeFont() const;
        int minimumFont() const;
        void setResizeFont(bool resize, int min);
        void setFont(const QFont &customFont = QFont());
        QFont font() const;
        bool contains(const QPointF &point) const;

        void setXOffset(qreal offset);
        qreal xOffset() const;

        void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    public slots:
        void setText(const QString &text);
        void setImage(const QString &path);
        void clear();

    private:
        void updateLabel(const QString &mode = QString());

        ScrollAnimation *m_animation;
        QFont m_font;
        QFont m_domesticatedFont;
        QPixmap m_image;
        bool m_resizeFont;
        int m_minFont;

        QString m_text;
        bool m_textDirty;
        QPointF m_textPos;
        qreal m_xOffset;
};

#endif