###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_powerzip_bof_vuln.nasl 1151 2009-03-30 13:15:29Z mar $
#
# PowerZip Stack Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900491);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1059");
  script_name("PowerZip Stack Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running PowerZip and is prone to Stack Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  Flaw is due to improper sanitization check for the compressed archive
  'zip' file and may lead to stack based buffer overflow.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes
  via specially  crafted archive 'zip' files.

  Impact level: System/Application

  Affected Software/OS:
  PowerZip Version 7.20 or prior.

  Fix: No solution or patch is available as on 31st March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.powerzip.biz/default.aspx

  References:
  http://www.milw0rm.com/exploits/8180

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of PowerZip");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_powerzip_detect.nasl");
  script_require_keys("PowerZip/Ver");
  exit(0);
}


include("version_func.inc");

zipVer = get_kb_item("PowerZip/Ver");
if(zipVer != NULL)
{
  # Grep for PowerZip version 7.20 or prior
  if(version_is_less_equal(version:zipVer, test_version:"7.20")){
    security_hole(0);
  }
}
