###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-045.nasl 4582 2009-09-09 09:45:21Z sep $
#
# Microsoft JScript Scripting Engine Remote Code Execution Vulnerability (971961)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Added JScript 5.7 on Microsoft Windows 2000 Service Pack 4 (KB975542)
# - By Nikita MR <rnikita@secpod.com> on 2009-11-13
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900929);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1920");
  script_bugtraq_id(36224);
  script_name("Microsoft JScript Scripting Engine Remote Code Execution Vulnerability (971961)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-045.

  Vulnerability Insight:
  The JScript scripting engine does not properly load decoded scripts into
  memory before execution.

  Impact:
  Successful exploitation could lead to memory corruption via specially crafted
  web pages and may allow execution of arbitrary code.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2k  Service Pack 4 and prior
  Microsoft Windows XP  Service Pack 3 and prior
  Microsoft Windows 2k3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-045.mspx

  References:
  http://secunia.com/advisories/36551/
  http://www.vupen.com/english/advisories/2009/2563
  http://www.microsoft.com/technet/security/bulletin/ms09-045.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-045 Hotfix (971961, 975542)
if((hotfix_missing(name:"971961") == 0) || (hotfix_missing(name:"975542") == 0)){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\Jscript.dll");
dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Check for Windows 2000
if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for Jscript.dll version 5.6.0.8837, 5.7 < 5.7.6002.22145
  if(version_is_less(version:dllVer, test_version:"5.6.0.8837") ||
     version_in_range(version:dllVer, test_version:"5.7", test_version2:"5.7.6002.22144")){
    security_hole(0);
  }
}

# Check for Windows XP
else if(hotfix_check_sp(xp:3) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 3" >< SP)
  {
    # Check for Jscript.dll version 5.7 < 5.7.6002.22145, 5.8 < 5.8.6001.22886
    if(version_in_range(version:dllVer, test_version:"5.7", test_version2:"5.7.6002.22144") ||
       version_in_range(version:dllVer, test_version:"5.8", test_version2:"5.8.6001.22885")){
       security_hole(0);
    }
  }
  else if("Service Pack 2" >< SP)
  {
    # Check for Jscript.dll version 5.6.0.8837
    if(version_is_less(version:dllVer, test_version:"5.6.0.8837")){
      security_hole(0);
    }
  }
  else
    security_hole(0);
}

# Check for Windows Server 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for Jscript.dll version < 5.6.0.8837, 5.7 < 5.7.6002.22145,
    # 5.8 < 5.8.6001.22886
    if(version_is_less(version:dllVer, test_version:"5.6.0.8837") ||
       version_in_range(version:dllVer, test_version:"5.7", test_version2:"5.7.6002.22144") ||
       version_in_range(version:dllVer, test_version:"5.8", test_version2:"5.8.6001.22885")){
      security_hole(0);
    }
  }
  else
    security_hole(0);
}
