##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ctorrent_detect.nasl 2464 2009-06-01 10:21:37Z may $
#
# CTorrent/Enhanced CTorrent Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900556);
  script_version("$Revision: 1.1 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("CTorrent/Enhanced CTorrent Version Detection");
  desc = "
  Overview : This script retrieves CTorrent/Enhanced CTorrent version and
  saves the result in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set version of CTorrent/Enhanced CTorrent in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"ctorrent", sock:sock);
foreach binaryFile (getPath)
{
  ctorrentVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-h",
                          ver_pattern:"(C|c)(T|t)orrent (dnh)?([0-9.]+)", sock:sock);
  if(ctorrentVer[4] != NULL)
  {
    if("dnh" >< ctorrentVer[3]){
      set_kb_item(name:"Enhanced/CTorrent/Ver", value:ctorrentVer[4]);
      security_note(data:"Enhanced CTorrent version " + ctorrentVer[4] +
           " running at location " + binaryFile + " was detected on the host");
    }
    else
      set_kb_item(name:"CTorrent/Ver", value:ctorrentVer[4]);
      security_note(data:"CTorrent version " + ctorrentVer[4] +
           " running at location " + binaryFile + " was detected on the host");

  }
  ssh_close_connection();
  exit(0);
}
ssh_close_connection();
