###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_audacity_detect_lin.nasl 1000 2009-02-16 10:10:29Z feb $
#
# Audacity Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900306);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Audacity Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of Audacity and sets
  the reuslt in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Audacity");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_file(file_name:"README.txt",file_path:"/doc/audacity/",
                  useregex:TRUE, regexpar:"$", sock:sock);
foreach binName (paths)
{
  audacityVer = get_bin_version(full_prog_name:"cat", version_argv:binName,
                                ver_pattern:"Version ([0-9]\.[0-9]\.[0-9]+)",
                                sock:sock);
  if("Audacity" >!< audacityVer){
    continue;
  }

  if(audacityVer[1] != NULL)
  {
    set_kb_item(name:"Audacity/Linux/Ver", value:audacityVer[1]);
    security_note(data:"Audacity version " + audacityVer[1] +
             " running at location " + binName + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
