#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Knud Erik Hjgaard <knud@skodliv.dk>
# This script is released under the GNU GPLv2

if(description)
{
 script_id(14263);
 script_bugtraq_id(6724);
 script_cve_id("CVE-2003-0048");
 script_xref(name:"OSVDB", value:"7687");
 script_version("$Revision: 8287 $");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "PuTTY SSH2 authentication password persistence weakness";
 script_name(name);
 desc = "
 PuTTY is a free SSH client.
 It has been reported that this version does not safely handle password information. 
 As a result, a local user may be able to recover authentication passwords.

 Solution : Upgrade to the newest version of PuTTY 

 Risk factor : High";


 script_description(desc);

 summary = "Determine PuTTY version";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Windows";
 script_family(family);
 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc"); 

path = registry_get_sz(item:"DisplayName",
       key:"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\PuTTY_is1");

if(!path){
  exit(0);
}

puttyVer = ereg_replace(pattern:"(.* version) ([0-9.]+.*)", replace:"\1", string:path);
security_note(data:"ver " + puttyVer);
if(!puttyVer){
  exit(0);
}

if(version_is_less_equal(version:puttyVer, test_version:"0.54a")){
  security_hole(0);
}
