###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox-3.0, xulrunner-1.9 regression USN-877-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840361);
  script_version("$Revision: 8167 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "877-1");
  script_cve_id("CVE-2009-3979", "CVE-2009-3981", "CVE-2009-3986", "CVE-2009-3983", "CVE-2009-3984", "CVE-2009-3985");
  script_name("Ubuntu Update for firefox-3.0, xulrunner-1.9 regression USN-877-1");
  desc = "

  Vulnerability Insight:

  USN-873-1 fixed vulnerabilities in Firefox and Xulrunner. The upstream
  changes introduced a regression when using NTLM authentication. This update
  fixes the problem and added additional stability fixes.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  Jesse Ruderman, Josh Soref, Martijn Wargers, Jose Angel, Olli Pettay, and
  David James discovered several flaws in the browser and JavaScript engines
  of Firefox. If a user were tricked into viewing a malicious website, a
  remote attacker could cause a denial of service or possibly execute
  arbitrary code with the privileges of the user invoking the program.
  (CVE-2009-3979, CVE-2009-3981, CVE-2009-3986)
  
  Takehiro Takahashi discovered flaws in the NTLM implementation in Firefox.
  If an NTLM authenticated user visited a malicious website, a remote
  attacker could send requests to other applications, authenticated as the
  user. (CVE-2009-3983)
  
  Jonathan Morgan discovered that Firefox did not properly display SSL
  indicators under certain circumstances. This could be used by an attacker
  to spoof an encrypted page, such as in a phishing attack. (CVE-2009-3984)
  
  Jordi Chancel discovered that Firefox did not properly display invalid URLs
  for a blank page. If a user were tricked into accessing a malicious
  website, an attacker could exploit this to spoof the location bar, such as
  in a phishing attack. (CVE-2009-3985)

  Affected Software/OS:
  firefox-3.0, xulrunner-1.9 regression on Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001022.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox-3.0, xulrunner-1.9 regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0-branding_3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-branding_3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dev_3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-gnome-support_3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0_3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dev_1.9.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-gnome-support_1.9.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9_1.9.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dom-inspector_3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-venkman_3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dom-inspector_1.9.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-venkman_1.9.0.17+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0-branding_3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-branding_3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dev_3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-gnome-support_3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0_3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dev_1.9.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-gnome-support_1.9.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9_1.9.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dom-inspector_3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-venkman_3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dom-inspector_1.9.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-venkman_1.9.0.17+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dev_3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-gnome-support_3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0_3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dev_1.9.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-gnome-support_1.9.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9_1.9.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dom-inspector_3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-venkman_3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dom-inspector_1.9.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-venkman_1.9.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}