###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tdairy_xss_vuln.nasl 7519 2010-03-04 17:25:36Z mar $
#
# tDiary 'tb-send.rb' Plugin Cross-Site Scripting Vulnerability
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800992);
  script_version("$Revision: 7665 $: 1.0");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0726");
  script_bugtraq_id(38413);
  script_name("tDiary 'tb-send.rb' Plugin Cross-Site Scripting Vulnerability");
  desc = "
  Overview: The host is running tDiary and is prone to Cross-Site Scripting
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of the 'plugin_tb_url' and
  'plugin_tb_excerpt' parameters upon submission to the tb-send.rb plugin
  script.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary
  HTML and script code in a user's browser session in the context of an affected
  site.

  Impact Level: Application

  Affected Software/OS:
  tDiary versions prior to 2.2.3

  Fix: Update to version 2.2.3 or later.
  For updates refer, http://www.tdiary.org/

  References:
  http://osvdb.org/62562
  http://www.tdiary.org/20100225.html
  http://secunia.com/advisories/38742
  http://jvndb.jvn.jp/en/contents/2010/JVNDB-2010-000005.html
  http://tdiary.svn.sourceforge.net/viewvc/tdiary/branches/Stable-2_2/plugin/tb-send.rb?r1=3238&r2=3573

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.2
  Risk factor : Medium";

  script_description(desc);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_summary("Check through the version of tDiary");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_dependencies("gb_tdiary_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

## Get HTTP Ports
diaryPort = get_http_port(default:80);
if(!diaryPort){
  exit(0);
}

## Get tDiary Version from KB
diaryVer = get_kb_item("www/" + diaryPort + "/tdiary");
if(isnull(diaryVer)){
  exit(0);
}

diaryVer = eregmatch(pattern:"^(.+) under (/.*)$", string:diaryVer);
if(diaryVer[1] != NULL)
{
  ## Check for version < 2.2.3
  if(version_is_less(version:diaryVer[1], test_version:"2.2.3")){
    security_warning(diaryPort);
  }
}

