###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_multiple_ibm_xss.nasl 7876 2010-06-01 11:02:32Z mime $
#
# Multiple IBM Products Login Page Cross Site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100538);
 script_tag(name:"cvss_base", value:"4.3");
 script_cve_id("CVE-2010-0714");
 script_bugtraq_id(38412);
 script_version ("1.0-$Revision: 7876 $");
  script_tag(name:"risk_factor", value:"Medium");

 script_name("Multiple IBM Products Login Page Cross Site Scripting Vulnerability");

desc = "Overview:
Multiple IBM products are prone to a cross-site scripting
vulnerability because it fails to properly sanitize user-
supplied input.

An attacker may leverage this issue to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site. This may allow the attacker to steal cookie-based authentication
credentials and to launch other attacks.

This issue affects IBM Lotus Web Content Management, WebSphere Portal,
and Lotus Quickr.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/38412
http://www.hacktics.com/#view=Resources%7CAdvisory
http://www-306.ibm.com/software/lotus/products/quickr/
http://www-01.ibm.com/software/lotus/products/webcontentmanagement/
http://www-306.ibm.com/software/websphere/portal/
http://www-01.ibm.com/support/docview.wss?uid=swg21421469

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if installed IBM Product is vulnerable to XSS");
 script_category(ACT_ATTACK);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 10040);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
   
port = get_http_port(default:10040);
if(!get_port_state(port))exit(0);

dir = "/wps/wcm/webinterface/login";

url = string(dir,"/login.jsp?%22%3E%3Cscript%3Ealert(%27openvas-xss-test%27)%3C/script%3E"); 
req = http_get(item:url, port:port);
buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);  
if( buf == NULL )continue;

if(egrep(pattern: "<script>alert\('openvas-xss-test'\)</script>", string: buf, icase: TRUE)) {
   
  security_warning(port:port);
  exit(0);

}

exit(0);

