###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mcafee_groupshield_detect.nasl 2158 2009-05-13 10:07:05Z may $
#
# McAfee GroupShield Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800618);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("McAfee GroupShield Version Detection");
  desc = "

  Overview: This script detects the installed version of McAfee GroupShield
  for Exchange and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of McAfee GroupShield");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

groupshieldKey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:groupshieldKey)){
    exit(0);
}


foreach item(registry_enum_keys(key:groupshieldKey))
{
  groupName = registry_get_sz(key:groupshieldKey + item, item:"DisplayName");
  if("McAfee GroupShield" >< groupName && "Exchange" >< groupName)
  {
    groupshieldVer = registry_get_sz(key:groupshieldKey + item,
                                    item:"DisplayVersion");
    if(groupshieldVer != NULL)
    {
      set_kb_item(name:"McAfee/GroupShield/Exchange/Ver", value:groupshieldVer);
      security_note(data:"McAfee GroupShield version " + groupshieldVer +
                         " was detected on the host");
    }
    exit(0);
  }
}
