###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for hal MDKA-2007:088 (hal)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830296);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:088");
  script_name( "Mandriva Update for hal MDKA-2007:088 (hal)");
  desc = "

  Vulnerability Insight:

  HAL daemon could use 100% cpu when some non storage SCSI peripheral
  when connected to a system.
  
  Update packages fix this issue by upgrading to new version 0.5.9.1,
  as well as other stability fixes and improved suspend/hibernation
  for some laptops.

  Affected Software/OS:
  hal on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-08/msg00013.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of hal");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.9.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hal-gnome", rpm:"hal-gnome~0.5.9.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hal-info", rpm:"hal-info~0.0~5.20070725.2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhal1", rpm:"libhal1~0.5.9.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhal1-devel", rpm:"libhal1-devel~0.5.9.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hal1", rpm:"lib64hal1~0.5.9.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hal1-devel", rpm:"lib64hal1-devel~0.5.9.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}