###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kerberos5_kdc_dos_vuln.nasl 2010-01-22 16:30:29Z jan $
#
# Kerberos5 KDC Cross Realm Referral Denial of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800441);
  script_version("$Revision: 7613 $: 1.0");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3295");
  script_bugtraq_id(37486);
  script_name("Kerberos5 KDC Cross Realm Referral Denial of Service Vulnerability");
  desc = "
  Overview: This host is installed with Kerberos5 and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  The flaw is caused by a NULL pointer dereference error in the KDC cross-realm
  referral processing implementation, which could allow an unauthenticated remote
  attacker to cause KDC to crash.

  Impact:
  Successful exploitation will let the attacker to cause a denial of service.

  Impact level: Application

  Affected Software/OS:
  kerberos5 version prior to 1.7.1

  Fix: Upgrade kerberos5 version 1.7.1 or Apply patch from below link,
  http://web.mit.edu/kerberos/www/
  http://web.mit.edu/kerberos/advisories/2009-003-patch.txt

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/37977
  http://www.vupen.com/english/advisories/2009/3652
  http://web.mit.edu/kerberos/advisories/MITKRB5-SA-2009-003.txt

  CVSS Score:
    CVSS Base Score      : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score  : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Kerberos5");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_kerberos5_detect.nasl");
  script_require_keys("Kerberos5/Ver");
  exit(0);
}


include("version_func.inc");

krbVer = get_kb_item("Kerberos5/Ver");
if(!krbVer){
  exit(0);
}

# Grep for Kerberos5 version 1.7 and prior.
if(version_is_less(version:krbVer, test_version:"1.7.1")){
  security_hole(0);
}

