##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_avast_av_detect_lin.nasl 3254 2009-07-07 15:18:37Z jul $
#
# avast! AntiVirus Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800598);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("avast! AntiVrius Version Detection (Linux)");
  desc = "

  Overview : This script detects the installed version of avast! Anti-Virus
  and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of avast! AntiVrius in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPaths = find_file(file_name:"avast", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);
foreach binaryFile (getPaths)
{
  avVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-V",
                          ver_pattern:"avast v([0-9.]+)", sock:sock);
  if(avVer[1] != NULL)
  {
    set_kb_item(name:"Avast!/AV/Linux/Ver", value:avVer[1]);
    security_note(data:"Avast! Anti Virus version " + avVer[1] + " running at" +
                       " location " + binaryFile +  " was detected on the host");
    ssh_close_connection();
  }
}
ssh_close_connection();
