###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_aol_detect.nasl 5239 2009-10-22 09:15:50Z oct $
#
# America Online (AOL) Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801025);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("America Online (AOL) Version Detection");
  desc = "
  Overview: This script detects the installed version of America Online
  and sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of America Online");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\America Online\AOL\";
if(!registry_key_exists(key:key)){
  exit(0);
}

appPath = registry_get_sz(key:key + "CurrentVersion", item:"AppPath");
if(appPath != NULL)
{
  share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:appPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",
                      string:appPath + "\aol.exe");
  version = GetVer(file:file, share:share);

  if(version != NULL)
  {
    set_kb_item(name:"AOL/Ver", value:version);
    security_note(data:"AOL version " + version + " running at location "
                       + appPath +  " was detected on the host");
  }
}
