# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2903 (lcms)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63659);
 script_cve_id("CVE-2009-0723", "CVE-2009-0733", "CVE-2009-0581");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 10 FEDORA-2009-2903 (lcms)";
 script_name(name);

 desc = "The remote host is missing an update to lcms
announced via advisory FEDORA-2009-2903.

ChangeLog:

* Mon Mar 23 2009 kwizart < kwizart at gmail.com > - 1.18-1
- Update to 1.18 (final)
- Remove upstreamed patches
- Disable autoreconf - patch libtool to prevent rpath issue
* Fri Mar 20 2009 kwizart < kwizart at gmail.com > - 1.18-0.1.beta2
- Update to 1.18beta2
fix bug #487508: CVE-2009-0723 LittleCms integer overflow
fix bug #487512: CVE-2009-0733 LittleCms lack of upper-bounds check on sizes
fix bug #487509: CVE-2009-0581 LittleCms memory leak
* Mon Mar  2 2009 kwizart < kwizart at gmail.com > - 1.17-10
- Fix circle dependency #452352

References:

[ 1 ] Bug #487508 - CVE-2009-0723 LittleCms integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=487508
[ 2 ] Bug #487512 - CVE-2009-0733 LittleCms lack of upper-bounds check on sizes
https://bugzilla.redhat.com/show_bug.cgi?id=487512
[ 3 ] Bug #487509 - CVE-2009-0581 LittleCms memory leak
https://bugzilla.redhat.com/show_bug.cgi?id=487509

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update lcms' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2903

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2903 (lcms)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"lcms", rpm:"lcms~1.18~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms-devel", rpm:"lcms-devel~1.18~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms-libs", rpm:"lcms-libs~1.18~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-lcms", rpm:"python-lcms~1.18~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms-debuginfo", rpm:"lcms-debuginfo~1.18~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
