###############################################################################
# OpenVAS Vulnerability Test
# $Id: family_connections_37379.nasl 7288 2010-04-13 15:32:56Z chandra $
#
# Family Connections Multiple Input Validation Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100408);
 script_bugtraq_id(37379);
 script_version ("1.0-$Revision: 7288 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Family Connections Multiple Input Validation Vulnerabilities");

desc = "Overview:
Family Connections is prone to multiple input-validation
vulnerabilities, including a local file-include issue, an arbitrary
file-upload issue, and multiple SQL-injection issues. These issues
occur because the application fails to properly sanitize user-
supplied input.

Exploiting these issues may allow an unauthorized user to view files
and execute local scripts, execute arbitrary script code, access or
modify data, or exploit latent vulnerabilities in the underlying
database implementation.

Family Connections versions 2.1.3 and prior are affected.

References:
http://www.securityfocus.com/bid/37379
http://www.haudenschilt.com/fcms/index.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Family Connections version is < 2.1.3");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("family_connections_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/FamilyConnections")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less_equal(version: vers, test_version: "2.1.3")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
