# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 964-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56242);
 script_cve_id("CVE-2006-0467");
 script_bugtraq_id(16429);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 964-1 (gnocatan)";
 script_name(name);

 desc = "The remote host is missing an update to gnocatan
announced via advisory DSA 964-1.

A problem has been discovered in gnocatan, the computer version of the
settlers of Catan boardgame, that can lead the server an other clients
to exit via an assert, and hence does not permit the execution of
arbitrary code.  The game has been renamed into Pioneers after the
release of Debian sarge.

For the old stable distribution (woody) this problem has been fixed in
version 0.6.1-5woody3.

For the stable distribution (sarge) this problem has been fixed in
version 0.8.1.59-1sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 0.9.49-1 of pioneers.

We recommend that you upgrade your gnocatan and pioneers packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20964-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 964-1 (gnocatan)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnocatan-data", ver:"0.6.1-5woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-help", ver:"0.6.1-5woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-client", ver:"0.6.1-5woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-server", ver:"0.6.1-5woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-help", ver:"0.8.1.59-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-server-data", ver:"0.8.1.59-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-ai", ver:"0.8.1.59-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-client", ver:"0.8.1.59-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-meta-server", ver:"0.8.1.59-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-server-console", ver:"0.8.1.59-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnocatan-server-gtk", ver:"0.8.1.59-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
