# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 960-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56219);
 script_bugtraq_id(16434);
 script_cve_id("CVE-2005-4536");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 960-2 (libmail-audit-perl)";
 script_name(name);

 desc = "The remote host is missing an update to libmail-audit-perl
announced via advisory DSA 960-2.

This update only corrects the update for sarge, the version in woody is correct.

Niko Tyni discovered that the Mail::Audit module, a Perl library for
creating simple mail filters, logs to a temporary file with a
predictable filename in an insecure fashion when logging is turned on,
which is not the case by default.

For the old stable distribution (woody) these problems have been fixed in
version 2.0-4woody1.

For the stable distribution (sarge) these problems have been fixed in
version 2.1-5sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 2.1-5.1.

We recommend that you upgrade your libmail-audit-perl package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20960-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 960-2 (libmail-audit-perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmail-audit-perl", ver:"2.1-5sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mail-audit-tools", ver:"2.1-5sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
