# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 548-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53238);
 script_bugtraq_id(11084);
 script_cve_id("CVE-2004-0817");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 548-1 (imlib)";
 script_name(name);

 desc = "The remote host is missing an update to imlib
announced via advisory DSA 548-1.

Marcus Meissner discovered a heap overflow error in imlib, an imaging
library for X and X11, that could be abused by an attacker to execute
arbitrary code on the vicims machine.

For the stable distribution (woody) this problem has been fixed in
version 1.9.14-2wody1.

For the unstable distribution (sid) this problem has been fixed in
version 1.9.14-17 of imlib and in version 1.9.14-16 of imlib+png2.

We recommend that you upgrade your imlib1 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20548-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 548-1 (imlib)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imlib-base", ver:"1.9.14-2wody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gdk-imlib-dev", ver:"1.9.14-2wody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gdk-imlib1", ver:"1.9.14-2wody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imlib-dev", ver:"1.9.14-2wody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imlib-progs", ver:"1.9.14-2wody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imlib1", ver:"1.9.14-2wody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
