/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8150778
 * @summary check stacktrace logging
 * @library /test/lib
 * @modules java.base/jdk.internal.misc
 *          java.management
 * @compile TestThrowable.java
 * @run driver StackTraceLogging
 */

import java.io.File;
import java.util.Map;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public class StackTraceLogging {
    static void analyzeOutputOn(ProcessBuilder pb) throws Exception {
        OutputAnalyzer output = new OutputAnalyzer(pb.start());
        // These depths match the ones in TestThrowable.java, except the one greater than 1024
        int[] depths = {10, 34, 100, 1023, 1024};
        for (int d : depths) {
            output.shouldContain("java.lang.RuntimeException, " + d);
        }
        output.shouldHaveExitValue(0);
    }


    public static void main(String[] args) throws Exception {
        ProcessBuilder pb = ProcessTools.createJavaProcessBuilder("-Xlog:stacktrace=info",
                                                                  "-XX:MaxJavaStackTraceDepth=1024",
                                                                  "--add-opens",
                                                                  "java.base/java.lang=ALL-UNNAMED",
                                                                  "TestThrowable");
        analyzeOutputOn(pb);
    }
}
