/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * callbacks.c
 * Copyright (C) chaitanya chandel 2009 <cchandel@yahoo.com>
 * 
 * callbacks.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * callbacks.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define _GNU_SOURCE
#include "callbacks.h"
#include <fcntl.h>
#include <pthread.h>
#include <sys/stat.h>

/*  respond to bt keypress events
 *  currently supports the following 
 *  XF86AudioNext, XF86AudioPlay, XF86AudioPrev and
 *  scancodes from certain bt headsets that arrive as
 *  Keycode-171, Keycode-172, Keycode-173
*/

void key_press(void *data, Evas *canvas_in, Evas_Object *obj, void *event_info)
{
	Evas_Event_Key_Down *ev;
	ev = (Evas_Event_Key_Down *)event_info;
	double current_time=0.0;

	//printf("keyname-%s, %s\n", ev->keyname, ev->key);
	if (strcmp(ev->keyname, "Keycode-171") == 0 || strcmp(ev->keyname, "XF86AudioNext") == 0) next_button_clicked(NULL, NULL, NULL);
	else if (strcmp(ev->keyname, "Keycode-173") == 0 || strcmp(ev->keyname, "XF86AudioPrev") == 0) prev_button_clicked(NULL, NULL, NULL);
	else if (strcmp(ev->keyname, "Keycode-172") == 0 || strcmp(ev->keyname, "XF86AudioPlay") == 0 || strcmp(ev->keyname, "XF86AudioPause") == 0) {
		current_time = ecore_time_get();
		if (current_time - keypress_time > 0.85) {
			play_button_clicked(NULL, NULL, NULL);
			//printf("time diff- %f\n", current_time - keypress_time);
			keypress_time = current_time;
		}
		else {
			//printf("rejecting 2nd keypress. time diff- %f\n", current_time - keypress_time);
			return;
		}
	}
}

/*  randomize the playlist
 */

void randomize_list(void)
{
	int i;

	seq = (int *) malloc((no_songs+1) * sizeof(int));
	srand ( (unsigned)time ( NULL ) );
	// Initialize seq to an ordered range
	for ( i = 0; i <no_songs; i++ ) seq[i] = i;
	// Random shuffle
	for ( i = 0; i < no_songs-1; i++ ) {
		int r = ( rand() % ( no_songs - i -1) +1);
		int save = seq[i];
		seq[i] = seq[i + r];
		seq[i + r] = save;
	}
}

/*  restart mplayer with or without bt streaming
 *  assumes you have told old mplayer process to wuit
 */

void restart_mplayer(void)
{
	char buf[255], line[10], *ans;
	int ret;
	FILE *fp;

	sprintf(buf, "kill -9 %d", pid);
	ret = system(buf);
	//close named pipes
	close(fd);
	fclose(mp_data);
	//unlink the fifo files
	unlink("/tmp/intone-mplayer");
	unlink("/tmp/mplayer-intone");
	//create a fifo file for sending commands to mplayer
	mkfifo("/tmp/intone-mplayer", S_IRUSR| S_IWUSR | O_NONBLOCK);
	//create a fifo file for reading mplayer output
	mkfifo("/tmp/mplayer-intone", S_IRUSR| S_IWUSR | O_NONBLOCK);
	//if bluetooth in use start mplayer with bt
	if (bt) {
		ret = pthread_create(&thread_id, NULL, (void *)start_mplayer_bt, NULL);
		//printf("started mplayer with bt\n");
	}
	//else normal start
	else {
		ret = pthread_create(&thread_id, NULL, (void *)start_mplayer, NULL);
		//printf("started mplayer normal\n");
	}
	//open fifo read only
	mp_data = fopen("/tmp/mplayer-intone", "r");
	//open fifo write only
	fd = open("/tmp/intone-mplayer", O_WRONLY, 0666);
	
	//get the pid value of mplayer
	fp = popen("pidof mplayer", "r");
	ans = fgets(line, sizeof line, fp);
	pclose(fp);
	pid = atoi(line);	
	//renice mplayer to set value
	sprintf(buf, "renice %d %d\n", priority, pid);
	ret = system(buf);
	play_state = IDLE;

	//set labels and slider
	elm_object_text_set(play_cur_pos, "0:00");
	elm_object_text_set(play_dur, "0:00");
	elm_slider_value_set(pos_slider, 0.0);
	seek = 0;
	
	//set play_button icon to play
	snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
	elm_icon_file_set(ic_play, buf, NULL);
}

Eina_Bool timer_func(void *data)
{
	char cmd[255], *tok, tystr[25], buf[255];
	int ret, min, sec;
	ssize_t read = 0;
	size_t len = 0;
	char *dur = "", *ok = "";

	//get time position
	sprintf(cmd, "get_time_pos\n");
	ret = write(fd, cmd, strlen(cmd));
	//read data from mplayer output
	while(strncmp(dur, "ANS_TIME_POSITION", 17) != 0) {
		read = getline(&dur, &len, mp_data);
		//check for end of song
		if (strncmp(dur, "EOF code: 1", 11) == 0) {
			if((song_index + 1) >= no_songs && loop == 0){ //reached end of playlist
				elm_slider_value_set(pos_slider, 0.0);
				play_state = IDLE;
				song_index = 0; seek = 0;
				if (view == LISTVIEW) {
					elm_genlist_item_selected_set(song_list[song_index], 1);
					elm_genlist_item_show(song_list[song_index], ELM_GENLIST_ITEM_SCROLLTO_IN);
				}
				else if (view == ALBUM_ART) show_song_info();
				else if (view == LYRICS) show_song_lyrics();
				elm_object_text_set(play_cur_pos, "0:00");
				snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
				elm_icon_file_set(ic_play, buf, NULL);
				return 0;
			}		 
			//song over - start next song if not end of playlist
			next_button_clicked (NULL, NULL, NULL);
			return 0;
		}
		//check for alsa error for bluetooth streaming
		else if (bt && (ok = strstr(dur, "Unknown PCM bluetooth"))) {
			//tell mplayer to quit
			ret = write(fd, "quit 1\n", 7);
			//popup message
			popup_message("Bluetooth Error!", "Cannot Stream over Bluetooth!", 1);
			bt = 0;
			//restart mplayer normal
			restart_mplayer();
			return 0;
		}
		//check for mplayer crashes
		else if (strncmp(dur, "- MPlayer crashed", 17) == 0) {
			//printf("Mplayer Crashed...Restarting");
			//song_index ++;
			restart_mplayer();
			return 0;
		}
		else if (strncmp(dur, "bt_audio_service_open: connect() failed", 39) == 0) {
			//printf("Mplayer Crashed...Restarting\n");
			//song_index ++;
			bt = 0;
			evas_object_del(set_page_win);
			popup_message("Bluetooth Error!", "Cannot Stream over Bluetooth!", 1);
			restart_mplayer();
			return 0;
		}
	}
	strcat(dur, "=");
	tok = strtok(dur, "=");
	tok = strtok(NULL, "=");
	//set position data
	pos_time = atoi(tok);
	min = pos_time/60;
	sec = pos_time%60;
	elm_slider_value_set(pos_slider, (double)pos_time);
	if (sec < 10) sprintf(tystr, "%d:0%d", min, (int)sec);
	else sprintf(tystr, "%d:%d", min, (int)sec);
	elm_object_text_set(play_cur_pos, tystr);
	return 1;
}

void song_select_play(void *data, Evas_Object *obj, void *event_info) 
{
	int pos, ret, i;
	char *path, cmd[255], buf[PATH_MAX];
	Evas_Object *li = data;

	if(timer1) ecore_timer_del(timer1);
	Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(li);
	if(!gl_item) return;
	_dir *song_data = (_dir *)elm_object_item_data_get(gl_item);
	if (strcmp(song_data->path, "/Add Songs using the 'Songs' Button!") == 0) return;
	pos = song_data->type;
	if (!randomize) {
		song_index = pos;
		path = path_songs[song_index];
	}
	else {
		//get the value of song_index such that seq[song_index] = pos
		for (i=0; i<no_songs-1; i++) if (seq[i] == pos) break;
		song_index = i;
		path = path_songs[seq[song_index]];
	}
	if (strcmp(path, "/Add Songs using the 'Songs' Button!") == 0) return;
	ret = check_file_exists(path);
	if (!ret) {
		elm_object_item_disabled_set(song_list[song_index], EINA_TRUE);
		return;
	}
	//tell mplayer to play cur_song
	sprintf(cmd, "loadfile \"%s\"\n", path);
	ret = write(fd, cmd, strlen(cmd));
	pos_time = 0;
	play_state = PLAYING;
	//set timer
	timer1 = ecore_timer_add(1.0, timer_func, NULL);
	//set selected song info
	if (view == LISTVIEW) {
		if (old_song != gl_item) elm_genlist_item_update(old_song);
		elm_genlist_item_update(gl_item);
	}
	else if(view == ALBUM_ART) show_song_info();
	else if(view == LYRICS) show_song_lyrics();
	ret = set_duration();
	//if (!ret) return;
	//change icon to pause
	snprintf(buf, sizeof(buf), "%s/pause.png", intone_dir);
	elm_icon_file_set(ic_play, buf, NULL);
	elm_object_text_set(play_cur_pos, "0:00");
	elm_slider_value_set(pos_slider, 0.0);
	old_song = gl_item;
}

void song_select(void *data, Evas_Object *obj, void *event_info) 
{
	if(play_state != IDLE ) return;
	Evas_Object *li = data;

	Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(li);
	_dir *song_data = (_dir *)elm_object_item_data_get(gl_item);
	song_index = song_data->type;
	old_song = gl_item;
}

int set_duration(void)
{
	char *dur = "\0", cmd[255], *tok, tystr[3];
	int ret, min, sec;
	ssize_t read;
	size_t len = 0;
	
	//get song duration
	sprintf(cmd, "get_time_length\n");
	ret = write(fd, cmd, strlen(cmd));
	//read data from mplayer output
	while(strncmp(dur, "ANS_LENGTH", 10) != 0) {
		read = getline(&dur, &len, mp_data);
		//printf("%s", dur);
		//check for alsa error for bluetooth streaming
		if (bt && strncmp(dur, "[AO_ALSA]", 9) == 0) {
			//tell mplayer to quit
			ret = write(fd, "quit 1\n", 7);
			//popup message
			popup_message("Bluetooth Error!", "Cannot Stream over Bluetooth!", 1);
			bt = 0;
			//restart mplayer
			restart_mplayer();
			return 0;
		}
		if (strncmp(dur, "- MPlayer crashed", 17) == 0) {
			//printf("Mplayer Crashed...Restarting");
			//song_index ++;
			restart_mplayer();
			return 0;
		}
	}
	strcat(dur, "=");
	tok = strtok(dur, "=");
	tok = strtok(NULL, "=");
	song_dur = atoi(tok);
	min = song_dur / 60;
	sec = song_dur % 60;
	if (sec < 10) sprintf(tystr, "0%d", sec);
	else sprintf(tystr, "%d", sec);
	sprintf(cmd, "%d:%s", min, tystr);
	//printf("%s\n", cmd);
	elm_slider_min_max_set(pos_slider, 0, (double)song_dur);
	elm_object_text_set(play_dur, cmd); //TODO : this is not working on desktops
	return 1;
}

void show_song_info(void)
{
	char *path, *tystr, buf[255];
	int n, ret;
	
	//get the cover img if it exists
	if (randomize) path = path_songs[seq[song_index]];
	else path = path_songs[song_index];
	//check for cover art based on song name
	strcpy(buf, path);
	n = strlen(buf);
	buf[n-3] = 'j';
	buf[n-2] = 'p';
	buf[n-1] = 'g';
	ret = check_file_exists (buf);
	//check for cover.jpg
	if (!ret) {
		tystr = strrchr(path, '/');
		tystr++;
		n = strlen(path) - strlen(tystr);
		strncpy(buf, path, n);
		buf[n] = '\0';
		strcat(buf, "cover.jpg");
		ret = check_file_exists (buf);
	}
	//use the default image
	if (!ret) snprintf(buf, sizeof(buf), "%s/no-album-art.jpg", intone_dir);
	//album-art image
   	elm_image_file_set(im, buf, NULL);
	//get the song and artist names from the db
	set_song_info();
	//set the labels
	elm_object_text_set(artist_lb, cur_artist);
	if(strlen(cur_song) > 36) {
		strncpy(buf, cur_song, 34);
		buf[34] = '.'; buf[35] = '.'; buf[36] = '\0';
		elm_object_text_set(song_lb, buf);
	}
	else elm_object_text_set(song_lb, cur_song);
}

void show_song_lyrics(void)
{
	char buf[PATH_MAX], *path, *data, line[260];
	int n, ret;
	FILE *lyric_file;
	
	//get the lyrics file if it exists
	elm_entry_entry_set(lyrics_entry, "");
	if (randomize) path = path_songs[seq[song_index]];
	else path = path_songs[song_index];
	n = strlen(path);
	strcpy(buf, path);
	buf[n-3] = 't';
	buf[n-2] = 'x';
	buf[n-1] = 't';
	ret = check_file_exists (buf);
	if (ret) {
		lyric_file = fopen(buf, "r");
		while ((data = fgets(line, sizeof line, lyric_file))) {
			n = strlen(line);
			strcpy(buf, line);
			buf[n-1] = '\0';
			strcat(buf, "<br>");
			elm_entry_entry_insert(lyrics_entry, buf);
		}
		elm_scroller_region_show(lyrics_sc, 0, 0, 0, 0);
	}
	else elm_entry_entry_set(lyrics_entry, "No Lyrics File Found");
	//get the song and artist names from the db
	set_song_info();
	//set the labels
	elm_object_text_set(artist_lb, cur_artist);
	if(strlen(cur_song) > 36) {
		strncpy(buf, cur_song, 34);
		buf[34] = '.'; buf[35] = '.'; buf[36] = '\0';
		elm_object_text_set(song_lb, buf);
	}
	else elm_object_text_set(song_lb, cur_song);
	//close the file
	fclose(lyric_file);
}

void prev_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	int ret;
	char *path = NULL, cmd[255];

	if((strlen(cur_playlist) < 1) || (strcmp(cur_playlist, "Select a Playlist!") == 0)) return;
	if (pos_time > 5) {
		//tell mplayer to seek to beginning of this song
		sprintf(cmd, "seek 0 2\n");
		ret = write(fd, cmd, strlen(cmd));
	}
	else {
		song_index -= 1;
		if (song_index < 0) {
			song_index = 0;
			return;
		}
		if(view == LISTVIEW) {
			elm_genlist_item_update(old_song);
			if(!randomize) {
				elm_genlist_item_selected_set(song_list[song_index+1], 0);
				elm_genlist_item_selected_set(song_list[song_index], 1);
				elm_genlist_item_update(song_list[song_index]);
				old_song = song_list[song_index];
				elm_genlist_item_show(song_list[song_index], ELM_GENLIST_ITEM_SCROLLTO_IN);
			}
			else {//if randomize
				elm_genlist_item_selected_set(song_list[seq[song_index+1]], 0);
				elm_genlist_item_selected_set(song_list[seq[song_index]], 1);
				elm_genlist_item_update(song_list[seq[song_index]]);
				old_song = song_list[seq[song_index]];
				elm_genlist_item_show(song_list[seq[song_index]], ELM_GENLIST_ITEM_SCROLLTO_IN);				
			}
		}
		else if (view == ALBUM_ART) show_song_info();
		else if (view == LYRICS) show_song_lyrics();
		if (play_state == IDLE) return;
		if(timer1) ecore_timer_del(timer1);	
		if (randomize) path = path_songs[seq[song_index]];
		else path = path_songs[song_index];
		ret = check_file_exists(path);
		if (!ret) {
			elm_object_item_disabled_set(song_list[song_index], EINA_TRUE);
			next_button_clicked (NULL, NULL, NULL);
			return;
		}
		elm_object_text_set(play_cur_pos, "0:00");
		//tell mplayer to play cur_song
		sprintf(cmd, "loadfile \"%s\"\n", path);
		ret = write(fd, cmd, strlen(cmd));
		ret = set_duration();
		timer1 = ecore_timer_add(1.0, timer_func, NULL);
	}
	//set timer
	pos_time = 0;
	play_state = PLAYING;
}

void next_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	int ret, i;
	char *path = NULL, cmd[255];

	if((strlen(cur_playlist) < 1) || (strcmp(cur_playlist, "Select a Playlist!") == 0)) return;
	if(next_song_random) {
		//set song index such that while next song is playing, rev brings us back to this song
		if (randomize == 0) {
			for (i=0; i<no_songs-1; i++) if (seq[i] == song_index) break;
			song_index = i;
		}
		randomize = 1;
	}
	else {
		//set song index such that next song played is the one after current song
		if (randomize == 1) song_index = seq[song_index];
		randomize = 0;
	}
	song_index += 1;
	if (song_index > no_songs -1) {
		if (loop == 0) {
			song_index = no_songs -1;
			return;
		}
		else song_index = 0;
	}

	if(view == LISTVIEW) {
		elm_genlist_item_update(old_song);
		if (!randomize) {
			if (song_index > 0) elm_genlist_item_selected_set(song_list[song_index-1], 0);
			else elm_genlist_item_selected_set(song_list[no_songs -1], 0);
			elm_genlist_item_selected_set(song_list[song_index], 1);
			elm_genlist_item_update(song_list[song_index]);
			old_song = song_list[song_index];
			elm_genlist_item_show(song_list[song_index], ELM_GENLIST_ITEM_SCROLLTO_IN);
		}
		else { // if randomize
			if(song_index > 0) elm_genlist_item_selected_set(song_list[seq[song_index -1]], 0);
			else elm_genlist_item_selected_set(song_list[seq[no_songs -1]], 0);
			elm_genlist_item_selected_set(song_list[seq[song_index]], 1);
			elm_genlist_item_update(song_list[seq[song_index]]);
			old_song = song_list[seq[song_index]];
			elm_genlist_item_show(song_list[seq[song_index]], ELM_GENLIST_ITEM_SCROLLTO_IN);
		}
	}
	else if (view == ALBUM_ART) show_song_info();
	else if (view == LYRICS) show_song_lyrics();
	if (play_state == IDLE) return;
	if(timer1) ecore_timer_del(timer1);

	if (randomize) path = path_songs[seq[song_index]];
	else path = path_songs[song_index];
	ret = check_file_exists(path);
	if (ret) {
		//set timer
		pos_time = 0;
		timer1 = ecore_timer_add(1.0, timer_func, NULL);
		elm_object_text_set(play_cur_pos, "0:00");
		play_state = PLAYING;
		//tell mplayer to play cur_song
		sprintf(cmd, "loadfile \"%s\"\n", path);
		ret = write(fd, cmd, strlen(cmd));
		ret = set_duration();
	}
	else {
		elm_object_item_disabled_set(song_list[song_index], EINA_TRUE);
		if (song_index >=  no_songs - 1 && loop == 0) { //end of playlist
			elm_slider_value_set(pos_slider, 0.0);
			play_state = IDLE;
			return;
		}
		next_button_clicked (NULL, NULL, NULL);
	}
}

void play_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
    int ret, pos;
	char *path = NULL, cmd[255], buf[PATH_MAX];
	
	if (play_state == PLAYING) {
		ret = write(fd, "pause\n", 6);
		ecore_timer_freeze(timer1);
		play_state = PAUSE;
		//restore system vol in case user wants to use phone
		sprintf(cmd, "amixer -qc 0 set PCM %d%s", sys_vol, "\%\n");
		ret = system(cmd);
		//restore bass
		sprintf(cmd, "amixer -qc 0 set Bass 0\n");
		ret = system(cmd);
		//restore treble
		sprintf(cmd, "amixer -qc 0 set Treble 0\n");
		ret = system(cmd);
		//change icon to play
		snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
		elm_icon_file_set(ic_play, buf, NULL);
		return;
	}
	if (play_state == PAUSE) {
		ret = write(fd, "pause\n", 6);
		ecore_timer_thaw(timer1);
		play_state = PLAYING;
		//restore intone volume
		sprintf(cmd, "amixer -qc 0 set PCM %d%s", vol, "\%\n");
		ret = system(cmd);
		//restore bass
		sprintf(cmd, "amixer -qc 0 set Bass %d\n", bass);
		ret = system(cmd);
		//restore treble
		sprintf(cmd, "amixer -qc 0 set Treble %d\n", treble);
		ret = system(cmd);
		//change icon to pause
		snprintf(buf, sizeof(buf), "%s/pause.png", intone_dir);
		elm_icon_file_set(ic_play, buf, NULL);
		return;
	}
	if (play_state == IDLE) {
		if((strlen(cur_playlist) < 1) || (strcmp(cur_playlist, "Select a Playlist!") == 0)) return;
		//get path for the current song
		if (randomize) path = path_songs[seq[song_index]];
		else path = path_songs[song_index];
		if (strcmp(path, "")  ==  0) return;
		//set up song index
		pos = get_song_pos(path_songs[song_index]);
		ret = check_file_exists(path);
		if (!ret) {
			if (!randomize) elm_object_item_disabled_set(song_list[song_index], EINA_TRUE);
			else elm_object_item_disabled_set(song_list[seq[song_index]], EINA_TRUE);
			song_index = pos - 1;
			play_state = PLAYING;
			// TODO : if last file in the playlist (and missing) stop else next
			if (song_index >=  no_songs - 1) { //end of playlist
				elm_slider_value_set(pos_slider, 0.0);
				play_state = IDLE;
				return;
			}	
			next_button_clicked (NULL, NULL, NULL);
			return;
		}
		//tell mplayer to play cur_song
		sprintf(cmd, "loadfile \"%s\"\n", path);
		ret = write(fd, cmd, strlen(cmd));
		//if seek value exists and user has not selected any other song
		if ((seek) && ((pos - 1) == song_index)) {
			pos_time = seek;
			sprintf(cmd, "seek %d 2\n", pos_time);
			ret = write(fd, cmd, strlen(cmd));
		}
		else {
			song_index = pos - 1; //song_index starts at 0			
			//set pos time
			pos_time = 0;
		}
		//set play state
		play_state = PLAYING;
		ret = set_duration(); //to prevent going to next song after starting with a paused state
		if (!ret) return;
		if (view == LISTVIEW) {
			elm_genlist_item_update(song_list[song_index]);
			elm_genlist_item_show(song_list[song_index], ELM_GENLIST_ITEM_SCROLLTO_IN);
			old_song = song_list[song_index];
		}
		else if(view == ALBUM_ART) show_song_info();
		else if(view == LYRICS) show_song_lyrics();
		//change icon to pause
		snprintf(buf, sizeof(buf), "%s/pause.png", intone_dir);
		elm_icon_file_set(ic_play, buf, NULL);
		timer1 = ecore_timer_add(1.0, timer_func, NULL);
		elm_object_text_set(play_cur_pos, "0:00");
	}
}

void vol_changed(void *data, Evas_Object *obj, void *event_info)
{
	char volume[32];
	double val;
	int ret;

	val = elm_slider_value_get(obj);
	vol = (int)val;
	sprintf(volume, "amixer -qc 0 set PCM %d%s", vol, "\%\n");
	ret = system(volume);
}

void pos_changed_start(void *data, Evas_Object *obj, void *event_info)
{
	if(timer1) ecore_timer_freeze(timer1);
}

void pos_changed(void *data, Evas_Object *obj, void *event_info)
{
	double val;
	int ret;
	char pos[15];
	val = elm_slider_value_get(obj);
	pos_time = val + 1; //actual pos is a fraction of sec more
	sprintf(pos, "seek %d 2\n", pos_time);
	ret = write(fd, pos, strlen(pos));
	if (timer1) ecore_timer_thaw(timer1);
}

int file_select(const struct dirent *entry)
{
	if ((strcmp(entry->d_name, ".") == 0) ||
		(strcmp(entry->d_name, "..") == 0) || 
		(strncmp(entry->d_name,".",1) == 0))
						 return 0;
	else return 1;
}

void load_dir(Evas_Object *li, char *direc)
{
	int n, i;
    struct dirent **eps;
	char buf[255], old_dir[255], buf1[255];
	Elm_Object_Item *dir_list=NULL;
    strcpy(old_dir, direc);
	
	snprintf(buf, sizeof(buf), "%s/folder.png", intone_dir);
	snprintf(buf1, sizeof(buf1), "%s/generic.png", intone_dir);
	n = scandir (old_dir, &eps, file_select, alphasort);
    if (n > 0) {
	    //clear the list
		elm_genlist_clear(li);
	   	for (i = 0; i < n; ++i) {
			if(strcmp(old_dir, "/") == 0) sprintf(dir_gl_entry[i].path, "/%s", eps[i]->d_name);
			else sprintf(dir_gl_entry[i].path, "%s/%s", old_dir, eps[i]->d_name);
			dir_gl_entry[i].type = eps[i]->d_type;
			dir_list = elm_genlist_item_append(li, &itc_dir_list, &dir_gl_entry[i], NULL, 
									ELM_GENLIST_ITEM_NONE, NULL, NULL);
			if(eps[i]->d_type != DT_DIR) elm_object_item_disabled_set(dir_list, EINA_TRUE);
		}
	}
    else return;
    free(eps);
	dir_list = elm_genlist_first_item_get(li);
	elm_genlist_item_selected_set(dir_list ,1);
}

int audio_file_select(const struct dirent *entry)
{
	char *ok;
	
	if ((ok = strstr(entry->d_name, ".mp3")) || (ok = strstr(entry->d_name, ".m4a")) || (ok = strstr(entry->d_name, ".wma")) ||
	    (ok = strstr(entry->d_name, ".oga")) || (ok = strstr(entry->d_name, ".ogg")) || (ok = strstr(entry->d_name, ".wav")) ||
		(ok = strstr(entry->d_name, ".flac")) ||
	    (ok = strstr(entry->d_name, ".MP3")) || (ok = strstr(entry->d_name, ".M4A")) || (ok = strstr(entry->d_name, ".WMA")) || 
	    (ok = strstr(entry->d_name, ".OGA")) || (ok = strstr(entry->d_name, ".OGG")) || (ok = strstr(entry->d_name, ".WAV")) ||
		(ok = strstr(entry->d_name, ".FLAC"))) 
			return 1;
	else return 0;
}

int check_audio_files(char *path)
{
	struct dirent **eps;
	int n;

	n = scandir(path, &eps, audio_file_select, alphasort);
	if (n > 0) return 1;
	else return 0;
}

void list_dir(char *direc)
{
	int n, flag=0, co=1, ret=0, j=0;
	char dir_nm[254], *ty=NULL, tystr[254], path[254], *root_dir=NULL, st_path[254];
	char *ok=NULL, name[254], scan_dir[254], ty_tystr[254];
	struct dirent **eps;
	struct stat statdata;
	tystr[0] = '\0';
	dir_nm[0] = '\0';
	path[0] = '\0';
	scan_dir[0] = '\0';
	
	n = scandir (direc, &eps, file_select, alphasort);
    if (n) {
		int i;
	   	for (i = 0; i < n; ++i) {
			if(eps[i]->d_type == DT_UNKNOWN) {
				sprintf(st_path, "%s/%s", direc, eps[i]->d_name);
				stat(st_path, &statdata);
				eps[i]->d_type = (statdata.st_mode >> 12) & 15;
			}
			if(eps[i]->d_type == DT_DIR) {
				sprintf(scan_dir, "%s/%s", direc, eps[i]->d_name);
				list_dir(scan_dir);
				//reset tystr to cater for value set in recursion
				strcpy(scan_dir, "");
			}
			else {	//if some files exist other than directories
				if (flag == 0) { // first time around - generate the playlist name
					strcpy(dir_nm, direc);
					ty = strrchr(direc, '/');
					ty ++;
					root_dir = strdup(ty);
					ty = strtok(dir_nm, "/");
					while ((ty = strtok (NULL, "/")) != NULL) {
						co ++;
						if (co == depth) root_dir = strdup(ty);
						if (co > depth) {
							// add artist name to playlist name
							if (strcmp(tystr, "") == 0) {
								strcpy (tystr, ty);
							}
							else {
								strcpy(ty_tystr, tystr);
								sprintf(tystr, "%s - %s", ty_tystr, ty);
							}
						}
					}
					//set flag to prevent regeneration of playlist name
					flag = 1;
					//set playlist name for files in the selected directory
					if (strcmp(direc, songs_dir) == 0) strcpy(tystr, root_dir);
					//check at least 1 file is of the type we recognise
					ret = check_audio_files(direc);
					if (ret) {						
						// add the playlist to playlist table
						add_playlist(tystr);
						albums_scanned ++;
					}
				}
				sprintf(path, "%s/%s", direc, eps[i]->d_name);
				//check that file is a song
				if ((ok = strstr(path, ".mp3")) || (ok = strstr(path, ".m4a")) || (ok = strstr(path, ".oga")) || (ok = strstr(path, ".ogg")) ||
					(ok = strstr(path, ".wav")) || (ok = strstr(path, ".wma")) || (ok = strstr(path, ".flac")) ||
					(ok = strstr(path, ".MP3")) || (ok = strstr(path, ".M4A")) || (ok = strstr(path, ".OGA")) || (ok = strstr(path, ".OGG")) ||
					(ok = strstr(path, ".WAV")) || (ok = strstr(path, ".WMA")) || (ok = strstr(path, ".FLAC")) ) {
						strcpy(name, eps[i]->d_name);
						j = strlen(name);
						name[j-4] = '\0';
						add_songs(tystr, name, path);//only adds recognised files
						//printf("%s\n", path);
						songs_scanned++;
				}
			}
    }
	}
  free(root_dir);
}

void up_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
    char tystr[254], ty[254];
    int i, flag=0;    
    Evas_Object *l = data;
    Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(l);
    _dir *dir_gl = (_dir *)elm_object_item_data_get(gl_item);
	char *path = dir_gl->path;
	
    if(strcmp(path, "/") == 0) strcpy(tystr, path);
    else {
        int n = strlen(path);
        strcpy(ty, path);
        for(i=n-1; i>0; i--) {
            if (ty[i] == '/') {
                if (flag == 1) break;
                else flag = 1;
            }
        }
        if (i == 0) strcpy(tystr, "/");
        else {
            strncpy(tystr, ty, i);
            tystr[i] = '\0';
        }
    }
	load_dir(l, tystr);
}

void priority_changed(void *data, Evas_Object *obj, void *event_info)
{
	char Prio[32];
	double val;
	int ret;

	val = elm_slider_value_get(obj);
	priority = (int)val;
	sprintf(Prio, "renice %d %d\n", priority, pid);
	ret = system(Prio);
}

void bass_changed(void *data, Evas_Object *obj, void *event_info)
{
	char Bass[32];
	double val;
	int ret;

	val = elm_slider_value_get(obj);
	bass = (int)val;
	sprintf(Bass, "amixer -qc 0 set Bass %d\n", bass);
	ret = system(Bass);
}

void treble_changed(void *data, Evas_Object *obj, void *event_info)
{
	char Treble[32];
	double val;
	int ret;

	val = elm_slider_value_get(obj);
	treble = (int)val;
	sprintf(Treble, "amixer -qc 0 set Treble %d\n", treble);
	ret = system(Treble);
}

void bt_tg(void *data, Evas_Object *obj, void *event_info)
{
	char *path, cmd[255];
	int ret, restart = 0, pause = 0;
	//char buf[255], line[10], *ans;
	//FILE *fp;
	
	if (bt) bt = 0;
	else bt = 1;
	//printf("bt - %d\n", bt);
	if (bt) {
		//load module uinput for bluetooth headset controls
		ret = system("modprobe uinput");
		bluetooth_on();
	}
	else {
		//printf("switching off bluetooth\n");
		bluetooth_off();
	}
	//if state is playing - restart song on bt
	if (play_state != IDLE) {
		if (play_state == PAUSE) pause = 1;
		restart = 1;
		//freeze timer
		ecore_timer_freeze(timer1);
		play_state = PAUSE;
		//printf("pausing...\n");
	}
	//tell mplayer to quit
	ret = write(fd, "quit 1\n", 7);
	//restart mplayer
	restart_mplayer();
	//tell mplayer to do appropriate action
	if (restart) {
		//tell new mplayer process to play song
		path = path_songs[song_index];
		sprintf(cmd, "loadfile \"%s\"\n", path);
		ret = write(fd, cmd, strlen(cmd));
		//seek to pos_time
		sprintf(cmd, "seek %d 2\n", pos_time);
		ret = write(fd, cmd, strlen(cmd));
		if (!PAUSE) {
			//thaw timer
			ecore_timer_thaw(timer1);
			play_state = PLAYING;
		}
	}
}

void random_tg(void *data, Evas_Object *obj, void *event_info)
{
	char buf[255];
	int temp;

	temp = next_song_random;
	if(temp) next_song_random = 0;
	else next_song_random = 1;
	//set shuffle icon
	if (next_song_random) snprintf(buf, sizeof(buf), "%s/shuffle.png", intone_dir);
	else snprintf(buf, sizeof(buf), "%s/no-shuffle.png", intone_dir);
	elm_icon_file_set(ic_shuffle, buf, NULL);
}

void set_random_mode(void *data, Evas_Object *obj, void *event_info)
{
	char buf[255], *mode;
	mode = (char *)data;
	
	evas_object_hide(shuffle_hv);
	if (strcmp(mode, "random") == 0) {
		random_tg(NULL, NULL, NULL);
		return;
	}
	else if (strcmp(mode, "artist") == 0) snprintf(buf, sizeof(buf), "%s/artist-shuffle.png", intone_dir);
	else if (strcmp(mode, "album") == 0) snprintf(buf, sizeof(buf), "%s/album-shuffle.png", intone_dir);
	if (strcmp(mode, "song") == 0) snprintf(buf, sizeof(buf), "%s/song-shuffle.png", intone_dir);
	elm_icon_file_set(ic_shuffle, buf, NULL);
	//if random mode on - switch it off
	next_song_random = 0;
	strcpy(order_by, mode);
	populate_main_list(list);
}

void finger_tg(void *data, Evas_Object *obj, void *event_info)
{
	if (finger == SMALL) finger = LARGE;
	else finger = SMALL;
}

void playlist_song_tg(void *data, Evas_Object *obj, void *event_info)
{
	if(pl_info) pl_info = 0;
	else pl_info = 1;
	//refresh main list
	populate_main_list (list);
}

void loop_tg(void *data, Evas_Object *obj, void *event_info)
{
	char buf[255];
	
	if(loop == 0) loop =1;
	else loop =0;
	//set repeat icon
	if (loop) snprintf(buf, sizeof(buf), "%s/repeat.png", intone_dir);
	else snprintf(buf, sizeof(buf), "%s/no-repeat.png", intone_dir);
	elm_icon_file_set(ic_repeat, buf, NULL);
}

void rescan_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	int ret;
	pthread_t thread_id;

	Evas_Object *li = (Evas_Object *) data;	
	Elm_Object_Item *gl_item = elm_genlist_selected_item_get(li);
	if(!gl_item) return;
	
	strcpy(songs_dir, (char *)elm_object_item_data_get(gl_item));
	//add albums and songs update message
	popup_message("Adding Songs .... Please Wait !!", NULL, 0);
	scanning = 1;
	scan_timer = ecore_timer_add(1.0, update_scan_popup, NULL);
	ret = pthread_create(&thread_id, NULL, (void *)song_scan, NULL);
}

/*************define del_pl****************/
char (*del_pl)[255]=NULL;

void remove_dir_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	int i, count, ret;
	char *ty, buf[255];
	Evas_Object *li = (Evas_Object *) data;	
	Elm_Object_Item *gl_item = elm_genlist_selected_item_get(li);
	if(!gl_item) return;

	ty = (char *) elm_object_item_data_get(gl_item);
	strcpy(songs_dir, ty);
	count = remove_song_dir(songs_dir);
	for (i=0; i<count; i++) {
		if (strcmp(del_pl[i], "0 All Songs") == 0) {
			//stop playing current song if playing / paused
			if (play_state == PLAYING) ret = write(fd, "pause\n", 6);
			play_state = IDLE;
			//del timer
			if(timer1) ecore_timer_del(timer1);
			//reset song index to 0
			song_index = 0;
			//reset the pos_slider
			elm_slider_value_set(pos_slider, 0.0);
			elm_slider_min_max_set(pos_slider, 0, 0);
			elm_object_text_set(play_cur_pos, "0:00");
			//change play icon
			snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
			elm_icon_file_set(ic_play, buf, NULL);
			continue;
		}
		else if (strcmp(del_pl[i], cur_playlist) == 0) {
			strcpy(cur_playlist, "Select a Playlist!");
			elm_win_title_set(win, cur_playlist);
			//stop playing current song if playing / paused
			if (play_state == PLAYING) ret = write(fd, "pause\n", 6);
			play_state = IDLE;
			//del timer
			if(timer1) ecore_timer_del(timer1);
			//reset song index to 0
			song_index = 0;
			//reset the pos_slider
			elm_slider_value_set(pos_slider, 0.0);
			elm_slider_min_max_set(pos_slider, 0, 0);
			elm_object_text_set(play_cur_pos, "0:00");
			//change play icon
			snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
			elm_icon_file_set(ic_play, buf, NULL);
		}
		del_playlist(del_pl[i]);
	}
	free(del_pl);
	//delete item from list
	elm_object_item_del(gl_item);
	set_no_songs ();
	populate_main_list(list);
}

void temp_playlist(void *data, Evas_Object *obj, void *event_info)
{
	int ret;
	Evas_Object *li = (Evas_Object *) data;
	const Eina_List *item;

	item = elm_genlist_selected_items_get(li);
	if (!item) return;
	//clear ty_playlist and populate it with the selected songs
	setup_ty_playlist(li);
	song_index = 0;
	//set the cur_playlist and populate the main list
	strcpy(cur_playlist, "ty_playlist");
	if (view == ALBUM_ART) toggle_view (NULL, NULL, NULL);
	populate_main_list (list);
	//close all the intervening windows
	evas_object_del(select_songs_page_win);
	evas_object_del(sel_songs_win);
	evas_object_del(manage_songs_page_win);
	//change name of window to Selected Songs
	elm_win_title_set(win, "Selected Songs");
	//stop playing whatever is playing
	ret = write(fd, "pause\n", 6);
	if (timer1) ecore_timer_freeze(timer1);
	play_state = IDLE;
	//reset the pos_slider
	elm_slider_value_set(pos_slider, 0.0);
	elm_slider_min_max_set(pos_slider, 0, 0);
	elm_object_text_set(play_cur_pos, "0:00");
	elm_object_text_set(play_dur, "0:00");
}

Eina_Bool update_scan_popup(void *data)
{
	char message[255];

	sprintf(message, "Added %d songs and %d Albums", songs_scanned, albums_scanned);
	elm_object_text_set(popup_lb, message);
	if (scanning == 1) return 1;
	else {
		//set the button visible
		evas_object_show(popup_bt);
		//help user set the cur playlist if none selected
		if ((strlen(cur_playlist) < 1) || (strcmp(cur_playlist, "Select a Playlist!") == 0)) {
			strcpy(cur_playlist, "0 All Songs");
			elm_win_title_set(win, "All Songs");
		}
		set_no_songs ();
		populate_main_list(list);
		return 0;
	}
}

void song_scan(void)
{
	char tystr[255], *ty;
	int i=1;
	
	//set the album and songs count variables to 0
	song_index = albums_scanned = songs_scanned = 0;
	//set depth
	strcpy(tystr, songs_dir);
	ty = strtok(tystr, "/");
	while ((ty = strtok(NULL, "/")) != NULL) {
		   i ++;
	}
	depth = i;
	begin_transaction ();
	list_dir(songs_dir);
	scanning = 0;
	//add/update default playlists
	add_default_playlist();
	commit_transaction ();
	//check for cur_playlist
	if (strcmp(cur_playlist, "Select a Playlist!") != 0) set_no_songs();
	//set up randomize stuff
	randomize_list();
	add_song_dir(songs_dir);
	//repopulate home list
	populate_home_list(home_list);
}

void change_view_list(void)
{
	char buf[PATH_MAX];

	if (view == ALBUM_ART) {
		evas_object_del(song_lb);
		evas_object_del(artist_lb);
		evas_object_del(im);
	}
	if (view == LYRICS) {
		evas_object_del(lyrics_sc);
		evas_object_del(song_lb);
		evas_object_del(artist_lb);
	}
	view = LISTVIEW;
	//add list to list_box now
	list = elm_genlist_add(win);
	elm_object_scale_set(list, 1.0);
	elm_scroller_bounce_set(list, 0 ,0);
	evas_object_size_hint_weight_set(list, 1.0, 1.0);
	evas_object_size_hint_align_set(list, -1.0, -1.0);
	elm_genlist_multi_select_set(list, 0);
	elm_box_pack_end(list_box, list);
	evas_object_show(list);
	evas_object_smart_callback_add(list, "clicked", song_select_play, list);
	evas_object_smart_callback_add(list, "selected", song_select, list);	

	populate_main_list(list);
	//set the icon
	snprintf(buf, sizeof(buf), "%s/playlist_view.png", intone_dir);
	elm_icon_file_set(ic_view, buf, NULL);
}

void change_view_album(void)
{
	char buf[PATH_MAX], *path, *tystr;
	int n, ret;

	if((strlen(cur_playlist) < 1) || (strcmp(cur_playlist, "Select a Playlist!") == 0)) return;
	if (view == LISTVIEW) evas_object_del(list);
	if (view == LYRICS) {
		evas_object_del(lyrics_sc);
		evas_object_del(artist_lb);
		evas_object_del(im);
	}
	view = ALBUM_ART;
	strcpy(cur_song, "");
	strcpy(cur_artist, "");
	//get the cover img if it exists
	if (randomize) path = path_songs[seq[song_index]];
	else path = path_songs[song_index];
	tystr = strrchr(path, '/');
	tystr++;
	n = strlen(path) - strlen(tystr);
	strncpy(buf, path, n);
	buf[n] = '\0';
	strcat(buf, "cover.jpg");
	ret = check_file_exists (buf);
	if (!ret) snprintf(buf, sizeof(buf), "%s/no-album-art.jpg", intone_dir);
	
	//album-art image
	im = elm_image_add(win);
   	elm_image_file_set(im, buf, NULL);
	elm_image_smooth_set(im, 1);
	evas_object_size_hint_weight_set(im, 1.0, 1.0);
	evas_object_size_hint_align_set(im, -1.0, -1.0);
	elm_box_pack_end(list_box, im);
	evas_object_show(im);
	
	//add a label for song name
	song_lb = elm_label_add(win);
	elm_object_text_set(song_lb, "");
	elm_box_pack_end(list_box, song_lb);
	evas_object_show(song_lb);

	//add a label for artist
	artist_lb = elm_label_add(win);
	elm_object_text_set(artist_lb, "");
	elm_box_pack_end(list_box, artist_lb);
	evas_object_show(artist_lb);
	
	show_song_info();
	//set the icon
	snprintf(buf, sizeof(buf), "%s/lyrics_view.png", intone_dir);
	elm_icon_file_set(ic_view, buf, NULL);
}

void change_view_lyrics(void)
{
	char buf[PATH_MAX];

	if((strlen(cur_playlist) < 1) || (strcmp(cur_playlist, "Select a Playlist!") == 0)) return;
	if (view == LISTVIEW) evas_object_del(list);
	if (view == ALBUM_ART) {
		evas_object_del(song_lb);
		evas_object_del(artist_lb);
		evas_object_del(im);
	}
	view = LYRICS;
	strcpy(cur_song, "");
	strcpy(cur_artist, "");

	//add a scroller for the entry
	lyrics_sc = elm_scroller_add(win);
	evas_object_size_hint_weight_set(lyrics_sc, 1.0, 1.0);
	evas_object_size_hint_align_set(lyrics_sc, -1.0, -1.0);
	elm_scroller_bounce_set(lyrics_sc, 0, 0);
	elm_scroller_policy_set(lyrics_sc, ELM_SCROLLER_POLICY_OFF, ELM_SCROLLER_POLICY_ON);
	elm_box_pack_end(list_box, lyrics_sc);
	
	//add an entry for lyrics
	lyrics_entry = elm_entry_add(win);
	elm_entry_editable_set(lyrics_entry, 0);
	elm_entry_line_wrap_set(lyrics_entry, 1);
	evas_object_size_hint_weight_set(lyrics_entry, 1.0, 1.0);
	evas_object_size_hint_align_set(lyrics_entry, -1.0, -1.0);
	elm_object_content_set(lyrics_sc, lyrics_entry);
	evas_object_show(lyrics_entry);
	evas_object_show(lyrics_sc);

	//add a label for song name
	song_lb = elm_label_add(win);
	elm_object_text_set(song_lb, "");
	elm_box_pack_end(list_box, song_lb);
	evas_object_show(song_lb);

	//add a label for artist
	artist_lb = elm_label_add(win);
	elm_object_text_set(artist_lb, "");
	elm_box_pack_end(list_box, artist_lb);
	evas_object_show(artist_lb);

	show_song_lyrics();
	//set the icon
	snprintf(buf, sizeof(buf), "%s/album_view.png", intone_dir);
	elm_icon_file_set(ic_view, buf, NULL);
}

void toggle_view (void *data, Evas_Object *obj, void *event_info)
{
	switch (view) {
		case LISTVIEW : change_view_album(); break;
		case ALBUM_ART : change_view_lyrics(); break;
		case LYRICS	: change_view_list(); break;	
	}
}

void home_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *l = data;

	load_dir(l, home_dir);
}

void dir_list_select(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *li = data;
	Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(li);
	_dir *dir_gl = (_dir *)elm_object_item_data_get(gl_item);
	load_dir(li, dir_gl->path);
}

void del_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	//TODO: ask user if he is sure
	Evas_Object *li = data;
	
	Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(li);
	if (!gl_item) return;
	char *list_name = (char *)elm_object_item_data_get(gl_item);
	if (strcmp(list_name, "0 All Songs") == 0) return;
	begin_transaction ();
	del_playlist(list_name);
	commit_transaction ();
	//remove entry from li
	elm_object_item_del(gl_item);
	//change cur_playlist
	strcpy(cur_playlist, "0 All Songs");
	populate_main_list(list);
	populate_play_list (play_list);
}

void sel_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	int ret;
	char buf[255];

	//stop playing current song if playing / paused
	if (play_state == PLAYING) ret = write(fd, "pause\n", 6);
	play_state = IDLE;
	//del timer
	if(timer1) ecore_timer_del(timer1);
	//reset song index to 0
	song_index = 0;
	//set the selected playlist as the currrent one
	Evas_Object *li = data;
	Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(li);
	if (!gl_item) return;
	char *list_name = (char *)elm_object_item_data_get(gl_item);
	strcpy(cur_playlist, list_name);
	if(strcmp(cur_playlist, "ty_playlist") == 0) strcpy(buf, "Selected Songs");
	else strcpy(buf, cur_playlist);
	elm_win_title_set(win, buf);
	set_no_songs();
	if(randomize) randomize_list ();
	//update the main list	
	if(view != LISTVIEW) change_view_list();
	populate_main_list (list);
	//reset the pos_slider
	elm_slider_value_set(pos_slider, 0.0);
	elm_slider_min_max_set(pos_slider, 0, 0);
	elm_object_text_set(play_cur_pos, "0:00");
	//change play icon
	snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
	elm_icon_file_set(ic_play, buf, NULL);
}

void edit_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info)
{ 
	Evas_Object *li = data;

	Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(li);
	if (!gl_item) return;
	char *list_name = (char *) elm_object_item_data_get(gl_item);
	if (strcmp(list_name, "0 All Songs") == 0) return;
	create_playlist_page((void *)list_name, NULL, NULL);
}

void remove_songs_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *li = data;
	const Eina_List *item;

	while((item = elm_genlist_selected_items_get(li))) {
		char *path = (char *)elm_object_item_data_get(item->data);
		if (path) free(path);
		elm_object_item_del(item->data);
	}
}

void save_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	const Elm_Object_Item *gl_item;

	Evas_Object *entry = data;
	char *pl = (char *)elm_entry_entry_get(entry);
	//remove the trailing<br>
	char *playlist = strtok(pl, "<");	
	//check there is some data in the playlist before adding
	gl_item = elm_genlist_first_item_get(c_play_list);
	if(!gl_item) {
		popup_message ("Please add Songs to the Playlist before Saving!", NULL, 1);
		return;
	}
	begin_transaction ();
	save_playlist(playlist, c_play_list);
	commit_transaction ();
	//update playlists list
	populate_play_list (play_list);
	//popup message
	popup_message("Playlist Saved!", NULL, 1);
	//close the create playlist page
}

void add_album_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	//get album names and add songs to c_play_list
	Evas_Object *li = data;
	const Eina_List *item;

	while((item = elm_genlist_selected_items_get(li))) {
		char *album = (char *)elm_object_item_data_get(item->data);
		add_songs_from_album(album, c_play_list);
		if (album) free(album);
		elm_object_item_del(item->data);
	}
}
