/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 * 
 * Contributions from:
 *     Ryan Wagoner <ryan@wgnrs.dynu.com>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

#define PLUGIN_NAME "Debug IMSpector logging plugin"
#define PLUGIN_SHORT_NAME "Debug"

extern "C"
{
	bool initloggingplugin(struct loggingplugininfo &ploggingplugininfo,
		class Options &options, bool debugmode);
	void closeloggingplugin(void);
	int logevents(std::vector<struct imevent> &imevents);
};

bool localdebugmode = false;

bool initloggingplugin(struct loggingplugininfo &loggingplugininfo,
	class Options &options, bool debugmode)
{
	localdebugmode = debugmode;

	if (!debugmode) return false;

	loggingplugininfo.pluginname = PLUGIN_NAME;
	
	return true;
}

void closeloggingplugin(void)
{
	return;
}

/* The main plugin function. See loggingplugin.cpp. */
int logevents(std::vector<struct imevent> &imevents)
{
	for (std::vector<struct imevent>::iterator i = imevents.begin();
		i != imevents.end(); i++)
	{
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Timestamp: %d", (int)(*i).timestamp);
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Client address: %s", (*i).clientaddress.c_str());
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Protocol: %s", (*i).protocolname.c_str());
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Direction: %s", (*i).outgoing ? "OUTGOING" : "INCOMING");

		switch ((*i).type)
		{
			case TYPE_NULL:
				debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Type: NULL");
				break;
			case TYPE_MSG:
				debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Type: MSG");
				break;
			case TYPE_FILE:
				debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Type: FILE");
				break;
			case TYPE_TYPING:
				debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Type: TYPING");
				break;
			case TYPE_WEBCAM:
				debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Type: WEBCAM");
				break;
			default:
				debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Type: Unknown");
		}		
	
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: LocalID: %s", (*i).localid.c_str());
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: RemoteID: %s", (*i).remoteid.c_str());
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Filtered: %s", (*i).filtered ? "YES" : "NO");
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Categories: %s", (*i).categories.c_str());
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Event: Data: %s", (*i).eventdata.c_str());
	}

	return 0;
}
