// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/clouddebugger/v2/controller.proto

/*
Package clouddebugger is a generated protocol buffer package.

It is generated from these files:
	google/devtools/clouddebugger/v2/controller.proto
	google/devtools/clouddebugger/v2/data.proto
	google/devtools/clouddebugger/v2/debugger.proto

It has these top-level messages:
	RegisterDebuggeeRequest
	RegisterDebuggeeResponse
	ListActiveBreakpointsRequest
	ListActiveBreakpointsResponse
	UpdateActiveBreakpointRequest
	UpdateActiveBreakpointResponse
	FormatMessage
	StatusMessage
	SourceLocation
	Variable
	StackFrame
	Breakpoint
	Debuggee
	SetBreakpointRequest
	SetBreakpointResponse
	GetBreakpointRequest
	GetBreakpointResponse
	DeleteBreakpointRequest
	ListBreakpointsRequest
	ListBreakpointsResponse
	ListDebuggeesRequest
	ListDebuggeesResponse
*/
package clouddebugger

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request to register a debuggee.
type RegisterDebuggeeRequest struct {
	// Debuggee information to register.
	// The fields `project`, `uniquifier`, `description` and `agent_version`
	// of the debuggee must be set.
	Debuggee *Debuggee `protobuf:"bytes,1,opt,name=debuggee" json:"debuggee,omitempty"`
}

func (m *RegisterDebuggeeRequest) Reset()                    { *m = RegisterDebuggeeRequest{} }
func (m *RegisterDebuggeeRequest) String() string            { return proto.CompactTextString(m) }
func (*RegisterDebuggeeRequest) ProtoMessage()               {}
func (*RegisterDebuggeeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *RegisterDebuggeeRequest) GetDebuggee() *Debuggee {
	if m != nil {
		return m.Debuggee
	}
	return nil
}

// Response for registering a debuggee.
type RegisterDebuggeeResponse struct {
	// Debuggee resource.
	// The field `id` is guranteed to be set (in addition to the echoed fields).
	// If the field `is_disabled` is set to `true`, the agent should disable
	// itself by removing all breakpoints and detaching from the application.
	// It should however continue to poll `RegisterDebuggee` until reenabled.
	Debuggee *Debuggee `protobuf:"bytes,1,opt,name=debuggee" json:"debuggee,omitempty"`
}

func (m *RegisterDebuggeeResponse) Reset()                    { *m = RegisterDebuggeeResponse{} }
func (m *RegisterDebuggeeResponse) String() string            { return proto.CompactTextString(m) }
func (*RegisterDebuggeeResponse) ProtoMessage()               {}
func (*RegisterDebuggeeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *RegisterDebuggeeResponse) GetDebuggee() *Debuggee {
	if m != nil {
		return m.Debuggee
	}
	return nil
}

// Request to list active breakpoints.
type ListActiveBreakpointsRequest struct {
	// Identifies the debuggee.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// A token that, if specified, blocks the method call until the list
	// of active breakpoints has changed, or a server-selected timeout has
	// expired. The value should be set from the `next_wait_token` field in
	// the last response. The initial value should be set to `"init"`.
	WaitToken string `protobuf:"bytes,2,opt,name=wait_token,json=waitToken" json:"wait_token,omitempty"`
	// If set to `true` (recommended), returns `google.rpc.Code.OK` status and
	// sets the `wait_expired` response field to `true` when the server-selected
	// timeout has expired.
	//
	// If set to `false` (deprecated), returns `google.rpc.Code.ABORTED` status
	// when the server-selected timeout has expired.
	SuccessOnTimeout bool `protobuf:"varint,3,opt,name=success_on_timeout,json=successOnTimeout" json:"success_on_timeout,omitempty"`
}

func (m *ListActiveBreakpointsRequest) Reset()                    { *m = ListActiveBreakpointsRequest{} }
func (m *ListActiveBreakpointsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListActiveBreakpointsRequest) ProtoMessage()               {}
func (*ListActiveBreakpointsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListActiveBreakpointsRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *ListActiveBreakpointsRequest) GetWaitToken() string {
	if m != nil {
		return m.WaitToken
	}
	return ""
}

func (m *ListActiveBreakpointsRequest) GetSuccessOnTimeout() bool {
	if m != nil {
		return m.SuccessOnTimeout
	}
	return false
}

// Response for listing active breakpoints.
type ListActiveBreakpointsResponse struct {
	// List of all active breakpoints.
	// The fields `id` and `location` are guaranteed to be set on each breakpoint.
	Breakpoints []*Breakpoint `protobuf:"bytes,1,rep,name=breakpoints" json:"breakpoints,omitempty"`
	// A token that can be used in the next method call to block until
	// the list of breakpoints changes.
	NextWaitToken string `protobuf:"bytes,2,opt,name=next_wait_token,json=nextWaitToken" json:"next_wait_token,omitempty"`
	// If set to `true`, indicates that there is no change to the
	// list of active breakpoints and the server-selected timeout has expired.
	// The `breakpoints` field would be empty and should be ignored.
	WaitExpired bool `protobuf:"varint,3,opt,name=wait_expired,json=waitExpired" json:"wait_expired,omitempty"`
}

func (m *ListActiveBreakpointsResponse) Reset()                    { *m = ListActiveBreakpointsResponse{} }
func (m *ListActiveBreakpointsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListActiveBreakpointsResponse) ProtoMessage()               {}
func (*ListActiveBreakpointsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListActiveBreakpointsResponse) GetBreakpoints() []*Breakpoint {
	if m != nil {
		return m.Breakpoints
	}
	return nil
}

func (m *ListActiveBreakpointsResponse) GetNextWaitToken() string {
	if m != nil {
		return m.NextWaitToken
	}
	return ""
}

func (m *ListActiveBreakpointsResponse) GetWaitExpired() bool {
	if m != nil {
		return m.WaitExpired
	}
	return false
}

// Request to update an active breakpoint.
type UpdateActiveBreakpointRequest struct {
	// Identifies the debuggee being debugged.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// Updated breakpoint information.
	// The field `id` must be set.
	// The agent must echo all Breakpoint specification fields in the update.
	Breakpoint *Breakpoint `protobuf:"bytes,2,opt,name=breakpoint" json:"breakpoint,omitempty"`
}

func (m *UpdateActiveBreakpointRequest) Reset()                    { *m = UpdateActiveBreakpointRequest{} }
func (m *UpdateActiveBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateActiveBreakpointRequest) ProtoMessage()               {}
func (*UpdateActiveBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *UpdateActiveBreakpointRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *UpdateActiveBreakpointRequest) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Response for updating an active breakpoint.
// The message is defined to allow future extensions.
type UpdateActiveBreakpointResponse struct {
}

func (m *UpdateActiveBreakpointResponse) Reset()                    { *m = UpdateActiveBreakpointResponse{} }
func (m *UpdateActiveBreakpointResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateActiveBreakpointResponse) ProtoMessage()               {}
func (*UpdateActiveBreakpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func init() {
	proto.RegisterType((*RegisterDebuggeeRequest)(nil), "google.devtools.clouddebugger.v2.RegisterDebuggeeRequest")
	proto.RegisterType((*RegisterDebuggeeResponse)(nil), "google.devtools.clouddebugger.v2.RegisterDebuggeeResponse")
	proto.RegisterType((*ListActiveBreakpointsRequest)(nil), "google.devtools.clouddebugger.v2.ListActiveBreakpointsRequest")
	proto.RegisterType((*ListActiveBreakpointsResponse)(nil), "google.devtools.clouddebugger.v2.ListActiveBreakpointsResponse")
	proto.RegisterType((*UpdateActiveBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.UpdateActiveBreakpointRequest")
	proto.RegisterType((*UpdateActiveBreakpointResponse)(nil), "google.devtools.clouddebugger.v2.UpdateActiveBreakpointResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Controller2 service

type Controller2Client interface {
	// Registers the debuggee with the controller service.
	//
	// All agents attached to the same application must call this method with
	// exactly the same request content to get back the same stable `debuggee_id`.
	// Agents should call this method again whenever `google.rpc.Code.NOT_FOUND`
	// is returned from any controller method.
	//
	// This protocol allows the controller service to disable debuggees, recover
	// from data loss, or change the `debuggee_id` format. Agents must handle
	// `debuggee_id` value changing upon re-registration.
	RegisterDebuggee(ctx context.Context, in *RegisterDebuggeeRequest, opts ...grpc.CallOption) (*RegisterDebuggeeResponse, error)
	// Returns the list of all active breakpoints for the debuggee.
	//
	// The breakpoint specification (`location`, `condition`, and `expressions`
	// fields) is semantically immutable, although the field values may
	// change. For example, an agent may update the location line number
	// to reflect the actual line where the breakpoint was set, but this
	// doesn't change the breakpoint semantics.
	//
	// This means that an agent does not need to check if a breakpoint has changed
	// when it encounters the same breakpoint on a successive call.
	// Moreover, an agent should remember the breakpoints that are completed
	// until the controller removes them from the active list to avoid
	// setting those breakpoints again.
	ListActiveBreakpoints(ctx context.Context, in *ListActiveBreakpointsRequest, opts ...grpc.CallOption) (*ListActiveBreakpointsResponse, error)
	// Updates the breakpoint state or mutable fields.
	// The entire Breakpoint message must be sent back to the controller service.
	//
	// Updates to active breakpoint fields are only allowed if the new value
	// does not change the breakpoint specification. Updates to the `location`,
	// `condition` and `expressions` fields should not alter the breakpoint
	// semantics. These may only make changes such as canonicalizing a value
	// or snapping the location to the correct line of code.
	UpdateActiveBreakpoint(ctx context.Context, in *UpdateActiveBreakpointRequest, opts ...grpc.CallOption) (*UpdateActiveBreakpointResponse, error)
}

type controller2Client struct {
	cc *grpc.ClientConn
}

func NewController2Client(cc *grpc.ClientConn) Controller2Client {
	return &controller2Client{cc}
}

func (c *controller2Client) RegisterDebuggee(ctx context.Context, in *RegisterDebuggeeRequest, opts ...grpc.CallOption) (*RegisterDebuggeeResponse, error) {
	out := new(RegisterDebuggeeResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Controller2/RegisterDebuggee", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controller2Client) ListActiveBreakpoints(ctx context.Context, in *ListActiveBreakpointsRequest, opts ...grpc.CallOption) (*ListActiveBreakpointsResponse, error) {
	out := new(ListActiveBreakpointsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Controller2/ListActiveBreakpoints", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controller2Client) UpdateActiveBreakpoint(ctx context.Context, in *UpdateActiveBreakpointRequest, opts ...grpc.CallOption) (*UpdateActiveBreakpointResponse, error) {
	out := new(UpdateActiveBreakpointResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Controller2/UpdateActiveBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Controller2 service

type Controller2Server interface {
	// Registers the debuggee with the controller service.
	//
	// All agents attached to the same application must call this method with
	// exactly the same request content to get back the same stable `debuggee_id`.
	// Agents should call this method again whenever `google.rpc.Code.NOT_FOUND`
	// is returned from any controller method.
	//
	// This protocol allows the controller service to disable debuggees, recover
	// from data loss, or change the `debuggee_id` format. Agents must handle
	// `debuggee_id` value changing upon re-registration.
	RegisterDebuggee(context.Context, *RegisterDebuggeeRequest) (*RegisterDebuggeeResponse, error)
	// Returns the list of all active breakpoints for the debuggee.
	//
	// The breakpoint specification (`location`, `condition`, and `expressions`
	// fields) is semantically immutable, although the field values may
	// change. For example, an agent may update the location line number
	// to reflect the actual line where the breakpoint was set, but this
	// doesn't change the breakpoint semantics.
	//
	// This means that an agent does not need to check if a breakpoint has changed
	// when it encounters the same breakpoint on a successive call.
	// Moreover, an agent should remember the breakpoints that are completed
	// until the controller removes them from the active list to avoid
	// setting those breakpoints again.
	ListActiveBreakpoints(context.Context, *ListActiveBreakpointsRequest) (*ListActiveBreakpointsResponse, error)
	// Updates the breakpoint state or mutable fields.
	// The entire Breakpoint message must be sent back to the controller service.
	//
	// Updates to active breakpoint fields are only allowed if the new value
	// does not change the breakpoint specification. Updates to the `location`,
	// `condition` and `expressions` fields should not alter the breakpoint
	// semantics. These may only make changes such as canonicalizing a value
	// or snapping the location to the correct line of code.
	UpdateActiveBreakpoint(context.Context, *UpdateActiveBreakpointRequest) (*UpdateActiveBreakpointResponse, error)
}

func RegisterController2Server(s *grpc.Server, srv Controller2Server) {
	s.RegisterService(&_Controller2_serviceDesc, srv)
}

func _Controller2_RegisterDebuggee_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterDebuggeeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Controller2Server).RegisterDebuggee(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Controller2/RegisterDebuggee",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Controller2Server).RegisterDebuggee(ctx, req.(*RegisterDebuggeeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller2_ListActiveBreakpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListActiveBreakpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Controller2Server).ListActiveBreakpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Controller2/ListActiveBreakpoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Controller2Server).ListActiveBreakpoints(ctx, req.(*ListActiveBreakpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller2_UpdateActiveBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActiveBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Controller2Server).UpdateActiveBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Controller2/UpdateActiveBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Controller2Server).UpdateActiveBreakpoint(ctx, req.(*UpdateActiveBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Controller2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouddebugger.v2.Controller2",
	HandlerType: (*Controller2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterDebuggee",
			Handler:    _Controller2_RegisterDebuggee_Handler,
		},
		{
			MethodName: "ListActiveBreakpoints",
			Handler:    _Controller2_ListActiveBreakpoints_Handler,
		},
		{
			MethodName: "UpdateActiveBreakpoint",
			Handler:    _Controller2_UpdateActiveBreakpoint_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouddebugger/v2/controller.proto",
}

func init() { proto.RegisterFile("google/devtools/clouddebugger/v2/controller.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 589 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0xdd, 0x6a, 0xd4, 0x40,
	0x14, 0x66, 0x5a, 0x94, 0xf6, 0x44, 0x69, 0x19, 0x50, 0x43, 0x6c, 0x75, 0x1b, 0xa4, 0x94, 0x5a,
	0x32, 0x18, 0xbd, 0x71, 0x05, 0x7f, 0xb6, 0x6a, 0x11, 0x5a, 0x2d, 0x4b, 0x55, 0xf0, 0x66, 0xc9,
	0x26, 0xc7, 0x30, 0x34, 0x9d, 0x89, 0x99, 0xc9, 0x5a, 0x29, 0xbd, 0xf1, 0x56, 0xf1, 0xc6, 0x47,
	0xf0, 0xce, 0x17, 0x10, 0x7c, 0x0d, 0x7d, 0x04, 0xaf, 0x7c, 0x0a, 0xc9, 0xdf, 0xee, 0xf6, 0x67,
	0x9b, 0x76, 0xf1, 0x32, 0xdf, 0x9c, 0xef, 0x3b, 0xdf, 0x37, 0x39, 0x73, 0xe0, 0x56, 0x28, 0x65,
	0x18, 0x21, 0x0b, 0xb0, 0xa7, 0xa5, 0x8c, 0x14, 0xf3, 0x23, 0x99, 0x06, 0x01, 0x76, 0xd3, 0x30,
	0xc4, 0x84, 0xf5, 0x5c, 0xe6, 0x4b, 0xa1, 0x13, 0x19, 0x45, 0x98, 0x38, 0x71, 0x22, 0xb5, 0xa4,
	0x8d, 0x82, 0xe2, 0x54, 0x14, 0xe7, 0x00, 0xc5, 0xe9, 0xb9, 0xd6, 0x5c, 0x29, 0xea, 0xc5, 0x9c,
	0x79, 0x42, 0x48, 0xed, 0x69, 0x2e, 0x85, 0x2a, 0xf8, 0xd6, 0xcd, 0xda, 0x96, 0x81, 0xa7, 0xbd,
	0xb2, 0xf8, 0x6a, 0x59, 0x9c, 0x7f, 0x75, 0xd3, 0xb7, 0x0c, 0x77, 0x62, 0xfd, 0xa1, 0x38, 0xb4,
	0x3d, 0xb8, 0xd2, 0xc6, 0x90, 0x2b, 0x8d, 0xc9, 0xe3, 0x82, 0x8e, 0x6d, 0x7c, 0x97, 0xa2, 0xd2,
	0xf4, 0x29, 0x4c, 0x95, 0x8a, 0x68, 0x92, 0x06, 0x59, 0x32, 0xdc, 0x65, 0xa7, 0xce, 0xb7, 0xd3,
	0x17, 0xe9, 0x73, 0xed, 0x2e, 0x98, 0x47, 0x5b, 0xa8, 0x58, 0x0a, 0x85, 0xff, 0xad, 0xc7, 0x67,
	0x02, 0x73, 0xeb, 0x5c, 0xe9, 0x47, 0xbe, 0xe6, 0x3d, 0x6c, 0x25, 0xe8, 0x6d, 0xc7, 0x92, 0x0b,
	0xad, 0xaa, 0x30, 0xd7, 0xc1, 0xa8, 0x8a, 0x3b, 0x3c, 0xc8, 0x7b, 0x4d, 0xb7, 0xa1, 0x82, 0x9e,
	0x05, 0x74, 0x1e, 0xe0, 0xbd, 0xc7, 0x75, 0x47, 0xcb, 0x6d, 0x14, 0xe6, 0x44, 0x7e, 0x3e, 0x9d,
	0x21, 0x5b, 0x19, 0x40, 0x57, 0x80, 0xaa, 0xd4, 0xf7, 0x51, 0xa9, 0x8e, 0x14, 0x1d, 0xcd, 0x77,
	0x50, 0xa6, 0xda, 0x9c, 0x6c, 0x90, 0xa5, 0xa9, 0xf6, 0x6c, 0x79, 0xf2, 0x42, 0x6c, 0x15, 0xb8,
	0xfd, 0x93, 0xc0, 0xfc, 0x08, 0x3b, 0x65, 0xf0, 0xe7, 0x60, 0x74, 0x07, 0xb0, 0x49, 0x1a, 0x93,
	0x4b, 0x86, 0xbb, 0x52, 0x9f, 0x7d, 0xa0, 0xd5, 0x1e, 0x16, 0xa0, 0x8b, 0x30, 0x23, 0x70, 0x57,
	0x77, 0x8e, 0x64, 0xb8, 0x98, 0xc1, 0xaf, 0xfb, 0x39, 0x16, 0xe0, 0x42, 0x5e, 0x82, 0xbb, 0x31,
	0x4f, 0x30, 0x28, 0x13, 0x18, 0x19, 0xf6, 0xa4, 0x80, 0xec, 0x2f, 0x04, 0xe6, 0x5f, 0xc6, 0x81,
	0xa7, 0xf1, 0xb0, 0xfd, 0x53, 0x5f, 0xe6, 0x3a, 0xc0, 0xc0, 0x5c, 0x6e, 0xe4, 0xac, 0xe1, 0x86,
	0xf8, 0x76, 0x03, 0xae, 0x8d, 0xf2, 0x53, 0xdc, 0xa6, 0xfb, 0xe9, 0x1c, 0x18, 0xab, 0xfd, 0x47,
	0xe6, 0xd2, 0x1f, 0x04, 0x66, 0x0f, 0xcf, 0x1c, 0xbd, 0x5b, 0x6f, 0x60, 0xc4, 0x53, 0xb0, 0x9a,
	0xe3, 0x50, 0x0b, 0x6f, 0xf6, 0xca, 0xc7, 0x5f, 0x7f, 0xbe, 0x4e, 0x2c, 0xda, 0x0b, 0x07, 0x37,
	0x01, 0xab, 0xae, 0x4b, 0xb1, 0xa4, 0xa4, 0x36, 0xc9, 0x32, 0xfd, 0x4d, 0xe0, 0xd2, 0xb1, 0x93,
	0x43, 0xef, 0xd7, 0x7b, 0x38, 0xe9, 0x05, 0x58, 0x0f, 0xc6, 0xe6, 0x97, 0x41, 0x9a, 0x79, 0x90,
	0x3b, 0xd4, 0x1d, 0x19, 0x64, 0x6f, 0x68, 0x2a, 0xf6, 0xd9, 0xf0, 0x78, 0xfe, 0x25, 0x70, 0xf9,
	0xf8, 0x7f, 0x48, 0x4f, 0xe1, 0xeb, 0xc4, 0x69, 0xb4, 0x1e, 0x8e, 0x2f, 0x50, 0x26, 0xdb, 0xc8,
	0x93, 0xad, 0x59, 0xad, 0xb3, 0x27, 0x63, 0x7b, 0x83, 0x0f, 0x87, 0x07, 0xfb, 0x4d, 0xb2, 0xdc,
	0xfa, 0x46, 0xe0, 0x86, 0x2f, 0x77, 0x6a, 0x6d, 0xb5, 0x66, 0x06, 0x33, 0xbb, 0x99, 0x6d, 0xe3,
	0x4d, 0xf2, 0x66, 0xa3, 0x24, 0x85, 0x32, 0xf2, 0x44, 0xe8, 0xc8, 0x24, 0x64, 0x21, 0x8a, 0x7c,
	0x57, 0xb3, 0xe2, 0xc8, 0x8b, 0xb9, 0x1a, 0xbd, 0xf8, 0xef, 0x1d, 0x00, 0xbe, 0x4f, 0x98, 0x6b,
	0x85, 0xde, 0x6a, 0x06, 0x57, 0x9b, 0x33, 0x71, 0x5e, 0xb9, 0xdd, 0xf3, 0xb9, 0xe8, 0xed, 0x7f,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x05, 0xef, 0x37, 0xb4, 0xbf, 0x06, 0x00, 0x00,
}
