// Code generated via go generate from gen_properties.go. DO NOT EDIT.

package uniseg

// eastAsianWidth are taken from
// https://www.unicode.org/Public/15.0.0/ucd/EastAsianWidth.txt
// and
// https://unicode.org/Public/15.0.0/ucd/emoji/emoji-data.txt
// ("Extended_Pictographic" only)
// on September 5, 2023. See https://www.unicode.org/license.html for the Unicode
// license agreement.
var eastAsianWidth = [][3]int{
	{0x0000, 0x001F, prN},     // Cc    [32] <control-0000>..<control-001F>
	{0x0020, 0x0020, prNa},    // Zs         SPACE
	{0x0021, 0x0023, prNa},    // Po     [3] EXCLAMATION MARK..NUMBER SIGN
	{0x0024, 0x0024, prNa},    // Sc         DOLLAR SIGN
	{0x0025, 0x0027, prNa},    // Po     [3] PERCENT SIGN..APOSTROPHE
	{0x0028, 0x0028, prNa},    // Ps         LEFT PARENTHESIS
	{0x0029, 0x0029, prNa},    // Pe         RIGHT PARENTHESIS
	{0x002A, 0x002A, prNa},    // Po         ASTERISK
	{0x002B, 0x002B, prNa},    // Sm         PLUS SIGN
	{0x002C, 0x002C, prNa},    // Po         COMMA
	{0x002D, 0x002D, prNa},    // Pd         HYPHEN-MINUS
	{0x002E, 0x002F, prNa},    // Po     [2] FULL STOP..SOLIDUS
	{0x0030, 0x0039, prNa},    // Nd    [10] DIGIT ZERO..DIGIT NINE
	{0x003A, 0x003B, prNa},    // Po     [2] COLON..SEMICOLON
	{0x003C, 0x003E, prNa},    // Sm     [3] LESS-THAN SIGN..GREATER-THAN SIGN
	{0x003F, 0x0040, prNa},    // Po     [2] QUESTION MARK..COMMERCIAL AT
	{0x0041, 0x005A, prNa},    // Lu    [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
	{0x005B, 0x005B, prNa},    // Ps         LEFT SQUARE BRACKET
	{0x005C, 0x005C, prNa},    // Po         REVERSE SOLIDUS
	{0x005D, 0x005D, prNa},    // Pe         RIGHT SQUARE BRACKET
	{0x005E, 0x005E, prNa},    // Sk         CIRCUMFLEX ACCENT
	{0x005F, 0x005F, prNa},    // Pc         LOW LINE
	{0x0060, 0x0060, prNa},    // Sk         GRAVE ACCENT
	{0x0061, 0x007A, prNa},    // Ll    [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
	{0x007B, 0x007B, prNa},    // Ps         LEFT CURLY BRACKET
	{0x007C, 0x007C, prNa},    // Sm         VERTICAL LINE
	{0x007D, 0x007D, prNa},    // Pe         RIGHT CURLY BRACKET
	{0x007E, 0x007E, prNa},    // Sm         TILDE
	{0x007F, 0x007F, prN},     // Cc         <control-007F>
	{0x0080, 0x009F, prN},     // Cc    [32] <control-0080>..<control-009F>
	{0x00A0, 0x00A0, prN},     // Zs         NO-BREAK SPACE
	{0x00A1, 0x00A1, prA},     // Po         INVERTED EXCLAMATION MARK
	{0x00A2, 0x00A3, prNa},    // Sc     [2] CENT SIGN..POUND SIGN
	{0x00A4, 0x00A4, prA},     // Sc         CURRENCY SIGN
	{0x00A5, 0x00A5, prNa},    // Sc         YEN SIGN
	{0x00A6, 0x00A6, prNa},    // So         BROKEN BAR
	{0x00A7, 0x00A7, prA},     // Po         SECTION SIGN
	{0x00A8, 0x00A8, prA},     // Sk         DIAERESIS
	{0x00A9, 0x00A9, prN},     // So         COPYRIGHT SIGN
	{0x00AA, 0x00AA, prA},     // Lo         FEMININE ORDINAL INDICATOR
	{0x00AB, 0x00AB, prN},     // Pi         LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00AC, 0x00AC, prNa},    // Sm         NOT SIGN
	{0x00AD, 0x00AD, prA},     // Cf         SOFT HYPHEN
	{0x00AE, 0x00AE, prA},     // So         REGISTERED SIGN
	{0x00AF, 0x00AF, prNa},    // Sk         MACRON
	{0x00B0, 0x00B0, prA},     // So         DEGREE SIGN
	{0x00B1, 0x00B1, prA},     // Sm         PLUS-MINUS SIGN
	{0x00B2, 0x00B3, prA},     // No     [2] SUPERSCRIPT TWO..SUPERSCRIPT THREE
	{0x00B4, 0x00B4, prA},     // Sk         ACUTE ACCENT
	{0x00B5, 0x00B5, prN},     // Ll         MICRO SIGN
	{0x00B6, 0x00B7, prA},     // Po     [2] PILCROW SIGN..MIDDLE DOT
	{0x00B8, 0x00B8, prA},     // Sk         CEDILLA
	{0x00B9, 0x00B9, prA},     // No         SUPERSCRIPT ONE
	{0x00BA, 0x00BA, prA},     // Lo         MASCULINE ORDINAL INDICATOR
	{0x00BB, 0x00BB, prN},     // Pf         RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00BC, 0x00BE, prA},     // No     [3] VULGAR FRACTION ONE QUARTER..VULGAR FRACTION THREE QUARTERS
	{0x00BF, 0x00BF, prA},     // Po         INVERTED QUESTION MARK
	{0x00C0, 0x00C5, prN},     // Lu     [6] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER A WITH RING ABOVE
	{0x00C6, 0x00C6, prA},     // Lu         LATIN CAPITAL LETTER AE
	{0x00C7, 0x00CF, prN},     // Lu     [9] LATIN CAPITAL LETTER C WITH CEDILLA..LATIN CAPITAL LETTER I WITH DIAERESIS
	{0x00D0, 0x00D0, prA},     // Lu         LATIN CAPITAL LETTER ETH
	{0x00D1, 0x00D6, prN},     // Lu     [6] LATIN CAPITAL LETTER N WITH TILDE..LATIN CAPITAL LETTER O WITH DIAERESIS
	{0x00D7, 0x00D7, prA},     // Sm         MULTIPLICATION SIGN
	{0x00D8, 0x00D8, prA},     // Lu         LATIN CAPITAL LETTER O WITH STROKE
	{0x00D9, 0x00DD, prN},     // Lu     [5] LATIN CAPITAL LETTER U WITH GRAVE..LATIN CAPITAL LETTER Y WITH ACUTE
	{0x00DE, 0x00E1, prA},     // L&     [4] LATIN CAPITAL LETTER THORN..LATIN SMALL LETTER A WITH ACUTE
	{0x00E2, 0x00E5, prN},     // Ll     [4] LATIN SMALL LETTER A WITH CIRCUMFLEX..LATIN SMALL LETTER A WITH RING ABOVE
	{0x00E6, 0x00E6, prA},     // Ll         LATIN SMALL LETTER AE
	{0x00E7, 0x00E7, prN},     // Ll         LATIN SMALL LETTER C WITH CEDILLA
	{0x00E8, 0x00EA, prA},     // Ll     [3] LATIN SMALL LETTER E WITH GRAVE..LATIN SMALL LETTER E WITH CIRCUMFLEX
	{0x00EB, 0x00EB, prN},     // Ll         LATIN SMALL LETTER E WITH DIAERESIS
	{0x00EC, 0x00ED, prA},     // Ll     [2] LATIN SMALL LETTER I WITH GRAVE..LATIN SMALL LETTER I WITH ACUTE
	{0x00EE, 0x00EF, prN},     // Ll     [2] LATIN SMALL LETTER I WITH CIRCUMFLEX..LATIN SMALL LETTER I WITH DIAERESIS
	{0x00F0, 0x00F0, prA},     // Ll         LATIN SMALL LETTER ETH
	{0x00F1, 0x00F1, prN},     // Ll         LATIN SMALL LETTER N WITH TILDE
	{0x00F2, 0x00F3, prA},     // Ll     [2] LATIN SMALL LETTER O WITH GRAVE..LATIN SMALL LETTER O WITH ACUTE
	{0x00F4, 0x00F6, prN},     // Ll     [3] LATIN SMALL LETTER O WITH CIRCUMFLEX..LATIN SMALL LETTER O WITH DIAERESIS
	{0x00F7, 0x00F7, prA},     // Sm         DIVISION SIGN
	{0x00F8, 0x00FA, prA},     // Ll     [3] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER U WITH ACUTE
	{0x00FB, 0x00FB, prN},     // Ll         LATIN SMALL LETTER U WITH CIRCUMFLEX
	{0x00FC, 0x00FC, prA},     // Ll         LATIN SMALL LETTER U WITH DIAERESIS
	{0x00FD, 0x00FD, prN},     // Ll         LATIN SMALL LETTER Y WITH ACUTE
	{0x00FE, 0x00FE, prA},     // Ll         LATIN SMALL LETTER THORN
	{0x00FF, 0x00FF, prN},     // Ll         LATIN SMALL LETTER Y WITH DIAERESIS
	{0x0100, 0x0100, prN},     // Lu         LATIN CAPITAL LETTER A WITH MACRON
	{0x0101, 0x0101, prA},     // Ll         LATIN SMALL LETTER A WITH MACRON
	{0x0102, 0x0110, prN},     // L&    [15] LATIN CAPITAL LETTER A WITH BREVE..LATIN CAPITAL LETTER D WITH STROKE
	{0x0111, 0x0111, prA},     // Ll         LATIN SMALL LETTER D WITH STROKE
	{0x0112, 0x0112, prN},     // Lu         LATIN CAPITAL LETTER E WITH MACRON
	{0x0113, 0x0113, prA},     // Ll         LATIN SMALL LETTER E WITH MACRON
	{0x0114, 0x011A, prN},     // L&     [7] LATIN CAPITAL LETTER E WITH BREVE..LATIN CAPITAL LETTER E WITH CARON
	{0x011B, 0x011B, prA},     // Ll         LATIN SMALL LETTER E WITH CARON
	{0x011C, 0x0125, prN},     // L&    [10] LATIN CAPITAL LETTER G WITH CIRCUMFLEX..LATIN SMALL LETTER H WITH CIRCUMFLEX
	{0x0126, 0x0127, prA},     // L&     [2] LATIN CAPITAL LETTER H WITH STROKE..LATIN SMALL LETTER H WITH STROKE
	{0x0128, 0x012A, prN},     // L&     [3] LATIN CAPITAL LETTER I WITH TILDE..LATIN CAPITAL LETTER I WITH MACRON
	{0x012B, 0x012B, prA},     // Ll         LATIN SMALL LETTER I WITH MACRON
	{0x012C, 0x0130, prN},     // L&     [5] LATIN CAPITAL LETTER I WITH BREVE..LATIN CAPITAL LETTER I WITH DOT ABOVE
	{0x0131, 0x0133, prA},     // L&     [3] LATIN SMALL LETTER DOTLESS I..LATIN SMALL LIGATURE IJ
	{0x0134, 0x0137, prN},     // L&     [4] LATIN CAPITAL LETTER J WITH CIRCUMFLEX..LATIN SMALL LETTER K WITH CEDILLA
	{0x0138, 0x0138, prA},     // Ll         LATIN SMALL LETTER KRA
	{0x0139, 0x013E, prN},     // L&     [6] LATIN CAPITAL LETTER L WITH ACUTE..LATIN SMALL LETTER L WITH CARON
	{0x013F, 0x0142, prA},     // L&     [4] LATIN CAPITAL LETTER L WITH MIDDLE DOT..LATIN SMALL LETTER L WITH STROKE
	{0x0143, 0x0143, prN},     // Lu         LATIN CAPITAL LETTER N WITH ACUTE
	{0x0144, 0x0144, prA},     // Ll         LATIN SMALL LETTER N WITH ACUTE
	{0x0145, 0x0147, prN},     // L&     [3] LATIN CAPITAL LETTER N WITH CEDILLA..LATIN CAPITAL LETTER N WITH CARON
	{0x0148, 0x014B, prA},     // L&     [4] LATIN SMALL LETTER N WITH CARON..LATIN SMALL LETTER ENG
	{0x014C, 0x014C, prN},     // Lu         LATIN CAPITAL LETTER O WITH MACRON
	{0x014D, 0x014D, prA},     // Ll         LATIN SMALL LETTER O WITH MACRON
	{0x014E, 0x0151, prN},     // L&     [4] LATIN CAPITAL LETTER O WITH BREVE..LATIN SMALL LETTER O WITH DOUBLE ACUTE
	{0x0152, 0x0153, prA},     // L&     [2] LATIN CAPITAL LIGATURE OE..LATIN SMALL LIGATURE OE
	{0x0154, 0x0165, prN},     // L&    [18] LATIN CAPITAL LETTER R WITH ACUTE..LATIN SMALL LETTER T WITH CARON
	{0x0166, 0x0167, prA},     // L&     [2] LATIN CAPITAL LETTER T WITH STROKE..LATIN SMALL LETTER T WITH STROKE
	{0x0168, 0x016A, prN},     // L&     [3] LATIN CAPITAL LETTER U WITH TILDE..LATIN CAPITAL LETTER U WITH MACRON
	{0x016B, 0x016B, prA},     // Ll         LATIN SMALL LETTER U WITH MACRON
	{0x016C, 0x017F, prN},     // L&    [20] LATIN CAPITAL LETTER U WITH BREVE..LATIN SMALL LETTER LONG S
	{0x0180, 0x01BA, prN},     // L&    [59] LATIN SMALL LETTER B WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
	{0x01BB, 0x01BB, prN},     // Lo         LATIN LETTER TWO WITH STROKE
	{0x01BC, 0x01BF, prN},     // L&     [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
	{0x01C0, 0x01C3, prN},     // Lo     [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
	{0x01C4, 0x01CD, prN},     // L&    [10] LATIN CAPITAL LETTER DZ WITH CARON..LATIN CAPITAL LETTER A WITH CARON
	{0x01CE, 0x01CE, prA},     // Ll         LATIN SMALL LETTER A WITH CARON
	{0x01CF, 0x01CF, prN},     // Lu         LATIN CAPITAL LETTER I WITH CARON
	{0x01D0, 0x01D0, prA},     // Ll         LATIN SMALL LETTER I WITH CARON
	{0x01D1, 0x01D1, prN},     // Lu         LATIN CAPITAL LETTER O WITH CARON
	{0x01D2, 0x01D2, prA},     // Ll         LATIN SMALL LETTER O WITH CARON
	{0x01D3, 0x01D3, prN},     // Lu         LATIN CAPITAL LETTER U WITH CARON
	{0x01D4, 0x01D4, prA},     // Ll         LATIN SMALL LETTER U WITH CARON
	{0x01D5, 0x01D5, prN},     // Lu         LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
	{0x01D6, 0x01D6, prA},     // Ll         LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
	{0x01D7, 0x01D7, prN},     // Lu         LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
	{0x01D8, 0x01D8, prA},     // Ll         LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
	{0x01D9, 0x01D9, prN},     // Lu         LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
	{0x01DA, 0x01DA, prA},     // Ll         LATIN SMALL LETTER U WITH DIAERESIS AND CARON
	{0x01DB, 0x01DB, prN},     // Lu         LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
	{0x01DC, 0x01DC, prA},     // Ll         LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
	{0x01DD, 0x024F, prN},     // L&   [115] LATIN SMALL LETTER TURNED E..LATIN SMALL LETTER Y WITH STROKE
	{0x0250, 0x0250, prN},     // Ll         LATIN SMALL LETTER TURNED A
	{0x0251, 0x0251, prA},     // Ll         LATIN SMALL LETTER ALPHA
	{0x0252, 0x0260, prN},     // Ll    [15] LATIN SMALL LETTER TURNED ALPHA..LATIN SMALL LETTER G WITH HOOK
	{0x0261, 0x0261, prA},     // Ll         LATIN SMALL LETTER SCRIPT G
	{0x0262, 0x0293, prN},     // Ll    [50] LATIN LETTER SMALL CAPITAL G..LATIN SMALL LETTER EZH WITH CURL
	{0x0294, 0x0294, prN},     // Lo         LATIN LETTER GLOTTAL STOP
	{0x0295, 0x02AF, prN},     // Ll    [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
	{0x02B0, 0x02C1, prN},     // Lm    [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
	{0x02C2, 0x02C3, prN},     // Sk     [2] MODIFIER LETTER LEFT ARROWHEAD..MODIFIER LETTER RIGHT ARROWHEAD
	{0x02C4, 0x02C4, prA},     // Sk         MODIFIER LETTER UP ARROWHEAD
	{0x02C5, 0x02C5, prN},     // Sk         MODIFIER LETTER DOWN ARROWHEAD
	{0x02C6, 0x02C6, prN},     // Lm         MODIFIER LETTER CIRCUMFLEX ACCENT
	{0x02C7, 0x02C7, prA},     // Lm         CARON
	{0x02C8, 0x02C8, prN},     // Lm         MODIFIER LETTER VERTICAL LINE
	{0x02C9, 0x02CB, prA},     // Lm     [3] MODIFIER LETTER MACRON..MODIFIER LETTER GRAVE ACCENT
	{0x02CC, 0x02CC, prN},     // Lm         MODIFIER LETTER LOW VERTICAL LINE
	{0x02CD, 0x02CD, prA},     // Lm         MODIFIER LETTER LOW MACRON
	{0x02CE, 0x02CF, prN},     // Lm     [2] MODIFIER LETTER LOW GRAVE ACCENT..MODIFIER LETTER LOW ACUTE ACCENT
	{0x02D0, 0x02D0, prA},     // Lm         MODIFIER LETTER TRIANGULAR COLON
	{0x02D1, 0x02D1, prN},     // Lm         MODIFIER LETTER HALF TRIANGULAR COLON
	{0x02D2, 0x02D7, prN},     // Sk     [6] MODIFIER LETTER CENTRED RIGHT HALF RING..MODIFIER LETTER MINUS SIGN
	{0x02D8, 0x02DB, prA},     // Sk     [4] BREVE..OGONEK
	{0x02DC, 0x02DC, prN},     // Sk         SMALL TILDE
	{0x02DD, 0x02DD, prA},     // Sk         DOUBLE ACUTE ACCENT
	{0x02DE, 0x02DE, prN},     // Sk         MODIFIER LETTER RHOTIC HOOK
	{0x02DF, 0x02DF, prA},     // Sk         MODIFIER LETTER CROSS ACCENT
	{0x02E0, 0x02E4, prN},     // Lm     [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
	{0x02E5, 0x02EB, prN},     // Sk     [7] MODIFIER LETTER EXTRA-HIGH TONE BAR..MODIFIER LETTER YANG DEPARTING TONE MARK
	{0x02EC, 0x02EC, prN},     // Lm         MODIFIER LETTER VOICING
	{0x02ED, 0x02ED, prN},     // Sk         MODIFIER LETTER UNASPIRATED
	{0x02EE, 0x02EE, prN},     // Lm         MODIFIER LETTER DOUBLE APOSTROPHE
	{0x02EF, 0x02FF, prN},     // Sk    [17] MODIFIER LETTER LOW DOWN ARROWHEAD..MODIFIER LETTER LOW LEFT ARROW
	{0x0300, 0x036F, prA},     // Mn   [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
	{0x0370, 0x0373, prN},     // L&     [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
	{0x0374, 0x0374, prN},     // Lm         GREEK NUMERAL SIGN
	{0x0375, 0x0375, prN},     // Sk         GREEK LOWER NUMERAL SIGN
	{0x0376, 0x0377, prN},     // L&     [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
	{0x037A, 0x037A, prN},     // Lm         GREEK YPOGEGRAMMENI
	{0x037B, 0x037D, prN},     // Ll     [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
	{0x037E, 0x037E, prN},     // Po         GREEK QUESTION MARK
	{0x037F, 0x037F, prN},     // Lu         GREEK CAPITAL LETTER YOT
	{0x0384, 0x0385, prN},     // Sk     [2] GREEK TONOS..GREEK DIALYTIKA TONOS
	{0x0386, 0x0386, prN},     // Lu         GREEK CAPITAL LETTER ALPHA WITH TONOS
	{0x0387, 0x0387, prN},     // Po         GREEK ANO TELEIA
	{0x0388, 0x038A, prN},     // Lu     [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
	{0x038C, 0x038C, prN},     // Lu         GREEK CAPITAL LETTER OMICRON WITH TONOS
	{0x038E, 0x0390, prN},     // L&     [3] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
	{0x0391, 0x03A1, prA},     // Lu    [17] GREEK CAPITAL LETTER ALPHA..GREEK CAPITAL LETTER RHO
	{0x03A3, 0x03A9, prA},     // Lu     [7] GREEK CAPITAL LETTER SIGMA..GREEK CAPITAL LETTER OMEGA
	{0x03AA, 0x03B0, prN},     // L&     [7] GREEK CAPITAL LETTER IOTA WITH DIALYTIKA..GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
	{0x03B1, 0x03C1, prA},     // Ll    [17] GREEK SMALL LETTER ALPHA..GREEK SMALL LETTER RHO
	{0x03C2, 0x03C2, prN},     // Ll         GREEK SMALL LETTER FINAL SIGMA
	{0x03C3, 0x03C9, prA},     // Ll     [7] GREEK SMALL LETTER SIGMA..GREEK SMALL LETTER OMEGA
	{0x03CA, 0x03F5, prN},     // L&    [44] GREEK SMALL LETTER IOTA WITH DIALYTIKA..GREEK LUNATE EPSILON SYMBOL
	{0x03F6, 0x03F6, prN},     // Sm         GREEK REVERSED LUNATE EPSILON SYMBOL
	{0x03F7, 0x03FF, prN},     // L&     [9] GREEK CAPITAL LETTER SHO..GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL
	{0x0400, 0x0400, prN},     // Lu         CYRILLIC CAPITAL LETTER IE WITH GRAVE
	{0x0401, 0x0401, prA},     // Lu         CYRILLIC CAPITAL LETTER IO
	{0x0402, 0x040F, prN},     // Lu    [14] CYRILLIC CAPITAL LETTER DJE..CYRILLIC CAPITAL LETTER DZHE
	{0x0410, 0x044F, prA},     // L&    [64] CYRILLIC CAPITAL LETTER A..CYRILLIC SMALL LETTER YA
	{0x0450, 0x0450, prN},     // Ll         CYRILLIC SMALL LETTER IE WITH GRAVE
	{0x0451, 0x0451, prA},     // Ll         CYRILLIC SMALL LETTER IO
	{0x0452, 0x0481, prN},     // L&    [48] CYRILLIC SMALL LETTER DJE..CYRILLIC SMALL LETTER KOPPA
	{0x0482, 0x0482, prN},     // So         CYRILLIC THOUSANDS SIGN
	{0x0483, 0x0487, prN},     // Mn     [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
	{0x0488, 0x0489, prN},     // Me     [2] COMBINING CYRILLIC HUNDRED THOUSANDS SIGN..COMBINING CYRILLIC MILLIONS SIGN
	{0x048A, 0x04FF, prN},     // L&   [118] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER HA WITH STROKE
	{0x0500, 0x052F, prN},     // L&    [48] CYRILLIC CAPITAL LETTER KOMI DE..CYRILLIC SMALL LETTER EL WITH DESCENDER
	{0x0531, 0x0556, prN},     // Lu    [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
	{0x0559, 0x0559, prN},     // Lm         ARMENIAN MODIFIER LETTER LEFT HALF RING
	{0x055A, 0x055F, prN},     // Po     [6] ARMENIAN APOSTROPHE..ARMENIAN ABBREVIATION MARK
	{0x0560, 0x0588, prN},     // Ll    [41] ARMENIAN SMALL LETTER TURNED AYB..ARMENIAN SMALL LETTER YI WITH STROKE
	{0x0589, 0x0589, prN},     // Po         ARMENIAN FULL STOP
	{0x058A, 0x058A, prN},     // Pd         ARMENIAN HYPHEN
	{0x058D, 0x058E, prN},     // So     [2] RIGHT-FACING ARMENIAN ETERNITY SIGN..LEFT-FACING ARMENIAN ETERNITY SIGN
	{0x058F, 0x058F, prN},     // Sc         ARMENIAN DRAM SIGN
	{0x0591, 0x05BD, prN},     // Mn    [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
	{0x05BE, 0x05BE, prN},     // Pd         HEBREW PUNCTUATION MAQAF
	{0x05BF, 0x05BF, prN},     // Mn         HEBREW POINT RAFE
	{0x05C0, 0x05C0, prN},     // Po         HEBREW PUNCTUATION PASEQ
	{0x05C1, 0x05C2, prN},     // Mn     [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
	{0x05C3, 0x05C3, prN},     // Po         HEBREW PUNCTUATION SOF PASUQ
	{0x05C4, 0x05C5, prN},     // Mn     [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
	{0x05C6, 0x05C6, prN},     // Po         HEBREW PUNCTUATION NUN HAFUKHA
	{0x05C7, 0x05C7, prN},     // Mn         HEBREW POINT QAMATS QATAN
	{0x05D0, 0x05EA, prN},     // Lo    [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
	{0x05EF, 0x05F2, prN},     // Lo     [4] HEBREW YOD TRIANGLE..HEBREW LIGATURE YIDDISH DOUBLE YOD
	{0x05F3, 0x05F4, prN},     // Po     [2] HEBREW PUNCTUATION GERESH..HEBREW PUNCTUATION GERSHAYIM
	{0x0600, 0x0605, prN},     // Cf     [6] ARABIC NUMBER SIGN..ARABIC NUMBER MARK ABOVE
	{0x0606, 0x0608, prN},     // Sm     [3] ARABIC-INDIC CUBE ROOT..ARABIC RAY
	{0x0609, 0x060A, prN},     // Po     [2] ARABIC-INDIC PER MILLE SIGN..ARABIC-INDIC PER TEN THOUSAND SIGN
	{0x060B, 0x060B, prN},     // Sc         AFGHANI SIGN
	{0x060C, 0x060D, prN},     // Po     [2] ARABIC COMMA..ARABIC DATE SEPARATOR
	{0x060E, 0x060F, prN},     // So     [2] ARABIC POETIC VERSE SIGN..ARABIC SIGN MISRA
	{0x0610, 0x061A, prN},     // Mn    [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
	{0x061B, 0x061B, prN},     // Po         ARABIC SEMICOLON
	{0x061C, 0x061C, prN},     // Cf         ARABIC LETTER MARK
	{0x061D, 0x061F, prN},     // Po     [3] ARABIC END OF TEXT MARK..ARABIC QUESTION MARK
	{0x0620, 0x063F, prN},     // Lo    [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
	{0x0640, 0x0640, prN},     // Lm         ARABIC TATWEEL
	{0x0641, 0x064A, prN},     // Lo    [10] ARABIC LETTER FEH..ARABIC LETTER YEH
	{0x064B, 0x065F, prN},     // Mn    [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
	{0x0660, 0x0669, prN},     // Nd    [10] ARABIC-INDIC DIGIT ZERO..ARABIC-INDIC DIGIT NINE
	{0x066A, 0x066D, prN},     // Po     [4] ARABIC PERCENT SIGN..ARABIC FIVE POINTED STAR
	{0x066E, 0x066F, prN},     // Lo     [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
	{0x0670, 0x0670, prN},     // Mn         ARABIC LETTER SUPERSCRIPT ALEF
	{0x0671, 0x06D3, prN},     // Lo    [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
	{0x06D4, 0x06D4, prN},     // Po         ARABIC FULL STOP
	{0x06D5, 0x06D5, prN},     // Lo         ARABIC LETTER AE
	{0x06D6, 0x06DC, prN},     // Mn     [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
	{0x06DD, 0x06DD, prN},     // Cf         ARABIC END OF AYAH
	{0x06DE, 0x06DE, prN},     // So         ARABIC START OF RUB EL HIZB
	{0x06DF, 0x06E4, prN},     // Mn     [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
	{0x06E5, 0x06E6, prN},     // Lm     [2] ARABIC SMALL WAW..ARABIC SMALL YEH
	{0x06E7, 0x06E8, prN},     // Mn     [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
	{0x06E9, 0x06E9, prN},     // So         ARABIC PLACE OF SAJDAH
	{0x06EA, 0x06ED, prN},     // Mn     [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
	{0x06EE, 0x06EF, prN},     // Lo     [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
	{0x06F0, 0x06F9, prN},     // Nd    [10] EXTENDED ARABIC-INDIC DIGIT ZERO..EXTENDED ARABIC-INDIC DIGIT NINE
	{0x06FA, 0x06FC, prN},     // Lo     [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
	{0x06FD, 0x06FE, prN},     // So     [2] ARABIC SIGN SINDHI AMPERSAND..ARABIC SIGN SINDHI POSTPOSITION MEN
	{0x06FF, 0x06FF, prN},     // Lo         ARABIC LETTER HEH WITH INVERTED V
	{0x0700, 0x070D, prN},     // Po    [14] SYRIAC END OF PARAGRAPH..SYRIAC HARKLEAN ASTERISCUS
	{0x070F, 0x070F, prN},     // Cf         SYRIAC ABBREVIATION MARK
	{0x0710, 0x0710, prN},     // Lo         SYRIAC LETTER ALAPH
	{0x0711, 0x0711, prN},     // Mn         SYRIAC LETTER SUPERSCRIPT ALAPH
	{0x0712, 0x072F, prN},     // Lo    [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
	{0x0730, 0x074A, prN},     // Mn    [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
	{0x074D, 0x074F, prN},     // Lo     [3] SYRIAC LETTER SOGDIAN ZHAIN..SYRIAC LETTER SOGDIAN FE
	{0x0750, 0x077F, prN},     // Lo    [48] ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW..ARABIC LETTER KAF WITH TWO DOTS ABOVE
	{0x0780, 0x07A5, prN},     // Lo    [38] THAANA LETTER HAA..THAANA LETTER WAAVU
	{0x07A6, 0x07B0, prN},     // Mn    [11] THAANA ABAFILI..THAANA SUKUN
	{0x07B1, 0x07B1, prN},     // Lo         THAANA LETTER NAA
	{0x07C0, 0x07C9, prN},     // Nd    [10] NKO DIGIT ZERO..NKO DIGIT NINE
	{0x07CA, 0x07EA, prN},     // Lo    [33] NKO LETTER A..NKO LETTER JONA RA
	{0x07EB, 0x07F3, prN},     // Mn     [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
	{0x07F4, 0x07F5, prN},     // Lm     [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
	{0x07F6, 0x07F6, prN},     // So         NKO SYMBOL OO DENNEN
	{0x07F7, 0x07F9, prN},     // Po     [3] NKO SYMBOL GBAKURUNEN..NKO EXCLAMATION MARK
	{0x07FA, 0x07FA, prN},     // Lm         NKO LAJANYALAN
	{0x07FD, 0x07FD, prN},     // Mn         NKO DANTAYALAN
	{0x07FE, 0x07FF, prN},     // Sc     [2] NKO DOROME SIGN..NKO TAMAN SIGN
	{0x0800, 0x0815, prN},     // Lo    [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
	{0x0816, 0x0819, prN},     // Mn     [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
	{0x081A, 0x081A, prN},     // Lm         SAMARITAN MODIFIER LETTER EPENTHETIC YUT
	{0x081B, 0x0823, prN},     // Mn     [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
	{0x0824, 0x0824, prN},     // Lm         SAMARITAN MODIFIER LETTER SHORT A
	{0x0825, 0x0827, prN},     // Mn     [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
	{0x0828, 0x0828, prN},     // Lm         SAMARITAN MODIFIER LETTER I
	{0x0829, 0x082D, prN},     // Mn     [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
	{0x0830, 0x083E, prN},     // Po    [15] SAMARITAN PUNCTUATION NEQUDAA..SAMARITAN PUNCTUATION ANNAAU
	{0x0840, 0x0858, prN},     // Lo    [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
	{0x0859, 0x085B, prN},     // Mn     [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
	{0x085E, 0x085E, prN},     // Po         MANDAIC PUNCTUATION
	{0x0860, 0x086A, prN},     // Lo    [11] SYRIAC LETTER MALAYALAM NGA..SYRIAC LETTER MALAYALAM SSA
	{0x0870, 0x0887, prN},     // Lo    [24] ARABIC LETTER ALEF WITH ATTACHED FATHA..ARABIC BASELINE ROUND DOT
	{0x0888, 0x0888, prN},     // Sk         ARABIC RAISED ROUND DOT
	{0x0889, 0x088E, prN},     // Lo     [6] ARABIC LETTER NOON WITH INVERTED SMALL V..ARABIC VERTICAL TAIL
	{0x0890, 0x0891, prN},     // Cf     [2] ARABIC POUND MARK ABOVE..ARABIC PIASTRE MARK ABOVE
	{0x0898, 0x089F, prN},     // Mn     [8] ARABIC SMALL HIGH WORD AL-JUZ..ARABIC HALF MADDA OVER MADDA
	{0x08A0, 0x08C8, prN},     // Lo    [41] ARABIC LETTER BEH WITH SMALL V BELOW..ARABIC LETTER GRAF
	{0x08C9, 0x08C9, prN},     // Lm         ARABIC SMALL FARSI YEH
	{0x08CA, 0x08E1, prN},     // Mn    [24] ARABIC SMALL HIGH FARSI YEH..ARABIC SMALL HIGH SIGN SAFHA
	{0x08E2, 0x08E2, prN},     // Cf         ARABIC DISPUTED END OF AYAH
	{0x08E3, 0x08FF, prN},     // Mn    [29] ARABIC TURNED DAMMA BELOW..ARABIC MARK SIDEWAYS NOON GHUNNA
	{0x0900, 0x0902, prN},     // Mn     [3] DEVANAGARI SIGN INVERTED CANDRABINDU..DEVANAGARI SIGN ANUSVARA
	{0x0903, 0x0903, prN},     // Mc         DEVANAGARI SIGN VISARGA
	{0x0904, 0x0939, prN},     // Lo    [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
	{0x093A, 0x093A, prN},     // Mn         DEVANAGARI VOWEL SIGN OE
	{0x093B, 0x093B, prN},     // Mc         DEVANAGARI VOWEL SIGN OOE
	{0x093C, 0x093C, prN},     // Mn         DEVANAGARI SIGN NUKTA
	{0x093D, 0x093D, prN},     // Lo         DEVANAGARI SIGN AVAGRAHA
	{0x093E, 0x0940, prN},     // Mc     [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
	{0x0941, 0x0948, prN},     // Mn     [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
	{0x0949, 0x094C, prN},     // Mc     [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
	{0x094D, 0x094D, prN},     // Mn         DEVANAGARI SIGN VIRAMA
	{0x094E, 0x094F, prN},     // Mc     [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
	{0x0950, 0x0950, prN},     // Lo         DEVANAGARI OM
	{0x0951, 0x0957, prN},     // Mn     [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
	{0x0958, 0x0961, prN},     // Lo    [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
	{0x0962, 0x0963, prN},     // Mn     [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
	{0x0964, 0x0965, prN},     // Po     [2] DEVANAGARI DANDA..DEVANAGARI DOUBLE DANDA
	{0x0966, 0x096F, prN},     // Nd    [10] DEVANAGARI DIGIT ZERO..DEVANAGARI DIGIT NINE
	{0x0970, 0x0970, prN},     // Po         DEVANAGARI ABBREVIATION SIGN
	{0x0971, 0x0971, prN},     // Lm         DEVANAGARI SIGN HIGH SPACING DOT
	{0x0972, 0x097F, prN},     // Lo    [14] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER BBA
	{0x0980, 0x0980, prN},     // Lo         BENGALI ANJI
	{0x0981, 0x0981, prN},     // Mn         BENGALI SIGN CANDRABINDU
	{0x0982, 0x0983, prN},     // Mc     [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
	{0x0985, 0x098C, prN},     // Lo     [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
	{0x098F, 0x0990, prN},     // Lo     [2] BENGALI LETTER E..BENGALI LETTER AI
	{0x0993, 0x09A8, prN},     // Lo    [22] BENGALI LETTER O..BENGALI LETTER NA
	{0x09AA, 0x09B0, prN},     // Lo     [7] BENGALI LETTER PA..BENGALI LETTER RA
	{0x09B2, 0x09B2, prN},     // Lo         BENGALI LETTER LA
	{0x09B6, 0x09B9, prN},     // Lo     [4] BENGALI LETTER SHA..BENGALI LETTER HA
	{0x09BC, 0x09BC, prN},     // Mn         BENGALI SIGN NUKTA
	{0x09BD, 0x09BD, prN},     // Lo         BENGALI SIGN AVAGRAHA
	{0x09BE, 0x09C0, prN},     // Mc     [3] BENGALI VOWEL SIGN AA..BENGALI VOWEL SIGN II
	{0x09C1, 0x09C4, prN},     // Mn     [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
	{0x09C7, 0x09C8, prN},     // Mc     [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
	{0x09CB, 0x09CC, prN},     // Mc     [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
	{0x09CD, 0x09CD, prN},     // Mn         BENGALI SIGN VIRAMA
	{0x09CE, 0x09CE, prN},     // Lo         BENGALI LETTER KHANDA TA
	{0x09D7, 0x09D7, prN},     // Mc         BENGALI AU LENGTH MARK
	{0x09DC, 0x09DD, prN},     // Lo     [2] BENGALI LETTER RRA..BENGALI LETTER RHA
	{0x09DF, 0x09E1, prN},     // Lo     [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
	{0x09E2, 0x09E3, prN},     // Mn     [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
	{0x09E6, 0x09EF, prN},     // Nd    [10] BENGALI DIGIT ZERO..BENGALI DIGIT NINE
	{0x09F0, 0x09F1, prN},     // Lo     [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
	{0x09F2, 0x09F3, prN},     // Sc     [2] BENGALI RUPEE MARK..BENGALI RUPEE SIGN
	{0x09F4, 0x09F9, prN},     // No     [6] BENGALI CURRENCY NUMERATOR ONE..BENGALI CURRENCY DENOMINATOR SIXTEEN
	{0x09FA, 0x09FA, prN},     // So         BENGALI ISSHAR
	{0x09FB, 0x09FB, prN},     // Sc         BENGALI GANDA MARK
	{0x09FC, 0x09FC, prN},     // Lo         BENGALI LETTER VEDIC ANUSVARA
	{0x09FD, 0x09FD, prN},     // Po         BENGALI ABBREVIATION SIGN
	{0x09FE, 0x09FE, prN},     // Mn         BENGALI SANDHI MARK
	{0x0A01, 0x0A02, prN},     // Mn     [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
	{0x0A03, 0x0A03, prN},     // Mc         GURMUKHI SIGN VISARGA
	{0x0A05, 0x0A0A, prN},     // Lo     [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
	{0x0A0F, 0x0A10, prN},     // Lo     [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
	{0x0A13, 0x0A28, prN},     // Lo    [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
	{0x0A2A, 0x0A30, prN},     // Lo     [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
	{0x0A32, 0x0A33, prN},     // Lo     [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
	{0x0A35, 0x0A36, prN},     // Lo     [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
	{0x0A38, 0x0A39, prN},     // Lo     [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
	{0x0A3C, 0x0A3C, prN},     // Mn         GURMUKHI SIGN NUKTA
	{0x0A3E, 0x0A40, prN},     // Mc     [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
	{0x0A41, 0x0A42, prN},     // Mn     [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
	{0x0A47, 0x0A48, prN},     // Mn     [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
	{0x0A4B, 0x0A4D, prN},     // Mn     [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
	{0x0A51, 0x0A51, prN},     // Mn         GURMUKHI SIGN UDAAT
	{0x0A59, 0x0A5C, prN},     // Lo     [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
	{0x0A5E, 0x0A5E, prN},     // Lo         GURMUKHI LETTER FA
	{0x0A66, 0x0A6F, prN},     // Nd    [10] GURMUKHI DIGIT ZERO..GURMUKHI DIGIT NINE
	{0x0A70, 0x0A71, prN},     // Mn     [2] GURMUKHI TIPPI..GURMUKHI ADDAK
	{0x0A72, 0x0A74, prN},     // Lo     [3] GURMUKHI IRI..GURMUKHI EK ONKAR
	{0x0A75, 0x0A75, prN},     // Mn         GURMUKHI SIGN YAKASH
	{0x0A76, 0x0A76, prN},     // Po         GURMUKHI ABBREVIATION SIGN
	{0x0A81, 0x0A82, prN},     // Mn     [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
	{0x0A83, 0x0A83, prN},     // Mc         GUJARATI SIGN VISARGA
	{0x0A85, 0x0A8D, prN},     // Lo     [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
	{0x0A8F, 0x0A91, prN},     // Lo     [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
	{0x0A93, 0x0AA8, prN},     // Lo    [22] GUJARATI LETTER O..GUJARATI LETTER NA
	{0x0AAA, 0x0AB0, prN},     // Lo     [7] GUJARATI LETTER PA..GUJARATI LETTER RA
	{0x0AB2, 0x0AB3, prN},     // Lo     [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
	{0x0AB5, 0x0AB9, prN},     // Lo     [5] GUJARATI LETTER VA..GUJARATI LETTER HA
	{0x0ABC, 0x0ABC, prN},     // Mn         GUJARATI SIGN NUKTA
	{0x0ABD, 0x0ABD, prN},     // Lo         GUJARATI SIGN AVAGRAHA
	{0x0ABE, 0x0AC0, prN},     // Mc     [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
	{0x0AC1, 0x0AC5, prN},     // Mn     [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
	{0x0AC7, 0x0AC8, prN},     // Mn     [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
	{0x0AC9, 0x0AC9, prN},     // Mc         GUJARATI VOWEL SIGN CANDRA O
	{0x0ACB, 0x0ACC, prN},     // Mc     [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
	{0x0ACD, 0x0ACD, prN},     // Mn         GUJARATI SIGN VIRAMA
	{0x0AD0, 0x0AD0, prN},     // Lo         GUJARATI OM
	{0x0AE0, 0x0AE1, prN},     // Lo     [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
	{0x0AE2, 0x0AE3, prN},     // Mn     [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
	{0x0AE6, 0x0AEF, prN},     // Nd    [10] GUJARATI DIGIT ZERO..GUJARATI DIGIT NINE
	{0x0AF0, 0x0AF0, prN},     // Po         GUJARATI ABBREVIATION SIGN
	{0x0AF1, 0x0AF1, prN},     // Sc         GUJARATI RUPEE SIGN
	{0x0AF9, 0x0AF9, prN},     // Lo         GUJARATI LETTER ZHA
	{0x0AFA, 0x0AFF, prN},     // Mn     [6] GUJARATI SIGN SUKUN..GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE
	{0x0B01, 0x0B01, prN},     // Mn         ORIYA SIGN CANDRABINDU
	{0x0B02, 0x0B03, prN},     // Mc     [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
	{0x0B05, 0x0B0C, prN},     // Lo     [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
	{0x0B0F, 0x0B10, prN},     // Lo     [2] ORIYA LETTER E..ORIYA LETTER AI
	{0x0B13, 0x0B28, prN},     // Lo    [22] ORIYA LETTER O..ORIYA LETTER NA
	{0x0B2A, 0x0B30, prN},     // Lo     [7] ORIYA LETTER PA..ORIYA LETTER RA
	{0x0B32, 0x0B33, prN},     // Lo     [2] ORIYA LETTER LA..ORIYA LETTER LLA
	{0x0B35, 0x0B39, prN},     // Lo     [5] ORIYA LETTER VA..ORIYA LETTER HA
	{0x0B3C, 0x0B3C, prN},     // Mn         ORIYA SIGN NUKTA
	{0x0B3D, 0x0B3D, prN},     // Lo         ORIYA SIGN AVAGRAHA
	{0x0B3E, 0x0B3E, prN},     // Mc         ORIYA VOWEL SIGN AA
	{0x0B3F, 0x0B3F, prN},     // Mn         ORIYA VOWEL SIGN I
	{0x0B40, 0x0B40, prN},     // Mc         ORIYA VOWEL SIGN II
	{0x0B41, 0x0B44, prN},     // Mn     [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
	{0x0B47, 0x0B48, prN},     // Mc     [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
	{0x0B4B, 0x0B4C, prN},     // Mc     [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
	{0x0B4D, 0x0B4D, prN},     // Mn         ORIYA SIGN VIRAMA
	{0x0B55, 0x0B56, prN},     // Mn     [2] ORIYA SIGN OVERLINE..ORIYA AI LENGTH MARK
	{0x0B57, 0x0B57, prN},     // Mc         ORIYA AU LENGTH MARK
	{0x0B5C, 0x0B5D, prN},     // Lo     [2] ORIYA LETTER RRA..ORIYA LETTER RHA
	{0x0B5F, 0x0B61, prN},     // Lo     [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
	{0x0B62, 0x0B63, prN},     // Mn     [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
	{0x0B66, 0x0B6F, prN},     // Nd    [10] ORIYA DIGIT ZERO..ORIYA DIGIT NINE
	{0x0B70, 0x0B70, prN},     // So         ORIYA ISSHAR
	{0x0B71, 0x0B71, prN},     // Lo         ORIYA LETTER WA
	{0x0B72, 0x0B77, prN},     // No     [6] ORIYA FRACTION ONE QUARTER..ORIYA FRACTION THREE SIXTEENTHS
	{0x0B82, 0x0B82, prN},     // Mn         TAMIL SIGN ANUSVARA
	{0x0B83, 0x0B83, prN},     // Lo         TAMIL SIGN VISARGA
	{0x0B85, 0x0B8A, prN},     // Lo     [6] TAMIL LETTER A..TAMIL LETTER UU
	{0x0B8E, 0x0B90, prN},     // Lo     [3] TAMIL LETTER E..TAMIL LETTER AI
	{0x0B92, 0x0B95, prN},     // Lo     [4] TAMIL LETTER O..TAMIL LETTER KA
	{0x0B99, 0x0B9A, prN},     // Lo     [2] TAMIL LETTER NGA..TAMIL LETTER CA
	{0x0B9C, 0x0B9C, prN},     // Lo         TAMIL LETTER JA
	{0x0B9E, 0x0B9F, prN},     // Lo     [2] TAMIL LETTER NYA..TAMIL LETTER TTA
	{0x0BA3, 0x0BA4, prN},     // Lo     [2] TAMIL LETTER NNA..TAMIL LETTER TA
	{0x0BA8, 0x0BAA, prN},     // Lo     [3] TAMIL LETTER NA..TAMIL LETTER PA
	{0x0BAE, 0x0BB9, prN},     // Lo    [12] TAMIL LETTER MA..TAMIL LETTER HA
	{0x0BBE, 0x0BBF, prN},     // Mc     [2] TAMIL VOWEL SIGN AA..TAMIL VOWEL SIGN I
	{0x0BC0, 0x0BC0, prN},     // Mn         TAMIL VOWEL SIGN II
	{0x0BC1, 0x0BC2, prN},     // Mc     [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
	{0x0BC6, 0x0BC8, prN},     // Mc     [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
	{0x0BCA, 0x0BCC, prN},     // Mc     [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
	{0x0BCD, 0x0BCD, prN},     // Mn         TAMIL SIGN VIRAMA
	{0x0BD0, 0x0BD0, prN},     // Lo         TAMIL OM
	{0x0BD7, 0x0BD7, prN},     // Mc         TAMIL AU LENGTH MARK
	{0x0BE6, 0x0BEF, prN},     // Nd    [10] TAMIL DIGIT ZERO..TAMIL DIGIT NINE
	{0x0BF0, 0x0BF2, prN},     // No     [3] TAMIL NUMBER TEN..TAMIL NUMBER ONE THOUSAND
	{0x0BF3, 0x0BF8, prN},     // So     [6] TAMIL DAY SIGN..TAMIL AS ABOVE SIGN
	{0x0BF9, 0x0BF9, prN},     // Sc         TAMIL RUPEE SIGN
	{0x0BFA, 0x0BFA, prN},     // So         TAMIL NUMBER SIGN
	{0x0C00, 0x0C00, prN},     // Mn         TELUGU SIGN COMBINING CANDRABINDU ABOVE
	{0x0C01, 0x0C03, prN},     // Mc     [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
	{0x0C04, 0x0C04, prN},     // Mn         TELUGU SIGN COMBINING ANUSVARA ABOVE
	{0x0C05, 0x0C0C, prN},     // Lo     [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
	{0x0C0E, 0x0C10, prN},     // Lo     [3] TELUGU LETTER E..TELUGU LETTER AI
	{0x0C12, 0x0C28, prN},     // Lo    [23] TELUGU LETTER O..TELUGU LETTER NA
	{0x0C2A, 0x0C39, prN},     // Lo    [16] TELUGU LETTER PA..TELUGU LETTER HA
	{0x0C3C, 0x0C3C, prN},     // Mn         TELUGU SIGN NUKTA
	{0x0C3D, 0x0C3D, prN},     // Lo         TELUGU SIGN AVAGRAHA
	{0x0C3E, 0x0C40, prN},     // Mn     [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
	{0x0C41, 0x0C44, prN},     // Mc     [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
	{0x0C46, 0x0C48, prN},     // Mn     [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
	{0x0C4A, 0x0C4D, prN},     // Mn     [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
	{0x0C55, 0x0C56, prN},     // Mn     [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
	{0x0C58, 0x0C5A, prN},     // Lo     [3] TELUGU LETTER TSA..TELUGU LETTER RRRA
	{0x0C5D, 0x0C5D, prN},     // Lo         TELUGU LETTER NAKAARA POLLU
	{0x0C60, 0x0C61, prN},     // Lo     [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
	{0x0C62, 0x0C63, prN},     // Mn     [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
	{0x0C66, 0x0C6F, prN},     // Nd    [10] TELUGU DIGIT ZERO..TELUGU DIGIT NINE
	{0x0C77, 0x0C77, prN},     // Po         TELUGU SIGN SIDDHAM
	{0x0C78, 0x0C7E, prN},     // No     [7] TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR..TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR
	{0x0C7F, 0x0C7F, prN},     // So         TELUGU SIGN TUUMU
	{0x0C80, 0x0C80, prN},     // Lo         KANNADA SIGN SPACING CANDRABINDU
	{0x0C81, 0x0C81, prN},     // Mn         KANNADA SIGN CANDRABINDU
	{0x0C82, 0x0C83, prN},     // Mc     [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
	{0x0C84, 0x0C84, prN},     // Po         KANNADA SIGN SIDDHAM
	{0x0C85, 0x0C8C, prN},     // Lo     [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
	{0x0C8E, 0x0C90, prN},     // Lo     [3] KANNADA LETTER E..KANNADA LETTER AI
	{0x0C92, 0x0CA8, prN},     // Lo    [23] KANNADA LETTER O..KANNADA LETTER NA
	{0x0CAA, 0x0CB3, prN},     // Lo    [10] KANNADA LETTER PA..KANNADA LETTER LLA
	{0x0CB5, 0x0CB9, prN},     // Lo     [5] KANNADA LETTER VA..KANNADA LETTER HA
	{0x0CBC, 0x0CBC, prN},     // Mn         KANNADA SIGN NUKTA
	{0x0CBD, 0x0CBD, prN},     // Lo         KANNADA SIGN AVAGRAHA
	{0x0CBE, 0x0CBE, prN},     // Mc         KANNADA VOWEL SIGN AA
	{0x0CBF, 0x0CBF, prN},     // Mn         KANNADA VOWEL SIGN I
	{0x0CC0, 0x0CC4, prN},     // Mc     [5] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN VOCALIC RR
	{0x0CC6, 0x0CC6, prN},     // Mn         KANNADA VOWEL SIGN E
	{0x0CC7, 0x0CC8, prN},     // Mc     [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
	{0x0CCA, 0x0CCB, prN},     // Mc     [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
	{0x0CCC, 0x0CCD, prN},     // Mn     [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
	{0x0CD5, 0x0CD6, prN},     // Mc     [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
	{0x0CDD, 0x0CDE, prN},     // Lo     [2] KANNADA LETTER NAKAARA POLLU..KANNADA LETTER FA
	{0x0CE0, 0x0CE1, prN},     // Lo     [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
	{0x0CE2, 0x0CE3, prN},     // Mn     [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
	{0x0CE6, 0x0CEF, prN},     // Nd    [10] KANNADA DIGIT ZERO..KANNADA DIGIT NINE
	{0x0CF1, 0x0CF2, prN},     // Lo     [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
	{0x0CF3, 0x0CF3, prN},     // Mc         KANNADA SIGN COMBINING ANUSVARA ABOVE RIGHT
	{0x0D00, 0x0D01, prN},     // Mn     [2] MALAYALAM SIGN COMBINING ANUSVARA ABOVE..MALAYALAM SIGN CANDRABINDU
	{0x0D02, 0x0D03, prN},     // Mc     [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
	{0x0D04, 0x0D0C, prN},     // Lo     [9] MALAYALAM LETTER VEDIC ANUSVARA..MALAYALAM LETTER VOCALIC L
	{0x0D0E, 0x0D10, prN},     // Lo     [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
	{0x0D12, 0x0D3A, prN},     // Lo    [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
	{0x0D3B, 0x0D3C, prN},     // Mn     [2] MALAYALAM SIGN VERTICAL BAR VIRAMA..MALAYALAM SIGN CIRCULAR VIRAMA
	{0x0D3D, 0x0D3D, prN},     // Lo         MALAYALAM SIGN AVAGRAHA
	{0x0D3E, 0x0D40, prN},     // Mc     [3] MALAYALAM VOWEL SIGN AA..MALAYALAM VOWEL SIGN II
	{0x0D41, 0x0D44, prN},     // Mn     [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
	{0x0D46, 0x0D48, prN},     // Mc     [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
	{0x0D4A, 0x0D4C, prN},     // Mc     [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
	{0x0D4D, 0x0D4D, prN},     // Mn         MALAYALAM SIGN VIRAMA
	{0x0D4E, 0x0D4E, prN},     // Lo         MALAYALAM LETTER DOT REPH
	{0x0D4F, 0x0D4F, prN},     // So         MALAYALAM SIGN PARA
	{0x0D54, 0x0D56, prN},     // Lo     [3] MALAYALAM LETTER CHILLU M..MALAYALAM LETTER CHILLU LLL
	{0x0D57, 0x0D57, prN},     // Mc         MALAYALAM AU LENGTH MARK
	{0x0D58, 0x0D5E, prN},     // No     [7] MALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIETH..MALAYALAM FRACTION ONE FIFTH
	{0x0D5F, 0x0D61, prN},     // Lo     [3] MALAYALAM LETTER ARCHAIC II..MALAYALAM LETTER VOCALIC LL
	{0x0D62, 0x0D63, prN},     // Mn     [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
	{0x0D66, 0x0D6F, prN},     // Nd    [10] MALAYALAM DIGIT ZERO..MALAYALAM DIGIT NINE
	{0x0D70, 0x0D78, prN},     // No     [9] MALAYALAM NUMBER TEN..MALAYALAM FRACTION THREE SIXTEENTHS
	{0x0D79, 0x0D79, prN},     // So         MALAYALAM DATE MARK
	{0x0D7A, 0x0D7F, prN},     // Lo     [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
	{0x0D81, 0x0D81, prN},     // Mn         SINHALA SIGN CANDRABINDU
	{0x0D82, 0x0D83, prN},     // Mc     [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
	{0x0D85, 0x0D96, prN},     // Lo    [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
	{0x0D9A, 0x0DB1, prN},     // Lo    [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
	{0x0DB3, 0x0DBB, prN},     // Lo     [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
	{0x0DBD, 0x0DBD, prN},     // Lo         SINHALA LETTER DANTAJA LAYANNA
	{0x0DC0, 0x0DC6, prN},     // Lo     [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
	{0x0DCA, 0x0DCA, prN},     // Mn         SINHALA SIGN AL-LAKUNA
	{0x0DCF, 0x0DD1, prN},     // Mc     [3] SINHALA VOWEL SIGN AELA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
	{0x0DD2, 0x0DD4, prN},     // Mn     [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
	{0x0DD6, 0x0DD6, prN},     // Mn         SINHALA VOWEL SIGN DIGA PAA-PILLA
	{0x0DD8, 0x0DDF, prN},     // Mc     [8] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN GAYANUKITTA
	{0x0DE6, 0x0DEF, prN},     // Nd    [10] SINHALA LITH DIGIT ZERO..SINHALA LITH DIGIT NINE
	{0x0DF2, 0x0DF3, prN},     // Mc     [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
	{0x0DF4, 0x0DF4, prN},     // Po         SINHALA PUNCTUATION KUNDDALIYA
	{0x0E01, 0x0E30, prN},     // Lo    [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
	{0x0E31, 0x0E31, prN},     // Mn         THAI CHARACTER MAI HAN-AKAT
	{0x0E32, 0x0E33, prN},     // Lo     [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
	{0x0E34, 0x0E3A, prN},     // Mn     [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
	{0x0E3F, 0x0E3F, prN},     // Sc         THAI CURRENCY SYMBOL BAHT
	{0x0E40, 0x0E45, prN},     // Lo     [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
	{0x0E46, 0x0E46, prN},     // Lm         THAI CHARACTER MAIYAMOK
	{0x0E47, 0x0E4E, prN},     // Mn     [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
	{0x0E4F, 0x0E4F, prN},     // Po         THAI CHARACTER FONGMAN
	{0x0E50, 0x0E59, prN},     // Nd    [10] THAI DIGIT ZERO..THAI DIGIT NINE
	{0x0E5A, 0x0E5B, prN},     // Po     [2] THAI CHARACTER ANGKHANKHU..THAI CHARACTER KHOMUT
	{0x0E81, 0x0E82, prN},     // Lo     [2] LAO LETTER KO..LAO LETTER KHO SUNG
	{0x0E84, 0x0E84, prN},     // Lo         LAO LETTER KHO TAM
	{0x0E86, 0x0E8A, prN},     // Lo     [5] LAO LETTER PALI GHA..LAO LETTER SO TAM
	{0x0E8C, 0x0EA3, prN},     // Lo    [24] LAO LETTER PALI JHA..LAO LETTER LO LING
	{0x0EA5, 0x0EA5, prN},     // Lo         LAO LETTER LO LOOT
	{0x0EA7, 0x0EB0, prN},     // Lo    [10] LAO LETTER WO..LAO VOWEL SIGN A
	{0x0EB1, 0x0EB1, prN},     // Mn         LAO VOWEL SIGN MAI KAN
	{0x0EB2, 0x0EB3, prN},     // Lo     [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
	{0x0EB4, 0x0EBC, prN},     // Mn     [9] LAO VOWEL SIGN I..LAO SEMIVOWEL SIGN LO
	{0x0EBD, 0x0EBD, prN},     // Lo         LAO SEMIVOWEL SIGN NYO
	{0x0EC0, 0x0EC4, prN},     // Lo     [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
	{0x0EC6, 0x0EC6, prN},     // Lm         LAO KO LA
	{0x0EC8, 0x0ECE, prN},     // Mn     [7] LAO TONE MAI EK..LAO YAMAKKAN
	{0x0ED0, 0x0ED9, prN},     // Nd    [10] LAO DIGIT ZERO..LAO DIGIT NINE
	{0x0EDC, 0x0EDF, prN},     // Lo     [4] LAO HO NO..LAO LETTER KHMU NYO
	{0x0F00, 0x0F00, prN},     // Lo         TIBETAN SYLLABLE OM
	{0x0F01, 0x0F03, prN},     // So     [3] TIBETAN MARK GTER YIG MGO TRUNCATED A..TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
	{0x0F04, 0x0F12, prN},     // Po    [15] TIBETAN MARK INITIAL YIG MGO MDUN MA..TIBETAN MARK RGYA GRAM SHAD
	{0x0F13, 0x0F13, prN},     // So         TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN
	{0x0F14, 0x0F14, prN},     // Po         TIBETAN MARK GTER TSHEG
	{0x0F15, 0x0F17, prN},     // So     [3] TIBETAN LOGOTYPE SIGN CHAD RTAGS..TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
	{0x0F18, 0x0F19, prN},     // Mn     [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
	{0x0F1A, 0x0F1F, prN},     // So     [6] TIBETAN SIGN RDEL DKAR GCIG..TIBETAN SIGN RDEL DKAR RDEL NAG
	{0x0F20, 0x0F29, prN},     // Nd    [10] TIBETAN DIGIT ZERO..TIBETAN DIGIT NINE
	{0x0F2A, 0x0F33, prN},     // No    [10] TIBETAN DIGIT HALF ONE..TIBETAN DIGIT HALF ZERO
	{0x0F34, 0x0F34, prN},     // So         TIBETAN MARK BSDUS RTAGS
	{0x0F35, 0x0F35, prN},     // Mn         TIBETAN MARK NGAS BZUNG NYI ZLA
	{0x0F36, 0x0F36, prN},     // So         TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
	{0x0F37, 0x0F37, prN},     // Mn         TIBETAN MARK NGAS BZUNG SGOR RTAGS
	{0x0F38, 0x0F38, prN},     // So         TIBETAN MARK CHE MGO
	{0x0F39, 0x0F39, prN},     // Mn         TIBETAN MARK TSA -PHRU
	{0x0F3A, 0x0F3A, prN},     // Ps         TIBETAN MARK GUG RTAGS GYON
	{0x0F3B, 0x0F3B, prN},     // Pe         TIBETAN MARK GUG RTAGS GYAS
	{0x0F3C, 0x0F3C, prN},     // Ps         TIBETAN MARK ANG KHANG GYON
	{0x0F3D, 0x0F3D, prN},     // Pe         TIBETAN MARK ANG KHANG GYAS
	{0x0F3E, 0x0F3F, prN},     // Mc     [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
	{0x0F40, 0x0F47, prN},     // Lo     [8] TIBETAN LETTER KA..TIBETAN LETTER JA
	{0x0F49, 0x0F6C, prN},     // Lo    [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
	{0x0F71, 0x0F7E, prN},     // Mn    [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
	{0x0F7F, 0x0F7F, prN},     // Mc         TIBETAN SIGN RNAM BCAD
	{0x0F80, 0x0F84, prN},     // Mn     [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
	{0x0F85, 0x0F85, prN},     // Po         TIBETAN MARK PALUTA
	{0x0F86, 0x0F87, prN},     // Mn     [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
	{0x0F88, 0x0F8C, prN},     // Lo     [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
	{0x0F8D, 0x0F97, prN},     // Mn    [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
	{0x0F99, 0x0FBC, prN},     // Mn    [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
	{0x0FBE, 0x0FC5, prN},     // So     [8] TIBETAN KU RU KHA..TIBETAN SYMBOL RDO RJE
	{0x0FC6, 0x0FC6, prN},     // Mn         TIBETAN SYMBOL PADMA GDAN
	{0x0FC7, 0x0FCC, prN},     // So     [6] TIBETAN SYMBOL RDO RJE RGYA GRAM..TIBETAN SYMBOL NOR BU BZHI -KHYIL
	{0x0FCE, 0x0FCF, prN},     // So     [2] TIBETAN SIGN RDEL NAG RDEL DKAR..TIBETAN SIGN RDEL NAG GSUM
	{0x0FD0, 0x0FD4, prN},     // Po     [5] TIBETAN MARK BSKA- SHOG GI MGO RGYAN..TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA
	{0x0FD5, 0x0FD8, prN},     // So     [4] RIGHT-FACING SVASTI SIGN..LEFT-FACING SVASTI SIGN WITH DOTS
	{0x0FD9, 0x0FDA, prN},     // Po     [2] TIBETAN MARK LEADING MCHAN RTAGS..TIBETAN MARK TRAILING MCHAN RTAGS
	{0x1000, 0x102A, prN},     // Lo    [43] MYANMAR LETTER KA..MYANMAR LETTER AU
	{0x102B, 0x102C, prN},     // Mc     [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
	{0x102D, 0x1030, prN},     // Mn     [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
	{0x1031, 0x1031, prN},     // Mc         MYANMAR VOWEL SIGN E
	{0x1032, 0x1037, prN},     // Mn     [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
	{0x1038, 0x1038, prN},     // Mc         MYANMAR SIGN VISARGA
	{0x1039, 0x103A, prN},     // Mn     [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
	{0x103B, 0x103C, prN},     // Mc     [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
	{0x103D, 0x103E, prN},     // Mn     [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
	{0x103F, 0x103F, prN},     // Lo         MYANMAR LETTER GREAT SA
	{0x1040, 0x1049, prN},     // Nd    [10] MYANMAR DIGIT ZERO..MYANMAR DIGIT NINE
	{0x104A, 0x104F, prN},     // Po     [6] MYANMAR SIGN LITTLE SECTION..MYANMAR SYMBOL GENITIVE
	{0x1050, 0x1055, prN},     // Lo     [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
	{0x1056, 0x1057, prN},     // Mc     [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
	{0x1058, 0x1059, prN},     // Mn     [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
	{0x105A, 0x105D, prN},     // Lo     [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
	{0x105E, 0x1060, prN},     // Mn     [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
	{0x1061, 0x1061, prN},     // Lo         MYANMAR LETTER SGAW KAREN SHA
	{0x1062, 0x1064, prN},     // Mc     [3] MYANMAR VOWEL SIGN SGAW KAREN EU..MYANMAR TONE MARK SGAW KAREN KE PHO
	{0x1065, 0x1066, prN},     // Lo     [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
	{0x1067, 0x106D, prN},     // Mc     [7] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR SIGN WESTERN PWO KAREN TONE-5
	{0x106E, 0x1070, prN},     // Lo     [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
	{0x1071, 0x1074, prN},     // Mn     [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
	{0x1075, 0x1081, prN},     // Lo    [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
	{0x1082, 0x1082, prN},     // Mn         MYANMAR CONSONANT SIGN SHAN MEDIAL WA
	{0x1083, 0x1084, prN},     // Mc     [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
	{0x1085, 0x1086, prN},     // Mn     [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
	{0x1087, 0x108C, prN},     // Mc     [6] MYANMAR SIGN SHAN TONE-2..MYANMAR SIGN SHAN COUNCIL TONE-3
	{0x108D, 0x108D, prN},     // Mn         MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
	{0x108E, 0x108E, prN},     // Lo         MYANMAR LETTER RUMAI PALAUNG FA
	{0x108F, 0x108F, prN},     // Mc         MYANMAR SIGN RUMAI PALAUNG TONE-5
	{0x1090, 0x1099, prN},     // Nd    [10] MYANMAR SHAN DIGIT ZERO..MYANMAR SHAN DIGIT NINE
	{0x109A, 0x109C, prN},     // Mc     [3] MYANMAR SIGN KHAMTI TONE-1..MYANMAR VOWEL SIGN AITON A
	{0x109D, 0x109D, prN},     // Mn         MYANMAR VOWEL SIGN AITON AI
	{0x109E, 0x109F, prN},     // So     [2] MYANMAR SYMBOL SHAN ONE..MYANMAR SYMBOL SHAN EXCLAMATION
	{0x10A0, 0x10C5, prN},     // Lu    [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
	{0x10C7, 0x10C7, prN},     // Lu         GEORGIAN CAPITAL LETTER YN
	{0x10CD, 0x10CD, prN},     // Lu         GEORGIAN CAPITAL LETTER AEN
	{0x10D0, 0x10FA, prN},     // Ll    [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
	{0x10FB, 0x10FB, prN},     // Po         GEORGIAN PARAGRAPH SEPARATOR
	{0x10FC, 0x10FC, prN},     // Lm         MODIFIER LETTER GEORGIAN NAR
	{0x10FD, 0x10FF, prN},     // Ll     [3] GEORGIAN LETTER AEN..GEORGIAN LETTER LABIAL SIGN
	{0x1100, 0x115F, prW},     // Lo    [96] HANGUL CHOSEONG KIYEOK..HANGUL CHOSEONG FILLER
	{0x1160, 0x11FF, prN},     // Lo   [160] HANGUL JUNGSEONG FILLER..HANGUL JONGSEONG SSANGNIEUN
	{0x1200, 0x1248, prN},     // Lo    [73] ETHIOPIC SYLLABLE HA..ETHIOPIC SYLLABLE QWA
	{0x124A, 0x124D, prN},     // Lo     [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
	{0x1250, 0x1256, prN},     // Lo     [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
	{0x1258, 0x1258, prN},     // Lo         ETHIOPIC SYLLABLE QHWA
	{0x125A, 0x125D, prN},     // Lo     [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
	{0x1260, 0x1288, prN},     // Lo    [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
	{0x128A, 0x128D, prN},     // Lo     [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
	{0x1290, 0x12B0, prN},     // Lo    [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
	{0x12B2, 0x12B5, prN},     // Lo     [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
	{0x12B8, 0x12BE, prN},     // Lo     [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
	{0x12C0, 0x12C0, prN},     // Lo         ETHIOPIC SYLLABLE KXWA
	{0x12C2, 0x12C5, prN},     // Lo     [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
	{0x12C8, 0x12D6, prN},     // Lo    [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
	{0x12D8, 0x1310, prN},     // Lo    [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
	{0x1312, 0x1315, prN},     // Lo     [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
	{0x1318, 0x135A, prN},     // Lo    [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
	{0x135D, 0x135F, prN},     // Mn     [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
	{0x1360, 0x1368, prN},     // Po     [9] ETHIOPIC SECTION MARK..ETHIOPIC PARAGRAPH SEPARATOR
	{0x1369, 0x137C, prN},     // No    [20] ETHIOPIC DIGIT ONE..ETHIOPIC NUMBER TEN THOUSAND
	{0x1380, 0x138F, prN},     // Lo    [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
	{0x1390, 0x1399, prN},     // So    [10] ETHIOPIC TONAL MARK YIZET..ETHIOPIC TONAL MARK KURT
	{0x13A0, 0x13F5, prN},     // Lu    [86] CHEROKEE LETTER A..CHEROKEE LETTER MV
	{0x13F8, 0x13FD, prN},     // Ll     [6] CHEROKEE SMALL LETTER YE..CHEROKEE SMALL LETTER MV
	{0x1400, 0x1400, prN},     // Pd         CANADIAN SYLLABICS HYPHEN
	{0x1401, 0x166C, prN},     // Lo   [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
	{0x166D, 0x166D, prN},     // So         CANADIAN SYLLABICS CHI SIGN
	{0x166E, 0x166E, prN},     // Po         CANADIAN SYLLABICS FULL STOP
	{0x166F, 0x167F, prN},     // Lo    [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
	{0x1680, 0x1680, prN},     // Zs         OGHAM SPACE MARK
	{0x1681, 0x169A, prN},     // Lo    [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
	{0x169B, 0x169B, prN},     // Ps         OGHAM FEATHER MARK
	{0x169C, 0x169C, prN},     // Pe         OGHAM REVERSED FEATHER MARK
	{0x16A0, 0x16EA, prN},     // Lo    [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
	{0x16EB, 0x16ED, prN},     // Po     [3] RUNIC SINGLE PUNCTUATION..RUNIC CROSS PUNCTUATION
	{0x16EE, 0x16F0, prN},     // Nl     [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
	{0x16F1, 0x16F8, prN},     // Lo     [8] RUNIC LETTER K..RUNIC LETTER FRANKS CASKET AESC
	{0x1700, 0x1711, prN},     // Lo    [18] TAGALOG LETTER A..TAGALOG LETTER HA
	{0x1712, 0x1714, prN},     // Mn     [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
	{0x1715, 0x1715, prN},     // Mc         TAGALOG SIGN PAMUDPOD
	{0x171F, 0x171F, prN},     // Lo         TAGALOG LETTER ARCHAIC RA
	{0x1720, 0x1731, prN},     // Lo    [18] HANUNOO LETTER A..HANUNOO LETTER HA
	{0x1732, 0x1733, prN},     // Mn     [2] HANUNOO VOWEL SIGN I..HANUNOO VOWEL SIGN U
	{0x1734, 0x1734, prN},     // Mc         HANUNOO SIGN PAMUDPOD
	{0x1735, 0x1736, prN},     // Po     [2] PHILIPPINE SINGLE PUNCTUATION..PHILIPPINE DOUBLE PUNCTUATION
	{0x1740, 0x1751, prN},     // Lo    [18] BUHID LETTER A..BUHID LETTER HA
	{0x1752, 0x1753, prN},     // Mn     [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
	{0x1760, 0x176C, prN},     // Lo    [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
	{0x176E, 0x1770, prN},     // Lo     [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
	{0x1772, 0x1773, prN},     // Mn     [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
	{0x1780, 0x17B3, prN},     // Lo    [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
	{0x17B4, 0x17B5, prN},     // Mn     [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
	{0x17B6, 0x17B6, prN},     // Mc         KHMER VOWEL SIGN AA
	{0x17B7, 0x17BD, prN},     // Mn     [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
	{0x17BE, 0x17C5, prN},     // Mc     [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
	{0x17C6, 0x17C6, prN},     // Mn         KHMER SIGN NIKAHIT
	{0x17C7, 0x17C8, prN},     // Mc     [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
	{0x17C9, 0x17D3, prN},     // Mn    [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
	{0x17D4, 0x17D6, prN},     // Po     [3] KHMER SIGN KHAN..KHMER SIGN CAMNUC PII KUUH
	{0x17D7, 0x17D7, prN},     // Lm         KHMER SIGN LEK TOO
	{0x17D8, 0x17DA, prN},     // Po     [3] KHMER SIGN BEYYAL..KHMER SIGN KOOMUUT
	{0x17DB, 0x17DB, prN},     // Sc         KHMER CURRENCY SYMBOL RIEL
	{0x17DC, 0x17DC, prN},     // Lo         KHMER SIGN AVAKRAHASANYA
	{0x17DD, 0x17DD, prN},     // Mn         KHMER SIGN ATTHACAN
	{0x17E0, 0x17E9, prN},     // Nd    [10] KHMER DIGIT ZERO..KHMER DIGIT NINE
	{0x17F0, 0x17F9, prN},     // No    [10] KHMER SYMBOL LEK ATTAK SON..KHMER SYMBOL LEK ATTAK PRAM-BUON
	{0x1800, 0x1805, prN},     // Po     [6] MONGOLIAN BIRGA..MONGOLIAN FOUR DOTS
	{0x1806, 0x1806, prN},     // Pd         MONGOLIAN TODO SOFT HYPHEN
	{0x1807, 0x180A, prN},     // Po     [4] MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER..MONGOLIAN NIRUGU
	{0x180B, 0x180D, prN},     // Mn     [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
	{0x180E, 0x180E, prN},     // Cf         MONGOLIAN VOWEL SEPARATOR
	{0x180F, 0x180F, prN},     // Mn         MONGOLIAN FREE VARIATION SELECTOR FOUR
	{0x1810, 0x1819, prN},     // Nd    [10] MONGOLIAN DIGIT ZERO..MONGOLIAN DIGIT NINE
	{0x1820, 0x1842, prN},     // Lo    [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
	{0x1843, 0x1843, prN},     // Lm         MONGOLIAN LETTER TODO LONG VOWEL SIGN
	{0x1844, 0x1878, prN},     // Lo    [53] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER CHA WITH TWO DOTS
	{0x1880, 0x1884, prN},     // Lo     [5] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
	{0x1885, 0x1886, prN},     // Mn     [2] MONGOLIAN LETTER ALI GALI BALUDA..MONGOLIAN LETTER ALI GALI THREE BALUDA
	{0x1887, 0x18A8, prN},     // Lo    [34] MONGOLIAN LETTER ALI GALI A..MONGOLIAN LETTER MANCHU ALI GALI BHA
	{0x18A9, 0x18A9, prN},     // Mn         MONGOLIAN LETTER ALI GALI DAGALGA
	{0x18AA, 0x18AA, prN},     // Lo         MONGOLIAN LETTER MANCHU ALI GALI LHA
	{0x18B0, 0x18F5, prN},     // Lo    [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
	{0x1900, 0x191E, prN},     // Lo    [31] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER TRA
	{0x1920, 0x1922, prN},     // Mn     [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
	{0x1923, 0x1926, prN},     // Mc     [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
	{0x1927, 0x1928, prN},     // Mn     [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
	{0x1929, 0x192B, prN},     // Mc     [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
	{0x1930, 0x1931, prN},     // Mc     [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
	{0x1932, 0x1932, prN},     // Mn         LIMBU SMALL LETTER ANUSVARA
	{0x1933, 0x1938, prN},     // Mc     [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
	{0x1939, 0x193B, prN},     // Mn     [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
	{0x1940, 0x1940, prN},     // So         LIMBU SIGN LOO
	{0x1944, 0x1945, prN},     // Po     [2] LIMBU EXCLAMATION MARK..LIMBU QUESTION MARK
	{0x1946, 0x194F, prN},     // Nd    [10] LIMBU DIGIT ZERO..LIMBU DIGIT NINE
	{0x1950, 0x196D, prN},     // Lo    [30] TAI LE LETTER KA..TAI LE LETTER AI
	{0x1970, 0x1974, prN},     // Lo     [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
	{0x1980, 0x19AB, prN},     // Lo    [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
	{0x19B0, 0x19C9, prN},     // Lo    [26] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE TONE MARK-2
	{0x19D0, 0x19D9, prN},     // Nd    [10] NEW TAI LUE DIGIT ZERO..NEW TAI LUE DIGIT NINE
	{0x19DA, 0x19DA, prN},     // No         NEW TAI LUE THAM DIGIT ONE
	{0x19DE, 0x19DF, prN},     // So     [2] NEW TAI LUE SIGN LAE..NEW TAI LUE SIGN LAEV
	{0x19E0, 0x19FF, prN},     // So    [32] KHMER SYMBOL PATHAMASAT..KHMER SYMBOL DAP-PRAM ROC
	{0x1A00, 0x1A16, prN},     // Lo    [23] BUGINESE LETTER KA..BUGINESE LETTER HA
	{0x1A17, 0x1A18, prN},     // Mn     [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
	{0x1A19, 0x1A1A, prN},     // Mc     [2] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN O
	{0x1A1B, 0x1A1B, prN},     // Mn         BUGINESE VOWEL SIGN AE
	{0x1A1E, 0x1A1F, prN},     // Po     [2] BUGINESE PALLAWA..BUGINESE END OF SECTION
	{0x1A20, 0x1A54, prN},     // Lo    [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
	{0x1A55, 0x1A55, prN},     // Mc         TAI THAM CONSONANT SIGN MEDIAL RA
	{0x1A56, 0x1A56, prN},     // Mn         TAI THAM CONSONANT SIGN MEDIAL LA
	{0x1A57, 0x1A57, prN},     // Mc         TAI THAM CONSONANT SIGN LA TANG LAI
	{0x1A58, 0x1A5E, prN},     // Mn     [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
	{0x1A60, 0x1A60, prN},     // Mn         TAI THAM SIGN SAKOT
	{0x1A61, 0x1A61, prN},     // Mc         TAI THAM VOWEL SIGN A
	{0x1A62, 0x1A62, prN},     // Mn         TAI THAM VOWEL SIGN MAI SAT
	{0x1A63, 0x1A64, prN},     // Mc     [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
	{0x1A65, 0x1A6C, prN},     // Mn     [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
	{0x1A6D, 0x1A72, prN},     // Mc     [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
	{0x1A73, 0x1A7C, prN},     // Mn    [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
	{0x1A7F, 0x1A7F, prN},     // Mn         TAI THAM COMBINING CRYPTOGRAMMIC DOT
	{0x1A80, 0x1A89, prN},     // Nd    [10] TAI THAM HORA DIGIT ZERO..TAI THAM HORA DIGIT NINE
	{0x1A90, 0x1A99, prN},     // Nd    [10] TAI THAM THAM DIGIT ZERO..TAI THAM THAM DIGIT NINE
	{0x1AA0, 0x1AA6, prN},     // Po     [7] TAI THAM SIGN WIANG..TAI THAM SIGN REVERSED ROTATED RANA
	{0x1AA7, 0x1AA7, prN},     // Lm         TAI THAM SIGN MAI YAMOK
	{0x1AA8, 0x1AAD, prN},     // Po     [6] TAI THAM SIGN KAAN..TAI THAM SIGN CAANG
	{0x1AB0, 0x1ABD, prN},     // Mn    [14] COMBINING DOUBLED CIRCUMFLEX ACCENT..COMBINING PARENTHESES BELOW
	{0x1ABE, 0x1ABE, prN},     // Me         COMBINING PARENTHESES OVERLAY
	{0x1ABF, 0x1ACE, prN},     // Mn    [16] COMBINING LATIN SMALL LETTER W BELOW..COMBINING LATIN SMALL LETTER INSULAR T
	{0x1B00, 0x1B03, prN},     // Mn     [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
	{0x1B04, 0x1B04, prN},     // Mc         BALINESE SIGN BISAH
	{0x1B05, 0x1B33, prN},     // Lo    [47] BALINESE LETTER AKARA..BALINESE LETTER HA
	{0x1B34, 0x1B34, prN},     // Mn         BALINESE SIGN REREKAN
	{0x1B35, 0x1B35, prN},     // Mc         BALINESE VOWEL SIGN TEDUNG
	{0x1B36, 0x1B3A, prN},     // Mn     [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
	{0x1B3B, 0x1B3B, prN},     // Mc         BALINESE VOWEL SIGN RA REPA TEDUNG
	{0x1B3C, 0x1B3C, prN},     // Mn         BALINESE VOWEL SIGN LA LENGA
	{0x1B3D, 0x1B41, prN},     // Mc     [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
	{0x1B42, 0x1B42, prN},     // Mn         BALINESE VOWEL SIGN PEPET
	{0x1B43, 0x1B44, prN},     // Mc     [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
	{0x1B45, 0x1B4C, prN},     // Lo     [8] BALINESE LETTER KAF SASAK..BALINESE LETTER ARCHAIC JNYA
	{0x1B50, 0x1B59, prN},     // Nd    [10] BALINESE DIGIT ZERO..BALINESE DIGIT NINE
	{0x1B5A, 0x1B60, prN},     // Po     [7] BALINESE PANTI..BALINESE PAMENENG
	{0x1B61, 0x1B6A, prN},     // So    [10] BALINESE MUSICAL SYMBOL DONG..BALINESE MUSICAL SYMBOL DANG GEDE
	{0x1B6B, 0x1B73, prN},     // Mn     [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
	{0x1B74, 0x1B7C, prN},     // So     [9] BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG..BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING
	{0x1B7D, 0x1B7E, prN},     // Po     [2] BALINESE PANTI LANTANG..BALINESE PAMADA LANTANG
	{0x1B80, 0x1B81, prN},     // Mn     [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
	{0x1B82, 0x1B82, prN},     // Mc         SUNDANESE SIGN PANGWISAD
	{0x1B83, 0x1BA0, prN},     // Lo    [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
	{0x1BA1, 0x1BA1, prN},     // Mc         SUNDANESE CONSONANT SIGN PAMINGKAL
	{0x1BA2, 0x1BA5, prN},     // Mn     [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
	{0x1BA6, 0x1BA7, prN},     // Mc     [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
	{0x1BA8, 0x1BA9, prN},     // Mn     [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
	{0x1BAA, 0x1BAA, prN},     // Mc         SUNDANESE SIGN PAMAAEH
	{0x1BAB, 0x1BAD, prN},     // Mn     [3] SUNDANESE SIGN VIRAMA..SUNDANESE CONSONANT SIGN PASANGAN WA
	{0x1BAE, 0x1BAF, prN},     // Lo     [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
	{0x1BB0, 0x1BB9, prN},     // Nd    [10] SUNDANESE DIGIT ZERO..SUNDANESE DIGIT NINE
	{0x1BBA, 0x1BBF, prN},     // Lo     [6] SUNDANESE AVAGRAHA..SUNDANESE LETTER FINAL M
	{0x1BC0, 0x1BE5, prN},     // Lo    [38] BATAK LETTER A..BATAK LETTER U
	{0x1BE6, 0x1BE6, prN},     // Mn         BATAK SIGN TOMPI
	{0x1BE7, 0x1BE7, prN},     // Mc         BATAK VOWEL SIGN E
	{0x1BE8, 0x1BE9, prN},     // Mn     [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
	{0x1BEA, 0x1BEC, prN},     // Mc     [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
	{0x1BED, 0x1BED, prN},     // Mn         BATAK VOWEL SIGN KARO O
	{0x1BEE, 0x1BEE, prN},     // Mc         BATAK VOWEL SIGN U
	{0x1BEF, 0x1BF1, prN},     // Mn     [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
	{0x1BF2, 0x1BF3, prN},     // Mc     [2] BATAK PANGOLAT..BATAK PANONGONAN
	{0x1BFC, 0x1BFF, prN},     // Po     [4] BATAK SYMBOL BINDU NA METEK..BATAK SYMBOL BINDU PANGOLAT
	{0x1C00, 0x1C23, prN},     // Lo    [36] LEPCHA LETTER KA..LEPCHA LETTER A
	{0x1C24, 0x1C2B, prN},     // Mc     [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
	{0x1C2C, 0x1C33, prN},     // Mn     [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
	{0x1C34, 0x1C35, prN},     // Mc     [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
	{0x1C36, 0x1C37, prN},     // Mn     [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
	{0x1C3B, 0x1C3F, prN},     // Po     [5] LEPCHA PUNCTUATION TA-ROL..LEPCHA PUNCTUATION TSHOOK
	{0x1C40, 0x1C49, prN},     // Nd    [10] LEPCHA DIGIT ZERO..LEPCHA DIGIT NINE
	{0x1C4D, 0x1C4F, prN},     // Lo     [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
	{0x1C50, 0x1C59, prN},     // Nd    [10] OL CHIKI DIGIT ZERO..OL CHIKI DIGIT NINE
	{0x1C5A, 0x1C77, prN},     // Lo    [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
	{0x1C78, 0x1C7D, prN},     // Lm     [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
	{0x1C7E, 0x1C7F, prN},     // Po     [2] OL CHIKI PUNCTUATION MUCAAD..OL CHIKI PUNCTUATION DOUBLE MUCAAD
	{0x1C80, 0x1C88, prN},     // Ll     [9] CYRILLIC SMALL LETTER ROUNDED VE..CYRILLIC SMALL LETTER UNBLENDED UK
	{0x1C90, 0x1CBA, prN},     // Lu    [43] GEORGIAN MTAVRULI CAPITAL LETTER AN..GEORGIAN MTAVRULI CAPITAL LETTER AIN
	{0x1CBD, 0x1CBF, prN},     // Lu     [3] GEORGIAN MTAVRULI CAPITAL LETTER AEN..GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
	{0x1CC0, 0x1CC7, prN},     // Po     [8] SUNDANESE PUNCTUATION BINDU SURYA..SUNDANESE PUNCTUATION BINDU BA SATANGA
	{0x1CD0, 0x1CD2, prN},     // Mn     [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
	{0x1CD3, 0x1CD3, prN},     // Po         VEDIC SIGN NIHSHVASA
	{0x1CD4, 0x1CE0, prN},     // Mn    [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
	{0x1CE1, 0x1CE1, prN},     // Mc         VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
	{0x1CE2, 0x1CE8, prN},     // Mn     [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
	{0x1CE9, 0x1CEC, prN},     // Lo     [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
	{0x1CED, 0x1CED, prN},     // Mn         VEDIC SIGN TIRYAK
	{0x1CEE, 0x1CF3, prN},     // Lo     [6] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ROTATED ARDHAVISARGA
	{0x1CF4, 0x1CF4, prN},     // Mn         VEDIC TONE CANDRA ABOVE
	{0x1CF5, 0x1CF6, prN},     // Lo     [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
	{0x1CF7, 0x1CF7, prN},     // Mc         VEDIC SIGN ATIKRAMA
	{0x1CF8, 0x1CF9, prN},     // Mn     [2] VEDIC TONE RING ABOVE..VEDIC TONE DOUBLE RING ABOVE
	{0x1CFA, 0x1CFA, prN},     // Lo         VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA
	{0x1D00, 0x1D2B, prN},     // Ll    [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
	{0x1D2C, 0x1D6A, prN},     // Lm    [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
	{0x1D6B, 0x1D77, prN},     // Ll    [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
	{0x1D78, 0x1D78, prN},     // Lm         MODIFIER LETTER CYRILLIC EN
	{0x1D79, 0x1D7F, prN},     // Ll     [7] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER UPSILON WITH STROKE
	{0x1D80, 0x1D9A, prN},     // Ll    [27] LATIN SMALL LETTER B WITH PALATAL HOOK..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
	{0x1D9B, 0x1DBF, prN},     // Lm    [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
	{0x1DC0, 0x1DFF, prN},     // Mn    [64] COMBINING DOTTED GRAVE ACCENT..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
	{0x1E00, 0x1EFF, prN},     // L&   [256] LATIN CAPITAL LETTER A WITH RING BELOW..LATIN SMALL LETTER Y WITH LOOP
	{0x1F00, 0x1F15, prN},     // L&    [22] GREEK SMALL LETTER ALPHA WITH PSILI..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
	{0x1F18, 0x1F1D, prN},     // Lu     [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
	{0x1F20, 0x1F45, prN},     // L&    [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
	{0x1F48, 0x1F4D, prN},     // Lu     [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
	{0x1F50, 0x1F57, prN},     // Ll     [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
	{0x1F59, 0x1F59, prN},     // Lu         GREEK CAPITAL LETTER UPSILON WITH DASIA
	{0x1F5B, 0x1F5B, prN},     // Lu         GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
	{0x1F5D, 0x1F5D, prN},     // Lu         GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
	{0x1F5F, 0x1F7D, prN},     // L&    [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
	{0x1F80, 0x1FB4, prN},     // L&    [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
	{0x1FB6, 0x1FBC, prN},     // L&     [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
	{0x1FBD, 0x1FBD, prN},     // Sk         GREEK KORONIS
	{0x1FBE, 0x1FBE, prN},     // Ll         GREEK PROSGEGRAMMENI
	{0x1FBF, 0x1FC1, prN},     // Sk     [3] GREEK PSILI..GREEK DIALYTIKA AND PERISPOMENI
	{0x1FC2, 0x1FC4, prN},     // Ll     [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
	{0x1FC6, 0x1FCC, prN},     // L&     [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
	{0x1FCD, 0x1FCF, prN},     // Sk     [3] GREEK PSILI AND VARIA..GREEK PSILI AND PERISPOMENI
	{0x1FD0, 0x1FD3, prN},     // Ll     [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
	{0x1FD6, 0x1FDB, prN},     // L&     [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
	{0x1FDD, 0x1FDF, prN},     // Sk     [3] GREEK DASIA AND VARIA..GREEK DASIA AND PERISPOMENI
	{0x1FE0, 0x1FEC, prN},     // L&    [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
	{0x1FED, 0x1FEF, prN},     // Sk     [3] GREEK DIALYTIKA AND VARIA..GREEK VARIA
	{0x1FF2, 0x1FF4, prN},     // Ll     [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
	{0x1FF6, 0x1FFC, prN},     // L&     [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
	{0x1FFD, 0x1FFE, prN},     // Sk     [2] GREEK OXIA..GREEK DASIA
	{0x2000, 0x200A, prN},     // Zs    [11] EN QUAD..HAIR SPACE
	{0x200B, 0x200F, prN},     // Cf     [5] ZERO WIDTH SPACE..RIGHT-TO-LEFT MARK
	{0x2010, 0x2010, prA},     // Pd         HYPHEN
	{0x2011, 0x2012, prN},     // Pd     [2] NON-BREAKING HYPHEN..FIGURE DASH
	{0x2013, 0x2015, prA},     // Pd     [3] EN DASH..HORIZONTAL BAR
	{0x2016, 0x2016, prA},     // Po         DOUBLE VERTICAL LINE
	{0x2017, 0x2017, prN},     // Po         DOUBLE LOW LINE
	{0x2018, 0x2018, prA},     // Pi         LEFT SINGLE QUOTATION MARK
	{0x2019, 0x2019, prA},     // Pf         RIGHT SINGLE QUOTATION MARK
	{0x201A, 0x201A, prN},     // Ps         SINGLE LOW-9 QUOTATION MARK
	{0x201B, 0x201B, prN},     // Pi         SINGLE HIGH-REVERSED-9 QUOTATION MARK
	{0x201C, 0x201C, prA},     // Pi         LEFT DOUBLE QUOTATION MARK
	{0x201D, 0x201D, prA},     // Pf         RIGHT DOUBLE QUOTATION MARK
	{0x201E, 0x201E, prN},     // Ps         DOUBLE LOW-9 QUOTATION MARK
	{0x201F, 0x201F, prN},     // Pi         DOUBLE HIGH-REVERSED-9 QUOTATION MARK
	{0x2020, 0x2022, prA},     // Po     [3] DAGGER..BULLET
	{0x2023, 0x2023, prN},     // Po         TRIANGULAR BULLET
	{0x2024, 0x2027, prA},     // Po     [4] ONE DOT LEADER..HYPHENATION POINT
	{0x2028, 0x2028, prN},     // Zl         LINE SEPARATOR
	{0x2029, 0x2029, prN},     // Zp         PARAGRAPH SEPARATOR
	{0x202A, 0x202E, prN},     // Cf     [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
	{0x202F, 0x202F, prN},     // Zs         NARROW NO-BREAK SPACE
	{0x2030, 0x2030, prA},     // Po         PER MILLE SIGN
	{0x2031, 0x2031, prN},     // Po         PER TEN THOUSAND SIGN
	{0x2032, 0x2033, prA},     // Po     [2] PRIME..DOUBLE PRIME
	{0x2034, 0x2034, prN},     // Po         TRIPLE PRIME
	{0x2035, 0x2035, prA},     // Po         REVERSED PRIME
	{0x2036, 0x2038, prN},     // Po     [3] REVERSED DOUBLE PRIME..CARET
	{0x2039, 0x2039, prN},     // Pi         SINGLE LEFT-POINTING ANGLE QUOTATION MARK
	{0x203A, 0x203A, prN},     // Pf         SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
	{0x203B, 0x203B, prA},     // Po         REFERENCE MARK
	{0x203C, 0x203D, prN},     // Po     [2] DOUBLE EXCLAMATION MARK..INTERROBANG
	{0x203E, 0x203E, prA},     // Po         OVERLINE
	{0x203F, 0x2040, prN},     // Pc     [2] UNDERTIE..CHARACTER TIE
	{0x2041, 0x2043, prN},     // Po     [3] CARET INSERTION POINT..HYPHEN BULLET
	{0x2044, 0x2044, prN},     // Sm         FRACTION SLASH
	{0x2045, 0x2045, prN},     // Ps         LEFT SQUARE BRACKET WITH QUILL
	{0x2046, 0x2046, prN},     // Pe         RIGHT SQUARE BRACKET WITH QUILL
	{0x2047, 0x2051, prN},     // Po    [11] DOUBLE QUESTION MARK..TWO ASTERISKS ALIGNED VERTICALLY
	{0x2052, 0x2052, prN},     // Sm         COMMERCIAL MINUS SIGN
	{0x2053, 0x2053, prN},     // Po         SWUNG DASH
	{0x2054, 0x2054, prN},     // Pc         INVERTED UNDERTIE
	{0x2055, 0x205E, prN},     // Po    [10] FLOWER PUNCTUATION MARK..VERTICAL FOUR DOTS
	{0x205F, 0x205F, prN},     // Zs         MEDIUM MATHEMATICAL SPACE
	{0x2060, 0x2064, prN},     // Cf     [5] WORD JOINER..INVISIBLE PLUS
	{0x2066, 0x206F, prN},     // Cf    [10] LEFT-TO-RIGHT ISOLATE..NOMINAL DIGIT SHAPES
	{0x2070, 0x2070, prN},     // No         SUPERSCRIPT ZERO
	{0x2071, 0x2071, prN},     // Lm         SUPERSCRIPT LATIN SMALL LETTER I
	{0x2074, 0x2074, prA},     // No         SUPERSCRIPT FOUR
	{0x2075, 0x2079, prN},     // No     [5] SUPERSCRIPT FIVE..SUPERSCRIPT NINE
	{0x207A, 0x207C, prN},     // Sm     [3] SUPERSCRIPT PLUS SIGN..SUPERSCRIPT EQUALS SIGN
	{0x207D, 0x207D, prN},     // Ps         SUPERSCRIPT LEFT PARENTHESIS
	{0x207E, 0x207E, prN},     // Pe         SUPERSCRIPT RIGHT PARENTHESIS
	{0x207F, 0x207F, prA},     // Lm         SUPERSCRIPT LATIN SMALL LETTER N
	{0x2080, 0x2080, prN},     // No         SUBSCRIPT ZERO
	{0x2081, 0x2084, prA},     // No     [4] SUBSCRIPT ONE..SUBSCRIPT FOUR
	{0x2085, 0x2089, prN},     // No     [5] SUBSCRIPT FIVE..SUBSCRIPT NINE
	{0x208A, 0x208C, prN},     // Sm     [3] SUBSCRIPT PLUS SIGN..SUBSCRIPT EQUALS SIGN
	{0x208D, 0x208D, prN},     // Ps         SUBSCRIPT LEFT PARENTHESIS
	{0x208E, 0x208E, prN},     // Pe         SUBSCRIPT RIGHT PARENTHESIS
	{0x2090, 0x209C, prN},     // Lm    [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
	{0x20A0, 0x20A8, prN},     // Sc     [9] EURO-CURRENCY SIGN..RUPEE SIGN
	{0x20A9, 0x20A9, prH},     // Sc         WON SIGN
	{0x20AA, 0x20AB, prN},     // Sc     [2] NEW SHEQEL SIGN..DONG SIGN
	{0x20AC, 0x20AC, prA},     // Sc         EURO SIGN
	{0x20AD, 0x20C0, prN},     // Sc    [20] KIP SIGN..SOM SIGN
	{0x20D0, 0x20DC, prN},     // Mn    [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
	{0x20DD, 0x20E0, prN},     // Me     [4] COMBINING ENCLOSING CIRCLE..COMBINING ENCLOSING CIRCLE BACKSLASH
	{0x20E1, 0x20E1, prN},     // Mn         COMBINING LEFT RIGHT ARROW ABOVE
	{0x20E2, 0x20E4, prN},     // Me     [3] COMBINING ENCLOSING SCREEN..COMBINING ENCLOSING UPWARD POINTING TRIANGLE
	{0x20E5, 0x20F0, prN},     // Mn    [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
	{0x2100, 0x2101, prN},     // So     [2] ACCOUNT OF..ADDRESSED TO THE SUBJECT
	{0x2102, 0x2102, prN},     // Lu         DOUBLE-STRUCK CAPITAL C
	{0x2103, 0x2103, prA},     // So         DEGREE CELSIUS
	{0x2104, 0x2104, prN},     // So         CENTRE LINE SYMBOL
	{0x2105, 0x2105, prA},     // So         CARE OF
	{0x2106, 0x2106, prN},     // So         CADA UNA
	{0x2107, 0x2107, prN},     // Lu         EULER CONSTANT
	{0x2108, 0x2108, prN},     // So         SCRUPLE
	{0x2109, 0x2109, prA},     // So         DEGREE FAHRENHEIT
	{0x210A, 0x2112, prN},     // L&     [9] SCRIPT SMALL G..SCRIPT CAPITAL L
	{0x2113, 0x2113, prA},     // Ll         SCRIPT SMALL L
	{0x2114, 0x2114, prN},     // So         L B BAR SYMBOL
	{0x2115, 0x2115, prN},     // Lu         DOUBLE-STRUCK CAPITAL N
	{0x2116, 0x2116, prA},     // So         NUMERO SIGN
	{0x2117, 0x2117, prN},     // So         SOUND RECORDING COPYRIGHT
	{0x2118, 0x2118, prN},     // Sm         SCRIPT CAPITAL P
	{0x2119, 0x211D, prN},     // Lu     [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
	{0x211E, 0x2120, prN},     // So     [3] PRESCRIPTION TAKE..SERVICE MARK
	{0x2121, 0x2122, prA},     // So     [2] TELEPHONE SIGN..TRADE MARK SIGN
	{0x2123, 0x2123, prN},     // So         VERSICLE
	{0x2124, 0x2124, prN},     // Lu         DOUBLE-STRUCK CAPITAL Z
	{0x2125, 0x2125, prN},     // So         OUNCE SIGN
	{0x2126, 0x2126, prA},     // Lu         OHM SIGN
	{0x2127, 0x2127, prN},     // So         INVERTED OHM SIGN
	{0x2128, 0x2128, prN},     // Lu         BLACK-LETTER CAPITAL Z
	{0x2129, 0x2129, prN},     // So         TURNED GREEK SMALL LETTER IOTA
	{0x212A, 0x212A, prN},     // Lu         KELVIN SIGN
	{0x212B, 0x212B, prA},     // Lu         ANGSTROM SIGN
	{0x212C, 0x212D, prN},     // Lu     [2] SCRIPT CAPITAL B..BLACK-LETTER CAPITAL C
	{0x212E, 0x212E, prN},     // So         ESTIMATED SYMBOL
	{0x212F, 0x2134, prN},     // L&     [6] SCRIPT SMALL E..SCRIPT SMALL O
	{0x2135, 0x2138, prN},     // Lo     [4] ALEF SYMBOL..DALET SYMBOL
	{0x2139, 0x2139, prN},     // Ll         INFORMATION SOURCE
	{0x213A, 0x213B, prN},     // So     [2] ROTATED CAPITAL Q..FACSIMILE SIGN
	{0x213C, 0x213F, prN},     // L&     [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
	{0x2140, 0x2144, prN},     // Sm     [5] DOUBLE-STRUCK N-ARY SUMMATION..TURNED SANS-SERIF CAPITAL Y
	{0x2145, 0x2149, prN},     // L&     [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
	{0x214A, 0x214A, prN},     // So         PROPERTY LINE
	{0x214B, 0x214B, prN},     // Sm         TURNED AMPERSAND
	{0x214C, 0x214D, prN},     // So     [2] PER SIGN..AKTIESELSKAB
	{0x214E, 0x214E, prN},     // Ll         TURNED SMALL F
	{0x214F, 0x214F, prN},     // So         SYMBOL FOR SAMARITAN SOURCE
	{0x2150, 0x2152, prN},     // No     [3] VULGAR FRACTION ONE SEVENTH..VULGAR FRACTION ONE TENTH
	{0x2153, 0x2154, prA},     // No     [2] VULGAR FRACTION ONE THIRD..VULGAR FRACTION TWO THIRDS
	{0x2155, 0x215A, prN},     // No     [6] VULGAR FRACTION ONE FIFTH..VULGAR FRACTION FIVE SIXTHS
	{0x215B, 0x215E, prA},     // No     [4] VULGAR FRACTION ONE EIGHTH..VULGAR FRACTION SEVEN EIGHTHS
	{0x215F, 0x215F, prN},     // No         FRACTION NUMERATOR ONE
	{0x2160, 0x216B, prA},     // Nl    [12] ROMAN NUMERAL ONE..ROMAN NUMERAL TWELVE
	{0x216C, 0x216F, prN},     // Nl     [4] ROMAN NUMERAL FIFTY..ROMAN NUMERAL ONE THOUSAND
	{0x2170, 0x2179, prA},     // Nl    [10] SMALL ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL TEN
	{0x217A, 0x2182, prN},     // Nl     [9] SMALL ROMAN NUMERAL ELEVEN..ROMAN NUMERAL TEN THOUSAND
	{0x2183, 0x2184, prN},     // L&     [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
	{0x2185, 0x2188, prN},     // Nl     [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
	{0x2189, 0x2189, prA},     // No         VULGAR FRACTION ZERO THIRDS
	{0x218A, 0x218B, prN},     // So     [2] TURNED DIGIT TWO..TURNED DIGIT THREE
	{0x2190, 0x2194, prA},     // Sm     [5] LEFTWARDS ARROW..LEFT RIGHT ARROW
	{0x2195, 0x2199, prA},     // So     [5] UP DOWN ARROW..SOUTH WEST ARROW
	{0x219A, 0x219B, prN},     // Sm     [2] LEFTWARDS ARROW WITH STROKE..RIGHTWARDS ARROW WITH STROKE
	{0x219C, 0x219F, prN},     // So     [4] LEFTWARDS WAVE ARROW..UPWARDS TWO HEADED ARROW
	{0x21A0, 0x21A0, prN},     // Sm         RIGHTWARDS TWO HEADED ARROW
	{0x21A1, 0x21A2, prN},     // So     [2] DOWNWARDS TWO HEADED ARROW..LEFTWARDS ARROW WITH TAIL
	{0x21A3, 0x21A3, prN},     // Sm         RIGHTWARDS ARROW WITH TAIL
	{0x21A4, 0x21A5, prN},     // So     [2] LEFTWARDS ARROW FROM BAR..UPWARDS ARROW FROM BAR
	{0x21A6, 0x21A6, prN},     // Sm         RIGHTWARDS ARROW FROM BAR
	{0x21A7, 0x21AD, prN},     // So     [7] DOWNWARDS ARROW FROM BAR..LEFT RIGHT WAVE ARROW
	{0x21AE, 0x21AE, prN},     // Sm         LEFT RIGHT ARROW WITH STROKE
	{0x21AF, 0x21B7, prN},     // So     [9] DOWNWARDS ZIGZAG ARROW..CLOCKWISE TOP SEMICIRCLE ARROW
	{0x21B8, 0x21B9, prA},     // So     [2] NORTH WEST ARROW TO LONG BAR..LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR
	{0x21BA, 0x21CD, prN},     // So    [20] ANTICLOCKWISE OPEN CIRCLE ARROW..LEFTWARDS DOUBLE ARROW WITH STROKE
	{0x21CE, 0x21CF, prN},     // Sm     [2] LEFT RIGHT DOUBLE ARROW WITH STROKE..RIGHTWARDS DOUBLE ARROW WITH STROKE
	{0x21D0, 0x21D1, prN},     // So     [2] LEFTWARDS DOUBLE ARROW..UPWARDS DOUBLE ARROW
	{0x21D2, 0x21D2, prA},     // Sm         RIGHTWARDS DOUBLE ARROW
	{0x21D3, 0x21D3, prN},     // So         DOWNWARDS DOUBLE ARROW
	{0x21D4, 0x21D4, prA},     // Sm         LEFT RIGHT DOUBLE ARROW
	{0x21D5, 0x21E6, prN},     // So    [18] UP DOWN DOUBLE ARROW..LEFTWARDS WHITE ARROW
	{0x21E7, 0x21E7, prA},     // So         UPWARDS WHITE ARROW
	{0x21E8, 0x21F3, prN},     // So    [12] RIGHTWARDS WHITE ARROW..UP DOWN WHITE ARROW
	{0x21F4, 0x21FF, prN},     // Sm    [12] RIGHT ARROW WITH SMALL CIRCLE..LEFT RIGHT OPEN-HEADED ARROW
	{0x2200, 0x2200, prA},     // Sm         FOR ALL
	{0x2201, 0x2201, prN},     // Sm         COMPLEMENT
	{0x2202, 0x2203, prA},     // Sm     [2] PARTIAL DIFFERENTIAL..THERE EXISTS
	{0x2204, 0x2206, prN},     // Sm     [3] THERE DOES NOT EXIST..INCREMENT
	{0x2207, 0x2208, prA},     // Sm     [2] NABLA..ELEMENT OF
	{0x2209, 0x220A, prN},     // Sm     [2] NOT AN ELEMENT OF..SMALL ELEMENT OF
	{0x220B, 0x220B, prA},     // Sm         CONTAINS AS MEMBER
	{0x220C, 0x220E, prN},     // Sm     [3] DOES NOT CONTAIN AS MEMBER..END OF PROOF
	{0x220F, 0x220F, prA},     // Sm         N-ARY PRODUCT
	{0x2210, 0x2210, prN},     // Sm         N-ARY COPRODUCT
	{0x2211, 0x2211, prA},     // Sm         N-ARY SUMMATION
	{0x2212, 0x2214, prN},     // Sm     [3] MINUS SIGN..DOT PLUS
	{0x2215, 0x2215, prA},     // Sm         DIVISION SLASH
	{0x2216, 0x2219, prN},     // Sm     [4] SET MINUS..BULLET OPERATOR
	{0x221A, 0x221A, prA},     // Sm         SQUARE ROOT
	{0x221B, 0x221C, prN},     // Sm     [2] CUBE ROOT..FOURTH ROOT
	{0x221D, 0x2220, prA},     // Sm     [4] PROPORTIONAL TO..ANGLE
	{0x2221, 0x2222, prN},     // Sm     [2] MEASURED ANGLE..SPHERICAL ANGLE
	{0x2223, 0x2223, prA},     // Sm         DIVIDES
	{0x2224, 0x2224, prN},     // Sm         DOES NOT DIVIDE
	{0x2225, 0x2225, prA},     // Sm         PARALLEL TO
	{0x2226, 0x2226, prN},     // Sm         NOT PARALLEL TO
	{0x2227, 0x222C, prA},     // Sm     [6] LOGICAL AND..DOUBLE INTEGRAL
	{0x222D, 0x222D, prN},     // Sm         TRIPLE INTEGRAL
	{0x222E, 0x222E, prA},     // Sm         CONTOUR INTEGRAL
	{0x222F, 0x2233, prN},     // Sm     [5] SURFACE INTEGRAL..ANTICLOCKWISE CONTOUR INTEGRAL
	{0x2234, 0x2237, prA},     // Sm     [4] THEREFORE..PROPORTION
	{0x2238, 0x223B, prN},     // Sm     [4] DOT MINUS..HOMOTHETIC
	{0x223C, 0x223D, prA},     // Sm     [2] TILDE OPERATOR..REVERSED TILDE
	{0x223E, 0x2247, prN},     // Sm    [10] INVERTED LAZY S..NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
	{0x2248, 0x2248, prA},     // Sm         ALMOST EQUAL TO
	{0x2249, 0x224B, prN},     // Sm     [3] NOT ALMOST EQUAL TO..TRIPLE TILDE
	{0x224C, 0x224C, prA},     // Sm         ALL EQUAL TO
	{0x224D, 0x2251, prN},     // Sm     [5] EQUIVALENT TO..GEOMETRICALLY EQUAL TO
	{0x2252, 0x2252, prA},     // Sm         APPROXIMATELY EQUAL TO OR THE IMAGE OF
	{0x2253, 0x225F, prN},     // Sm    [13] IMAGE OF OR APPROXIMATELY EQUAL TO..QUESTIONED EQUAL TO
	{0x2260, 0x2261, prA},     // Sm     [2] NOT EQUAL TO..IDENTICAL TO
	{0x2262, 0x2263, prN},     // Sm     [2] NOT IDENTICAL TO..STRICTLY EQUIVALENT TO
	{0x2264, 0x2267, prA},     // Sm     [4] LESS-THAN OR EQUAL TO..GREATER-THAN OVER EQUAL TO
	{0x2268, 0x2269, prN},     // Sm     [2] LESS-THAN BUT NOT EQUAL TO..GREATER-THAN BUT NOT EQUAL TO
	{0x226A, 0x226B, prA},     // Sm     [2] MUCH LESS-THAN..MUCH GREATER-THAN
	{0x226C, 0x226D, prN},     // Sm     [2] BETWEEN..NOT EQUIVALENT TO
	{0x226E, 0x226F, prA},     // Sm     [2] NOT LESS-THAN..NOT GREATER-THAN
	{0x2270, 0x2281, prN},     // Sm    [18] NEITHER LESS-THAN NOR EQUAL TO..DOES NOT SUCCEED
	{0x2282, 0x2283, prA},     // Sm     [2] SUBSET OF..SUPERSET OF
	{0x2284, 0x2285, prN},     // Sm     [2] NOT A SUBSET OF..NOT A SUPERSET OF
	{0x2286, 0x2287, prA},     // Sm     [2] SUBSET OF OR EQUAL TO..SUPERSET OF OR EQUAL TO
	{0x2288, 0x2294, prN},     // Sm    [13] NEITHER A SUBSET OF NOR EQUAL TO..SQUARE CUP
	{0x2295, 0x2295, prA},     // Sm         CIRCLED PLUS
	{0x2296, 0x2298, prN},     // Sm     [3] CIRCLED MINUS..CIRCLED DIVISION SLASH
	{0x2299, 0x2299, prA},     // Sm         CIRCLED DOT OPERATOR
	{0x229A, 0x22A4, prN},     // Sm    [11] CIRCLED RING OPERATOR..DOWN TACK
	{0x22A5, 0x22A5, prA},     // Sm         UP TACK
	{0x22A6, 0x22BE, prN},     // Sm    [25] ASSERTION..RIGHT ANGLE WITH ARC
	{0x22BF, 0x22BF, prA},     // Sm         RIGHT TRIANGLE
	{0x22C0, 0x22FF, prN},     // Sm    [64] N-ARY LOGICAL AND..Z NOTATION BAG MEMBERSHIP
	{0x2300, 0x2307, prN},     // So     [8] DIAMETER SIGN..WAVY LINE
	{0x2308, 0x2308, prN},     // Ps         LEFT CEILING
	{0x2309, 0x2309, prN},     // Pe         RIGHT CEILING
	{0x230A, 0x230A, prN},     // Ps         LEFT FLOOR
	{0x230B, 0x230B, prN},     // Pe         RIGHT FLOOR
	{0x230C, 0x2311, prN},     // So     [6] BOTTOM RIGHT CROP..SQUARE LOZENGE
	{0x2312, 0x2312, prA},     // So         ARC
	{0x2313, 0x2319, prN},     // So     [7] SEGMENT..TURNED NOT SIGN
	{0x231A, 0x231B, prW},     // So     [2] WATCH..HOURGLASS
	{0x231C, 0x231F, prN},     // So     [4] TOP LEFT CORNER..BOTTOM RIGHT CORNER
	{0x2320, 0x2321, prN},     // Sm     [2] TOP HALF INTEGRAL..BOTTOM HALF INTEGRAL
	{0x2322, 0x2328, prN},     // So     [7] FROWN..KEYBOARD
	{0x2329, 0x2329, prW},     // Ps         LEFT-POINTING ANGLE BRACKET
	{0x232A, 0x232A, prW},     // Pe         RIGHT-POINTING ANGLE BRACKET
	{0x232B, 0x237B, prN},     // So    [81] ERASE TO THE LEFT..NOT CHECK MARK
	{0x237C, 0x237C, prN},     // Sm         RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
	{0x237D, 0x239A, prN},     // So    [30] SHOULDERED OPEN BOX..CLEAR SCREEN SYMBOL
	{0x239B, 0x23B3, prN},     // Sm    [25] LEFT PARENTHESIS UPPER HOOK..SUMMATION BOTTOM
	{0x23B4, 0x23DB, prN},     // So    [40] TOP SQUARE BRACKET..FUSE
	{0x23DC, 0x23E1, prN},     // Sm     [6] TOP PARENTHESIS..BOTTOM TORTOISE SHELL BRACKET
	{0x23E2, 0x23E8, prN},     // So     [7] WHITE TRAPEZIUM..DECIMAL EXPONENT SYMBOL
	{0x23E9, 0x23EC, prW},     // So     [4] BLACK RIGHT-POINTING DOUBLE TRIANGLE..BLACK DOWN-POINTING DOUBLE TRIANGLE
	{0x23ED, 0x23EF, prN},     // So     [3] BLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR..BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR
	{0x23F0, 0x23F0, prW},     // So         ALARM CLOCK
	{0x23F1, 0x23F2, prN},     // So     [2] STOPWATCH..TIMER CLOCK
	{0x23F3, 0x23F3, prW},     // So         HOURGLASS WITH FLOWING SAND
	{0x23F4, 0x23FF, prN},     // So    [12] BLACK MEDIUM LEFT-POINTING TRIANGLE..OBSERVER EYE SYMBOL
	{0x2400, 0x2426, prN},     // So    [39] SYMBOL FOR NULL..SYMBOL FOR SUBSTITUTE FORM TWO
	{0x2440, 0x244A, prN},     // So    [11] OCR HOOK..OCR DOUBLE BACKSLASH
	{0x2460, 0x249B, prA},     // No    [60] CIRCLED DIGIT ONE..NUMBER TWENTY FULL STOP
	{0x249C, 0x24E9, prA},     // So    [78] PARENTHESIZED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
	{0x24EA, 0x24EA, prN},     // No         CIRCLED DIGIT ZERO
	{0x24EB, 0x24FF, prA},     // No    [21] NEGATIVE CIRCLED NUMBER ELEVEN..NEGATIVE CIRCLED DIGIT ZERO
	{0x2500, 0x254B, prA},     // So    [76] BOX DRAWINGS LIGHT HORIZONTAL..BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
	{0x254C, 0x254F, prN},     // So     [4] BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL..BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL
	{0x2550, 0x2573, prA},     // So    [36] BOX DRAWINGS DOUBLE HORIZONTAL..BOX DRAWINGS LIGHT DIAGONAL CROSS
	{0x2574, 0x257F, prN},     // So    [12] BOX DRAWINGS LIGHT LEFT..BOX DRAWINGS HEAVY UP AND LIGHT DOWN
	{0x2580, 0x258F, prA},     // So    [16] UPPER HALF BLOCK..LEFT ONE EIGHTH BLOCK
	{0x2590, 0x2591, prN},     // So     [2] RIGHT HALF BLOCK..LIGHT SHADE
	{0x2592, 0x2595, prA},     // So     [4] MEDIUM SHADE..RIGHT ONE EIGHTH BLOCK
	{0x2596, 0x259F, prN},     // So    [10] QUADRANT LOWER LEFT..QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT
	{0x25A0, 0x25A1, prA},     // So     [2] BLACK SQUARE..WHITE SQUARE
	{0x25A2, 0x25A2, prN},     // So         WHITE SQUARE WITH ROUNDED CORNERS
	{0x25A3, 0x25A9, prA},     // So     [7] WHITE SQUARE CONTAINING BLACK SMALL SQUARE..SQUARE WITH DIAGONAL CROSSHATCH FILL
	{0x25AA, 0x25B1, prN},     // So     [8] BLACK SMALL SQUARE..WHITE PARALLELOGRAM
	{0x25B2, 0x25B3, prA},     // So     [2] BLACK UP-POINTING TRIANGLE..WHITE UP-POINTING TRIANGLE
	{0x25B4, 0x25B5, prN},     // So     [2] BLACK UP-POINTING SMALL TRIANGLE..WHITE UP-POINTING SMALL TRIANGLE
	{0x25B6, 0x25B6, prA},     // So         BLACK RIGHT-POINTING TRIANGLE
	{0x25B7, 0x25B7, prA},     // Sm         WHITE RIGHT-POINTING TRIANGLE
	{0x25B8, 0x25BB, prN},     // So     [4] BLACK RIGHT-POINTING SMALL TRIANGLE..WHITE RIGHT-POINTING POINTER
	{0x25BC, 0x25BD, prA},     // So     [2] BLACK DOWN-POINTING TRIANGLE..WHITE DOWN-POINTING TRIANGLE
	{0x25BE, 0x25BF, prN},     // So     [2] BLACK DOWN-POINTING SMALL TRIANGLE..WHITE DOWN-POINTING SMALL TRIANGLE
	{0x25C0, 0x25C0, prA},     // So         BLACK LEFT-POINTING TRIANGLE
	{0x25C1, 0x25C1, prA},     // Sm         WHITE LEFT-POINTING TRIANGLE
	{0x25C2, 0x25C5, prN},     // So     [4] BLACK LEFT-POINTING SMALL TRIANGLE..WHITE LEFT-POINTING POINTER
	{0x25C6, 0x25C8, prA},     // So     [3] BLACK DIAMOND..WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
	{0x25C9, 0x25CA, prN},     // So     [2] FISHEYE..LOZENGE
	{0x25CB, 0x25CB, prA},     // So         WHITE CIRCLE
	{0x25CC, 0x25CD, prN},     // So     [2] DOTTED CIRCLE..CIRCLE WITH VERTICAL FILL
	{0x25CE, 0x25D1, prA},     // So     [4] BULLSEYE..CIRCLE WITH RIGHT HALF BLACK
	{0x25D2, 0x25E1, prN},     // So    [16] CIRCLE WITH LOWER HALF BLACK..LOWER HALF CIRCLE
	{0x25E2, 0x25E5, prA},     // So     [4] BLACK LOWER RIGHT TRIANGLE..BLACK UPPER RIGHT TRIANGLE
	{0x25E6, 0x25EE, prN},     // So     [9] WHITE BULLET..UP-POINTING TRIANGLE WITH RIGHT HALF BLACK
	{0x25EF, 0x25EF, prA},     // So         LARGE CIRCLE
	{0x25F0, 0x25F7, prN},     // So     [8] WHITE SQUARE WITH UPPER LEFT QUADRANT..WHITE CIRCLE WITH UPPER RIGHT QUADRANT
	{0x25F8, 0x25FC, prN},     // Sm     [5] UPPER LEFT TRIANGLE..BLACK MEDIUM SQUARE
	{0x25FD, 0x25FE, prW},     // Sm     [2] WHITE MEDIUM SMALL SQUARE..BLACK MEDIUM SMALL SQUARE
	{0x25FF, 0x25FF, prN},     // Sm         LOWER RIGHT TRIANGLE
	{0x2600, 0x2604, prN},     // So     [5] BLACK SUN WITH RAYS..COMET
	{0x2605, 0x2606, prA},     // So     [2] BLACK STAR..WHITE STAR
	{0x2607, 0x2608, prN},     // So     [2] LIGHTNING..THUNDERSTORM
	{0x2609, 0x2609, prA},     // So         SUN
	{0x260A, 0x260D, prN},     // So     [4] ASCENDING NODE..OPPOSITION
	{0x260E, 0x260F, prA},     // So     [2] BLACK TELEPHONE..WHITE TELEPHONE
	{0x2610, 0x2613, prN},     // So     [4] BALLOT BOX..SALTIRE
	{0x2614, 0x2615, prW},     // So     [2] UMBRELLA WITH RAIN DROPS..HOT BEVERAGE
	{0x2616, 0x261B, prN},     // So     [6] WHITE SHOGI PIECE..BLACK RIGHT POINTING INDEX
	{0x261C, 0x261C, prA},     // So         WHITE LEFT POINTING INDEX
	{0x261D, 0x261D, prN},     // So         WHITE UP POINTING INDEX
	{0x261E, 0x261E, prA},     // So         WHITE RIGHT POINTING INDEX
	{0x261F, 0x263F, prN},     // So    [33] WHITE DOWN POINTING INDEX..MERCURY
	{0x2640, 0x2640, prA},     // So         FEMALE SIGN
	{0x2641, 0x2641, prN},     // So         EARTH
	{0x2642, 0x2642, prA},     // So         MALE SIGN
	{0x2643, 0x2647, prN},     // So     [5] JUPITER..PLUTO
	{0x2648, 0x2653, prW},     // So    [12] ARIES..PISCES
	{0x2654, 0x265F, prN},     // So    [12] WHITE CHESS KING..BLACK CHESS PAWN
	{0x2660, 0x2661, prA},     // So     [2] BLACK SPADE SUIT..WHITE HEART SUIT
	{0x2662, 0x2662, prN},     // So         WHITE DIAMOND SUIT
	{0x2663, 0x2665, prA},     // So     [3] BLACK CLUB SUIT..BLACK HEART SUIT
	{0x2666, 0x2666, prN},     // So         BLACK DIAMOND SUIT
	{0x2667, 0x266A, prA},     // So     [4] WHITE CLUB SUIT..EIGHTH NOTE
	{0x266B, 0x266B, prN},     // So         BEAMED EIGHTH NOTES
	{0x266C, 0x266D, prA},     // So     [2] BEAMED SIXTEENTH NOTES..MUSIC FLAT SIGN
	{0x266E, 0x266E, prN},     // So         MUSIC NATURAL SIGN
	{0x266F, 0x266F, prA},     // Sm         MUSIC SHARP SIGN
	{0x2670, 0x267E, prN},     // So    [15] WEST SYRIAC CROSS..PERMANENT PAPER SIGN
	{0x267F, 0x267F, prW},     // So         WHEELCHAIR SYMBOL
	{0x2680, 0x2692, prN},     // So    [19] DIE FACE-1..HAMMER AND PICK
	{0x2693, 0x2693, prW},     // So         ANCHOR
	{0x2694, 0x269D, prN},     // So    [10] CROSSED SWORDS..OUTLINED WHITE STAR
	{0x269E, 0x269F, prA},     // So     [2] THREE LINES CONVERGING RIGHT..THREE LINES CONVERGING LEFT
	{0x26A0, 0x26A0, prN},     // So         WARNING SIGN
	{0x26A1, 0x26A1, prW},     // So         HIGH VOLTAGE SIGN
	{0x26A2, 0x26A9, prN},     // So     [8] DOUBLED FEMALE SIGN..HORIZONTAL MALE WITH STROKE SIGN
	{0x26AA, 0x26AB, prW},     // So     [2] MEDIUM WHITE CIRCLE..MEDIUM BLACK CIRCLE
	{0x26AC, 0x26BC, prN},     // So    [17] MEDIUM SMALL WHITE CIRCLE..SESQUIQUADRATE
	{0x26BD, 0x26BE, prW},     // So     [2] SOCCER BALL..BASEBALL
	{0x26BF, 0x26BF, prA},     // So         SQUARED KEY
	{0x26C0, 0x26C3, prN},     // So     [4] WHITE DRAUGHTS MAN..BLACK DRAUGHTS KING
	{0x26C4, 0x26C5, prW},     // So     [2] SNOWMAN WITHOUT SNOW..SUN BEHIND CLOUD
	{0x26C6, 0x26CD, prA},     // So     [8] RAIN..DISABLED CAR
	{0x26CE, 0x26CE, prW},     // So         OPHIUCHUS
	{0x26CF, 0x26D3, prA},     // So     [5] PICK..CHAINS
	{0x26D4, 0x26D4, prW},     // So         NO ENTRY
	{0x26D5, 0x26E1, prA},     // So    [13] ALTERNATE ONE-WAY LEFT WAY TRAFFIC..RESTRICTED LEFT ENTRY-2
	{0x26E2, 0x26E2, prN},     // So         ASTRONOMICAL SYMBOL FOR URANUS
	{0x26E3, 0x26E3, prA},     // So         HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE
	{0x26E4, 0x26E7, prN},     // So     [4] PENTAGRAM..INVERTED PENTAGRAM
	{0x26E8, 0x26E9, prA},     // So     [2] BLACK CROSS ON SHIELD..SHINTO SHRINE
	{0x26EA, 0x26EA, prW},     // So         CHURCH
	{0x26EB, 0x26F1, prA},     // So     [7] CASTLE..UMBRELLA ON GROUND
	{0x26F2, 0x26F3, prW},     // So     [2] FOUNTAIN..FLAG IN HOLE
	{0x26F4, 0x26F4, prA},     // So         FERRY
	{0x26F5, 0x26F5, prW},     // So         SAILBOAT
	{0x26F6, 0x26F9, prA},     // So     [4] SQUARE FOUR CORNERS..PERSON WITH BALL
	{0x26FA, 0x26FA, prW},     // So         TENT
	{0x26FB, 0x26FC, prA},     // So     [2] JAPANESE BANK SYMBOL..HEADSTONE GRAVEYARD SYMBOL
	{0x26FD, 0x26FD, prW},     // So         FUEL PUMP
	{0x26FE, 0x26FF, prA},     // So     [2] CUP ON BLACK SQUARE..WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE
	{0x2700, 0x2704, prN},     // So     [5] BLACK SAFETY SCISSORS..WHITE SCISSORS
	{0x2705, 0x2705, prW},     // So         WHITE HEAVY CHECK MARK
	{0x2706, 0x2709, prN},     // So     [4] TELEPHONE LOCATION SIGN..ENVELOPE
	{0x270A, 0x270B, prW},     // So     [2] RAISED FIST..RAISED HAND
	{0x270C, 0x2727, prN},     // So    [28] VICTORY HAND..WHITE FOUR POINTED STAR
	{0x2728, 0x2728, prW},     // So         SPARKLES
	{0x2729, 0x273C, prN},     // So    [20] STRESS OUTLINED WHITE STAR..OPEN CENTRE TEARDROP-SPOKED ASTERISK
	{0x273D, 0x273D, prA},     // So         HEAVY TEARDROP-SPOKED ASTERISK
	{0x273E, 0x274B, prN},     // So    [14] SIX PETALLED BLACK AND WHITE FLORETTE..HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
	{0x274C, 0x274C, prW},     // So         CROSS MARK
	{0x274D, 0x274D, prN},     // So         SHADOWED WHITE CIRCLE
	{0x274E, 0x274E, prW},     // So         NEGATIVE SQUARED CROSS MARK
	{0x274F, 0x2752, prN},     // So     [4] LOWER RIGHT DROP-SHADOWED WHITE SQUARE..UPPER RIGHT SHADOWED WHITE SQUARE
	{0x2753, 0x2755, prW},     // So     [3] BLACK QUESTION MARK ORNAMENT..WHITE EXCLAMATION MARK ORNAMENT
	{0x2756, 0x2756, prN},     // So         BLACK DIAMOND MINUS WHITE X
	{0x2757, 0x2757, prW},     // So         HEAVY EXCLAMATION MARK SYMBOL
	{0x2758, 0x2767, prN},     // So    [16] LIGHT VERTICAL BAR..ROTATED FLORAL HEART BULLET
	{0x2768, 0x2768, prN},     // Ps         MEDIUM LEFT PARENTHESIS ORNAMENT
	{0x2769, 0x2769, prN},     // Pe         MEDIUM RIGHT PARENTHESIS ORNAMENT
	{0x276A, 0x276A, prN},     // Ps         MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
	{0x276B, 0x276B, prN},     // Pe         MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
	{0x276C, 0x276C, prN},     // Ps         MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
	{0x276D, 0x276D, prN},     // Pe         MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
	{0x276E, 0x276E, prN},     // Ps         HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
	{0x276F, 0x276F, prN},     // Pe         HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
	{0x2770, 0x2770, prN},     // Ps         HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
	{0x2771, 0x2771, prN},     // Pe         HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
	{0x2772, 0x2772, prN},     // Ps         LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
	{0x2773, 0x2773, prN},     // Pe         LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
	{0x2774, 0x2774, prN},     // Ps         MEDIUM LEFT CURLY BRACKET ORNAMENT
	{0x2775, 0x2775, prN},     // Pe         MEDIUM RIGHT CURLY BRACKET ORNAMENT
	{0x2776, 0x277F, prA},     // No    [10] DINGBAT NEGATIVE CIRCLED DIGIT ONE..DINGBAT NEGATIVE CIRCLED NUMBER TEN
	{0x2780, 0x2793, prN},     // No    [20] DINGBAT CIRCLED SANS-SERIF DIGIT ONE..DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
	{0x2794, 0x2794, prN},     // So         HEAVY WIDE-HEADED RIGHTWARDS ARROW
	{0x2795, 0x2797, prW},     // So     [3] HEAVY PLUS SIGN..HEAVY DIVISION SIGN
	{0x2798, 0x27AF, prN},     // So    [24] HEAVY SOUTH EAST ARROW..NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
	{0x27B0, 0x27B0, prW},     // So         CURLY LOOP
	{0x27B1, 0x27BE, prN},     // So    [14] NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW..OPEN-OUTLINED RIGHTWARDS ARROW
	{0x27BF, 0x27BF, prW},     // So         DOUBLE CURLY LOOP
	{0x27C0, 0x27C4, prN},     // Sm     [5] THREE DIMENSIONAL ANGLE..OPEN SUPERSET
	{0x27C5, 0x27C5, prN},     // Ps         LEFT S-SHAPED BAG DELIMITER
	{0x27C6, 0x27C6, prN},     // Pe         RIGHT S-SHAPED BAG DELIMITER
	{0x27C7, 0x27E5, prN},     // Sm    [31] OR WITH DOT INSIDE..WHITE SQUARE WITH RIGHTWARDS TICK
	{0x27E6, 0x27E6, prNa},    // Ps         MATHEMATICAL LEFT WHITE SQUARE BRACKET
	{0x27E7, 0x27E7, prNa},    // Pe         MATHEMATICAL RIGHT WHITE SQUARE BRACKET
	{0x27E8, 0x27E8, prNa},    // Ps         MATHEMATICAL LEFT ANGLE BRACKET
	{0x27E9, 0x27E9, prNa},    // Pe         MATHEMATICAL RIGHT ANGLE BRACKET
	{0x27EA, 0x27EA, prNa},    // Ps         MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
	{0x27EB, 0x27EB, prNa},    // Pe         MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
	{0x27EC, 0x27EC, prNa},    // Ps         MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
	{0x27ED, 0x27ED, prNa},    // Pe         MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
	{0x27EE, 0x27EE, prN},     // Ps         MATHEMATICAL LEFT FLATTENED PARENTHESIS
	{0x27EF, 0x27EF, prN},     // Pe         MATHEMATICAL RIGHT FLATTENED PARENTHESIS
	{0x27F0, 0x27FF, prN},     // Sm    [16] UPWARDS QUADRUPLE ARROW..LONG RIGHTWARDS SQUIGGLE ARROW
	{0x2800, 0x28FF, prN},     // So   [256] BRAILLE PATTERN BLANK..BRAILLE PATTERN DOTS-12345678
	{0x2900, 0x297F, prN},     // Sm   [128] RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE..DOWN FISH TAIL
	{0x2980, 0x2982, prN},     // Sm     [3] TRIPLE VERTICAL BAR DELIMITER..Z NOTATION TYPE COLON
	{0x2983, 0x2983, prN},     // Ps         LEFT WHITE CURLY BRACKET
	{0x2984, 0x2984, prN},     // Pe         RIGHT WHITE CURLY BRACKET
	{0x2985, 0x2985, prNa},    // Ps         LEFT WHITE PARENTHESIS
	{0x2986, 0x2986, prNa},    // Pe         RIGHT WHITE PARENTHESIS
	{0x2987, 0x2987, prN},     // Ps         Z NOTATION LEFT IMAGE BRACKET
	{0x2988, 0x2988, prN},     // Pe         Z NOTATION RIGHT IMAGE BRACKET
	{0x2989, 0x2989, prN},     // Ps         Z NOTATION LEFT BINDING BRACKET
	{0x298A, 0x298A, prN},     // Pe         Z NOTATION RIGHT BINDING BRACKET
	{0x298B, 0x298B, prN},     // Ps         LEFT SQUARE BRACKET WITH UNDERBAR
	{0x298C, 0x298C, prN},     // Pe         RIGHT SQUARE BRACKET WITH UNDERBAR
	{0x298D, 0x298D, prN},     // Ps         LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
	{0x298E, 0x298E, prN},     // Pe         RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
	{0x298F, 0x298F, prN},     // Ps         LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
	{0x2990, 0x2990, prN},     // Pe         RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
	{0x2991, 0x2991, prN},     // Ps         LEFT ANGLE BRACKET WITH DOT
	{0x2992, 0x2992, prN},     // Pe         RIGHT ANGLE BRACKET WITH DOT
	{0x2993, 0x2993, prN},     // Ps         LEFT ARC LESS-THAN BRACKET
	{0x2994, 0x2994, prN},     // Pe         RIGHT ARC GREATER-THAN BRACKET
	{0x2995, 0x2995, prN},     // Ps         DOUBLE LEFT ARC GREATER-THAN BRACKET
	{0x2996, 0x2996, prN},     // Pe         DOUBLE RIGHT ARC LESS-THAN BRACKET
	{0x2997, 0x2997, prN},     // Ps         LEFT BLACK TORTOISE SHELL BRACKET
	{0x2998, 0x2998, prN},     // Pe         RIGHT BLACK TORTOISE SHELL BRACKET
	{0x2999, 0x29D7, prN},     // Sm    [63] DOTTED FENCE..BLACK HOURGLASS
	{0x29D8, 0x29D8, prN},     // Ps         LEFT WIGGLY FENCE
	{0x29D9, 0x29D9, prN},     // Pe         RIGHT WIGGLY FENCE
	{0x29DA, 0x29DA, prN},     // Ps         LEFT DOUBLE WIGGLY FENCE
	{0x29DB, 0x29DB, prN},     // Pe         RIGHT DOUBLE WIGGLY FENCE
	{0x29DC, 0x29FB, prN},     // Sm    [32] INCOMPLETE INFINITY..TRIPLE PLUS
	{0x29FC, 0x29FC, prN},     // Ps         LEFT-POINTING CURVED ANGLE BRACKET
	{0x29FD, 0x29FD, prN},     // Pe         RIGHT-POINTING CURVED ANGLE BRACKET
	{0x29FE, 0x29FF, prN},     // Sm     [2] TINY..MINY
	{0x2A00, 0x2AFF, prN},     // Sm   [256] N-ARY CIRCLED DOT OPERATOR..N-ARY WHITE VERTICAL BAR
	{0x2B00, 0x2B1A, prN},     // So    [27] NORTH EAST WHITE ARROW..DOTTED SQUARE
	{0x2B1B, 0x2B1C, prW},     // So     [2] BLACK LARGE SQUARE..WHITE LARGE SQUARE
	{0x2B1D, 0x2B2F, prN},     // So    [19] BLACK VERY SMALL SQUARE..WHITE VERTICAL ELLIPSE
	{0x2B30, 0x2B44, prN},     // Sm    [21] LEFT ARROW WITH SMALL CIRCLE..RIGHTWARDS ARROW THROUGH SUPERSET
	{0x2B45, 0x2B46, prN},     // So     [2] LEFTWARDS QUADRUPLE ARROW..RIGHTWARDS QUADRUPLE ARROW
	{0x2B47, 0x2B4C, prN},     // Sm     [6] REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW..RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
	{0x2B4D, 0x2B4F, prN},     // So     [3] DOWNWARDS TRIANGLE-HEADED ZIGZAG ARROW..SHORT BACKSLANTED SOUTH ARROW
	{0x2B50, 0x2B50, prW},     // So         WHITE MEDIUM STAR
	{0x2B51, 0x2B54, prN},     // So     [4] BLACK SMALL STAR..WHITE RIGHT-POINTING PENTAGON
	{0x2B55, 0x2B55, prW},     // So         HEAVY LARGE CIRCLE
	{0x2B56, 0x2B59, prA},     // So     [4] HEAVY OVAL WITH OVAL INSIDE..HEAVY CIRCLED SALTIRE
	{0x2B5A, 0x2B73, prN},     // So    [26] SLANTED NORTH ARROW WITH HOOKED HEAD..DOWNWARDS TRIANGLE-HEADED ARROW TO BAR
	{0x2B76, 0x2B95, prN},     // So    [32] NORTH WEST TRIANGLE-HEADED ARROW TO BAR..RIGHTWARDS BLACK ARROW
	{0x2B97, 0x2BFF, prN},     // So   [105] SYMBOL FOR TYPE A ELECTRONICS..HELLSCHREIBER PAUSE SYMBOL
	{0x2C00, 0x2C5F, prN},     // L&    [96] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC SMALL LETTER CAUDATE CHRIVI
	{0x2C60, 0x2C7B, prN},     // L&    [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
	{0x2C7C, 0x2C7D, prN},     // Lm     [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
	{0x2C7E, 0x2C7F, prN},     // Lu     [2] LATIN CAPITAL LETTER S WITH SWASH TAIL..LATIN CAPITAL LETTER Z WITH SWASH TAIL
	{0x2C80, 0x2CE4, prN},     // L&   [101] COPTIC CAPITAL LETTER ALFA..COPTIC SYMBOL KAI
	{0x2CE5, 0x2CEA, prN},     // So     [6] COPTIC SYMBOL MI RO..COPTIC SYMBOL SHIMA SIMA
	{0x2CEB, 0x2CEE, prN},     // L&     [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
	{0x2CEF, 0x2CF1, prN},     // Mn     [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
	{0x2CF2, 0x2CF3, prN},     // L&     [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
	{0x2CF9, 0x2CFC, prN},     // Po     [4] COPTIC OLD NUBIAN FULL STOP..COPTIC OLD NUBIAN VERSE DIVIDER
	{0x2CFD, 0x2CFD, prN},     // No         COPTIC FRACTION ONE HALF
	{0x2CFE, 0x2CFF, prN},     // Po     [2] COPTIC FULL STOP..COPTIC MORPHOLOGICAL DIVIDER
	{0x2D00, 0x2D25, prN},     // Ll    [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
	{0x2D27, 0x2D27, prN},     // Ll         GEORGIAN SMALL LETTER YN
	{0x2D2D, 0x2D2D, prN},     // Ll         GEORGIAN SMALL LETTER AEN
	{0x2D30, 0x2D67, prN},     // Lo    [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
	{0x2D6F, 0x2D6F, prN},     // Lm         TIFINAGH MODIFIER LETTER LABIALIZATION MARK
	{0x2D70, 0x2D70, prN},     // Po         TIFINAGH SEPARATOR MARK
	{0x2D7F, 0x2D7F, prN},     // Mn         TIFINAGH CONSONANT JOINER
	{0x2D80, 0x2D96, prN},     // Lo    [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
	{0x2DA0, 0x2DA6, prN},     // Lo     [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
	{0x2DA8, 0x2DAE, prN},     // Lo     [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
	{0x2DB0, 0x2DB6, prN},     // Lo     [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
	{0x2DB8, 0x2DBE, prN},     // Lo     [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
	{0x2DC0, 0x2DC6, prN},     // Lo     [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
	{0x2DC8, 0x2DCE, prN},     // Lo     [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
	{0x2DD0, 0x2DD6, prN},     // Lo     [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
	{0x2DD8, 0x2DDE, prN},     // Lo     [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
	{0x2DE0, 0x2DFF, prN},     // Mn    [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
	{0x2E00, 0x2E01, prN},     // Po     [2] RIGHT ANGLE SUBSTITUTION MARKER..RIGHT ANGLE DOTTED SUBSTITUTION MARKER
	{0x2E02, 0x2E02, prN},     // Pi         LEFT SUBSTITUTION BRACKET
	{0x2E03, 0x2E03, prN},     // Pf         RIGHT SUBSTITUTION BRACKET
	{0x2E04, 0x2E04, prN},     // Pi         LEFT DOTTED SUBSTITUTION BRACKET
	{0x2E05, 0x2E05, prN},     // Pf         RIGHT DOTTED SUBSTITUTION BRACKET
	{0x2E06, 0x2E08, prN},     // Po     [3] RAISED INTERPOLATION MARKER..DOTTED TRANSPOSITION MARKER
	{0x2E09, 0x2E09, prN},     // Pi         LEFT TRANSPOSITION BRACKET
	{0x2E0A, 0x2E0A, prN},     // Pf         RIGHT TRANSPOSITION BRACKET
	{0x2E0B, 0x2E0B, prN},     // Po         RAISED SQUARE
	{0x2E0C, 0x2E0C, prN},     // Pi         LEFT RAISED OMISSION BRACKET
	{0x2E0D, 0x2E0D, prN},     // Pf         RIGHT RAISED OMISSION BRACKET
	{0x2E0E, 0x2E16, prN},     // Po     [9] EDITORIAL CORONIS..DOTTED RIGHT-POINTING ANGLE
	{0x2E17, 0x2E17, prN},     // Pd         DOUBLE OBLIQUE HYPHEN
	{0x2E18, 0x2E19, prN},     // Po     [2] INVERTED INTERROBANG..PALM BRANCH
	{0x2E1A, 0x2E1A, prN},     // Pd         HYPHEN WITH DIAERESIS
	{0x2E1B, 0x2E1B, prN},     // Po         TILDE WITH RING ABOVE
	{0x2E1C, 0x2E1C, prN},     // Pi         LEFT LOW PARAPHRASE BRACKET
	{0x2E1D, 0x2E1D, prN},     // Pf         RIGHT LOW PARAPHRASE BRACKET
	{0x2E1E, 0x2E1F, prN},     // Po     [2] TILDE WITH DOT ABOVE..TILDE WITH DOT BELOW
	{0x2E20, 0x2E20, prN},     // Pi         LEFT VERTICAL BAR WITH QUILL
	{0x2E21, 0x2E21, prN},     // Pf         RIGHT VERTICAL BAR WITH QUILL
	{0x2E22, 0x2E22, prN},     // Ps         TOP LEFT HALF BRACKET
	{0x2E23, 0x2E23, prN},     // Pe         TOP RIGHT HALF BRACKET
	{0x2E24, 0x2E24, prN},     // Ps         BOTTOM LEFT HALF BRACKET
	{0x2E25, 0x2E25, prN},     // Pe         BOTTOM RIGHT HALF BRACKET
	{0x2E26, 0x2E26, prN},     // Ps         LEFT SIDEWAYS U BRACKET
	{0x2E27, 0x2E27, prN},     // Pe         RIGHT SIDEWAYS U BRACKET
	{0x2E28, 0x2E28, prN},     // Ps         LEFT DOUBLE PARENTHESIS
	{0x2E29, 0x2E29, prN},     // Pe         RIGHT DOUBLE PARENTHESIS
	{0x2E2A, 0x2E2E, prN},     // Po     [5] TWO DOTS OVER ONE DOT PUNCTUATION..REVERSED QUESTION MARK
	{0x2E2F, 0x2E2F, prN},     // Lm         VERTICAL TILDE
	{0x2E30, 0x2E39, prN},     // Po    [10] RING POINT..TOP HALF SECTION SIGN
	{0x2E3A, 0x2E3B, prN},     // Pd     [2] TWO-EM DASH..THREE-EM DASH
	{0x2E3C, 0x2E3F, prN},     // Po     [4] STENOGRAPHIC FULL STOP..CAPITULUM
	{0x2E40, 0x2E40, prN},     // Pd         DOUBLE HYPHEN
	{0x2E41, 0x2E41, prN},     // Po         REVERSED COMMA
	{0x2E42, 0x2E42, prN},     // Ps         DOUBLE LOW-REVERSED-9 QUOTATION MARK
	{0x2E43, 0x2E4F, prN},     // Po    [13] DASH WITH LEFT UPTURN..CORNISH VERSE DIVIDER
	{0x2E50, 0x2E51, prN},     // So     [2] CROSS PATTY WITH RIGHT CROSSBAR..CROSS PATTY WITH LEFT CROSSBAR
	{0x2E52, 0x2E54, prN},     // Po     [3] TIRONIAN SIGN CAPITAL ET..MEDIEVAL QUESTION MARK
	{0x2E55, 0x2E55, prN},     // Ps         LEFT SQUARE BRACKET WITH STROKE
	{0x2E56, 0x2E56, prN},     // Pe         RIGHT SQUARE BRACKET WITH STROKE
	{0x2E57, 0x2E57, prN},     // Ps         LEFT SQUARE BRACKET WITH DOUBLE STROKE
	{0x2E58, 0x2E58, prN},     // Pe         RIGHT SQUARE BRACKET WITH DOUBLE STROKE
	{0x2E59, 0x2E59, prN},     // Ps         TOP HALF LEFT PARENTHESIS
	{0x2E5A, 0x2E5A, prN},     // Pe         TOP HALF RIGHT PARENTHESIS
	{0x2E5B, 0x2E5B, prN},     // Ps         BOTTOM HALF LEFT PARENTHESIS
	{0x2E5C, 0x2E5C, prN},     // Pe         BOTTOM HALF RIGHT PARENTHESIS
	{0x2E5D, 0x2E5D, prN},     // Pd         OBLIQUE HYPHEN
	{0x2E80, 0x2E99, prW},     // So    [26] CJK RADICAL REPEAT..CJK RADICAL RAP
	{0x2E9B, 0x2EF3, prW},     // So    [89] CJK RADICAL CHOKE..CJK RADICAL C-SIMPLIFIED TURTLE
	{0x2F00, 0x2FD5, prW},     // So   [214] KANGXI RADICAL ONE..KANGXI RADICAL FLUTE
	{0x2FF0, 0x2FFB, prW},     // So    [12] IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT..IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID
	{0x3000, 0x3000, prF},     // Zs         IDEOGRAPHIC SPACE
	{0x3001, 0x3003, prW},     // Po     [3] IDEOGRAPHIC COMMA..DITTO MARK
	{0x3004, 0x3004, prW},     // So         JAPANESE INDUSTRIAL STANDARD SYMBOL
	{0x3005, 0x3005, prW},     // Lm         IDEOGRAPHIC ITERATION MARK
	{0x3006, 0x3006, prW},     // Lo         IDEOGRAPHIC CLOSING MARK
	{0x3007, 0x3007, prW},     // Nl         IDEOGRAPHIC NUMBER ZERO
	{0x3008, 0x3008, prW},     // Ps         LEFT ANGLE BRACKET
	{0x3009, 0x3009, prW},     // Pe         RIGHT ANGLE BRACKET
	{0x300A, 0x300A, prW},     // Ps         LEFT DOUBLE ANGLE BRACKET
	{0x300B, 0x300B, prW},     // Pe         RIGHT DOUBLE ANGLE BRACKET
	{0x300C, 0x300C, prW},     // Ps         LEFT CORNER BRACKET
	{0x300D, 0x300D, prW},     // Pe         RIGHT CORNER BRACKET
	{0x300E, 0x300E, prW},     // Ps         LEFT WHITE CORNER BRACKET
	{0x300F, 0x300F, prW},     // Pe         RIGHT WHITE CORNER BRACKET
	{0x3010, 0x3010, prW},     // Ps         LEFT BLACK LENTICULAR BRACKET
	{0x3011, 0x3011, prW},     // Pe         RIGHT BLACK LENTICULAR BRACKET
	{0x3012, 0x3013, prW},     // So     [2] POSTAL MARK..GETA MARK
	{0x3014, 0x3014, prW},     // Ps         LEFT TORTOISE SHELL BRACKET
	{0x3015, 0x3015, prW},     // Pe         RIGHT TORTOISE SHELL BRACKET
	{0x3016, 0x3016, prW},     // Ps         LEFT WHITE LENTICULAR BRACKET
	{0x3017, 0x3017, prW},     // Pe         RIGHT WHITE LENTICULAR BRACKET
	{0x3018, 0x3018, prW},     // Ps         LEFT WHITE TORTOISE SHELL BRACKET
	{0x3019, 0x3019, prW},     // Pe         RIGHT WHITE TORTOISE SHELL BRACKET
	{0x301A, 0x301A, prW},     // Ps         LEFT WHITE SQUARE BRACKET
	{0x301B, 0x301B, prW},     // Pe         RIGHT WHITE SQUARE BRACKET
	{0x301C, 0x301C, prW},     // Pd         WAVE DASH
	{0x301D, 0x301D, prW},     // Ps         REVERSED DOUBLE PRIME QUOTATION MARK
	{0x301E, 0x301F, prW},     // Pe     [2] DOUBLE PRIME QUOTATION MARK..LOW DOUBLE PRIME QUOTATION MARK
	{0x3020, 0x3020, prW},     // So         POSTAL MARK FACE
	{0x3021, 0x3029, prW},     // Nl     [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
	{0x302A, 0x302D, prW},     // Mn     [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
	{0x302E, 0x302F, prW},     // Mc     [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
	{0x3030, 0x3030, prW},     // Pd         WAVY DASH
	{0x3031, 0x3035, prW},     // Lm     [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
	{0x3036, 0x3037, prW},     // So     [2] CIRCLED POSTAL MARK..IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL
	{0x3038, 0x303A, prW},     // Nl     [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
	{0x303B, 0x303B, prW},     // Lm         VERTICAL IDEOGRAPHIC ITERATION MARK
	{0x303C, 0x303C, prW},     // Lo         MASU MARK
	{0x303D, 0x303D, prW},     // Po         PART ALTERNATION MARK
	{0x303E, 0x303E, prW},     // So         IDEOGRAPHIC VARIATION INDICATOR
	{0x303F, 0x303F, prN},     // So         IDEOGRAPHIC HALF FILL SPACE
	{0x3041, 0x3096, prW},     // Lo    [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
	{0x3099, 0x309A, prW},     // Mn     [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{0x309B, 0x309C, prW},     // Sk     [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{0x309D, 0x309E, prW},     // Lm     [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
	{0x309F, 0x309F, prW},     // Lo         HIRAGANA DIGRAPH YORI
	{0x30A0, 0x30A0, prW},     // Pd         KATAKANA-HIRAGANA DOUBLE HYPHEN
	{0x30A1, 0x30FA, prW},     // Lo    [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
	{0x30FB, 0x30FB, prW},     // Po         KATAKANA MIDDLE DOT
	{0x30FC, 0x30FE, prW},     // Lm     [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
	{0x30FF, 0x30FF, prW},     // Lo         KATAKANA DIGRAPH KOTO
	{0x3105, 0x312F, prW},     // Lo    [43] BOPOMOFO LETTER B..BOPOMOFO LETTER NN
	{0x3131, 0x318E, prW},     // Lo    [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
	{0x3190, 0x3191, prW},     // So     [2] IDEOGRAPHIC ANNOTATION LINKING MARK..IDEOGRAPHIC ANNOTATION REVERSE MARK
	{0x3192, 0x3195, prW},     // No     [4] IDEOGRAPHIC ANNOTATION ONE MARK..IDEOGRAPHIC ANNOTATION FOUR MARK
	{0x3196, 0x319F, prW},     // So    [10] IDEOGRAPHIC ANNOTATION TOP MARK..IDEOGRAPHIC ANNOTATION MAN MARK
	{0x31A0, 0x31BF, prW},     // Lo    [32] BOPOMOFO LETTER BU..BOPOMOFO LETTER AH
	{0x31C0, 0x31E3, prW},     // So    [36] CJK STROKE T..CJK STROKE Q
	{0x31F0, 0x31FF, prW},     // Lo    [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
	{0x3200, 0x321E, prW},     // So    [31] PARENTHESIZED HANGUL KIYEOK..PARENTHESIZED KOREAN CHARACTER O HU
	{0x3220, 0x3229, prW},     // No    [10] PARENTHESIZED IDEOGRAPH ONE..PARENTHESIZED IDEOGRAPH TEN
	{0x322A, 0x3247, prW},     // So    [30] PARENTHESIZED IDEOGRAPH MOON..CIRCLED IDEOGRAPH KOTO
	{0x3248, 0x324F, prA},     // No     [8] CIRCLED NUMBER TEN ON BLACK SQUARE..CIRCLED NUMBER EIGHTY ON BLACK SQUARE
	{0x3250, 0x3250, prW},     // So         PARTNERSHIP SIGN
	{0x3251, 0x325F, prW},     // No    [15] CIRCLED NUMBER TWENTY ONE..CIRCLED NUMBER THIRTY FIVE
	{0x3260, 0x327F, prW},     // So    [32] CIRCLED HANGUL KIYEOK..KOREAN STANDARD SYMBOL
	{0x3280, 0x3289, prW},     // No    [10] CIRCLED IDEOGRAPH ONE..CIRCLED IDEOGRAPH TEN
	{0x328A, 0x32B0, prW},     // So    [39] CIRCLED IDEOGRAPH MOON..CIRCLED IDEOGRAPH NIGHT
	{0x32B1, 0x32BF, prW},     // No    [15] CIRCLED NUMBER THIRTY SIX..CIRCLED NUMBER FIFTY
	{0x32C0, 0x32FF, prW},     // So    [64] IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY..SQUARE ERA NAME REIWA
	{0x3300, 0x33FF, prW},     // So   [256] SQUARE APAATO..SQUARE GAL
	{0x3400, 0x4DBF, prW},     // Lo  [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF
	{0x4DC0, 0x4DFF, prN},     // So    [64] HEXAGRAM FOR THE CREATIVE HEAVEN..HEXAGRAM FOR BEFORE COMPLETION
	{0x4E00, 0x9FFF, prW},     // Lo [20992] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FFF
	{0xA000, 0xA014, prW},     // Lo    [21] YI SYLLABLE IT..YI SYLLABLE E
	{0xA015, 0xA015, prW},     // Lm         YI SYLLABLE WU
	{0xA016, 0xA48C, prW},     // Lo  [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
	{0xA490, 0xA4C6, prW},     // So    [55] YI RADICAL QOT..YI RADICAL KE
	{0xA4D0, 0xA4F7, prN},     // Lo    [40] LISU LETTER BA..LISU LETTER OE
	{0xA4F8, 0xA4FD, prN},     // Lm     [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
	{0xA4FE, 0xA4FF, prN},     // Po     [2] LISU PUNCTUATION COMMA..LISU PUNCTUATION FULL STOP
	{0xA500, 0xA60B, prN},     // Lo   [268] VAI SYLLABLE EE..VAI SYLLABLE NG
	{0xA60C, 0xA60C, prN},     // Lm         VAI SYLLABLE LENGTHENER
	{0xA60D, 0xA60F, prN},     // Po     [3] VAI COMMA..VAI QUESTION MARK
	{0xA610, 0xA61F, prN},     // Lo    [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
	{0xA620, 0xA629, prN},     // Nd    [10] VAI DIGIT ZERO..VAI DIGIT NINE
	{0xA62A, 0xA62B, prN},     // Lo     [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
	{0xA640, 0xA66D, prN},     // L&    [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
	{0xA66E, 0xA66E, prN},     // Lo         CYRILLIC LETTER MULTIOCULAR O
	{0xA66F, 0xA66F, prN},     // Mn         COMBINING CYRILLIC VZMET
	{0xA670, 0xA672, prN},     // Me     [3] COMBINING CYRILLIC TEN MILLIONS SIGN..COMBINING CYRILLIC THOUSAND MILLIONS SIGN
	{0xA673, 0xA673, prN},     // Po         SLAVONIC ASTERISK
	{0xA674, 0xA67D, prN},     // Mn    [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
	{0xA67E, 0xA67E, prN},     // Po         CYRILLIC KAVYKA
	{0xA67F, 0xA67F, prN},     // Lm         CYRILLIC PAYEROK
	{0xA680, 0xA69B, prN},     // L&    [28] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER CROSSED O
	{0xA69C, 0xA69D, prN},     // Lm     [2] MODIFIER LETTER CYRILLIC HARD SIGN..MODIFIER LETTER CYRILLIC SOFT SIGN
	{0xA69E, 0xA69F, prN},     // Mn     [2] COMBINING CYRILLIC LETTER EF..COMBINING CYRILLIC LETTER IOTIFIED E
	{0xA6A0, 0xA6E5, prN},     // Lo    [70] BAMUM LETTER A..BAMUM LETTER KI
	{0xA6E6, 0xA6EF, prN},     // Nl    [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
	{0xA6F0, 0xA6F1, prN},     // Mn     [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
	{0xA6F2, 0xA6F7, prN},     // Po     [6] BAMUM NJAEMLI..BAMUM QUESTION MARK
	{0xA700, 0xA716, prN},     // Sk    [23] MODIFIER LETTER CHINESE TONE YIN PING..MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR
	{0xA717, 0xA71F, prN},     // Lm     [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
	{0xA720, 0xA721, prN},     // Sk     [2] MODIFIER LETTER STRESS AND HIGH TONE..MODIFIER LETTER STRESS AND LOW TONE
	{0xA722, 0xA76F, prN},     // L&    [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
	{0xA770, 0xA770, prN},     // Lm         MODIFIER LETTER US
	{0xA771, 0xA787, prN},     // L&    [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
	{0xA788, 0xA788, prN},     // Lm         MODIFIER LETTER LOW CIRCUMFLEX ACCENT
	{0xA789, 0xA78A, prN},     // Sk     [2] MODIFIER LETTER COLON..MODIFIER LETTER SHORT EQUALS SIGN
	{0xA78B, 0xA78E, prN},     // L&     [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
	{0xA78F, 0xA78F, prN},     // Lo         LATIN LETTER SINOLOGICAL DOT
	{0xA790, 0xA7CA, prN},     // L&    [59] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER S WITH SHORT STROKE OVERLAY
	{0xA7D0, 0xA7D1, prN},     // L&     [2] LATIN CAPITAL LETTER CLOSED INSULAR G..LATIN SMALL LETTER CLOSED INSULAR G
	{0xA7D3, 0xA7D3, prN},     // Ll         LATIN SMALL LETTER DOUBLE THORN
	{0xA7D5, 0xA7D9, prN},     // L&     [5] LATIN SMALL LETTER DOUBLE WYNN..LATIN SMALL LETTER SIGMOID S
	{0xA7F2, 0xA7F4, prN},     // Lm     [3] MODIFIER LETTER CAPITAL C..MODIFIER LETTER CAPITAL Q
	{0xA7F5, 0xA7F6, prN},     // L&     [2] LATIN CAPITAL LETTER REVERSED HALF H..LATIN SMALL LETTER REVERSED HALF H
	{0xA7F7, 0xA7F7, prN},     // Lo         LATIN EPIGRAPHIC LETTER SIDEWAYS I
	{0xA7F8, 0xA7F9, prN},     // Lm     [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
	{0xA7FA, 0xA7FA, prN},     // Ll         LATIN LETTER SMALL CAPITAL TURNED M
	{0xA7FB, 0xA7FF, prN},     // Lo     [5] LATIN EPIGRAPHIC LETTER REVERSED F..LATIN EPIGRAPHIC LETTER ARCHAIC M
	{0xA800, 0xA801, prN},     // Lo     [2] SYLOTI NAGRI LETTER A..SYLOTI NAGRI LETTER I
	{0xA802, 0xA802, prN},     // Mn         SYLOTI NAGRI SIGN DVISVARA
	{0xA803, 0xA805, prN},     // Lo     [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
	{0xA806, 0xA806, prN},     // Mn         SYLOTI NAGRI SIGN HASANTA
	{0xA807, 0xA80A, prN},     // Lo     [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
	{0xA80B, 0xA80B, prN},     // Mn         SYLOTI NAGRI SIGN ANUSVARA
	{0xA80C, 0xA822, prN},     // Lo    [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
	{0xA823, 0xA824, prN},     // Mc     [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
	{0xA825, 0xA826, prN},     // Mn     [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
	{0xA827, 0xA827, prN},     // Mc         SYLOTI NAGRI VOWEL SIGN OO
	{0xA828, 0xA82B, prN},     // So     [4] SYLOTI NAGRI POETRY MARK-1..SYLOTI NAGRI POETRY MARK-4
	{0xA82C, 0xA82C, prN},     // Mn         SYLOTI NAGRI SIGN ALTERNATE HASANTA
	{0xA830, 0xA835, prN},     // No     [6] NORTH INDIC FRACTION ONE QUARTER..NORTH INDIC FRACTION THREE SIXTEENTHS
	{0xA836, 0xA837, prN},     // So     [2] NORTH INDIC QUARTER MARK..NORTH INDIC PLACEHOLDER MARK
	{0xA838, 0xA838, prN},     // Sc         NORTH INDIC RUPEE MARK
	{0xA839, 0xA839, prN},     // So         NORTH INDIC QUANTITY MARK
	{0xA840, 0xA873, prN},     // Lo    [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
	{0xA874, 0xA877, prN},     // Po     [4] PHAGS-PA SINGLE HEAD MARK..PHAGS-PA MARK DOUBLE SHAD
	{0xA880, 0xA881, prN},     // Mc     [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
	{0xA882, 0xA8B3, prN},     // Lo    [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
	{0xA8B4, 0xA8C3, prN},     // Mc    [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
	{0xA8C4, 0xA8C5, prN},     // Mn     [2] SAURASHTRA SIGN VIRAMA..SAURASHTRA SIGN CANDRABINDU
	{0xA8CE, 0xA8CF, prN},     // Po     [2] SAURASHTRA DANDA..SAURASHTRA DOUBLE DANDA
	{0xA8D0, 0xA8D9, prN},     // Nd    [10] SAURASHTRA DIGIT ZERO..SAURASHTRA DIGIT NINE
	{0xA8E0, 0xA8F1, prN},     // Mn    [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
	{0xA8F2, 0xA8F7, prN},     // Lo     [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
	{0xA8F8, 0xA8FA, prN},     // Po     [3] DEVANAGARI SIGN PUSHPIKA..DEVANAGARI CARET
	{0xA8FB, 0xA8FB, prN},     // Lo         DEVANAGARI HEADSTROKE
	{0xA8FC, 0xA8FC, prN},     // Po         DEVANAGARI SIGN SIDDHAM
	{0xA8FD, 0xA8FE, prN},     // Lo     [2] DEVANAGARI JAIN OM..DEVANAGARI LETTER AY
	{0xA8FF, 0xA8FF, prN},     // Mn         DEVANAGARI VOWEL SIGN AY
	{0xA900, 0xA909, prN},     // Nd    [10] KAYAH LI DIGIT ZERO..KAYAH LI DIGIT NINE
	{0xA90A, 0xA925, prN},     // Lo    [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
	{0xA926, 0xA92D, prN},     // Mn     [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
	{0xA92E, 0xA92F, prN},     // Po     [2] KAYAH LI SIGN CWI..KAYAH LI SIGN SHYA
	{0xA930, 0xA946, prN},     // Lo    [23] REJANG LETTER KA..REJANG LETTER A
	{0xA947, 0xA951, prN},     // Mn    [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
	{0xA952, 0xA953, prN},     // Mc     [2] REJANG CONSONANT SIGN H..REJANG VIRAMA
	{0xA95F, 0xA95F, prN},     // Po         REJANG SECTION MARK
	{0xA960, 0xA97C, prW},     // Lo    [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
	{0xA980, 0xA982, prN},     // Mn     [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
	{0xA983, 0xA983, prN},     // Mc         JAVANESE SIGN WIGNYAN
	{0xA984, 0xA9B2, prN},     // Lo    [47] JAVANESE LETTER A..JAVANESE LETTER HA
	{0xA9B3, 0xA9B3, prN},     // Mn         JAVANESE SIGN CECAK TELU
	{0xA9B4, 0xA9B5, prN},     // Mc     [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
	{0xA9B6, 0xA9B9, prN},     // Mn     [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
	{0xA9BA, 0xA9BB, prN},     // Mc     [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
	{0xA9BC, 0xA9BD, prN},     // Mn     [2] JAVANESE VOWEL SIGN PEPET..JAVANESE CONSONANT SIGN KERET
	{0xA9BE, 0xA9C0, prN},     // Mc     [3] JAVANESE CONSONANT SIGN PENGKAL..JAVANESE PANGKON
	{0xA9C1, 0xA9CD, prN},     // Po    [13] JAVANESE LEFT RERENGGAN..JAVANESE TURNED PADA PISELEH
	{0xA9CF, 0xA9CF, prN},     // Lm         JAVANESE PANGRANGKEP
	{0xA9D0, 0xA9D9, prN},     // Nd    [10] JAVANESE DIGIT ZERO..JAVANESE DIGIT NINE
	{0xA9DE, 0xA9DF, prN},     // Po     [2] JAVANESE PADA TIRTA TUMETES..JAVANESE PADA ISEN-ISEN
	{0xA9E0, 0xA9E4, prN},     // Lo     [5] MYANMAR LETTER SHAN GHA..MYANMAR LETTER SHAN BHA
	{0xA9E5, 0xA9E5, prN},     // Mn         MYANMAR SIGN SHAN SAW
	{0xA9E6, 0xA9E6, prN},     // Lm         MYANMAR MODIFIER LETTER SHAN REDUPLICATION
	{0xA9E7, 0xA9EF, prN},     // Lo     [9] MYANMAR LETTER TAI LAING NYA..MYANMAR LETTER TAI LAING NNA
	{0xA9F0, 0xA9F9, prN},     // Nd    [10] MYANMAR TAI LAING DIGIT ZERO..MYANMAR TAI LAING DIGIT NINE
	{0xA9FA, 0xA9FE, prN},     // Lo     [5] MYANMAR LETTER TAI LAING LLA..MYANMAR LETTER TAI LAING BHA
	{0xAA00, 0xAA28, prN},     // Lo    [41] CHAM LETTER A..CHAM LETTER HA
	{0xAA29, 0xAA2E, prN},     // Mn     [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
	{0xAA2F, 0xAA30, prN},     // Mc     [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
	{0xAA31, 0xAA32, prN},     // Mn     [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
	{0xAA33, 0xAA34, prN},     // Mc     [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
	{0xAA35, 0xAA36, prN},     // Mn     [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
	{0xAA40, 0xAA42, prN},     // Lo     [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
	{0xAA43, 0xAA43, prN},     // Mn         CHAM CONSONANT SIGN FINAL NG
	{0xAA44, 0xAA4B, prN},     // Lo     [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
	{0xAA4C, 0xAA4C, prN},     // Mn         CHAM CONSONANT SIGN FINAL M
	{0xAA4D, 0xAA4D, prN},     // Mc         CHAM CONSONANT SIGN FINAL H
	{0xAA50, 0xAA59, prN},     // Nd    [10] CHAM DIGIT ZERO..CHAM DIGIT NINE
	{0xAA5C, 0xAA5F, prN},     // Po     [4] CHAM PUNCTUATION SPIRAL..CHAM PUNCTUATION TRIPLE DANDA
	{0xAA60, 0xAA6F, prN},     // Lo    [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
	{0xAA70, 0xAA70, prN},     // Lm         MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
	{0xAA71, 0xAA76, prN},     // Lo     [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
	{0xAA77, 0xAA79, prN},     // So     [3] MYANMAR SYMBOL AITON EXCLAMATION..MYANMAR SYMBOL AITON TWO
	{0xAA7A, 0xAA7A, prN},     // Lo         MYANMAR LETTER AITON RA
	{0xAA7B, 0xAA7B, prN},     // Mc         MYANMAR SIGN PAO KAREN TONE
	{0xAA7C, 0xAA7C, prN},     // Mn         MYANMAR SIGN TAI LAING TONE-2
	{0xAA7D, 0xAA7D, prN},     // Mc         MYANMAR SIGN TAI LAING TONE-5
	{0xAA7E, 0xAA7F, prN},     // Lo     [2] MYANMAR LETTER SHWE PALAUNG CHA..MYANMAR LETTER SHWE PALAUNG SHA
	{0xAA80, 0xAAAF, prN},     // Lo    [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
	{0xAAB0, 0xAAB0, prN},     // Mn         TAI VIET MAI KANG
	{0xAAB1, 0xAAB1, prN},     // Lo         TAI VIET VOWEL AA
	{0xAAB2, 0xAAB4, prN},     // Mn     [3] TAI VIET VOWEL I..TAI VIET VOWEL U
	{0xAAB5, 0xAAB6, prN},     // Lo     [2] TAI VIET VOWEL E..TAI VIET VOWEL O
	{0xAAB7, 0xAAB8, prN},     // Mn     [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
	{0xAAB9, 0xAABD, prN},     // Lo     [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
	{0xAABE, 0xAABF, prN},     // Mn     [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
	{0xAAC0, 0xAAC0, prN},     // Lo         TAI VIET TONE MAI NUENG
	{0xAAC1, 0xAAC1, prN},     // Mn         TAI VIET TONE MAI THO
	{0xAAC2, 0xAAC2, prN},     // Lo         TAI VIET TONE MAI SONG
	{0xAADB, 0xAADC, prN},     // Lo     [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
	{0xAADD, 0xAADD, prN},     // Lm         TAI VIET SYMBOL SAM
	{0xAADE, 0xAADF, prN},     // Po     [2] TAI VIET SYMBOL HO HOI..TAI VIET SYMBOL KOI KOI
	{0xAAE0, 0xAAEA, prN},     // Lo    [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
	{0xAAEB, 0xAAEB, prN},     // Mc         MEETEI MAYEK VOWEL SIGN II
	{0xAAEC, 0xAAED, prN},     // Mn     [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
	{0xAAEE, 0xAAEF, prN},     // Mc     [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
	{0xAAF0, 0xAAF1, prN},     // Po     [2] MEETEI MAYEK CHEIKHAN..MEETEI MAYEK AHANG KHUDAM
	{0xAAF2, 0xAAF2, prN},     // Lo         MEETEI MAYEK ANJI
	{0xAAF3, 0xAAF4, prN},     // Lm     [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
	{0xAAF5, 0xAAF5, prN},     // Mc         MEETEI MAYEK VOWEL SIGN VISARGA
	{0xAAF6, 0xAAF6, prN},     // Mn         MEETEI MAYEK VIRAMA
	{0xAB01, 0xAB06, prN},     // Lo     [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
	{0xAB09, 0xAB0E, prN},     // Lo     [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
	{0xAB11, 0xAB16, prN},     // Lo     [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
	{0xAB20, 0xAB26, prN},     // Lo     [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
	{0xAB28, 0xAB2E, prN},     // Lo     [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
	{0xAB30, 0xAB5A, prN},     // Ll    [43] LATIN SMALL LETTER BARRED ALPHA..LATIN SMALL LETTER Y WITH SHORT RIGHT LEG
	{0xAB5B, 0xAB5B, prN},     // Sk         MODIFIER BREVE WITH INVERTED BREVE
	{0xAB5C, 0xAB5F, prN},     // Lm     [4] MODIFIER LETTER SMALL HENG..MODIFIER LETTER SMALL U WITH LEFT HOOK
	{0xAB60, 0xAB68, prN},     // Ll     [9] LATIN SMALL LETTER SAKHA YAT..LATIN SMALL LETTER TURNED R WITH MIDDLE TILDE
	{0xAB69, 0xAB69, prN},     // Lm         MODIFIER LETTER SMALL TURNED W
	{0xAB6A, 0xAB6B, prN},     // Sk     [2] MODIFIER LETTER LEFT TACK..MODIFIER LETTER RIGHT TACK
	{0xAB70, 0xABBF, prN},     // Ll    [80] CHEROKEE SMALL LETTER A..CHEROKEE SMALL LETTER YA
	{0xABC0, 0xABE2, prN},     // Lo    [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
	{0xABE3, 0xABE4, prN},     // Mc     [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
	{0xABE5, 0xABE5, prN},     // Mn         MEETEI MAYEK VOWEL SIGN ANAP
	{0xABE6, 0xABE7, prN},     // Mc     [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
	{0xABE8, 0xABE8, prN},     // Mn         MEETEI MAYEK VOWEL SIGN UNAP
	{0xABE9, 0xABEA, prN},     // Mc     [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
	{0xABEB, 0xABEB, prN},     // Po         MEETEI MAYEK CHEIKHEI
	{0xABEC, 0xABEC, prN},     // Mc         MEETEI MAYEK LUM IYEK
	{0xABED, 0xABED, prN},     // Mn         MEETEI MAYEK APUN IYEK
	{0xABF0, 0xABF9, prN},     // Nd    [10] MEETEI MAYEK DIGIT ZERO..MEETEI MAYEK DIGIT NINE
	{0xAC00, 0xD7A3, prW},     // Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
	{0xD7B0, 0xD7C6, prN},     // Lo    [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
	{0xD7CB, 0xD7FB, prN},     // Lo    [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
	{0xD800, 0xDB7F, prN},     // Cs   [896] <surrogate-D800>..<surrogate-DB7F>
	{0xDB80, 0xDBFF, prN},     // Cs   [128] <surrogate-DB80>..<surrogate-DBFF>
	{0xDC00, 0xDFFF, prN},     // Cs  [1024] <surrogate-DC00>..<surrogate-DFFF>
	{0xE000, 0xF8FF, prA},     // Co  [6400] <private-use-E000>..<private-use-F8FF>
	{0xF900, 0xFA6D, prW},     // Lo   [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
	{0xFA6E, 0xFA6F, prW},     // Cn     [2] <reserved-FA6E>..<reserved-FA6F>
	{0xFA70, 0xFAD9, prW},     // Lo   [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
	{0xFADA, 0xFAFF, prW},     // Cn    [38] <reserved-FADA>..<reserved-FAFF>
	{0xFB00, 0xFB06, prN},     // Ll     [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
	{0xFB13, 0xFB17, prN},     // Ll     [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
	{0xFB1D, 0xFB1D, prN},     // Lo         HEBREW LETTER YOD WITH HIRIQ
	{0xFB1E, 0xFB1E, prN},     // Mn         HEBREW POINT JUDEO-SPANISH VARIKA
	{0xFB1F, 0xFB28, prN},     // Lo    [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
	{0xFB29, 0xFB29, prN},     // Sm         HEBREW LETTER ALTERNATIVE PLUS SIGN
	{0xFB2A, 0xFB36, prN},     // Lo    [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
	{0xFB38, 0xFB3C, prN},     // Lo     [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
	{0xFB3E, 0xFB3E, prN},     // Lo         HEBREW LETTER MEM WITH DAGESH
	{0xFB40, 0xFB41, prN},     // Lo     [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
	{0xFB43, 0xFB44, prN},     // Lo     [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
	{0xFB46, 0xFB4F, prN},     // Lo    [10] HEBREW LETTER TSADI WITH DAGESH..HEBREW LIGATURE ALEF LAMED
	{0xFB50, 0xFBB1, prN},     // Lo    [98] ARABIC LETTER ALEF WASLA ISOLATED FORM..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
	{0xFBB2, 0xFBC2, prN},     // Sk    [17] ARABIC SYMBOL DOT ABOVE..ARABIC SYMBOL WASLA ABOVE
	{0xFBD3, 0xFD3D, prN},     // Lo   [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
	{0xFD3E, 0xFD3E, prN},     // Pe         ORNATE LEFT PARENTHESIS
	{0xFD3F, 0xFD3F, prN},     // Ps         ORNATE RIGHT PARENTHESIS
	{0xFD40, 0xFD4F, prN},     // So    [16] ARABIC LIGATURE RAHIMAHU ALLAAH..ARABIC LIGATURE RAHIMAHUM ALLAAH
	{0xFD50, 0xFD8F, prN},     // Lo    [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
	{0xFD92, 0xFDC7, prN},     // Lo    [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
	{0xFDCF, 0xFDCF, prN},     // So         ARABIC LIGATURE SALAAMUHU ALAYNAA
	{0xFDF0, 0xFDFB, prN},     // Lo    [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
	{0xFDFC, 0xFDFC, prN},     // Sc         RIAL SIGN
	{0xFDFD, 0xFDFF, prN},     // So     [3] ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM..ARABIC LIGATURE AZZA WA JALL
	{0xFE00, 0xFE0F, prA},     // Mn    [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
	{0xFE10, 0xFE16, prW},     // Po     [7] PRESENTATION FORM FOR VERTICAL COMMA..PRESENTATION FORM FOR VERTICAL QUESTION MARK
	{0xFE17, 0xFE17, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
	{0xFE18, 0xFE18, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
	{0xFE19, 0xFE19, prW},     // Po         PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS
	{0xFE20, 0xFE2F, prN},     // Mn    [16] COMBINING LIGATURE LEFT HALF..COMBINING CYRILLIC TITLO RIGHT HALF
	{0xFE30, 0xFE30, prW},     // Po         PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
	{0xFE31, 0xFE32, prW},     // Pd     [2] PRESENTATION FORM FOR VERTICAL EM DASH..PRESENTATION FORM FOR VERTICAL EN DASH
	{0xFE33, 0xFE34, prW},     // Pc     [2] PRESENTATION FORM FOR VERTICAL LOW LINE..PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
	{0xFE35, 0xFE35, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
	{0xFE36, 0xFE36, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
	{0xFE37, 0xFE37, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
	{0xFE38, 0xFE38, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
	{0xFE39, 0xFE39, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
	{0xFE3A, 0xFE3A, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
	{0xFE3B, 0xFE3B, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
	{0xFE3C, 0xFE3C, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
	{0xFE3D, 0xFE3D, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
	{0xFE3E, 0xFE3E, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
	{0xFE3F, 0xFE3F, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
	{0xFE40, 0xFE40, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
	{0xFE41, 0xFE41, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
	{0xFE42, 0xFE42, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
	{0xFE43, 0xFE43, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
	{0xFE44, 0xFE44, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
	{0xFE45, 0xFE46, prW},     // Po     [2] SESAME DOT..WHITE SESAME DOT
	{0xFE47, 0xFE47, prW},     // Ps         PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
	{0xFE48, 0xFE48, prW},     // Pe         PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
	{0xFE49, 0xFE4C, prW},     // Po     [4] DASHED OVERLINE..DOUBLE WAVY OVERLINE
	{0xFE4D, 0xFE4F, prW},     // Pc     [3] DASHED LOW LINE..WAVY LOW LINE
	{0xFE50, 0xFE52, prW},     // Po     [3] SMALL COMMA..SMALL FULL STOP
	{0xFE54, 0xFE57, prW},     // Po     [4] SMALL SEMICOLON..SMALL EXCLAMATION MARK
	{0xFE58, 0xFE58, prW},     // Pd         SMALL EM DASH
	{0xFE59, 0xFE59, prW},     // Ps         SMALL LEFT PARENTHESIS
	{0xFE5A, 0xFE5A, prW},     // Pe         SMALL RIGHT PARENTHESIS
	{0xFE5B, 0xFE5B, prW},     // Ps         SMALL LEFT CURLY BRACKET
	{0xFE5C, 0xFE5C, prW},     // Pe         SMALL RIGHT CURLY BRACKET
	{0xFE5D, 0xFE5D, prW},     // Ps         SMALL LEFT TORTOISE SHELL BRACKET
	{0xFE5E, 0xFE5E, prW},     // Pe         SMALL RIGHT TORTOISE SHELL BRACKET
	{0xFE5F, 0xFE61, prW},     // Po     [3] SMALL NUMBER SIGN..SMALL ASTERISK
	{0xFE62, 0xFE62, prW},     // Sm         SMALL PLUS SIGN
	{0xFE63, 0xFE63, prW},     // Pd         SMALL HYPHEN-MINUS
	{0xFE64, 0xFE66, prW},     // Sm     [3] SMALL LESS-THAN SIGN..SMALL EQUALS SIGN
	{0xFE68, 0xFE68, prW},     // Po         SMALL REVERSE SOLIDUS
	{0xFE69, 0xFE69, prW},     // Sc         SMALL DOLLAR SIGN
	{0xFE6A, 0xFE6B, prW},     // Po     [2] SMALL PERCENT SIGN..SMALL COMMERCIAL AT
	{0xFE70, 0xFE74, prN},     // Lo     [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
	{0xFE76, 0xFEFC, prN},     // Lo   [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
	{0xFEFF, 0xFEFF, prN},     // Cf         ZERO WIDTH NO-BREAK SPACE
	{0xFF01, 0xFF03, prF},     // Po     [3] FULLWIDTH EXCLAMATION MARK..FULLWIDTH NUMBER SIGN
	{0xFF04, 0xFF04, prF},     // Sc         FULLWIDTH DOLLAR SIGN
	{0xFF05, 0xFF07, prF},     // Po     [3] FULLWIDTH PERCENT SIGN..FULLWIDTH APOSTROPHE
	{0xFF08, 0xFF08, prF},     // Ps         FULLWIDTH LEFT PARENTHESIS
	{0xFF09, 0xFF09, prF},     // Pe         FULLWIDTH RIGHT PARENTHESIS
	{0xFF0A, 0xFF0A, prF},     // Po         FULLWIDTH ASTERISK
	{0xFF0B, 0xFF0B, prF},     // Sm         FULLWIDTH PLUS SIGN
	{0xFF0C, 0xFF0C, prF},     // Po         FULLWIDTH COMMA
	{0xFF0D, 0xFF0D, prF},     // Pd         FULLWIDTH HYPHEN-MINUS
	{0xFF0E, 0xFF0F, prF},     // Po     [2] FULLWIDTH FULL STOP..FULLWIDTH SOLIDUS
	{0xFF10, 0xFF19, prF},     // Nd    [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
	{0xFF1A, 0xFF1B, prF},     // Po     [2] FULLWIDTH COLON..FULLWIDTH SEMICOLON
	{0xFF1C, 0xFF1E, prF},     // Sm     [3] FULLWIDTH LESS-THAN SIGN..FULLWIDTH GREATER-THAN SIGN
	{0xFF1F, 0xFF20, prF},     // Po     [2] FULLWIDTH QUESTION MARK..FULLWIDTH COMMERCIAL AT
	{0xFF21, 0xFF3A, prF},     // Lu    [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
	{0xFF3B, 0xFF3B, prF},     // Ps         FULLWIDTH LEFT SQUARE BRACKET
	{0xFF3C, 0xFF3C, prF},     // Po         FULLWIDTH REVERSE SOLIDUS
	{0xFF3D, 0xFF3D, prF},     // Pe         FULLWIDTH RIGHT SQUARE BRACKET
	{0xFF3E, 0xFF3E, prF},     // Sk         FULLWIDTH CIRCUMFLEX ACCENT
	{0xFF3F, 0xFF3F, prF},     // Pc         FULLWIDTH LOW LINE
	{0xFF40, 0xFF40, prF},     // Sk         FULLWIDTH GRAVE ACCENT
	{0xFF41, 0xFF5A, prF},     // Ll    [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
	{0xFF5B, 0xFF5B, prF},     // Ps         FULLWIDTH LEFT CURLY BRACKET
	{0xFF5C, 0xFF5C, prF},     // Sm         FULLWIDTH VERTICAL LINE
	{0xFF5D, 0xFF5D, prF},     // Pe         FULLWIDTH RIGHT CURLY BRACKET
	{0xFF5E, 0xFF5E, prF},     // Sm         FULLWIDTH TILDE
	{0xFF5F, 0xFF5F, prF},     // Ps         FULLWIDTH LEFT WHITE PARENTHESIS
	{0xFF60, 0xFF60, prF},     // Pe         FULLWIDTH RIGHT WHITE PARENTHESIS
	{0xFF61, 0xFF61, prH},     // Po         HALFWIDTH IDEOGRAPHIC FULL STOP
	{0xFF62, 0xFF62, prH},     // Ps         HALFWIDTH LEFT CORNER BRACKET
	{0xFF63, 0xFF63, prH},     // Pe         HALFWIDTH RIGHT CORNER BRACKET
	{0xFF64, 0xFF65, prH},     // Po     [2] HALFWIDTH IDEOGRAPHIC COMMA..HALFWIDTH KATAKANA MIDDLE DOT
	{0xFF66, 0xFF6F, prH},     // Lo    [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
	{0xFF70, 0xFF70, prH},     // Lm         HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{0xFF71, 0xFF9D, prH},     // Lo    [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
	{0xFF9E, 0xFF9F, prH},     // Lm     [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
	{0xFFA0, 0xFFBE, prH},     // Lo    [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
	{0xFFC2, 0xFFC7, prH},     // Lo     [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
	{0xFFCA, 0xFFCF, prH},     // Lo     [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
	{0xFFD2, 0xFFD7, prH},     // Lo     [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
	{0xFFDA, 0xFFDC, prH},     // Lo     [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
	{0xFFE0, 0xFFE1, prF},     // Sc     [2] FULLWIDTH CENT SIGN..FULLWIDTH POUND SIGN
	{0xFFE2, 0xFFE2, prF},     // Sm         FULLWIDTH NOT SIGN
	{0xFFE3, 0xFFE3, prF},     // Sk         FULLWIDTH MACRON
	{0xFFE4, 0xFFE4, prF},     // So         FULLWIDTH BROKEN BAR
	{0xFFE5, 0xFFE6, prF},     // Sc     [2] FULLWIDTH YEN SIGN..FULLWIDTH WON SIGN
	{0xFFE8, 0xFFE8, prH},     // So         HALFWIDTH FORMS LIGHT VERTICAL
	{0xFFE9, 0xFFEC, prH},     // Sm     [4] HALFWIDTH LEFTWARDS ARROW..HALFWIDTH DOWNWARDS ARROW
	{0xFFED, 0xFFEE, prH},     // So     [2] HALFWIDTH BLACK SQUARE..HALFWIDTH WHITE CIRCLE
	{0xFFF9, 0xFFFB, prN},     // Cf     [3] INTERLINEAR ANNOTATION ANCHOR..INTERLINEAR ANNOTATION TERMINATOR
	{0xFFFC, 0xFFFC, prN},     // So         OBJECT REPLACEMENT CHARACTER
	{0xFFFD, 0xFFFD, prA},     // So         REPLACEMENT CHARACTER
	{0x10000, 0x1000B, prN},   // Lo    [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
	{0x1000D, 0x10026, prN},   // Lo    [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
	{0x10028, 0x1003A, prN},   // Lo    [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
	{0x1003C, 0x1003D, prN},   // Lo     [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
	{0x1003F, 0x1004D, prN},   // Lo    [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
	{0x10050, 0x1005D, prN},   // Lo    [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
	{0x10080, 0x100FA, prN},   // Lo   [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
	{0x10100, 0x10102, prN},   // Po     [3] AEGEAN WORD SEPARATOR LINE..AEGEAN CHECK MARK
	{0x10107, 0x10133, prN},   // No    [45] AEGEAN NUMBER ONE..AEGEAN NUMBER NINETY THOUSAND
	{0x10137, 0x1013F, prN},   // So     [9] AEGEAN WEIGHT BASE UNIT..AEGEAN MEASURE THIRD SUBUNIT
	{0x10140, 0x10174, prN},   // Nl    [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
	{0x10175, 0x10178, prN},   // No     [4] GREEK ONE HALF SIGN..GREEK THREE QUARTERS SIGN
	{0x10179, 0x10189, prN},   // So    [17] GREEK YEAR SIGN..GREEK TRYBLION BASE SIGN
	{0x1018A, 0x1018B, prN},   // No     [2] GREEK ZERO SIGN..GREEK ONE QUARTER SIGN
	{0x1018C, 0x1018E, prN},   // So     [3] GREEK SINUSOID SIGN..NOMISMA SIGN
	{0x10190, 0x1019C, prN},   // So    [13] ROMAN SEXTANS SIGN..ASCIA SYMBOL
	{0x101A0, 0x101A0, prN},   // So         GREEK SYMBOL TAU RHO
	{0x101D0, 0x101FC, prN},   // So    [45] PHAISTOS DISC SIGN PEDESTRIAN..PHAISTOS DISC SIGN WAVY BAND
	{0x101FD, 0x101FD, prN},   // Mn         PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
	{0x10280, 0x1029C, prN},   // Lo    [29] LYCIAN LETTER A..LYCIAN LETTER X
	{0x102A0, 0x102D0, prN},   // Lo    [49] CARIAN LETTER A..CARIAN LETTER UUU3
	{0x102E0, 0x102E0, prN},   // Mn         COPTIC EPACT THOUSANDS MARK
	{0x102E1, 0x102FB, prN},   // No    [27] COPTIC EPACT DIGIT ONE..COPTIC EPACT NUMBER NINE HUNDRED
	{0x10300, 0x1031F, prN},   // Lo    [32] OLD ITALIC LETTER A..OLD ITALIC LETTER ESS
	{0x10320, 0x10323, prN},   // No     [4] OLD ITALIC NUMERAL ONE..OLD ITALIC NUMERAL FIFTY
	{0x1032D, 0x1032F, prN},   // Lo     [3] OLD ITALIC LETTER YE..OLD ITALIC LETTER SOUTHERN TSE
	{0x10330, 0x10340, prN},   // Lo    [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
	{0x10341, 0x10341, prN},   // Nl         GOTHIC LETTER NINETY
	{0x10342, 0x10349, prN},   // Lo     [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
	{0x1034A, 0x1034A, prN},   // Nl         GOTHIC LETTER NINE HUNDRED
	{0x10350, 0x10375, prN},   // Lo    [38] OLD PERMIC LETTER AN..OLD PERMIC LETTER IA
	{0x10376, 0x1037A, prN},   // Mn     [5] COMBINING OLD PERMIC LETTER AN..COMBINING OLD PERMIC LETTER SII
	{0x10380, 0x1039D, prN},   // Lo    [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
	{0x1039F, 0x1039F, prN},   // Po         UGARITIC WORD DIVIDER
	{0x103A0, 0x103C3, prN},   // Lo    [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
	{0x103C8, 0x103CF, prN},   // Lo     [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
	{0x103D0, 0x103D0, prN},   // Po         OLD PERSIAN WORD DIVIDER
	{0x103D1, 0x103D5, prN},   // Nl     [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
	{0x10400, 0x1044F, prN},   // L&    [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
	{0x10450, 0x1047F, prN},   // Lo    [48] SHAVIAN LETTER PEEP..SHAVIAN LETTER YEW
	{0x10480, 0x1049D, prN},   // Lo    [30] OSMANYA LETTER ALEF..OSMANYA LETTER OO
	{0x104A0, 0x104A9, prN},   // Nd    [10] OSMANYA DIGIT ZERO..OSMANYA DIGIT NINE
	{0x104B0, 0x104D3, prN},   // Lu    [36] OSAGE CAPITAL LETTER A..OSAGE CAPITAL LETTER ZHA
	{0x104D8, 0x104FB, prN},   // Ll    [36] OSAGE SMALL LETTER A..OSAGE SMALL LETTER ZHA
	{0x10500, 0x10527, prN},   // Lo    [40] ELBASAN LETTER A..ELBASAN LETTER KHE
	{0x10530, 0x10563, prN},   // Lo    [52] CAUCASIAN ALBANIAN LETTER ALT..CAUCASIAN ALBANIAN LETTER KIW
	{0x1056F, 0x1056F, prN},   // Po         CAUCASIAN ALBANIAN CITATION MARK
	{0x10570, 0x1057A, prN},   // Lu    [11] VITHKUQI CAPITAL LETTER A..VITHKUQI CAPITAL LETTER GA
	{0x1057C, 0x1058A, prN},   // Lu    [15] VITHKUQI CAPITAL LETTER HA..VITHKUQI CAPITAL LETTER RE
	{0x1058C, 0x10592, prN},   // Lu     [7] VITHKUQI CAPITAL LETTER SE..VITHKUQI CAPITAL LETTER XE
	{0x10594, 0x10595, prN},   // Lu     [2] VITHKUQI CAPITAL LETTER Y..VITHKUQI CAPITAL LETTER ZE
	{0x10597, 0x105A1, prN},   // Ll    [11] VITHKUQI SMALL LETTER A..VITHKUQI SMALL LETTER GA
	{0x105A3, 0x105B1, prN},   // Ll    [15] VITHKUQI SMALL LETTER HA..VITHKUQI SMALL LETTER RE
	{0x105B3, 0x105B9, prN},   // Ll     [7] VITHKUQI SMALL LETTER SE..VITHKUQI SMALL LETTER XE
	{0x105BB, 0x105BC, prN},   // Ll     [2] VITHKUQI SMALL LETTER Y..VITHKUQI SMALL LETTER ZE
	{0x10600, 0x10736, prN},   // Lo   [311] LINEAR A SIGN AB001..LINEAR A SIGN A664
	{0x10740, 0x10755, prN},   // Lo    [22] LINEAR A SIGN A701 A..LINEAR A SIGN A732 JE
	{0x10760, 0x10767, prN},   // Lo     [8] LINEAR A SIGN A800..LINEAR A SIGN A807
	{0x10780, 0x10785, prN},   // Lm     [6] MODIFIER LETTER SMALL CAPITAL AA..MODIFIER LETTER SMALL B WITH HOOK
	{0x10787, 0x107B0, prN},   // Lm    [42] MODIFIER LETTER SMALL DZ DIGRAPH..MODIFIER LETTER SMALL V WITH RIGHT HOOK
	{0x107B2, 0x107BA, prN},   // Lm     [9] MODIFIER LETTER SMALL CAPITAL Y..MODIFIER LETTER SMALL S WITH CURL
	{0x10800, 0x10805, prN},   // Lo     [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
	{0x10808, 0x10808, prN},   // Lo         CYPRIOT SYLLABLE JO
	{0x1080A, 0x10835, prN},   // Lo    [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
	{0x10837, 0x10838, prN},   // Lo     [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
	{0x1083C, 0x1083C, prN},   // Lo         CYPRIOT SYLLABLE ZA
	{0x1083F, 0x1083F, prN},   // Lo         CYPRIOT SYLLABLE ZO
	{0x10840, 0x10855, prN},   // Lo    [22] IMPERIAL ARAMAIC LETTER ALEPH..IMPERIAL ARAMAIC LETTER TAW
	{0x10857, 0x10857, prN},   // Po         IMPERIAL ARAMAIC SECTION SIGN
	{0x10858, 0x1085F, prN},   // No     [8] IMPERIAL ARAMAIC NUMBER ONE..IMPERIAL ARAMAIC NUMBER TEN THOUSAND
	{0x10860, 0x10876, prN},   // Lo    [23] PALMYRENE LETTER ALEPH..PALMYRENE LETTER TAW
	{0x10877, 0x10878, prN},   // So     [2] PALMYRENE LEFT-POINTING FLEURON..PALMYRENE RIGHT-POINTING FLEURON
	{0x10879, 0x1087F, prN},   // No     [7] PALMYRENE NUMBER ONE..PALMYRENE NUMBER TWENTY
	{0x10880, 0x1089E, prN},   // Lo    [31] NABATAEAN LETTER FINAL ALEPH..NABATAEAN LETTER TAW
	{0x108A7, 0x108AF, prN},   // No     [9] NABATAEAN NUMBER ONE..NABATAEAN NUMBER ONE HUNDRED
	{0x108E0, 0x108F2, prN},   // Lo    [19] HATRAN LETTER ALEPH..HATRAN LETTER QOPH
	{0x108F4, 0x108F5, prN},   // Lo     [2] HATRAN LETTER SHIN..HATRAN LETTER TAW
	{0x108FB, 0x108FF, prN},   // No     [5] HATRAN NUMBER ONE..HATRAN NUMBER ONE HUNDRED
	{0x10900, 0x10915, prN},   // Lo    [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
	{0x10916, 0x1091B, prN},   // No     [6] PHOENICIAN NUMBER ONE..PHOENICIAN NUMBER THREE
	{0x1091F, 0x1091F, prN},   // Po         PHOENICIAN WORD SEPARATOR
	{0x10920, 0x10939, prN},   // Lo    [26] LYDIAN LETTER A..LYDIAN LETTER C
	{0x1093F, 0x1093F, prN},   // Po         LYDIAN TRIANGULAR MARK
	{0x10980, 0x1099F, prN},   // Lo    [32] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC HIEROGLYPHIC SYMBOL VIDJ-2
	{0x109A0, 0x109B7, prN},   // Lo    [24] MEROITIC CURSIVE LETTER A..MEROITIC CURSIVE LETTER DA
	{0x109BC, 0x109BD, prN},   // No     [2] MEROITIC CURSIVE FRACTION ELEVEN TWELFTHS..MEROITIC CURSIVE FRACTION ONE HALF
	{0x109BE, 0x109BF, prN},   // Lo     [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
	{0x109C0, 0x109CF, prN},   // No    [16] MEROITIC CURSIVE NUMBER ONE..MEROITIC CURSIVE NUMBER SEVENTY
	{0x109D2, 0x109FF, prN},   // No    [46] MEROITIC CURSIVE NUMBER ONE HUNDRED..MEROITIC CURSIVE FRACTION TEN TWELFTHS
	{0x10A00, 0x10A00, prN},   // Lo         KHAROSHTHI LETTER A
	{0x10A01, 0x10A03, prN},   // Mn     [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
	{0x10A05, 0x10A06, prN},   // Mn     [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
	{0x10A0C, 0x10A0F, prN},   // Mn     [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
	{0x10A10, 0x10A13, prN},   // Lo     [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
	{0x10A15, 0x10A17, prN},   // Lo     [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
	{0x10A19, 0x10A35, prN},   // Lo    [29] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER VHA
	{0x10A38, 0x10A3A, prN},   // Mn     [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
	{0x10A3F, 0x10A3F, prN},   // Mn         KHAROSHTHI VIRAMA
	{0x10A40, 0x10A48, prN},   // No     [9] KHAROSHTHI DIGIT ONE..KHAROSHTHI FRACTION ONE HALF
	{0x10A50, 0x10A58, prN},   // Po     [9] KHAROSHTHI PUNCTUATION DOT..KHAROSHTHI PUNCTUATION LINES
	{0x10A60, 0x10A7C, prN},   // Lo    [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
	{0x10A7D, 0x10A7E, prN},   // No     [2] OLD SOUTH ARABIAN NUMBER ONE..OLD SOUTH ARABIAN NUMBER FIFTY
	{0x10A7F, 0x10A7F, prN},   // Po         OLD SOUTH ARABIAN NUMERIC INDICATOR
	{0x10A80, 0x10A9C, prN},   // Lo    [29] OLD NORTH ARABIAN LETTER HEH..OLD NORTH ARABIAN LETTER ZAH
	{0x10A9D, 0x10A9F, prN},   // No     [3] OLD NORTH ARABIAN NUMBER ONE..OLD NORTH ARABIAN NUMBER TWENTY
	{0x10AC0, 0x10AC7, prN},   // Lo     [8] MANICHAEAN LETTER ALEPH..MANICHAEAN LETTER WAW
	{0x10AC8, 0x10AC8, prN},   // So         MANICHAEAN SIGN UD
	{0x10AC9, 0x10AE4, prN},   // Lo    [28] MANICHAEAN LETTER ZAYIN..MANICHAEAN LETTER TAW
	{0x10AE5, 0x10AE6, prN},   // Mn     [2] MANICHAEAN ABBREVIATION MARK ABOVE..MANICHAEAN ABBREVIATION MARK BELOW
	{0x10AEB, 0x10AEF, prN},   // No     [5] MANICHAEAN NUMBER ONE..MANICHAEAN NUMBER ONE HUNDRED
	{0x10AF0, 0x10AF6, prN},   // Po     [7] MANICHAEAN PUNCTUATION STAR..MANICHAEAN PUNCTUATION LINE FILLER
	{0x10B00, 0x10B35, prN},   // Lo    [54] AVESTAN LETTER A..AVESTAN LETTER HE
	{0x10B39, 0x10B3F, prN},   // Po     [7] AVESTAN ABBREVIATION MARK..LARGE ONE RING OVER TWO RINGS PUNCTUATION
	{0x10B40, 0x10B55, prN},   // Lo    [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
	{0x10B58, 0x10B5F, prN},   // No     [8] INSCRIPTIONAL PARTHIAN NUMBER ONE..INSCRIPTIONAL PARTHIAN NUMBER ONE THOUSAND
	{0x10B60, 0x10B72, prN},   // Lo    [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
	{0x10B78, 0x10B7F, prN},   // No     [8] INSCRIPTIONAL PAHLAVI NUMBER ONE..INSCRIPTIONAL PAHLAVI NUMBER ONE THOUSAND
	{0x10B80, 0x10B91, prN},   // Lo    [18] PSALTER PAHLAVI LETTER ALEPH..PSALTER PAHLAVI LETTER TAW
	{0x10B99, 0x10B9C, prN},   // Po     [4] PSALTER PAHLAVI SECTION MARK..PSALTER PAHLAVI FOUR DOTS WITH DOT
	{0x10BA9, 0x10BAF, prN},   // No     [7] PSALTER PAHLAVI NUMBER ONE..PSALTER PAHLAVI NUMBER ONE HUNDRED
	{0x10C00, 0x10C48, prN},   // Lo    [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
	{0x10C80, 0x10CB2, prN},   // Lu    [51] OLD HUNGARIAN CAPITAL LETTER A..OLD HUNGARIAN CAPITAL LETTER US
	{0x10CC0, 0x10CF2, prN},   // Ll    [51] OLD HUNGARIAN SMALL LETTER A..OLD HUNGARIAN SMALL LETTER US
	{0x10CFA, 0x10CFF, prN},   // No     [6] OLD HUNGARIAN NUMBER ONE..OLD HUNGARIAN NUMBER ONE THOUSAND
	{0x10D00, 0x10D23, prN},   // Lo    [36] HANIFI ROHINGYA LETTER A..HANIFI ROHINGYA MARK NA KHONNA
	{0x10D24, 0x10D27, prN},   // Mn     [4] HANIFI ROHINGYA SIGN HARBAHAY..HANIFI ROHINGYA SIGN TASSI
	{0x10D30, 0x10D39, prN},   // Nd    [10] HANIFI ROHINGYA DIGIT ZERO..HANIFI ROHINGYA DIGIT NINE
	{0x10E60, 0x10E7E, prN},   // No    [31] RUMI DIGIT ONE..RUMI FRACTION TWO THIRDS
	{0x10E80, 0x10EA9, prN},   // Lo    [42] YEZIDI LETTER ELIF..YEZIDI LETTER ET
	{0x10EAB, 0x10EAC, prN},   // Mn     [2] YEZIDI COMBINING HAMZA MARK..YEZIDI COMBINING MADDA MARK
	{0x10EAD, 0x10EAD, prN},   // Pd         YEZIDI HYPHENATION MARK
	{0x10EB0, 0x10EB1, prN},   // Lo     [2] YEZIDI LETTER LAM WITH DOT ABOVE..YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE
	{0x10EFD, 0x10EFF, prN},   // Mn     [3] ARABIC SMALL LOW WORD SAKTA..ARABIC SMALL LOW WORD MADDA
	{0x10F00, 0x10F1C, prN},   // Lo    [29] OLD SOGDIAN LETTER ALEPH..OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL
	{0x10F1D, 0x10F26, prN},   // No    [10] OLD SOGDIAN NUMBER ONE..OLD SOGDIAN FRACTION ONE HALF
	{0x10F27, 0x10F27, prN},   // Lo         OLD SOGDIAN LIGATURE AYIN-DALETH
	{0x10F30, 0x10F45, prN},   // Lo    [22] SOGDIAN LETTER ALEPH..SOGDIAN INDEPENDENT SHIN
	{0x10F46, 0x10F50, prN},   // Mn    [11] SOGDIAN COMBINING DOT BELOW..SOGDIAN COMBINING STROKE BELOW
	{0x10F51, 0x10F54, prN},   // No     [4] SOGDIAN NUMBER ONE..SOGDIAN NUMBER ONE HUNDRED
	{0x10F55, 0x10F59, prN},   // Po     [5] SOGDIAN PUNCTUATION TWO VERTICAL BARS..SOGDIAN PUNCTUATION HALF CIRCLE WITH DOT
	{0x10F70, 0x10F81, prN},   // Lo    [18] OLD UYGHUR LETTER ALEPH..OLD UYGHUR LETTER LESH
	{0x10F82, 0x10F85, prN},   // Mn     [4] OLD UYGHUR COMBINING DOT ABOVE..OLD UYGHUR COMBINING TWO DOTS BELOW
	{0x10F86, 0x10F89, prN},   // Po     [4] OLD UYGHUR PUNCTUATION BAR..OLD UYGHUR PUNCTUATION FOUR DOTS
	{0x10FB0, 0x10FC4, prN},   // Lo    [21] CHORASMIAN LETTER ALEPH..CHORASMIAN LETTER TAW
	{0x10FC5, 0x10FCB, prN},   // No     [7] CHORASMIAN NUMBER ONE..CHORASMIAN NUMBER ONE HUNDRED
	{0x10FE0, 0x10FF6, prN},   // Lo    [23] ELYMAIC LETTER ALEPH..ELYMAIC LIGATURE ZAYIN-YODH
	{0x11000, 0x11000, prN},   // Mc         BRAHMI SIGN CANDRABINDU
	{0x11001, 0x11001, prN},   // Mn         BRAHMI SIGN ANUSVARA
	{0x11002, 0x11002, prN},   // Mc         BRAHMI SIGN VISARGA
	{0x11003, 0x11037, prN},   // Lo    [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
	{0x11038, 0x11046, prN},   // Mn    [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
	{0x11047, 0x1104D, prN},   // Po     [7] BRAHMI DANDA..BRAHMI PUNCTUATION LOTUS
	{0x11052, 0x11065, prN},   // No    [20] BRAHMI NUMBER ONE..BRAHMI NUMBER ONE THOUSAND
	{0x11066, 0x1106F, prN},   // Nd    [10] BRAHMI DIGIT ZERO..BRAHMI DIGIT NINE
	{0x11070, 0x11070, prN},   // Mn         BRAHMI SIGN OLD TAMIL VIRAMA
	{0x11071, 0x11072, prN},   // Lo     [2] BRAHMI LETTER OLD TAMIL SHORT E..BRAHMI LETTER OLD TAMIL SHORT O
	{0x11073, 0x11074, prN},   // Mn     [2] BRAHMI VOWEL SIGN OLD TAMIL SHORT E..BRAHMI VOWEL SIGN OLD TAMIL SHORT O
	{0x11075, 0x11075, prN},   // Lo         BRAHMI LETTER OLD TAMIL LLA
	{0x1107F, 0x1107F, prN},   // Mn         BRAHMI NUMBER JOINER
	{0x11080, 0x11081, prN},   // Mn     [2] KAITHI SIGN CANDRABINDU..KAITHI SIGN ANUSVARA
	{0x11082, 0x11082, prN},   // Mc         KAITHI SIGN VISARGA
	{0x11083, 0x110AF, prN},   // Lo    [45] KAITHI LETTER A..KAITHI LETTER HA
	{0x110B0, 0x110B2, prN},   // Mc     [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
	{0x110B3, 0x110B6, prN},   // Mn     [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
	{0x110B7, 0x110B8, prN},   // Mc     [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
	{0x110B9, 0x110BA, prN},   // Mn     [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
	{0x110BB, 0x110BC, prN},   // Po     [2] KAITHI ABBREVIATION SIGN..KAITHI ENUMERATION SIGN
	{0x110BD, 0x110BD, prN},   // Cf         KAITHI NUMBER SIGN
	{0x110BE, 0x110C1, prN},   // Po     [4] KAITHI SECTION MARK..KAITHI DOUBLE DANDA
	{0x110C2, 0x110C2, prN},   // Mn         KAITHI VOWEL SIGN VOCALIC R
	{0x110CD, 0x110CD, prN},   // Cf         KAITHI NUMBER SIGN ABOVE
	{0x110D0, 0x110E8, prN},   // Lo    [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
	{0x110F0, 0x110F9, prN},   // Nd    [10] SORA SOMPENG DIGIT ZERO..SORA SOMPENG DIGIT NINE
	{0x11100, 0x11102, prN},   // Mn     [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
	{0x11103, 0x11126, prN},   // Lo    [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
	{0x11127, 0x1112B, prN},   // Mn     [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
	{0x1112C, 0x1112C, prN},   // Mc         CHAKMA VOWEL SIGN E
	{0x1112D, 0x11134, prN},   // Mn     [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
	{0x11136, 0x1113F, prN},   // Nd    [10] CHAKMA DIGIT ZERO..CHAKMA DIGIT NINE
	{0x11140, 0x11143, prN},   // Po     [4] CHAKMA SECTION MARK..CHAKMA QUESTION MARK
	{0x11144, 0x11144, prN},   // Lo         CHAKMA LETTER LHAA
	{0x11145, 0x11146, prN},   // Mc     [2] CHAKMA VOWEL SIGN AA..CHAKMA VOWEL SIGN EI
	{0x11147, 0x11147, prN},   // Lo         CHAKMA LETTER VAA
	{0x11150, 0x11172, prN},   // Lo    [35] MAHAJANI LETTER A..MAHAJANI LETTER RRA
	{0x11173, 0x11173, prN},   // Mn         MAHAJANI SIGN NUKTA
	{0x11174, 0x11175, prN},   // Po     [2] MAHAJANI ABBREVIATION SIGN..MAHAJANI SECTION MARK
	{0x11176, 0x11176, prN},   // Lo         MAHAJANI LIGATURE SHRI
	{0x11180, 0x11181, prN},   // Mn     [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
	{0x11182, 0x11182, prN},   // Mc         SHARADA SIGN VISARGA
	{0x11183, 0x111B2, prN},   // Lo    [48] SHARADA LETTER A..SHARADA LETTER HA
	{0x111B3, 0x111B5, prN},   // Mc     [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
	{0x111B6, 0x111BE, prN},   // Mn     [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
	{0x111BF, 0x111C0, prN},   // Mc     [2] SHARADA VOWEL SIGN AU..SHARADA SIGN VIRAMA
	{0x111C1, 0x111C4, prN},   // Lo     [4] SHARADA SIGN AVAGRAHA..SHARADA OM
	{0x111C5, 0x111C8, prN},   // Po     [4] SHARADA DANDA..SHARADA SEPARATOR
	{0x111C9, 0x111CC, prN},   // Mn     [4] SHARADA SANDHI MARK..SHARADA EXTRA SHORT VOWEL MARK
	{0x111CD, 0x111CD, prN},   // Po         SHARADA SUTRA MARK
	{0x111CE, 0x111CE, prN},   // Mc         SHARADA VOWEL SIGN PRISHTHAMATRA E
	{0x111CF, 0x111CF, prN},   // Mn         SHARADA SIGN INVERTED CANDRABINDU
	{0x111D0, 0x111D9, prN},   // Nd    [10] SHARADA DIGIT ZERO..SHARADA DIGIT NINE
	{0x111DA, 0x111DA, prN},   // Lo         SHARADA EKAM
	{0x111DB, 0x111DB, prN},   // Po         SHARADA SIGN SIDDHAM
	{0x111DC, 0x111DC, prN},   // Lo         SHARADA HEADSTROKE
	{0x111DD, 0x111DF, prN},   // Po     [3] SHARADA CONTINUATION SIGN..SHARADA SECTION MARK-2
	{0x111E1, 0x111F4, prN},   // No    [20] SINHALA ARCHAIC DIGIT ONE..SINHALA ARCHAIC NUMBER ONE THOUSAND
	{0x11200, 0x11211, prN},   // Lo    [18] KHOJKI LETTER A..KHOJKI LETTER JJA
	{0x11213, 0x1122B, prN},   // Lo    [25] KHOJKI LETTER NYA..KHOJKI LETTER LLA
	{0x1122C, 0x1122E, prN},   // Mc     [3] KHOJKI VOWEL SIGN AA..KHOJKI VOWEL SIGN II
	{0x1122F, 0x11231, prN},   // Mn     [3] KHOJKI VOWEL SIGN U..KHOJKI VOWEL SIGN AI
	{0x11232, 0x11233, prN},   // Mc     [2] KHOJKI VOWEL SIGN O..KHOJKI VOWEL SIGN AU
	{0x11234, 0x11234, prN},   // Mn         KHOJKI SIGN ANUSVARA
	{0x11235, 0x11235, prN},   // Mc         KHOJKI SIGN VIRAMA
	{0x11236, 0x11237, prN},   // Mn     [2] KHOJKI SIGN NUKTA..KHOJKI SIGN SHADDA
	{0x11238, 0x1123D, prN},   // Po     [6] KHOJKI DANDA..KHOJKI ABBREVIATION SIGN
	{0x1123E, 0x1123E, prN},   // Mn         KHOJKI SIGN SUKUN
	{0x1123F, 0x11240, prN},   // Lo     [2] KHOJKI LETTER QA..KHOJKI LETTER SHORT I
	{0x11241, 0x11241, prN},   // Mn         KHOJKI VOWEL SIGN VOCALIC R
	{0x11280, 0x11286, prN},   // Lo     [7] MULTANI LETTER A..MULTANI LETTER GA
	{0x11288, 0x11288, prN},   // Lo         MULTANI LETTER GHA
	{0x1128A, 0x1128D, prN},   // Lo     [4] MULTANI LETTER CA..MULTANI LETTER JJA
	{0x1128F, 0x1129D, prN},   // Lo    [15] MULTANI LETTER NYA..MULTANI LETTER BA
	{0x1129F, 0x112A8, prN},   // Lo    [10] MULTANI LETTER BHA..MULTANI LETTER RHA
	{0x112A9, 0x112A9, prN},   // Po         MULTANI SECTION MARK
	{0x112B0, 0x112DE, prN},   // Lo    [47] KHUDAWADI LETTER A..KHUDAWADI LETTER HA
	{0x112DF, 0x112DF, prN},   // Mn         KHUDAWADI SIGN ANUSVARA
	{0x112E0, 0x112E2, prN},   // Mc     [3] KHUDAWADI VOWEL SIGN AA..KHUDAWADI VOWEL SIGN II
	{0x112E3, 0x112EA, prN},   // Mn     [8] KHUDAWADI VOWEL SIGN U..KHUDAWADI SIGN VIRAMA
	{0x112F0, 0x112F9, prN},   // Nd    [10] KHUDAWADI DIGIT ZERO..KHUDAWADI DIGIT NINE
	{0x11300, 0x11301, prN},   // Mn     [2] GRANTHA SIGN COMBINING ANUSVARA ABOVE..GRANTHA SIGN CANDRABINDU
	{0x11302, 0x11303, prN},   // Mc     [2] GRANTHA SIGN ANUSVARA..GRANTHA SIGN VISARGA
	{0x11305, 0x1130C, prN},   // Lo     [8] GRANTHA LETTER A..GRANTHA LETTER VOCALIC L
	{0x1130F, 0x11310, prN},   // Lo     [2] GRANTHA LETTER EE..GRANTHA LETTER AI
	{0x11313, 0x11328, prN},   // Lo    [22] GRANTHA LETTER OO..GRANTHA LETTER NA
	{0x1132A, 0x11330, prN},   // Lo     [7] GRANTHA LETTER PA..GRANTHA LETTER RA
	{0x11332, 0x11333, prN},   // Lo     [2] GRANTHA LETTER LA..GRANTHA LETTER LLA
	{0x11335, 0x11339, prN},   // Lo     [5] GRANTHA LETTER VA..GRANTHA LETTER HA
	{0x1133B, 0x1133C, prN},   // Mn     [2] COMBINING BINDU BELOW..GRANTHA SIGN NUKTA
	{0x1133D, 0x1133D, prN},   // Lo         GRANTHA SIGN AVAGRAHA
	{0x1133E, 0x1133F, prN},   // Mc     [2] GRANTHA VOWEL SIGN AA..GRANTHA VOWEL SIGN I
	{0x11340, 0x11340, prN},   // Mn         GRANTHA VOWEL SIGN II
	{0x11341, 0x11344, prN},   // Mc     [4] GRANTHA VOWEL SIGN U..GRANTHA VOWEL SIGN VOCALIC RR
	{0x11347, 0x11348, prN},   // Mc     [2] GRANTHA VOWEL SIGN EE..GRANTHA VOWEL SIGN AI
	{0x1134B, 0x1134D, prN},   // Mc     [3] GRANTHA VOWEL SIGN OO..GRANTHA SIGN VIRAMA
	{0x11350, 0x11350, prN},   // Lo         GRANTHA OM
	{0x11357, 0x11357, prN},   // Mc         GRANTHA AU LENGTH MARK
	{0x1135D, 0x11361, prN},   // Lo     [5] GRANTHA SIGN PLUTA..GRANTHA LETTER VOCALIC LL
	{0x11362, 0x11363, prN},   // Mc     [2] GRANTHA VOWEL SIGN VOCALIC L..GRANTHA VOWEL SIGN VOCALIC LL
	{0x11366, 0x1136C, prN},   // Mn     [7] COMBINING GRANTHA DIGIT ZERO..COMBINING GRANTHA DIGIT SIX
	{0x11370, 0x11374, prN},   // Mn     [5] COMBINING GRANTHA LETTER A..COMBINING GRANTHA LETTER PA
	{0x11400, 0x11434, prN},   // Lo    [53] NEWA LETTER A..NEWA LETTER HA
	{0x11435, 0x11437, prN},   // Mc     [3] NEWA VOWEL SIGN AA..NEWA VOWEL SIGN II
	{0x11438, 0x1143F, prN},   // Mn     [8] NEWA VOWEL SIGN U..NEWA VOWEL SIGN AI
	{0x11440, 0x11441, prN},   // Mc     [2] NEWA VOWEL SIGN O..NEWA VOWEL SIGN AU
	{0x11442, 0x11444, prN},   // Mn     [3] NEWA SIGN VIRAMA..NEWA SIGN ANUSVARA
	{0x11445, 0x11445, prN},   // Mc         NEWA SIGN VISARGA
	{0x11446, 0x11446, prN},   // Mn         NEWA SIGN NUKTA
	{0x11447, 0x1144A, prN},   // Lo     [4] NEWA SIGN AVAGRAHA..NEWA SIDDHI
	{0x1144B, 0x1144F, prN},   // Po     [5] NEWA DANDA..NEWA ABBREVIATION SIGN
	{0x11450, 0x11459, prN},   // Nd    [10] NEWA DIGIT ZERO..NEWA DIGIT NINE
	{0x1145A, 0x1145B, prN},   // Po     [2] NEWA DOUBLE COMMA..NEWA PLACEHOLDER MARK
	{0x1145D, 0x1145D, prN},   // Po         NEWA INSERTION SIGN
	{0x1145E, 0x1145E, prN},   // Mn         NEWA SANDHI MARK
	{0x1145F, 0x11461, prN},   // Lo     [3] NEWA LETTER VEDIC ANUSVARA..NEWA SIGN UPADHMANIYA
	{0x11480, 0x114AF, prN},   // Lo    [48] TIRHUTA ANJI..TIRHUTA LETTER HA
	{0x114B0, 0x114B2, prN},   // Mc     [3] TIRHUTA VOWEL SIGN AA..TIRHUTA VOWEL SIGN II
	{0x114B3, 0x114B8, prN},   // Mn     [6] TIRHUTA VOWEL SIGN U..TIRHUTA VOWEL SIGN VOCALIC LL
	{0x114B9, 0x114B9, prN},   // Mc         TIRHUTA VOWEL SIGN E
	{0x114BA, 0x114BA, prN},   // Mn         TIRHUTA VOWEL SIGN SHORT E
	{0x114BB, 0x114BE, prN},   // Mc     [4] TIRHUTA VOWEL SIGN AI..TIRHUTA VOWEL SIGN AU
	{0x114BF, 0x114C0, prN},   // Mn     [2] TIRHUTA SIGN CANDRABINDU..TIRHUTA SIGN ANUSVARA
	{0x114C1, 0x114C1, prN},   // Mc         TIRHUTA SIGN VISARGA
	{0x114C2, 0x114C3, prN},   // Mn     [2] TIRHUTA SIGN VIRAMA..TIRHUTA SIGN NUKTA
	{0x114C4, 0x114C5, prN},   // Lo     [2] TIRHUTA SIGN AVAGRAHA..TIRHUTA GVANG
	{0x114C6, 0x114C6, prN},   // Po         TIRHUTA ABBREVIATION SIGN
	{0x114C7, 0x114C7, prN},   // Lo         TIRHUTA OM
	{0x114D0, 0x114D9, prN},   // Nd    [10] TIRHUTA DIGIT ZERO..TIRHUTA DIGIT NINE
	{0x11580, 0x115AE, prN},   // Lo    [47] SIDDHAM LETTER A..SIDDHAM LETTER HA
	{0x115AF, 0x115B1, prN},   // Mc     [3] SIDDHAM VOWEL SIGN AA..SIDDHAM VOWEL SIGN II
	{0x115B2, 0x115B5, prN},   // Mn     [4] SIDDHAM VOWEL SIGN U..SIDDHAM VOWEL SIGN VOCALIC RR
	{0x115B8, 0x115BB, prN},   // Mc     [4] SIDDHAM VOWEL SIGN E..SIDDHAM VOWEL SIGN AU
	{0x115BC, 0x115BD, prN},   // Mn     [2] SIDDHAM SIGN CANDRABINDU..SIDDHAM SIGN ANUSVARA
	{0x115BE, 0x115BE, prN},   // Mc         SIDDHAM SIGN VISARGA
	{0x115BF, 0x115C0, prN},   // Mn     [2] SIDDHAM SIGN VIRAMA..SIDDHAM SIGN NUKTA
	{0x115C1, 0x115D7, prN},   // Po    [23] SIDDHAM SIGN SIDDHAM..SIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURES
	{0x115D8, 0x115DB, prN},   // Lo     [4] SIDDHAM LETTER THREE-CIRCLE ALTERNATE I..SIDDHAM LETTER ALTERNATE U
	{0x115DC, 0x115DD, prN},   // Mn     [2] SIDDHAM VOWEL SIGN ALTERNATE U..SIDDHAM VOWEL SIGN ALTERNATE UU
	{0x11600, 0x1162F, prN},   // Lo    [48] MODI LETTER A..MODI LETTER LLA
	{0x11630, 0x11632, prN},   // Mc     [3] MODI VOWEL SIGN AA..MODI VOWEL SIGN II
	{0x11633, 0x1163A, prN},   // Mn     [8] MODI VOWEL SIGN U..MODI VOWEL SIGN AI
	{0x1163B, 0x1163C, prN},   // Mc     [2] MODI VOWEL SIGN O..MODI VOWEL SIGN AU
	{0x1163D, 0x1163D, prN},   // Mn         MODI SIGN ANUSVARA
	{0x1163E, 0x1163E, prN},   // Mc         MODI SIGN VISARGA
	{0x1163F, 0x11640, prN},   // Mn     [2] MODI SIGN VIRAMA..MODI SIGN ARDHACANDRA
	{0x11641, 0x11643, prN},   // Po     [3] MODI DANDA..MODI ABBREVIATION SIGN
	{0x11644, 0x11644, prN},   // Lo         MODI SIGN HUVA
	{0x11650, 0x11659, prN},   // Nd    [10] MODI DIGIT ZERO..MODI DIGIT NINE
	{0x11660, 0x1166C, prN},   // Po    [13] MONGOLIAN BIRGA WITH ORNAMENT..MONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENT
	{0x11680, 0x116AA, prN},   // Lo    [43] TAKRI LETTER A..TAKRI LETTER RRA
	{0x116AB, 0x116AB, prN},   // Mn         TAKRI SIGN ANUSVARA
	{0x116AC, 0x116AC, prN},   // Mc         TAKRI SIGN VISARGA
	{0x116AD, 0x116AD, prN},   // Mn         TAKRI VOWEL SIGN AA
	{0x116AE, 0x116AF, prN},   // Mc     [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
	{0x116B0, 0x116B5, prN},   // Mn     [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
	{0x116B6, 0x116B6, prN},   // Mc         TAKRI SIGN VIRAMA
	{0x116B7, 0x116B7, prN},   // Mn         TAKRI SIGN NUKTA
	{0x116B8, 0x116B8, prN},   // Lo         TAKRI LETTER ARCHAIC KHA
	{0x116B9, 0x116B9, prN},   // Po         TAKRI ABBREVIATION SIGN
	{0x116C0, 0x116C9, prN},   // Nd    [10] TAKRI DIGIT ZERO..TAKRI DIGIT NINE
	{0x11700, 0x1171A, prN},   // Lo    [27] AHOM LETTER KA..AHOM LETTER ALTERNATE BA
	{0x1171D, 0x1171F, prN},   // Mn     [3] AHOM CONSONANT SIGN MEDIAL LA..AHOM CONSONANT SIGN MEDIAL LIGATING RA
	{0x11720, 0x11721, prN},   // Mc     [2] AHOM VOWEL SIGN A..AHOM VOWEL SIGN AA
	{0x11722, 0x11725, prN},   // Mn     [4] AHOM VOWEL SIGN I..AHOM VOWEL SIGN UU
	{0x11726, 0x11726, prN},   // Mc         AHOM VOWEL SIGN E
	{0x11727, 0x1172B, prN},   // Mn     [5] AHOM VOWEL SIGN AW..AHOM SIGN KILLER
	{0x11730, 0x11739, prN},   // Nd    [10] AHOM DIGIT ZERO..AHOM DIGIT NINE
	{0x1173A, 0x1173B, prN},   // No     [2] AHOM NUMBER TEN..AHOM NUMBER TWENTY
	{0x1173C, 0x1173E, prN},   // Po     [3] AHOM SIGN SMALL SECTION..AHOM SIGN RULAI
	{0x1173F, 0x1173F, prN},   // So         AHOM SYMBOL VI
	{0x11740, 0x11746, prN},   // Lo     [7] AHOM LETTER CA..AHOM LETTER LLA
	{0x11800, 0x1182B, prN},   // Lo    [44] DOGRA LETTER A..DOGRA LETTER RRA
	{0x1182C, 0x1182E, prN},   // Mc     [3] DOGRA VOWEL SIGN AA..DOGRA VOWEL SIGN II
	{0x1182F, 0x11837, prN},   // Mn     [9] DOGRA VOWEL SIGN U..DOGRA SIGN ANUSVARA
	{0x11838, 0x11838, prN},   // Mc         DOGRA SIGN VISARGA
	{0x11839, 0x1183A, prN},   // Mn     [2] DOGRA SIGN VIRAMA..DOGRA SIGN NUKTA
	{0x1183B, 0x1183B, prN},   // Po         DOGRA ABBREVIATION SIGN
	{0x118A0, 0x118DF, prN},   // L&    [64] WARANG CITI CAPITAL LETTER NGAA..WARANG CITI SMALL LETTER VIYO
	{0x118E0, 0x118E9, prN},   // Nd    [10] WARANG CITI DIGIT ZERO..WARANG CITI DIGIT NINE
	{0x118EA, 0x118F2, prN},   // No     [9] WARANG CITI NUMBER TEN..WARANG CITI NUMBER NINETY
	{0x118FF, 0x118FF, prN},   // Lo         WARANG CITI OM
	{0x11900, 0x11906, prN},   // Lo     [7] DIVES AKURU LETTER A..DIVES AKURU LETTER E
	{0x11909, 0x11909, prN},   // Lo         DIVES AKURU LETTER O
	{0x1190C, 0x11913, prN},   // Lo     [8] DIVES AKURU LETTER KA..DIVES AKURU LETTER JA
	{0x11915, 0x11916, prN},   // Lo     [2] DIVES AKURU LETTER NYA..DIVES AKURU LETTER TTA
	{0x11918, 0x1192F, prN},   // Lo    [24] DIVES AKURU LETTER DDA..DIVES AKURU LETTER ZA
	{0x11930, 0x11935, prN},   // Mc     [6] DIVES AKURU VOWEL SIGN AA..DIVES AKURU VOWEL SIGN E
	{0x11937, 0x11938, prN},   // Mc     [2] DIVES AKURU VOWEL SIGN AI..DIVES AKURU VOWEL SIGN O
	{0x1193B, 0x1193C, prN},   // Mn     [2] DIVES AKURU SIGN ANUSVARA..DIVES AKURU SIGN CANDRABINDU
	{0x1193D, 0x1193D, prN},   // Mc         DIVES AKURU SIGN HALANTA
	{0x1193E, 0x1193E, prN},   // Mn         DIVES AKURU VIRAMA
	{0x1193F, 0x1193F, prN},   // Lo         DIVES AKURU PREFIXED NASAL SIGN
	{0x11940, 0x11940, prN},   // Mc         DIVES AKURU MEDIAL YA
	{0x11941, 0x11941, prN},   // Lo         DIVES AKURU INITIAL RA
	{0x11942, 0x11942, prN},   // Mc         DIVES AKURU MEDIAL RA
	{0x11943, 0x11943, prN},   // Mn         DIVES AKURU SIGN NUKTA
	{0x11944, 0x11946, prN},   // Po     [3] DIVES AKURU DOUBLE DANDA..DIVES AKURU END OF TEXT MARK
	{0x11950, 0x11959, prN},   // Nd    [10] DIVES AKURU DIGIT ZERO..DIVES AKURU DIGIT NINE
	{0x119A0, 0x119A7, prN},   // Lo     [8] NANDINAGARI LETTER A..NANDINAGARI LETTER VOCALIC RR
	{0x119AA, 0x119D0, prN},   // Lo    [39] NANDINAGARI LETTER E..NANDINAGARI LETTER RRA
	{0x119D1, 0x119D3, prN},   // Mc     [3] NANDINAGARI VOWEL SIGN AA..NANDINAGARI VOWEL SIGN II
	{0x119D4, 0x119D7, prN},   // Mn     [4] NANDINAGARI VOWEL SIGN U..NANDINAGARI VOWEL SIGN VOCALIC RR
	{0x119DA, 0x119DB, prN},   // Mn     [2] NANDINAGARI VOWEL SIGN E..NANDINAGARI VOWEL SIGN AI
	{0x119DC, 0x119DF, prN},   // Mc     [4] NANDINAGARI VOWEL SIGN O..NANDINAGARI SIGN VISARGA
	{0x119E0, 0x119E0, prN},   // Mn         NANDINAGARI SIGN VIRAMA
	{0x119E1, 0x119E1, prN},   // Lo         NANDINAGARI SIGN AVAGRAHA
	{0x119E2, 0x119E2, prN},   // Po         NANDINAGARI SIGN SIDDHAM
	{0x119E3, 0x119E3, prN},   // Lo         NANDINAGARI HEADSTROKE
	{0x119E4, 0x119E4, prN},   // Mc         NANDINAGARI VOWEL SIGN PRISHTHAMATRA E
	{0x11A00, 0x11A00, prN},   // Lo         ZANABAZAR SQUARE LETTER A
	{0x11A01, 0x11A0A, prN},   // Mn    [10] ZANABAZAR SQUARE VOWEL SIGN I..ZANABAZAR SQUARE VOWEL LENGTH MARK
	{0x11A0B, 0x11A32, prN},   // Lo    [40] ZANABAZAR SQUARE LETTER KA..ZANABAZAR SQUARE LETTER KSSA
	{0x11A33, 0x11A38, prN},   // Mn     [6] ZANABAZAR SQUARE FINAL CONSONANT MARK..ZANABAZAR SQUARE SIGN ANUSVARA
	{0x11A39, 0x11A39, prN},   // Mc         ZANABAZAR SQUARE SIGN VISARGA
	{0x11A3A, 0x11A3A, prN},   // Lo         ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA
	{0x11A3B, 0x11A3E, prN},   // Mn     [4] ZANABAZAR SQUARE CLUSTER-FINAL LETTER YA..ZANABAZAR SQUARE CLUSTER-FINAL LETTER VA
	{0x11A3F, 0x11A46, prN},   // Po     [8] ZANABAZAR SQUARE INITIAL HEAD MARK..ZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD MARK
	{0x11A47, 0x11A47, prN},   // Mn         ZANABAZAR SQUARE SUBJOINER
	{0x11A50, 0x11A50, prN},   // Lo         SOYOMBO LETTER A
	{0x11A51, 0x11A56, prN},   // Mn     [6] SOYOMBO VOWEL SIGN I..SOYOMBO VOWEL SIGN OE
	{0x11A57, 0x11A58, prN},   // Mc     [2] SOYOMBO VOWEL SIGN AI..SOYOMBO VOWEL SIGN AU
	{0x11A59, 0x11A5B, prN},   // Mn     [3] SOYOMBO VOWEL SIGN VOCALIC R..SOYOMBO VOWEL LENGTH MARK
	{0x11A5C, 0x11A89, prN},   // Lo    [46] SOYOMBO LETTER KA..SOYOMBO CLUSTER-INITIAL LETTER SA
	{0x11A8A, 0x11A96, prN},   // Mn    [13] SOYOMBO FINAL CONSONANT SIGN G..SOYOMBO SIGN ANUSVARA
	{0x11A97, 0x11A97, prN},   // Mc         SOYOMBO SIGN VISARGA
	{0x11A98, 0x11A99, prN},   // Mn     [2] SOYOMBO GEMINATION MARK..SOYOMBO SUBJOINER
	{0x11A9A, 0x11A9C, prN},   // Po     [3] SOYOMBO MARK TSHEG..SOYOMBO MARK DOUBLE SHAD
	{0x11A9D, 0x11A9D, prN},   // Lo         SOYOMBO MARK PLUTA
	{0x11A9E, 0x11AA2, prN},   // Po     [5] SOYOMBO HEAD MARK WITH MOON AND SUN AND TRIPLE FLAME..SOYOMBO TERMINAL MARK-2
	{0x11AB0, 0x11ABF, prN},   // Lo    [16] CANADIAN SYLLABICS NATTILIK HI..CANADIAN SYLLABICS SPA
	{0x11AC0, 0x11AF8, prN},   // Lo    [57] PAU CIN HAU LETTER PA..PAU CIN HAU GLOTTAL STOP FINAL
	{0x11B00, 0x11B09, prN},   // Po    [10] DEVANAGARI HEAD MARK..DEVANAGARI SIGN MINDU
	{0x11C00, 0x11C08, prN},   // Lo     [9] BHAIKSUKI LETTER A..BHAIKSUKI LETTER VOCALIC L
	{0x11C0A, 0x11C2E, prN},   // Lo    [37] BHAIKSUKI LETTER E..BHAIKSUKI LETTER HA
	{0x11C2F, 0x11C2F, prN},   // Mc         BHAIKSUKI VOWEL SIGN AA
	{0x11C30, 0x11C36, prN},   // Mn     [7] BHAIKSUKI VOWEL SIGN I..BHAIKSUKI VOWEL SIGN VOCALIC L
	{0x11C38, 0x11C3D, prN},   // Mn     [6] BHAIKSUKI VOWEL SIGN E..BHAIKSUKI SIGN ANUSVARA
	{0x11C3E, 0x11C3E, prN},   // Mc         BHAIKSUKI SIGN VISARGA
	{0x11C3F, 0x11C3F, prN},   // Mn         BHAIKSUKI SIGN VIRAMA
	{0x11C40, 0x11C40, prN},   // Lo         BHAIKSUKI SIGN AVAGRAHA
	{0x11C41, 0x11C45, prN},   // Po     [5] BHAIKSUKI DANDA..BHAIKSUKI GAP FILLER-2
	{0x11C50, 0x11C59, prN},   // Nd    [10] BHAIKSUKI DIGIT ZERO..BHAIKSUKI DIGIT NINE
	{0x11C5A, 0x11C6C, prN},   // No    [19] BHAIKSUKI NUMBER ONE..BHAIKSUKI HUNDREDS UNIT MARK
	{0x11C70, 0x11C71, prN},   // Po     [2] MARCHEN HEAD MARK..MARCHEN MARK SHAD
	{0x11C72, 0x11C8F, prN},   // Lo    [30] MARCHEN LETTER KA..MARCHEN LETTER A
	{0x11C92, 0x11CA7, prN},   // Mn    [22] MARCHEN SUBJOINED LETTER KA..MARCHEN SUBJOINED LETTER ZA
	{0x11CA9, 0x11CA9, prN},   // Mc         MARCHEN SUBJOINED LETTER YA
	{0x11CAA, 0x11CB0, prN},   // Mn     [7] MARCHEN SUBJOINED LETTER RA..MARCHEN VOWEL SIGN AA
	{0x11CB1, 0x11CB1, prN},   // Mc         MARCHEN VOWEL SIGN I
	{0x11CB2, 0x11CB3, prN},   // Mn     [2] MARCHEN VOWEL SIGN U..MARCHEN VOWEL SIGN E
	{0x11CB4, 0x11CB4, prN},   // Mc         MARCHEN VOWEL SIGN O
	{0x11CB5, 0x11CB6, prN},   // Mn     [2] MARCHEN SIGN ANUSVARA..MARCHEN SIGN CANDRABINDU
	{0x11D00, 0x11D06, prN},   // Lo     [7] MASARAM GONDI LETTER A..MASARAM GONDI LETTER E
	{0x11D08, 0x11D09, prN},   // Lo     [2] MASARAM GONDI LETTER AI..MASARAM GONDI LETTER O
	{0x11D0B, 0x11D30, prN},   // Lo    [38] MASARAM GONDI LETTER AU..MASARAM GONDI LETTER TRA
	{0x11D31, 0x11D36, prN},   // Mn     [6] MASARAM GONDI VOWEL SIGN AA..MASARAM GONDI VOWEL SIGN VOCALIC R
	{0x11D3A, 0x11D3A, prN},   // Mn         MASARAM GONDI VOWEL SIGN E
	{0x11D3C, 0x11D3D, prN},   // Mn     [2] MASARAM GONDI VOWEL SIGN AI..MASARAM GONDI VOWEL SIGN O
	{0x11D3F, 0x11D45, prN},   // Mn     [7] MASARAM GONDI VOWEL SIGN AU..MASARAM GONDI VIRAMA
	{0x11D46, 0x11D46, prN},   // Lo         MASARAM GONDI REPHA
	{0x11D47, 0x11D47, prN},   // Mn         MASARAM GONDI RA-KARA
	{0x11D50, 0x11D59, prN},   // Nd    [10] MASARAM GONDI DIGIT ZERO..MASARAM GONDI DIGIT NINE
	{0x11D60, 0x11D65, prN},   // Lo     [6] GUNJALA GONDI LETTER A..GUNJALA GONDI LETTER UU
	{0x11D67, 0x11D68, prN},   // Lo     [2] GUNJALA GONDI LETTER EE..GUNJALA GONDI LETTER AI
	{0x11D6A, 0x11D89, prN},   // Lo    [32] GUNJALA GONDI LETTER OO..GUNJALA GONDI LETTER SA
	{0x11D8A, 0x11D8E, prN},   // Mc     [5] GUNJALA GONDI VOWEL SIGN AA..GUNJALA GONDI VOWEL SIGN UU
	{0x11D90, 0x11D91, prN},   // Mn     [2] GUNJALA GONDI VOWEL SIGN EE..GUNJALA GONDI VOWEL SIGN AI
	{0x11D93, 0x11D94, prN},   // Mc     [2] GUNJALA GONDI VOWEL SIGN OO..GUNJALA GONDI VOWEL SIGN AU
	{0x11D95, 0x11D95, prN},   // Mn         GUNJALA GONDI SIGN ANUSVARA
	{0x11D96, 0x11D96, prN},   // Mc         GUNJALA GONDI SIGN VISARGA
	{0x11D97, 0x11D97, prN},   // Mn         GUNJALA GONDI VIRAMA
	{0x11D98, 0x11D98, prN},   // Lo         GUNJALA GONDI OM
	{0x11DA0, 0x11DA9, prN},   // Nd    [10] GUNJALA GONDI DIGIT ZERO..GUNJALA GONDI DIGIT NINE
	{0x11EE0, 0x11EF2, prN},   // Lo    [19] MAKASAR LETTER KA..MAKASAR ANGKA
	{0x11EF3, 0x11EF4, prN},   // Mn     [2] MAKASAR VOWEL SIGN I..MAKASAR VOWEL SIGN U
	{0x11EF5, 0x11EF6, prN},   // Mc     [2] MAKASAR VOWEL SIGN E..MAKASAR VOWEL SIGN O
	{0x11EF7, 0x11EF8, prN},   // Po     [2] MAKASAR PASSIMBANG..MAKASAR END OF SECTION
	{0x11F00, 0x11F01, prN},   // Mn     [2] KAWI SIGN CANDRABINDU..KAWI SIGN ANUSVARA
	{0x11F02, 0x11F02, prN},   // Lo         KAWI SIGN REPHA
	{0x11F03, 0x11F03, prN},   // Mc         KAWI SIGN VISARGA
	{0x11F04, 0x11F10, prN},   // Lo    [13] KAWI LETTER A..KAWI LETTER O
	{0x11F12, 0x11F33, prN},   // Lo    [34] KAWI LETTER KA..KAWI LETTER JNYA
	{0x11F34, 0x11F35, prN},   // Mc     [2] KAWI VOWEL SIGN AA..KAWI VOWEL SIGN ALTERNATE AA
	{0x11F36, 0x11F3A, prN},   // Mn     [5] KAWI VOWEL SIGN I..KAWI VOWEL SIGN VOCALIC R
	{0x11F3E, 0x11F3F, prN},   // Mc     [2] KAWI VOWEL SIGN E..KAWI VOWEL SIGN AI
	{0x11F40, 0x11F40, prN},   // Mn         KAWI VOWEL SIGN EU
	{0x11F41, 0x11F41, prN},   // Mc         KAWI SIGN KILLER
	{0x11F42, 0x11F42, prN},   // Mn         KAWI CONJOINER
	{0x11F43, 0x11F4F, prN},   // Po    [13] KAWI DANDA..KAWI PUNCTUATION CLOSING SPIRAL
	{0x11F50, 0x11F59, prN},   // Nd    [10] KAWI DIGIT ZERO..KAWI DIGIT NINE
	{0x11FB0, 0x11FB0, prN},   // Lo         LISU LETTER YHA
	{0x11FC0, 0x11FD4, prN},   // No    [21] TAMIL FRACTION ONE THREE-HUNDRED-AND-TWENTIETH..TAMIL FRACTION DOWNSCALING FACTOR KIIZH
	{0x11FD5, 0x11FDC, prN},   // So     [8] TAMIL SIGN NEL..TAMIL SIGN MUKKURUNI
	{0x11FDD, 0x11FE0, prN},   // Sc     [4] TAMIL SIGN KAACU..TAMIL SIGN VARAAKAN
	{0x11FE1, 0x11FF1, prN},   // So    [17] TAMIL SIGN PAARAM..TAMIL SIGN VAKAIYARAA
	{0x11FFF, 0x11FFF, prN},   // Po         TAMIL PUNCTUATION END OF TEXT
	{0x12000, 0x12399, prN},   // Lo   [922] CUNEIFORM SIGN A..CUNEIFORM SIGN U U
	{0x12400, 0x1246E, prN},   // Nl   [111] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM
	{0x12470, 0x12474, prN},   // Po     [5] CUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDER..CUNEIFORM PUNCTUATION SIGN DIAGONAL QUADCOLON
	{0x12480, 0x12543, prN},   // Lo   [196] CUNEIFORM SIGN AB TIMES NUN TENU..CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU
	{0x12F90, 0x12FF0, prN},   // Lo    [97] CYPRO-MINOAN SIGN CM001..CYPRO-MINOAN SIGN CM114
	{0x12FF1, 0x12FF2, prN},   // Po     [2] CYPRO-MINOAN SIGN CM301..CYPRO-MINOAN SIGN CM302
	{0x13000, 0x1342F, prN},   // Lo  [1072] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH V011D
	{0x13430, 0x1343F, prN},   // Cf    [16] EGYPTIAN HIEROGLYPH VERTICAL JOINER..EGYPTIAN HIEROGLYPH END WALLED ENCLOSURE
	{0x13440, 0x13440, prN},   // Mn         EGYPTIAN HIEROGLYPH MIRROR HORIZONTALLY
	{0x13441, 0x13446, prN},   // Lo     [6] EGYPTIAN HIEROGLYPH FULL BLANK..EGYPTIAN HIEROGLYPH WIDE LOST SIGN
	{0x13447, 0x13455, prN},   // Mn    [15] EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP START..EGYPTIAN HIEROGLYPH MODIFIER DAMAGED
	{0x14400, 0x14646, prN},   // Lo   [583] ANATOLIAN HIEROGLYPH A001..ANATOLIAN HIEROGLYPH A530
	{0x16800, 0x16A38, prN},   // Lo   [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
	{0x16A40, 0x16A5E, prN},   // Lo    [31] MRO LETTER TA..MRO LETTER TEK
	{0x16A60, 0x16A69, prN},   // Nd    [10] MRO DIGIT ZERO..MRO DIGIT NINE
	{0x16A6E, 0x16A6F, prN},   // Po     [2] MRO DANDA..MRO DOUBLE DANDA
	{0x16A70, 0x16ABE, prN},   // Lo    [79] TANGSA LETTER OZ..TANGSA LETTER ZA
	{0x16AC0, 0x16AC9, prN},   // Nd    [10] TANGSA DIGIT ZERO..TANGSA DIGIT NINE
	{0x16AD0, 0x16AED, prN},   // Lo    [30] BASSA VAH LETTER ENNI..BASSA VAH LETTER I
	{0x16AF0, 0x16AF4, prN},   // Mn     [5] BASSA VAH COMBINING HIGH TONE..BASSA VAH COMBINING HIGH-LOW TONE
	{0x16AF5, 0x16AF5, prN},   // Po         BASSA VAH FULL STOP
	{0x16B00, 0x16B2F, prN},   // Lo    [48] PAHAWH HMONG VOWEL KEEB..PAHAWH HMONG CONSONANT CAU
	{0x16B30, 0x16B36, prN},   // Mn     [7] PAHAWH HMONG MARK CIM TUB..PAHAWH HMONG MARK CIM TAUM
	{0x16B37, 0x16B3B, prN},   // Po     [5] PAHAWH HMONG SIGN VOS THOM..PAHAWH HMONG SIGN VOS FEEM
	{0x16B3C, 0x16B3F, prN},   // So     [4] PAHAWH HMONG SIGN XYEEM NTXIV..PAHAWH HMONG SIGN XYEEM FAIB
	{0x16B40, 0x16B43, prN},   // Lm     [4] PAHAWH HMONG SIGN VOS SEEV..PAHAWH HMONG SIGN IB YAM
	{0x16B44, 0x16B44, prN},   // Po         PAHAWH HMONG SIGN XAUS
	{0x16B45, 0x16B45, prN},   // So         PAHAWH HMONG SIGN CIM TSOV ROG
	{0x16B50, 0x16B59, prN},   // Nd    [10] PAHAWH HMONG DIGIT ZERO..PAHAWH HMONG DIGIT NINE
	{0x16B5B, 0x16B61, prN},   // No     [7] PAHAWH HMONG NUMBER TENS..PAHAWH HMONG NUMBER TRILLIONS
	{0x16B63, 0x16B77, prN},   // Lo    [21] PAHAWH HMONG SIGN VOS LUB..PAHAWH HMONG SIGN CIM NRES TOS
	{0x16B7D, 0x16B8F, prN},   // Lo    [19] PAHAWH HMONG CLAN SIGN TSHEEJ..PAHAWH HMONG CLAN SIGN VWJ
	{0x16E40, 0x16E7F, prN},   // L&    [64] MEDEFAIDRIN CAPITAL LETTER M..MEDEFAIDRIN SMALL LETTER Y
	{0x16E80, 0x16E96, prN},   // No    [23] MEDEFAIDRIN DIGIT ZERO..MEDEFAIDRIN DIGIT THREE ALTERNATE FORM
	{0x16E97, 0x16E9A, prN},   // Po     [4] MEDEFAIDRIN COMMA..MEDEFAIDRIN EXCLAMATION OH
	{0x16F00, 0x16F4A, prN},   // Lo    [75] MIAO LETTER PA..MIAO LETTER RTE
	{0x16F4F, 0x16F4F, prN},   // Mn         MIAO SIGN CONSONANT MODIFIER BAR
	{0x16F50, 0x16F50, prN},   // Lo         MIAO LETTER NASALIZATION
	{0x16F51, 0x16F87, prN},   // Mc    [55] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN UI
	{0x16F8F, 0x16F92, prN},   // Mn     [4] MIAO TONE RIGHT..MIAO TONE BELOW
	{0x16F93, 0x16F9F, prN},   // Lm    [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
	{0x16FE0, 0x16FE1, prW},   // Lm     [2] TANGUT ITERATION MARK..NUSHU ITERATION MARK
	{0x16FE2, 0x16FE2, prW},   // Po         OLD CHINESE HOOK MARK
	{0x16FE3, 0x16FE3, prW},   // Lm         OLD CHINESE ITERATION MARK
	{0x16FE4, 0x16FE4, prW},   // Mn         KHITAN SMALL SCRIPT FILLER
	{0x16FF0, 0x16FF1, prW},   // Mc     [2] VIETNAMESE ALTERNATE READING MARK CA..VIETNAMESE ALTERNATE READING MARK NHAY
	{0x17000, 0x187F7, prW},   // Lo  [6136] TANGUT IDEOGRAPH-17000..TANGUT IDEOGRAPH-187F7
	{0x18800, 0x18AFF, prW},   // Lo   [768] TANGUT COMPONENT-001..TANGUT COMPONENT-768
	{0x18B00, 0x18CD5, prW},   // Lo   [470] KHITAN SMALL SCRIPT CHARACTER-18B00..KHITAN SMALL SCRIPT CHARACTER-18CD5
	{0x18D00, 0x18D08, prW},   // Lo     [9] TANGUT IDEOGRAPH-18D00..TANGUT IDEOGRAPH-18D08
	{0x1AFF0, 0x1AFF3, prW},   // Lm     [4] KATAKANA LETTER MINNAN TONE-2..KATAKANA LETTER MINNAN TONE-5
	{0x1AFF5, 0x1AFFB, prW},   // Lm     [7] KATAKANA LETTER MINNAN TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-5
	{0x1AFFD, 0x1AFFE, prW},   // Lm     [2] KATAKANA LETTER MINNAN NASALIZED TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-8
	{0x1B000, 0x1B0FF, prW},   // Lo   [256] KATAKANA LETTER ARCHAIC E..HENTAIGANA LETTER RE-2
	{0x1B100, 0x1B122, prW},   // Lo    [35] HENTAIGANA LETTER RE-3..KATAKANA LETTER ARCHAIC WU
	{0x1B132, 0x1B132, prW},   // Lo         HIRAGANA LETTER SMALL KO
	{0x1B150, 0x1B152, prW},   // Lo     [3] HIRAGANA LETTER SMALL WI..HIRAGANA LETTER SMALL WO
	{0x1B155, 0x1B155, prW},   // Lo         KATAKANA LETTER SMALL KO
	{0x1B164, 0x1B167, prW},   // Lo     [4] KATAKANA LETTER SMALL WI..KATAKANA LETTER SMALL N
	{0x1B170, 0x1B2FB, prW},   // Lo   [396] NUSHU CHARACTER-1B170..NUSHU CHARACTER-1B2FB
	{0x1BC00, 0x1BC6A, prN},   // Lo   [107] DUPLOYAN LETTER H..DUPLOYAN LETTER VOCALIC M
	{0x1BC70, 0x1BC7C, prN},   // Lo    [13] DUPLOYAN AFFIX LEFT HORIZONTAL SECANT..DUPLOYAN AFFIX ATTACHED TANGENT HOOK
	{0x1BC80, 0x1BC88, prN},   // Lo     [9] DUPLOYAN AFFIX HIGH ACUTE..DUPLOYAN AFFIX HIGH VERTICAL
	{0x1BC90, 0x1BC99, prN},   // Lo    [10] DUPLOYAN AFFIX LOW ACUTE..DUPLOYAN AFFIX LOW ARROW
	{0x1BC9C, 0x1BC9C, prN},   // So         DUPLOYAN SIGN O WITH CROSS
	{0x1BC9D, 0x1BC9E, prN},   // Mn     [2] DUPLOYAN THICK LETTER SELECTOR..DUPLOYAN DOUBLE MARK
	{0x1BC9F, 0x1BC9F, prN},   // Po         DUPLOYAN PUNCTUATION CHINOOK FULL STOP
	{0x1BCA0, 0x1BCA3, prN},   // Cf     [4] SHORTHAND FORMAT LETTER OVERLAP..SHORTHAND FORMAT UP STEP
	{0x1CF00, 0x1CF2D, prN},   // Mn    [46] ZNAMENNY COMBINING MARK GORAZDO NIZKO S KRYZHEM ON LEFT..ZNAMENNY COMBINING MARK KRYZH ON LEFT
	{0x1CF30, 0x1CF46, prN},   // Mn    [23] ZNAMENNY COMBINING TONAL RANGE MARK MRACHNO..ZNAMENNY PRIZNAK MODIFIER ROG
	{0x1CF50, 0x1CFC3, prN},   // So   [116] ZNAMENNY NEUME KRYUK..ZNAMENNY NEUME PAUK
	{0x1D000, 0x1D0F5, prN},   // So   [246] BYZANTINE MUSICAL SYMBOL PSILI..BYZANTINE MUSICAL SYMBOL GORGON NEO KATO
	{0x1D100, 0x1D126, prN},   // So    [39] MUSICAL SYMBOL SINGLE BARLINE..MUSICAL SYMBOL DRUM CLEF-2
	{0x1D129, 0x1D164, prN},   // So    [60] MUSICAL SYMBOL MULTIPLE MEASURE REST..MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
	{0x1D165, 0x1D166, prN},   // Mc     [2] MUSICAL SYMBOL COMBINING STEM..MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
	{0x1D167, 0x1D169, prN},   // Mn     [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
	{0x1D16A, 0x1D16C, prN},   // So     [3] MUSICAL SYMBOL FINGERED TREMOLO-1..MUSICAL SYMBOL FINGERED TREMOLO-3
	{0x1D16D, 0x1D172, prN},   // Mc     [6] MUSICAL SYMBOL COMBINING AUGMENTATION DOT..MUSICAL SYMBOL COMBINING FLAG-5
	{0x1D173, 0x1D17A, prN},   // Cf     [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
	{0x1D17B, 0x1D182, prN},   // Mn     [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
	{0x1D183, 0x1D184, prN},   // So     [2] MUSICAL SYMBOL ARPEGGIATO UP..MUSICAL SYMBOL ARPEGGIATO DOWN
	{0x1D185, 0x1D18B, prN},   // Mn     [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
	{0x1D18C, 0x1D1A9, prN},   // So    [30] MUSICAL SYMBOL RINFORZANDO..MUSICAL SYMBOL DEGREE SLASH
	{0x1D1AA, 0x1D1AD, prN},   // Mn     [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
	{0x1D1AE, 0x1D1EA, prN},   // So    [61] MUSICAL SYMBOL PEDAL MARK..MUSICAL SYMBOL KORON
	{0x1D200, 0x1D241, prN},   // So    [66] GREEK VOCAL NOTATION SYMBOL-1..GREEK INSTRUMENTAL NOTATION SYMBOL-54
	{0x1D242, 0x1D244, prN},   // Mn     [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
	{0x1D245, 0x1D245, prN},   // So         GREEK MUSICAL LEIMMA
	{0x1D2C0, 0x1D2D3, prN},   // No    [20] KAKTOVIK NUMERAL ZERO..KAKTOVIK NUMERAL NINETEEN
	{0x1D2E0, 0x1D2F3, prN},   // No    [20] MAYAN NUMERAL ZERO..MAYAN NUMERAL NINETEEN
	{0x1D300, 0x1D356, prN},   // So    [87] MONOGRAM FOR EARTH..TETRAGRAM FOR FOSTERING
	{0x1D360, 0x1D378, prN},   // No    [25] COUNTING ROD UNIT DIGIT ONE..TALLY MARK FIVE
	{0x1D400, 0x1D454, prN},   // L&    [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
	{0x1D456, 0x1D49C, prN},   // L&    [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
	{0x1D49E, 0x1D49F, prN},   // Lu     [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
	{0x1D4A2, 0x1D4A2, prN},   // Lu         MATHEMATICAL SCRIPT CAPITAL G
	{0x1D4A5, 0x1D4A6, prN},   // Lu     [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
	{0x1D4A9, 0x1D4AC, prN},   // Lu     [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
	{0x1D4AE, 0x1D4B9, prN},   // L&    [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
	{0x1D4BB, 0x1D4BB, prN},   // Ll         MATHEMATICAL SCRIPT SMALL F
	{0x1D4BD, 0x1D4C3, prN},   // Ll     [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
	{0x1D4C5, 0x1D505, prN},   // L&    [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
	{0x1D507, 0x1D50A, prN},   // Lu     [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
	{0x1D50D, 0x1D514, prN},   // Lu     [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
	{0x1D516, 0x1D51C, prN},   // Lu     [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
	{0x1D51E, 0x1D539, prN},   // L&    [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
	{0x1D53B, 0x1D53E, prN},   // Lu     [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
	{0x1D540, 0x1D544, prN},   // Lu     [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
	{0x1D546, 0x1D546, prN},   // Lu         MATHEMATICAL DOUBLE-STRUCK CAPITAL O
	{0x1D54A, 0x1D550, prN},   // Lu     [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
	{0x1D552, 0x1D6A5, prN},   // L&   [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
	{0x1D6A8, 0x1D6C0, prN},   // Lu    [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
	{0x1D6C1, 0x1D6C1, prN},   // Sm         MATHEMATICAL BOLD NABLA
	{0x1D6C2, 0x1D6DA, prN},   // Ll    [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
	{0x1D6DB, 0x1D6DB, prN},   // Sm         MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
	{0x1D6DC, 0x1D6FA, prN},   // L&    [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
	{0x1D6FB, 0x1D6FB, prN},   // Sm         MATHEMATICAL ITALIC NABLA
	{0x1D6FC, 0x1D714, prN},   // Ll    [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
	{0x1D715, 0x1D715, prN},   // Sm         MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
	{0x1D716, 0x1D734, prN},   // L&    [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
	{0x1D735, 0x1D735, prN},   // Sm         MATHEMATICAL BOLD ITALIC NABLA
	{0x1D736, 0x1D74E, prN},   // Ll    [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
	{0x1D74F, 0x1D74F, prN},   // Sm         MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
	{0x1D750, 0x1D76E, prN},   // L&    [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
	{0x1D76F, 0x1D76F, prN},   // Sm         MATHEMATICAL SANS-SERIF BOLD NABLA
	{0x1D770, 0x1D788, prN},   // Ll    [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
	{0x1D789, 0x1D789, prN},   // Sm         MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
	{0x1D78A, 0x1D7A8, prN},   // L&    [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
	{0x1D7A9, 0x1D7A9, prN},   // Sm         MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
	{0x1D7AA, 0x1D7C2, prN},   // Ll    [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
	{0x1D7C3, 0x1D7C3, prN},   // Sm         MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
	{0x1D7C4, 0x1D7CB, prN},   // L&     [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
	{0x1D7CE, 0x1D7FF, prN},   // Nd    [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
	{0x1D800, 0x1D9FF, prN},   // So   [512] SIGNWRITING HAND-FIST INDEX..SIGNWRITING HEAD
	{0x1DA00, 0x1DA36, prN},   // Mn    [55] SIGNWRITING HEAD RIM..SIGNWRITING AIR SUCKING IN
	{0x1DA37, 0x1DA3A, prN},   // So     [4] SIGNWRITING AIR BLOW SMALL ROTATIONS..SIGNWRITING BREATH EXHALE
	{0x1DA3B, 0x1DA6C, prN},   // Mn    [50] SIGNWRITING MOUTH CLOSED NEUTRAL..SIGNWRITING EXCITEMENT
	{0x1DA6D, 0x1DA74, prN},   // So     [8] SIGNWRITING SHOULDER HIP SPINE..SIGNWRITING TORSO-FLOORPLANE TWISTING
	{0x1DA75, 0x1DA75, prN},   // Mn         SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS
	{0x1DA76, 0x1DA83, prN},   // So    [14] SIGNWRITING LIMB COMBINATION..SIGNWRITING LOCATION DEPTH
	{0x1DA84, 0x1DA84, prN},   // Mn         SIGNWRITING LOCATION HEAD NECK
	{0x1DA85, 0x1DA86, prN},   // So     [2] SIGNWRITING LOCATION TORSO..SIGNWRITING LOCATION LIMBS DIGITS
	{0x1DA87, 0x1DA8B, prN},   // Po     [5] SIGNWRITING COMMA..SIGNWRITING PARENTHESIS
	{0x1DA9B, 0x1DA9F, prN},   // Mn     [5] SIGNWRITING FILL MODIFIER-2..SIGNWRITING FILL MODIFIER-6
	{0x1DAA1, 0x1DAAF, prN},   // Mn    [15] SIGNWRITING ROTATION MODIFIER-2..SIGNWRITING ROTATION MODIFIER-16
	{0x1DF00, 0x1DF09, prN},   // Ll    [10] LATIN SMALL LETTER FENG DIGRAPH WITH TRILL..LATIN SMALL LETTER T WITH HOOK AND RETROFLEX HOOK
	{0x1DF0A, 0x1DF0A, prN},   // Lo         LATIN LETTER RETROFLEX CLICK WITH RETROFLEX HOOK
	{0x1DF0B, 0x1DF1E, prN},   // Ll    [20] LATIN SMALL LETTER ESH WITH DOUBLE BAR..LATIN SMALL LETTER S WITH CURL
	{0x1DF25, 0x1DF2A, prN},   // Ll     [6] LATIN SMALL LETTER D WITH MID-HEIGHT LEFT HOOK..LATIN SMALL LETTER T WITH MID-HEIGHT LEFT HOOK
	{0x1E000, 0x1E006, prN},   // Mn     [7] COMBINING GLAGOLITIC LETTER AZU..COMBINING GLAGOLITIC LETTER ZHIVETE
	{0x1E008, 0x1E018, prN},   // Mn    [17] COMBINING GLAGOLITIC LETTER ZEMLJA..COMBINING GLAGOLITIC LETTER HERU
	{0x1E01B, 0x1E021, prN},   // Mn     [7] COMBINING GLAGOLITIC LETTER SHTA..COMBINING GLAGOLITIC LETTER YATI
	{0x1E023, 0x1E024, prN},   // Mn     [2] COMBINING GLAGOLITIC LETTER YU..COMBINING GLAGOLITIC LETTER SMALL YUS
	{0x1E026, 0x1E02A, prN},   // Mn     [5] COMBINING GLAGOLITIC LETTER YO..COMBINING GLAGOLITIC LETTER FITA
	{0x1E030, 0x1E06D, prN},   // Lm    [62] MODIFIER LETTER CYRILLIC SMALL A..MODIFIER LETTER CYRILLIC SMALL STRAIGHT U WITH STROKE
	{0x1E08F, 0x1E08F, prN},   // Mn         COMBINING CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
	{0x1E100, 0x1E12C, prN},   // Lo    [45] NYIAKENG PUACHUE HMONG LETTER MA..NYIAKENG PUACHUE HMONG LETTER W
	{0x1E130, 0x1E136, prN},   // Mn     [7] NYIAKENG PUACHUE HMONG TONE-B..NYIAKENG PUACHUE HMONG TONE-D
	{0x1E137, 0x1E13D, prN},   // Lm     [7] NYIAKENG PUACHUE HMONG SIGN FOR PERSON..NYIAKENG PUACHUE HMONG SYLLABLE LENGTHENER
	{0x1E140, 0x1E149, prN},   // Nd    [10] NYIAKENG PUACHUE HMONG DIGIT ZERO..NYIAKENG PUACHUE HMONG DIGIT NINE
	{0x1E14E, 0x1E14E, prN},   // Lo         NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ
	{0x1E14F, 0x1E14F, prN},   // So         NYIAKENG PUACHUE HMONG CIRCLED CA
	{0x1E290, 0x1E2AD, prN},   // Lo    [30] TOTO LETTER PA..TOTO LETTER A
	{0x1E2AE, 0x1E2AE, prN},   // Mn         TOTO SIGN RISING TONE
	{0x1E2C0, 0x1E2EB, prN},   // Lo    [44] WANCHO LETTER AA..WANCHO LETTER YIH
	{0x1E2EC, 0x1E2EF, prN},   // Mn     [4] WANCHO TONE TUP..WANCHO TONE KOINI
	{0x1E2F0, 0x1E2F9, prN},   // Nd    [10] WANCHO DIGIT ZERO..WANCHO DIGIT NINE
	{0x1E2FF, 0x1E2FF, prN},   // Sc         WANCHO NGUN SIGN
	{0x1E4D0, 0x1E4EA, prN},   // Lo    [27] NAG MUNDARI LETTER O..NAG MUNDARI LETTER ELL
	{0x1E4EB, 0x1E4EB, prN},   // Lm         NAG MUNDARI SIGN OJOD
	{0x1E4EC, 0x1E4EF, prN},   // Mn     [4] NAG MUNDARI SIGN MUHOR..NAG MUNDARI SIGN SUTUH
	{0x1E4F0, 0x1E4F9, prN},   // Nd    [10] NAG MUNDARI DIGIT ZERO..NAG MUNDARI DIGIT NINE
	{0x1E7E0, 0x1E7E6, prN},   // Lo     [7] ETHIOPIC SYLLABLE HHYA..ETHIOPIC SYLLABLE HHYO
	{0x1E7E8, 0x1E7EB, prN},   // Lo     [4] ETHIOPIC SYLLABLE GURAGE HHWA..ETHIOPIC SYLLABLE HHWE
	{0x1E7ED, 0x1E7EE, prN},   // Lo     [2] ETHIOPIC SYLLABLE GURAGE MWI..ETHIOPIC SYLLABLE GURAGE MWEE
	{0x1E7F0, 0x1E7FE, prN},   // Lo    [15] ETHIOPIC SYLLABLE GURAGE QWI..ETHIOPIC SYLLABLE GURAGE PWEE
	{0x1E800, 0x1E8C4, prN},   // Lo   [197] MENDE KIKAKUI SYLLABLE M001 KI..MENDE KIKAKUI SYLLABLE M060 NYON
	{0x1E8C7, 0x1E8CF, prN},   // No     [9] MENDE KIKAKUI DIGIT ONE..MENDE KIKAKUI DIGIT NINE
	{0x1E8D0, 0x1E8D6, prN},   // Mn     [7] MENDE KIKAKUI COMBINING NUMBER TEENS..MENDE KIKAKUI COMBINING NUMBER MILLIONS
	{0x1E900, 0x1E943, prN},   // L&    [68] ADLAM CAPITAL LETTER ALIF..ADLAM SMALL LETTER SHA
	{0x1E944, 0x1E94A, prN},   // Mn     [7] ADLAM ALIF LENGTHENER..ADLAM NUKTA
	{0x1E94B, 0x1E94B, prN},   // Lm         ADLAM NASALIZATION MARK
	{0x1E950, 0x1E959, prN},   // Nd    [10] ADLAM DIGIT ZERO..ADLAM DIGIT NINE
	{0x1E95E, 0x1E95F, prN},   // Po     [2] ADLAM INITIAL EXCLAMATION MARK..ADLAM INITIAL QUESTION MARK
	{0x1EC71, 0x1ECAB, prN},   // No    [59] INDIC SIYAQ NUMBER ONE..INDIC SIYAQ NUMBER PREFIXED NINE
	{0x1ECAC, 0x1ECAC, prN},   // So         INDIC SIYAQ PLACEHOLDER
	{0x1ECAD, 0x1ECAF, prN},   // No     [3] INDIC SIYAQ FRACTION ONE QUARTER..INDIC SIYAQ FRACTION THREE QUARTERS
	{0x1ECB0, 0x1ECB0, prN},   // Sc         INDIC SIYAQ RUPEE MARK
	{0x1ECB1, 0x1ECB4, prN},   // No     [4] INDIC SIYAQ NUMBER ALTERNATE ONE..INDIC SIYAQ ALTERNATE LAKH MARK
	{0x1ED01, 0x1ED2D, prN},   // No    [45] OTTOMAN SIYAQ NUMBER ONE..OTTOMAN SIYAQ NUMBER NINETY THOUSAND
	{0x1ED2E, 0x1ED2E, prN},   // So         OTTOMAN SIYAQ MARRATAN
	{0x1ED2F, 0x1ED3D, prN},   // No    [15] OTTOMAN SIYAQ ALTERNATE NUMBER TWO..OTTOMAN SIYAQ FRACTION ONE SIXTH
	{0x1EE00, 0x1EE03, prN},   // Lo     [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
	{0x1EE05, 0x1EE1F, prN},   // Lo    [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
	{0x1EE21, 0x1EE22, prN},   // Lo     [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
	{0x1EE24, 0x1EE24, prN},   // Lo         ARABIC MATHEMATICAL INITIAL HEH
	{0x1EE27, 0x1EE27, prN},   // Lo         ARABIC MATHEMATICAL INITIAL HAH
	{0x1EE29, 0x1EE32, prN},   // Lo    [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
	{0x1EE34, 0x1EE37, prN},   // Lo     [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
	{0x1EE39, 0x1EE39, prN},   // Lo         ARABIC MATHEMATICAL INITIAL DAD
	{0x1EE3B, 0x1EE3B, prN},   // Lo         ARABIC MATHEMATICAL INITIAL GHAIN
	{0x1EE42, 0x1EE42, prN},   // Lo         ARABIC MATHEMATICAL TAILED JEEM
	{0x1EE47, 0x1EE47, prN},   // Lo         ARABIC MATHEMATICAL TAILED HAH
	{0x1EE49, 0x1EE49, prN},   // Lo         ARABIC MATHEMATICAL TAILED YEH
	{0x1EE4B, 0x1EE4B, prN},   // Lo         ARABIC MATHEMATICAL TAILED LAM
	{0x1EE4D, 0x1EE4F, prN},   // Lo     [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
	{0x1EE51, 0x1EE52, prN},   // Lo     [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
	{0x1EE54, 0x1EE54, prN},   // Lo         ARABIC MATHEMATICAL TAILED SHEEN
	{0x1EE57, 0x1EE57, prN},   // Lo         ARABIC MATHEMATICAL TAILED KHAH
	{0x1EE59, 0x1EE59, prN},   // Lo         ARABIC MATHEMATICAL TAILED DAD
	{0x1EE5B, 0x1EE5B, prN},   // Lo         ARABIC MATHEMATICAL TAILED GHAIN
	{0x1EE5D, 0x1EE5D, prN},   // Lo         ARABIC MATHEMATICAL TAILED DOTLESS NOON
	{0x1EE5F, 0x1EE5F, prN},   // Lo         ARABIC MATHEMATICAL TAILED DOTLESS QAF
	{0x1EE61, 0x1EE62, prN},   // Lo     [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
	{0x1EE64, 0x1EE64, prN},   // Lo         ARABIC MATHEMATICAL STRETCHED HEH
	{0x1EE67, 0x1EE6A, prN},   // Lo     [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
	{0x1EE6C, 0x1EE72, prN},   // Lo     [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
	{0x1EE74, 0x1EE77, prN},   // Lo     [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
	{0x1EE79, 0x1EE7C, prN},   // Lo     [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
	{0x1EE7E, 0x1EE7E, prN},   // Lo         ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
	{0x1EE80, 0x1EE89, prN},   // Lo    [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
	{0x1EE8B, 0x1EE9B, prN},   // Lo    [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
	{0x1EEA1, 0x1EEA3, prN},   // Lo     [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
	{0x1EEA5, 0x1EEA9, prN},   // Lo     [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
	{0x1EEAB, 0x1EEBB, prN},   // Lo    [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
	{0x1EEF0, 0x1EEF1, prN},   // Sm     [2] ARABIC MATHEMATICAL OPERATOR MEEM WITH HAH WITH TATWEEL..ARABIC MATHEMATICAL OPERATOR HAH WITH DAL
	{0x1F000, 0x1F003, prN},   // So     [4] MAHJONG TILE EAST WIND..MAHJONG TILE NORTH WIND
	{0x1F004, 0x1F004, prW},   // So         MAHJONG TILE RED DRAGON
	{0x1F005, 0x1F02B, prN},   // So    [39] MAHJONG TILE GREEN DRAGON..MAHJONG TILE BACK
	{0x1F030, 0x1F093, prN},   // So   [100] DOMINO TILE HORIZONTAL BACK..DOMINO TILE VERTICAL-06-06
	{0x1F0A0, 0x1F0AE, prN},   // So    [15] PLAYING CARD BACK..PLAYING CARD KING OF SPADES
	{0x1F0B1, 0x1F0BF, prN},   // So    [15] PLAYING CARD ACE OF HEARTS..PLAYING CARD RED JOKER
	{0x1F0C1, 0x1F0CE, prN},   // So    [14] PLAYING CARD ACE OF DIAMONDS..PLAYING CARD KING OF DIAMONDS
	{0x1F0CF, 0x1F0CF, prW},   // So         PLAYING CARD BLACK JOKER
	{0x1F0D1, 0x1F0F5, prN},   // So    [37] PLAYING CARD ACE OF CLUBS..PLAYING CARD TRUMP-21
	{0x1F100, 0x1F10A, prA},   // No    [11] DIGIT ZERO FULL STOP..DIGIT NINE COMMA
	{0x1F10B, 0x1F10C, prN},   // No     [2] DINGBAT CIRCLED SANS-SERIF DIGIT ZERO..DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO
	{0x1F10D, 0x1F10F, prN},   // So     [3] CIRCLED ZERO WITH SLASH..CIRCLED DOLLAR SIGN WITH OVERLAID BACKSLASH
	{0x1F110, 0x1F12D, prA},   // So    [30] PARENTHESIZED LATIN CAPITAL LETTER A..CIRCLED CD
	{0x1F12E, 0x1F12F, prN},   // So     [2] CIRCLED WZ..COPYLEFT SYMBOL
	{0x1F130, 0x1F169, prA},   // So    [58] SQUARED LATIN CAPITAL LETTER A..NEGATIVE CIRCLED LATIN CAPITAL LETTER Z
	{0x1F16A, 0x1F16F, prN},   // So     [6] RAISED MC SIGN..CIRCLED HUMAN FIGURE
	{0x1F170, 0x1F18D, prA},   // So    [30] NEGATIVE SQUARED LATIN CAPITAL LETTER A..NEGATIVE SQUARED SA
	{0x1F18E, 0x1F18E, prW},   // So         NEGATIVE SQUARED AB
	{0x1F18F, 0x1F190, prA},   // So     [2] NEGATIVE SQUARED WC..SQUARE DJ
	{0x1F191, 0x1F19A, prW},   // So    [10] SQUARED CL..SQUARED VS
	{0x1F19B, 0x1F1AC, prA},   // So    [18] SQUARED THREE D..SQUARED VOD
	{0x1F1AD, 0x1F1AD, prN},   // So         MASK WORK SYMBOL
	{0x1F1E6, 0x1F1FF, prN},   // So    [26] REGIONAL INDICATOR SYMBOL LETTER A..REGIONAL INDICATOR SYMBOL LETTER Z
	{0x1F200, 0x1F202, prW},   // So     [3] SQUARE HIRAGANA HOKA..SQUARED KATAKANA SA
	{0x1F210, 0x1F23B, prW},   // So    [44] SQUARED CJK UNIFIED IDEOGRAPH-624B..SQUARED CJK UNIFIED IDEOGRAPH-914D
	{0x1F240, 0x1F248, prW},   // So     [9] TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C..TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
	{0x1F250, 0x1F251, prW},   // So     [2] CIRCLED IDEOGRAPH ADVANTAGE..CIRCLED IDEOGRAPH ACCEPT
	{0x1F260, 0x1F265, prW},   // So     [6] ROUNDED SYMBOL FOR FU..ROUNDED SYMBOL FOR CAI
	{0x1F300, 0x1F320, prW},   // So    [33] CYCLONE..SHOOTING STAR
	{0x1F321, 0x1F32C, prN},   // So    [12] THERMOMETER..WIND BLOWING FACE
	{0x1F32D, 0x1F335, prW},   // So     [9] HOT DOG..CACTUS
	{0x1F336, 0x1F336, prN},   // So         HOT PEPPER
	{0x1F337, 0x1F37C, prW},   // So    [70] TULIP..BABY BOTTLE
	{0x1F37D, 0x1F37D, prN},   // So         FORK AND KNIFE WITH PLATE
	{0x1F37E, 0x1F393, prW},   // So    [22] BOTTLE WITH POPPING CORK..GRADUATION CAP
	{0x1F394, 0x1F39F, prN},   // So    [12] HEART WITH TIP ON THE LEFT..ADMISSION TICKETS
	{0x1F3A0, 0x1F3CA, prW},   // So    [43] CAROUSEL HORSE..SWIMMER
	{0x1F3CB, 0x1F3CE, prN},   // So     [4] WEIGHT LIFTER..RACING CAR
	{0x1F3CF, 0x1F3D3, prW},   // So     [5] CRICKET BAT AND BALL..TABLE TENNIS PADDLE AND BALL
	{0x1F3D4, 0x1F3DF, prN},   // So    [12] SNOW CAPPED MOUNTAIN..STADIUM
	{0x1F3E0, 0x1F3F0, prW},   // So    [17] HOUSE BUILDING..EUROPEAN CASTLE
	{0x1F3F1, 0x1F3F3, prN},   // So     [3] WHITE PENNANT..WAVING WHITE FLAG
	{0x1F3F4, 0x1F3F4, prW},   // So         WAVING BLACK FLAG
	{0x1F3F5, 0x1F3F7, prN},   // So     [3] ROSETTE..LABEL
	{0x1F3F8, 0x1F3FA, prW},   // So     [3] BADMINTON RACQUET AND SHUTTLECOCK..AMPHORA
	{0x1F3FB, 0x1F3FF, prW},   // Sk     [5] EMOJI MODIFIER FITZPATRICK TYPE-1-2..EMOJI MODIFIER FITZPATRICK TYPE-6
	{0x1F400, 0x1F43E, prW},   // So    [63] RAT..PAW PRINTS
	{0x1F43F, 0x1F43F, prN},   // So         CHIPMUNK
	{0x1F440, 0x1F440, prW},   // So         EYES
	{0x1F441, 0x1F441, prN},   // So         EYE
	{0x1F442, 0x1F4FC, prW},   // So   [187] EAR..VIDEOCASSETTE
	{0x1F4FD, 0x1F4FE, prN},   // So     [2] FILM PROJECTOR..PORTABLE STEREO
	{0x1F4FF, 0x1F53D, prW},   // So    [63] PRAYER BEADS..DOWN-POINTING SMALL RED TRIANGLE
	{0x1F53E, 0x1F54A, prN},   // So    [13] LOWER RIGHT SHADOWED WHITE CIRCLE..DOVE OF PEACE
	{0x1F54B, 0x1F54E, prW},   // So     [4] KAABA..MENORAH WITH NINE BRANCHES
	{0x1F54F, 0x1F54F, prN},   // So         BOWL OF HYGIEIA
	{0x1F550, 0x1F567, prW},   // So    [24] CLOCK FACE ONE OCLOCK..CLOCK FACE TWELVE-THIRTY
	{0x1F568, 0x1F579, prN},   // So    [18] RIGHT SPEAKER..JOYSTICK
	{0x1F57A, 0x1F57A, prW},   // So         MAN DANCING
	{0x1F57B, 0x1F594, prN},   // So    [26] LEFT HAND TELEPHONE RECEIVER..REVERSED VICTORY HAND
	{0x1F595, 0x1F596, prW},   // So     [2] REVERSED HAND WITH MIDDLE FINGER EXTENDED..RAISED HAND WITH PART BETWEEN MIDDLE AND RING FINGERS
	{0x1F597, 0x1F5A3, prN},   // So    [13] WHITE DOWN POINTING LEFT HAND INDEX..BLACK DOWN POINTING BACKHAND INDEX
	{0x1F5A4, 0x1F5A4, prW},   // So         BLACK HEART
	{0x1F5A5, 0x1F5FA, prN},   // So    [86] DESKTOP COMPUTER..WORLD MAP
	{0x1F5FB, 0x1F5FF, prW},   // So     [5] MOUNT FUJI..MOYAI
	{0x1F600, 0x1F64F, prW},   // So    [80] GRINNING FACE..PERSON WITH FOLDED HANDS
	{0x1F650, 0x1F67F, prN},   // So    [48] NORTH WEST POINTING LEAF..REVERSE CHECKER BOARD
	{0x1F680, 0x1F6C5, prW},   // So    [70] ROCKET..LEFT LUGGAGE
	{0x1F6C6, 0x1F6CB, prN},   // So     [6] TRIANGLE WITH ROUNDED CORNERS..COUCH AND LAMP
	{0x1F6CC, 0x1F6CC, prW},   // So         SLEEPING ACCOMMODATION
	{0x1F6CD, 0x1F6CF, prN},   // So     [3] SHOPPING BAGS..BED
	{0x1F6D0, 0x1F6D2, prW},   // So     [3] PLACE OF WORSHIP..SHOPPING TROLLEY
	{0x1F6D3, 0x1F6D4, prN},   // So     [2] STUPA..PAGODA
	{0x1F6D5, 0x1F6D7, prW},   // So     [3] HINDU TEMPLE..ELEVATOR
	{0x1F6DC, 0x1F6DF, prW},   // So     [4] WIRELESS..RING BUOY
	{0x1F6E0, 0x1F6EA, prN},   // So    [11] HAMMER AND WRENCH..NORTHEAST-POINTING AIRPLANE
	{0x1F6EB, 0x1F6EC, prW},   // So     [2] AIRPLANE DEPARTURE..AIRPLANE ARRIVING
	{0x1F6F0, 0x1F6F3, prN},   // So     [4] SATELLITE..PASSENGER SHIP
	{0x1F6F4, 0x1F6FC, prW},   // So     [9] SCOOTER..ROLLER SKATE
	{0x1F700, 0x1F776, prN},   // So   [119] ALCHEMICAL SYMBOL FOR QUINTESSENCE..LUNAR ECLIPSE
	{0x1F77B, 0x1F77F, prN},   // So     [5] HAUMEA..ORCUS
	{0x1F780, 0x1F7D9, prN},   // So    [90] BLACK LEFT-POINTING ISOSCELES RIGHT TRIANGLE..NINE POINTED WHITE STAR
	{0x1F7E0, 0x1F7EB, prW},   // So    [12] LARGE ORANGE CIRCLE..LARGE BROWN SQUARE
	{0x1F7F0, 0x1F7F0, prW},   // So         HEAVY EQUALS SIGN
	{0x1F800, 0x1F80B, prN},   // So    [12] LEFTWARDS ARROW WITH SMALL TRIANGLE ARROWHEAD..DOWNWARDS ARROW WITH LARGE TRIANGLE ARROWHEAD
	{0x1F810, 0x1F847, prN},   // So    [56] LEFTWARDS ARROW WITH SMALL EQUILATERAL ARROWHEAD..DOWNWARDS HEAVY ARROW
	{0x1F850, 0x1F859, prN},   // So    [10] LEFTWARDS SANS-SERIF ARROW..UP DOWN SANS-SERIF ARROW
	{0x1F860, 0x1F887, prN},   // So    [40] WIDE-HEADED LEFTWARDS LIGHT BARB ARROW..WIDE-HEADED SOUTH WEST VERY HEAVY BARB ARROW
	{0x1F890, 0x1F8AD, prN},   // So    [30] LEFTWARDS TRIANGLE ARROWHEAD..WHITE ARROW SHAFT WIDTH TWO THIRDS
	{0x1F8B0, 0x1F8B1, prN},   // So     [2] ARROW POINTING UPWARDS THEN NORTH WEST..ARROW POINTING RIGHTWARDS THEN CURVING SOUTH WEST
	{0x1F900, 0x1F90B, prN},   // So    [12] CIRCLED CROSS FORMEE WITH FOUR DOTS..DOWNWARD FACING NOTCHED HOOK WITH DOT
	{0x1F90C, 0x1F93A, prW},   // So    [47] PINCHED FINGERS..FENCER
	{0x1F93B, 0x1F93B, prN},   // So         MODERN PENTATHLON
	{0x1F93C, 0x1F945, prW},   // So    [10] WRESTLERS..GOAL NET
	{0x1F946, 0x1F946, prN},   // So         RIFLE
	{0x1F947, 0x1F9FF, prW},   // So   [185] FIRST PLACE MEDAL..NAZAR AMULET
	{0x1FA00, 0x1FA53, prN},   // So    [84] NEUTRAL CHESS KING..BLACK CHESS KNIGHT-BISHOP
	{0x1FA60, 0x1FA6D, prN},   // So    [14] XIANGQI RED GENERAL..XIANGQI BLACK SOLDIER
	{0x1FA70, 0x1FA7C, prW},   // So    [13] BALLET SHOES..CRUTCH
	{0x1FA80, 0x1FA88, prW},   // So     [9] YO-YO..FLUTE
	{0x1FA90, 0x1FABD, prW},   // So    [46] RINGED PLANET..WING
	{0x1FABF, 0x1FAC5, prW},   // So     [7] GOOSE..PERSON WITH CROWN
	{0x1FACE, 0x1FADB, prW},   // So    [14] MOOSE..PEA POD
	{0x1FAE0, 0x1FAE8, prW},   // So     [9] MELTING FACE..SHAKING FACE
	{0x1FAF0, 0x1FAF8, prW},   // So     [9] HAND WITH INDEX FINGER AND THUMB CROSSED..RIGHTWARDS PUSHING HAND
	{0x1FB00, 0x1FB92, prN},   // So   [147] BLOCK SEXTANT-1..UPPER HALF INVERSE MEDIUM SHADE AND LOWER HALF BLOCK
	{0x1FB94, 0x1FBCA, prN},   // So    [55] LEFT HALF INVERSE MEDIUM SHADE AND RIGHT HALF BLOCK..WHITE UP-POINTING CHEVRON
	{0x1FBF0, 0x1FBF9, prN},   // Nd    [10] SEGMENTED DIGIT ZERO..SEGMENTED DIGIT NINE
	{0x20000, 0x2A6DF, prW},   // Lo [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF
	{0x2A6E0, 0x2A6FF, prW},   // Cn    [32] <reserved-2A6E0>..<reserved-2A6FF>
	{0x2A700, 0x2B739, prW},   // Lo  [4154] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B739
	{0x2B73A, 0x2B73F, prW},   // Cn     [6] <reserved-2B73A>..<reserved-2B73F>
	{0x2B740, 0x2B81D, prW},   // Lo   [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
	{0x2B81E, 0x2B81F, prW},   // Cn     [2] <reserved-2B81E>..<reserved-2B81F>
	{0x2B820, 0x2CEA1, prW},   // Lo  [5762] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEA1
	{0x2CEA2, 0x2CEAF, prW},   // Cn    [14] <reserved-2CEA2>..<reserved-2CEAF>
	{0x2CEB0, 0x2EBE0, prW},   // Lo  [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0
	{0x2EBE1, 0x2F7FF, prW},   // Cn  [3103] <reserved-2EBE1>..<reserved-2F7FF>
	{0x2F800, 0x2FA1D, prW},   // Lo   [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
	{0x2FA1E, 0x2FA1F, prW},   // Cn     [2] <reserved-2FA1E>..<reserved-2FA1F>
	{0x2FA20, 0x2FFFD, prW},   // Cn  [1502] <reserved-2FA20>..<reserved-2FFFD>
	{0x30000, 0x3134A, prW},   // Lo  [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A
	{0x3134B, 0x3134F, prW},   // Cn     [5] <reserved-3134B>..<reserved-3134F>
	{0x31350, 0x323AF, prW},   // Lo  [4192] CJK UNIFIED IDEOGRAPH-31350..CJK UNIFIED IDEOGRAPH-323AF
	{0x323B0, 0x3FFFD, prW},   // Cn [56398] <reserved-323B0>..<reserved-3FFFD>
	{0xE0001, 0xE0001, prN},   // Cf         LANGUAGE TAG
	{0xE0020, 0xE007F, prN},   // Cf    [96] TAG SPACE..CANCEL TAG
	{0xE0100, 0xE01EF, prA},   // Mn   [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256
	{0xF0000, 0xFFFFD, prA},   // Co [65534] <private-use-F0000>..<private-use-FFFFD>
	{0x100000, 0x10FFFD, prA}, // Co [65534] <private-use-100000>..<private-use-10FFFD>
}
