Frontend Knowledge Structure
========
## 项目起源
还记得@jayli 的这幅前端知识结构图么。

![前端知识结构](https://raw.github.com/JacksonTian/fks/master/figures/fks.jpg)

图片的形式具有诸多的不便。缺失源图的我们，无法为此图贡献些什么，随着时间的迁移，或许有些技术点会发生改变，所以有了这个GitHub项目。我们可以通过协作的方式来共同维护这个项目。Git的历史记录也可以见证前端行业的一些变迁。

[可视化效果](http://html5ify.com/fks/fks_chart/)

## 前端开发知识结构
- 前端工程师
    - 浏览器
        - IE6/[7](http://www.microsoft.com/en-us/download/internet-explorer-7-details.aspx)/[8](http://windows.microsoft.com/en-US/internet-explorer/downloads/ie-8)/[9](http://windows.microsoft.com/en-US/internet-explorer/downloads/ie-9/worldwide-languages)/[10](http://windows.microsoft.com/en-US/internet-explorer/ie-10-worldwide-languages)/[11](http://windows.microsoft.com/en-US/internet-explorer/ie-11-worldwide-languages) (Trident) / [Edge](https://www.microsoft.com/en-us/windows/microsoft-edge) (EdgeHTML)
        - [Firefox](http://www.mozilla.org/en-US/) (Gecko)
        - [Chrome](http://www.google.com/chrome)/[Chromium](http://www.chromium.org/) (Blink)
        - [Safari](http://www.apple.com/safari/) (WebKit)
        - [Opera](http://www.opera.com/) (Blink)
    - 编程语言
        - [JavaScript](https://developer.mozilla.org/en-US/docs/JavaScript)/[Node.js](http://nodejs.org/)
        - [CoffeeScript](http://coffeescript.org/)
        - [TypeScript](http://www.typescriptlang.org/)
    - 切页面
        - [HTML](http://www.w3.org/html/)/[HTML5](http://www.w3.org/TR/html5/)
        - [CSS/CSS3](http://www.w3.org/Style/CSS/)
        - [Sass](http://sass-lang.com/)/[LESS](http://lesscss.org/)/[Stylus](http://learnboost.github.io/stylus/)/[postCSS](https://github.com/postcss/postcss)
        - [PhotoShop](http://www.photoshop.com/products/photoshop)/[Paint.net](http://www.getpaint.net/)/[Fireworks](http://www.adobe.com/cn/products/fireworks.html)/[GIMP](http://www.gimp.org/)/[Sketch](http://bohemiancoding.com/sketch/)
    - 开发工具
        - 编辑器和IDE
            - [VIM](http://www.vim.org/)/[Sublime Text2](http://www.sublimetext.com/)
            - [Notepad++](http://notepad-plus-plus.org/)/[EditPlus](http://www.editplus.com/)
            - [WebStorm](http://www.jetbrains.com/webstorm/)
            - [Emacs](http://www.gnu.org/software/emacs/)  [EmacsWiki](http://emacswiki.org)
            - [Brackets](http://brackets.io)
            - [Atom](https://atom.io/)
            - [Lime Text](http://limetext.org/)
            - [Light Table](http://lighttable.com/)
            - [Codebox](https://www.codebox.io/)
            - [TextMate](http://macromates.com/)
            - [Neovim](http://neovim.org/)
            - [Komodo IDE / Edit](http://www.activestate.com/komodo-edit)
            - [Eclipse](http://www.eclipse.org/)
            - [Visual Studio](http://www.visualstudio.com/)
            - [Visual Studio Code](https://code.visualstudio.com/)
            - [NetBeans](https://netbeans.org/)
            - [Cloud9 IDE](http://c9.io/)
            - [HBuilder](http://www.dcloud.io/)
            - [Nuclide](http://nuclide.io/)
        - 调试工具
            - [Firebug](http://getfirebug.com/)/[Firecookie](https://addons.mozilla.org/en-US/firefox/addon/firecookie/)
            - [YSlow](http://developer.yahoo.com/yslow/)
            - [IEDeveloperToolbar](http://www.microsoft.com/en-us/download/details.aspx?id=18359)/[IETester](http://www.my-debugbar.com/wiki/IETester/HomePage)
            - [Fiddler](http://www.telerik.com/fiddler)
            - [Chrome Dev Tools](https://developer.chrome.com/devtools)
            - [Dragonfly](http://www.opera.com/dragonfly/)
            - [DebugBar](http://www.debugbar.com/)
            - [Venkman](https://developer.mozilla.org/en-US/docs/Venkman)
            - [Charles](https://www.charlesproxy.com/)
        - 版本管理
            - [Git](http://git-scm.com/)/[SVN](http://subversion.apache.org/)/[Mercurial](http://mercurial.selenic.com/)
            - [Github](https://github.com/)/[GitLab](https://about.gitlab.com/)/[Bitbucket](https://bitbucket.org/)/[Gitorious](https://gitorious.org/)/[GNU Savannah](http://savannah.gnu.org/)/[Launchpad](https://launchpad.net/)/[SourceForge](http://sourceforge.net/)/[TeamForge](http://www.collab.net/products/teamforge)
    - 代码质量
        - Coding style
            - [JSLint](http://www.jslint.com/)/[JSHint](http://www.jshint.com/)/[jscs](https://github.com/mdevils/node-jscs)/[ESLint](https://github.com/eslint/eslint)
            - [CSSLint](http://csslint.net/)
            - [Markup Validation Service](http://validator.w3.org/)
            - [HTML Validators](https://validator.whatwg.org/)
        - 单元测试
            - [QUnit](http://qunitjs.com/)/[Jasmine](http://jasmine.github.io/)
            - [Mocha](http://mochajs.org/)/[Should](https://github.com/visionmedia/should.js/)/[Chai](http://chaijs.com/)/[Expect](https://github.com/LearnBoost/expect.js/)
            - [Unit JS](http://unitjs.com/)
        - 自动化测试
            - [WebDriver](http://docs.seleniumhq.org/docs/03_webdriver.jsp)/[Protractor](https://github.com/angular/protractor)/[Karma Runner](https://github.com/karma-runner/karma)/[Sahi](http://sahi.co.in/)
            - [phantomjs](http://phantomjs.org/)
            - [SourceLabs](https://saucelabs.com/)/[BrowserStack](http://www.browserstack.com/)
    - 前端库/框架
        - [jQuery](http://jquery.com/)/[Underscore](http://underscorejs.org/)/[Mootools](http://mootools.net/)/[Prototype.js](http://www.prototypejs.org/)
        - [YUI3](http://yuilibrary.com/projects/yui3/)/[Dojo](http://dojotoolkit.org/)/[ExtJS](http://www.sencha.com/products/extjs)/[KISSY](http://docs.kissyui.com/)
        - [Backbone](http://backbonejs.org/)/[KnockoutJS](http://knockoutjs.com/)/[Emberjs](http://emberjs.com/)
        - [AngularJS](http://angularjs.org/)
            - [Batarang](https://chrome.google.com/webstore/detail/angularjs-batarang/ighdmehidhipcmcojjgiloacoafjmpfk)
        - [Bootstrap](http://getbootstrap.com/)
        - [Semantic UI](http://www.semantic-ui.com/)
        - [Juice UI](http://juiceui.com/)
        - [Web Atoms](http://webatomsjs.neurospeech.com/)
        - [Polymer](http://docs.polymerchina.org/)
        - [Dhtmlx](http://dhtmlx.com/)
        - [qooxdoo](http://qooxdoo.org/)
        - [React](http://facebook.github.io/react/)
        - [Brick](http://mozbrick.github.io/)
        - [vue.js](http://cn.vuejs.org/)
    - 前端标准/规范
        - HTTP/1.1: RFCs 7230-7235
        - [HTTP/2](https://http2.github.io/)
        - [ECMAScript3/5](http://www.ecma-international.org/publications/standards/Ecma-262.htm)
        - [ECMAScript6](http://www.ecma-international.org/ecma-262/6.0/index.html)
        - [W3C: DOM/BOM/XHTML/XML/JSON/JSONP/...](http://www.w3.org/TR/)
        - [CommonJS Modules](http://wiki.commonjs.org/wiki/Modules/1.0)/[AMD](https://github.com/amdjs/amdjs-api/wiki/AMD)
        - [HTML5](http://www.w3.org/html/wg/drafts/html/master/)/[CSS3](http://www.w3.org/Style/CSS/specs.en.html)
        - [Semantic Web](http://semanticweb.org/)
            - [MicroData](http://schema.org)
            - [RDFa](http://www.w3.org/TR/rdfa-core/)
        - [Web Accessibility](http://www.w3.org/WAI/)
            - [WCAG](http://www.w3.org/TR/WAI-WEBCONTENT/)
            - [Role Attribute](http://www.w3.org/TR/role-attribute/)
            - [WAI-ARIA](http://www.w3.org/TR/wai-aria/)
    - 性能
        - [JSPerf](http://jsperf.com/)
        - [YSlow 35 rules](http://developer.yahoo.com/performance/rules.html)
        - [PageSpeed](https://developers.google.com/speed/pagespeed/)
        - [HTTPWatch](http://www.httpwatch.com/)
        - [DynaTrace's Ajax](http://www.compuware.com/application-performance-management/dynatrace-ajax-download.html)
        - [高性能JavaScript](http://book.douban.com/subject/5362856/)
    - SEO
    - 编程知识储备
        - [数据结构](http://zh.wikipedia.org/wiki/%E6%95%B0%E6%8D%AE%E7%BB%93%E6%9E%84)
        - OOP/AOP
        - [原型链](http://net.tutsplus.com/tutorials/javascript-ajax/prototypes-in-javascript-what-you-need-to-know/)/作用域链
        - [闭包](http://www.jibbering.com/faq/notes/closures/)
        - [编程范型](http://zh.wikipedia.org/wiki/%E7%BC%96%E7%A8%8B%E8%8C%83%E5%9E%8B)
        - [设计模式](http://addyosmani.com/resources/essentialjsdesignpatterns/book/)
        - [Javascript Tips](http://sanshi.me/articles/JavaScript-Garden-CN/html/index.html)
    - 部署流程
        - 压缩合并
            - [YUI Compressor](http://developer.yahoo.com/yui/compressor/)
            - [Google Clousure Complier](https://developers.google.com/closure/compiler/)
            - [UglifyJS](https://github.com/mishoo/UglifyJS)
            - [CleanCSS](https://github.com/GoalSmashers/clean-css)
        - 文档输出
            - [JSDoc](https://github.com/jsdoc3/jsdoc)
            - [Dox](https://github.com/visionmedia/dox)/[Doxmate](https://github.com/JacksonTian/doxmate)/[Grunt-Doxmate](https://github.com/luozhihua/grunt-doxmate)
        - 项目构建工具
            - [make](http://www.gnu.org/software/make/)/[Ant](http://ant.apache.org/)
            - [GYP](http://code.google.com/p/gyp/)
            - [Grunt](http://gruntjs.com/)
            - [Gulp](http://gulpjs.com/)
            - [Yeoman](http://yeoman.io/)
            - [FIS](http://fis.baidu.com/)
            - [Mod](https://github.com/modulejs/modjs)
        - ES6＋ 转换器
            - [Traceur](https://github.com/google/traceur-compiler)
            - [Babel](https://babeljs.io/)
    - 代码组织
        - 类库模块化
            - [CommonJS](http://www.commonjs.org/)/AMD
            - [YUI3模块](http://yuilibrary.com/projects/yui3/)
            - [webpack](http://webpack.github.io/)
        - 业务逻辑模块化
            - [bower](https://github.com/twitter/bower)/[component](https://github.com/component/component)
        - 文件加载
            - [LABjs](http://labjs.com/)
            - [SeaJS](http://seajs.org/)/[Require.js](http://requirejs.org/)
        - 模块化预处理器
            - [Browserify](https://github.com/substack/node-browserify)
    - 安全
        - [CSRF](http://en.wikipedia.org/wiki/Cross-site_request_forgery)/[XSS](http://en.wikipedia.org/wiki/Cross-site_scripting)
        - [CSP](http://www.w3.org/TR/CSP/)
        - [Same-origin policy](https://developer.mozilla.org/docs/Web/Security/Same-origin_policy)
        - ADsafe/Caja/Sandbox
    - 移动Web
        - HTML5/CSS3
        - [响应式网页设计](http://zh.wikipedia.org/wiki/%E5%93%8D%E5%BA%94%E5%BC%8F%E7%BD%91%E9%A1%B5%E8%AE%BE%E8%AE%A1)
        - [Zeptojs](http://zeptojs.com/)/[iScroll](http://cubiq.org/iscroll)
        - V5/[Sencha Touch](http://www.sencha.com/products/touch)
        - [PhoneGap](http://phonegap.com/)/[Cordova](https://cordova.apache.org/)
        - [jQuery Mobile](http://jquerymobile.com/)
        - [W3C Mobile Web Initiative](http://www.w3.org/Mobile/)
        - [W3C mobileOK Checker](http://validator.w3.org/mobile/)
        - [Open Mobile Alliance](http://openmobilealliance.org/)
        - [React Native](https://facebook.github.io/react-native/)
        - [ionic](http://ionicframework.com/)
    - 前沿技术社区/会议
        - [D2](http://d2forum.org)/[WebRebuild](http://www.webrebuild.org/)
        - NodeParty/[W3CTech](http://w3ctech.com)/[HTML5梦工厂](http://www.html5dw.com)
        - [JSConf](http://jsconf.com/)/[沪JS(JSConf.cn)](http://jsconf.cn)
        - QCon/Velocity/SDCC
        - [JSConf](http://jsconf.com/)/[NodeConf](http://www.nodeconf.com/)
        - [CSSConf](http://cssconf.com/)
        - YDN/YUIConf
        - HybridApp
        - [WHATWG](http://whatwg.org/)
        - [MDN](https://developer.mozilla.org/zh-CN/)
        - [codepen](http://codepen.io/)
        - [w3cplus](http://www.w3cplus.com/)
        - [CNode](https://cnodejs.org/)
    - 计算机知识储备
        - 编译原理
        - [计算机网络](http://zh.wikipedia.org/wiki/%E8%AE%A1%E7%AE%97%E6%9C%BA%E7%BD%91%E7%BB%9C)
        - [操作系统](http://zh.wikipedia.org/wiki/%E6%93%8D%E4%BD%9C%E7%B3%BB%E7%BB%9F)
        - 算法原理
        - 软件工程/软件测试原理
        - [Unicode](http://www.unicode.org/)
    - 软技能
        - 知识管理/总结分享
        - 沟通技巧/团队协作
        - 需求管理/PM
        - 交互设计/可用性/可访问性知识
    - 可视化
        - SVG/Canvas/VML
        - SVG: [D3](http://d3js.org/)/[Raphaël](http://dmitrybaranovskiy.github.io/raphael/)/[Snap.svg](http://snapsvg.io/)/[DataV](http://datavlab.org/datavjs/)
        - Canvas: [CreateJS](http://www.createjs.com/)/[KineticJS](http://kineticjs.com/)
        - [WebGL](http://en.wikipedia.org/wiki/WebGL)/[Three.JS](http://threejs.org/)

- 后端工程师
    - 编程语言
        - C/C++/Java/PHP/Ruby/Python/...
    - 网页服务器
        - [Nginx](http://nginx.org/en/)
        - [Apache](http://httpd.apache.org/)
        - [Lighttpd](http://www.lighttpd.net/)
    - 数据库
        - SQL
        - [MySQL](http://www.mysql.com/)/[PostgreSQL](http://www.postgresql.org/)/[Oracle](http://www.oracle.com/us/products/database/overview/index.html)/[DB2](http://www-01.ibm.com/software/data/db2)
        - [MongoDB](http://www.mongodb.org/)/[CouchDB](http://couchdb.apache.org/)
    - 数据缓存
        - [Redis](http://redis.io/)
        - [Memcached](http://memcached.org/)
    - 文件缓存/代理
        - [Varnish](https://www.varnish-cache.org/)
        - [Squid](http://www.squid-cache.org/)
    - 操作系统
        - Unix/Linux/OS X/Windows
    - 数据结构

## 前端书籍推荐
★越少越简单,越适合入门,★多的要么是难度比较高,要么是比较适合在后面看,比如讲性能之类的书.

### CSS
- [Eric Meyer 谈 CSS（卷二）](http://www.amazon.cn/Eric-Meyer-谈-CSS-迈耶/dp/B00170M84I/)★★★
- [CSS权威指南 （第3版）](http://book.douban.com/subject/2308234/)★★
- [精通CSS](http://book.douban.com/subject/4736167/)★★★
- [HTML & CSS设计与构建网站](http://book.douban.com/subject/21338365/)★

### JavaScript
- [JavaScript & jQuery交互式Web前端开发](http://book.douban.com/subject/26433805/)★
- [JavaScript DOM编程艺术 （第2版）](http://book.douban.com/subject/6038371/)★
- [JavaScript高级程序设计（第3版）](http://book.douban.com/subject/10546125/)★★
- [锋利的jQuery](http://book.douban.com/subject/10792216/)★★
- [高性能JavaScript](http://book.douban.com/subject/5362856/)★★★
- [JavaScript语言精粹](http://book.douban.com/subject/3590768/)★★★
- [JavaScript权威指南](http://book.douban.com/subject/10549733/)★★★
- [编写可维护的JavaScript](http://book.douban.com/subject/21792530/)★★★
- [JAVASCRIPT语言精髓与编程实践](http://book.douban.com/subject/3012828/)★★★
- [Effective Javascript](http://www.amazon.com/Effective-JavaScript-Specific-Software-Development/dp/0321812182)★★★
- [Secrets of the JavaScript Ninja](http://book.douban.com/subject/3176860/)★★★
- [JavaScript模式](http://book.douban.com/subject/11506062/)★★★
- [JavaScript设计模式](http://book.douban.com/subject/3329540/)★★★★
- [基于MVC的JavaScript Web富应用开发](http://book.douban.com/subject/10733304/)★★★

### 性能实践
- [高性能网站建设指南](https://book.douban.com/subject/3132277/)★
- [高性能网站建设进阶指南](https://book.douban.com/subject/4719162/)★★
- [Web性能实践日志](http://book.douban.com/subject/25891125/)★★★
- [Web性能权威指南](http://book.douban.com/subject/25856314/)★★★

### 版本控制工具
- [版本控制之道 (git)](http://book.douban.com/subject/4813786/)★★
- [Pro Git](http://iissnan.com/progit/)★★★
- [Git权威指南](http://book.douban.com/subject/6526452/)★★★★

## 后端书籍推荐
### Linux管理
- [Linux 系统管理技术手册](http://book.douban.com/subject/3042029/)
- [鸟哥的 Linux 私房菜](http://book.douban.com/subject/4889838/)
- [Linux 101 Hacks](http://www.thegeekstuff.com/linux-101-hacks-free-ebook-non-english/)
- [UNIX Shell Scripting](http://book.douban.com/subject/3519360/)
- [The Linux Command Line](http://book.douban.com/subject/6806862/)
- [Linux Network Administrator's Guide](http://oreilly.com/openbook/linag2/book/index.html)

### Linux编程
- [Linux程序设计](http://book.douban.com/subject/4831448/)
- [Linux系统编程](http://book.douban.com/subject/3907181/)
- [Unix环境高级编程](http://book.douban.com/subject/1788421/)
- [Unix编程艺术](http://book.douban.com/subject/1467587/)
- [The Linux Programming Interface](http://book.douban.com/subject/4292217/)
- [程序员的自我修养](http://book.douban.com/subject/3652388/)
- [深入理解Linux内核](http://book.douban.com/subject/2287506/)
- [Unix网络编程](http://book.douban.com/subject/1500149/)
- [TCP/IP高级编程](http://book.douban.com/subject/1088054/)

### C/C++
- [Linux C编程一站式学习](http://book.douban.com/subject/4141733/)
- [C和指针](http://book.douban.com/subject/3012360/)
- [C陷阱与缺陷](http://book.douban.com/subject/2778632/)
- [C专家编程](http://book.douban.com/subject/2377310/)
- [C语言核心技术](http://book.douban.com/subject/2226913/)
- [彻底搞定C指针](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&ved=0CDEQFjAA&url=http%3A%2F%2Fblogimg.chinaunix.net%2Fblog%2Fupfile2%2F110210170023.pdf&ei=P95mUfrmNKKriALS04HAAw&usg=AFQjCNEzB88PnpfL0fRgJDkP3O9TlBPswA&sig2=isyd4ktsByNBMa5M9EPhRQ&bvm=bv.45107431,d.cGE&cad=rjt)
- [征服C指针](http://book.douban.com/subject/21317828/)
- [C++编程思想](http://book.douban.com/subject/1094797/)
- [高质量程序设计指南---C/C++语言](http://book.douban.com/subject/2116929/)
- [Inside the C++ Object Model](http://book.douban.com/subject/1484262/)
- [A Tour of C++](http://www.stroustrup.com/Tour.html)
- [The C++ Programming Language](http://en.wikipedia.org/wiki/The_C%2B%2B_Programming_Language)
- [The C++ Standard Library - A Tutorial and Reference](http://www.cppstdlib.com/)
- [The C++ Standard (INCITS/ISO/IEC 14882-2011)](http://webstore.ansi.org/RecordDetail.aspx?sku=INCITS%2fISO%2fIEC+14882-2012)
- [Overview of the New C++](http://www.artima.com/shop/overview_of_the_new_cpp)

## 前端工作面试
- [前端工作面试问题](https://github.com/darcyclarke/Front-end-Developer-Interview-Questions)
- [前端开发面试题（中文）](https://github.com/markyun/My-blog/tree/master/Front-end-Developer-Questions/Question)

## 内容贡献者
除了感谢Jayli提供了知识结构图的原本来，还感谢以下的内容贡献者们，结果由`git-summary`生成于2014-01-03：

```

 project  : fks
 repo age : 1 year, 3 months
 active   : 53 days
 commits  : 108
 files    : 4
 authors  :
    56  Jackson Tian            51.9%
     9  吴晓兰               8.3%
     5  liyinkan                4.6%
     3  chriscai                2.8%
     3  fengxiaolong            2.8%
     3  XiNGRZ                  2.8%
     2  monkadd                 1.9%
     2  Johnny                  1.9%
     2  weiwenqing              1.9%
     2  Yinkan Li               1.9%
     2  Copypeng                1.9%
     2  左岸                  1.9%
     2  Jakukyo Friel           1.9%
     2  Glowin                  1.9%
     1  李亚川               0.9%
     1  Evan You                0.9%
     1  Mickey                  0.9%
     1  Mickey-                 0.9%
     1  Qi Junyuan              0.9%
     1  browsnet                0.9%
     1  doabit                  0.9%
     1  guoxiangyang            0.9%
     1  linkgod                 0.9%
     1  popomore                0.9%
     1  vipzhicheng             0.9%
     1  zhaqiang                0.9%
     1  Colin Luo               0.9%

```
