# Awesome Redux [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**  *generated with [DocToc](https://github.com/thlorenz/doctoc)*

- [Awesome Redux *](#awesome-redux-)
  - [Redux](#redux)
  - [Documentation of Redux](#documentation-of-redux)
  - [Documentation of Redux(Simplified Chinese version)](#documentation-of-reduxsimplified-chinese-version)
  - [Documentation of Redux(Russian version) (Work in progress)](#documentation-of-reduxrussian-version-work-in-progress)
  - [Documentation of Redux(Traditional Chinese version)](#documentation-of-reduxtraditional-chinese-version)
  - [Documentation of Redux(Portuguese version) (Work in progress)](#documentation-of-reduxportuguese-version-work-in-progress)
  - [Documentation of Redux(Spanish version) (Work in progress)](#documentation-of-reduxspanish-version-work-in-progress)
  - [Documentation of Redux(Korean version)](#documentation-of-reduxkorean-version)
  - [Documentation of Redux(Sinhala|සිංහල version) (Work in progress)](#documentation-of-reduxsinhala%E0%B7%83%E0%B7%92%E0%B6%82%E0%B7%84%E0%B6%BD-version-work-in-progress)
  - [Documentation of Redux(Japanese|日本語 version) (Work in progress)](#documentation-of-reduxjapanese%E6%97%A5%E6%9C%AC%E8%AA%9E-version-work-in-progress)
  - [Marks](#marks)
    - [Presentations](#presentations)
    - [Resources](#resources)
    - [Articles And Tutorials](#articles-and-tutorials)
    - [Boilerplate](#boilerplate)
    - [React Native - A framework for building native apps using React](#react-native---a-framework-for-building-native-apps-using-react)
    - [React - A JavaScript library for building user interfaces](#react---a-javascript-library-for-building-user-interfaces)
    - [Examples](#examples)
    - [Similar libraries](#similar-libraries)
    - [Deku - Functional view library for building UI components as an alternative to React](#deku---functional-view-library-for-building-ui-components-as-an-alternative-to-react)
    - [Incremental DOM - Incremental DOM is a library for building up DOM trees and updating them in-place when data changes](#incremental-dom---incremental-dom-is-a-library-for-building-up-dom-trees-and-updating-them-in-place-when-data-changes)
    - [WinJS - Windows Library for JavaScript](#winjs---windows-library-for-javascript)
    - [AngularJS - HTML enhanced for web apps](#angularjs---html-enhanced-for-web-apps)
    - [Angular - One framework. Mobile and desktop](#angular---one-framework-mobile-and-desktop)
    - [Vue - A library for building modern web interfaces](#vue---a-library-for-building-modern-web-interfaces)
    - [Polymer - Build modern apps using web components](#polymer---build-modern-apps-using-web-components)
    - [Ember - A framework for creating ambitious web applications](#ember---a-framework-for-creating-ambitious-web-applications)
    - [Meteor - Build apps that are a delight to use, faster than you ever thought possible](#meteor---build-apps-that-are-a-delight-to-use-faster-than-you-ever-thought-possible)
    - [Mithril - A Javascript Framework for Building Brilliant Applications](#mithril---a-javascript-framework-for-building-brilliant-applications)
    - [Backbone - Give your JS App some Backbone with Models, Views, Collections, and Events](#backbone---give-your-js-app-some-backbone-with-models-views-collections-and-events)
    - [Aurelia - is a next gen JavaScript client framework for mobile, desktop and web that leverages simple conventions to empower your creativity](#aurelia---is-a-next-gen-javascript-client-framework-for-mobile-desktop-and-web-that-leverages-simple-conventions-to-empower-your-creativity)
    - [Riot - A React-like user interface micro-library](#riot---a-react-like-user-interface-micro-library)
    - [Electron - Build cross platform desktop apps with web technologies](#electron---build-cross-platform-desktop-apps-with-web-technologies)
    - [A-Frame - A web framework for building VR experiences](#a-frame---a-web-framework-for-building-vr-experiences)
    - [Chrome Extensions](#chrome-extensions)
  - [Ruby on Rails Resources](#ruby-on-rails-resources)
  - [Other languages](#other-languages)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->



> List of repositories which use Redux

## [Redux](https://github.com/reactjs/redux)
## [Documentation of Redux](http://redux.js.org)
## [Documentation of Redux(Simplified Chinese version)](https://github.com/camsong/redux-in-chinese)
## [Documentation of Redux(Russian version)](https://rajdee.gitbooks.io/redux-in-russian/) (Work in progress)
## [Documentation of Redux(Traditional Chinese version)](http://chentsulin.github.io/redux/index.html)
## [Documentation of Redux(Portuguese version)](https://github.com/franzejr/redux-in-portuguese/) (Work in progress)
## [Documentation of Redux(Spanish version)](https://sergiodxa.gitbooks.io/redux-en-espanol/content/) (Work in progress)
## [Documentation of Redux(Korean version)](http://dobbit.github.io/redux/)
## [Documentation of Redux(Sinhala|සිංහල version)](https://sandaruny.github.io/redux-sin/) (Work in progress)
## [Documentation of Redux(Japanese|日本語 version)](https://0-to-1.github.io/redux/) (Work in progress)

> Predictable state container for JavaScript apps

## Marks
* [Universal (Isomorphic)](http://isomorphic.net) - :metal:
* [Hot Reload](https://github.com/gaearon/react-transform-hmr) - :fire:

### Presentations
* [Let's learn React and Redux with Javascript's new ES6 syntax, from Beginner to Intermediate to Advanced.](https://www.youtube.com/watch?v=d0oUGmSE6IY&list=PLJBrYU54JD2pTblB20OmV7GL6H5J-p2g8)
* [A introduction about Redux](https://github.com/chentsulin/redux-intro)
* [Real World Redux](https://speakerdeck.com/chrisui/real-world-redux)
* [The power of higher-order reducers](http://slides.com/omnidan/hor)
* [Reactive Architecture with Redux and Angular](http://slides.com/evanschultz-1/reactive-angular)
* [Redux Internals](http://slides.com/vladimirnovick/reduxinternals)
* [Replacing Angular 1 with React and Redux](http://slides.com/scottprue-2/deck)
* [A tour on the React ecosystem](http://slides.com/cguedes/a-tour-on-react-ecosystem)
* [Redux from Twitter hype to production](http://slides.com/jenyaterpil/redux-from-twitter-hype-to-production#/)

---

### Resources

* [Many tools and middlewares](https://github.com/redux-effects)
* [Redux offline docs](https://github.com/paulwittmann/redux-offline-docs)
* [Flux challenge](https://github.com/staltz/flux-challenge)
* [Sound Redux - a simple Soundcloud client](https://github.com/andrewngu/sound-redux)
* [Favesound Redux - SoundCloud Client for Artists](https://github.com/rwieruch/favesound-redux)
* [Structor - a user interface builder for React](https://github.com/ipselon/structor)
* [generator-redux - CLI tools for Redux: next-gen functional Flux/React with devtools](https://github.com/banderson/generator-redux)
* [generator-reactapp - Yeoman generator for react app with redux](https://github.com/Jackong/generator-reactapp)
* [Rekit - Toolkit for building scalable web apps with React, Redux and React-router](http://rekit.js.org)
* [Spectacle - ReactJS based Presentation Library](https://github.com/FormidableLabs/spectacle)
* [Notes (and partial transcription) of Dan Abramov's Redux course videos on http://egghead.io](https://github.com/tayiorbeii/egghead.io_redux_course_notes)
* [Comprehensive Notes for Learning (how to use) Redux to manage state in your Web/Mobile Apps](https://github.com/dwyl/learn-redux)
* [React Redux [RU tutorial]](https://maxfarseer.gitbooks.io/redux-course-ru/content/)
* [Redux without profanity](https://tonyhb.gitbooks.io/redux-without-profanity/content/index.html)
* [React and Redux Single Page Applications Resources](https://medium.com/@sapegin/react-and-redux-single-page-applications-resources-22cd859b0c1d#.o66rolp0p)
* [A categorized list of Redux-related addons, libraries, and utilities](https://github.com/markerikson/redux-ecosystem-links)
* [Building the F8 2016 App (Redux, GraphQL, React Native)](http://makeitopen.com/tutorials/building-the-f8-app/planning/)
* [The Elm Architecture in JavaScript](https://github.com/salsita/redux-elm)
* [React Redux Workflow - Graphical Cheat Sheet](https://github.com/uanders/react-redux-cheatsheet)

---

### Articles And Tutorials
* [Building Applications with React and Redux in ES6 on Pluralsight](https://app.pluralsight.com/library/courses/react-redux-react-router-es6)
* [Writing a Basic App in Redux](http://davidandsuzi.com/writing-a-basic-app-in-redux)
* [Learn how to use Redux step by step](https://github.com/happypoulp/redux-tutorial)
* [Tutorial: Handcrafting an Isomorphic Redux Application (With Love)](https://medium.com/@bananaoomarang/handcrafting-an-isomorphic-redux-application-with-love-40ada4468af4)
* [0 to 1 : Getting started with Redux](http://www.jchapron.com/2015/08/14/getting-started-with-redux)
* [Redux Chinese Document](https://github.com/camsong/redux-in-chinese)
* [Redux Document (Traditional Chinese)](https://github.com/chentsulin/redux)
* [Relay and Routing](https://medium.com/@cpojer/relay-and-routing-36b5439bad9)
* [Understanding Redux Middleware](https://medium.com/@meagle/understanding-87566abcfb7a)
* [Several videos about Redux + Falcor](https://www.livecoding.tv/ekosz/videos) and [Example code](https://github.com/ekosz/postcard-sender)
* [Redux Middleware: Behind the Scenes](http://briantroncone.com/?p=529)
* [A proposal for bundling reducers, action types and actions when using Redux](https://github.com/erikras/ducks-modular-redux)
* [Full-Stack Redux Tutorial - A Comprehensive Guide to Test-First Development with Redux, React, and Immutable](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html) Source [Server](https://github.com/teropa/redux-voting-server) + [Client](https://github.com/teropa/redux-voting-client)
* [Redux best practices](https://medium.com/lexical-labs-engineering/redux-best-practices-64d59775802e)
* [The 3REE Stack: React + Redux + RethinkDB + Express.js](http://blog.workshape.io/the-3ree-stack-react-redux-rethinkdb-express-js)
* [React Tutorial - Converting Reflux to Redux](http://engineering.wework.com/process/2015/10/01/react-reflux-to-redux)
* [Redux example using 500px API (with ES6)](https://github.com/yildizberkay/redux-example)
* [Building a boilerplate for a Koa, Redux, React application including Webpack, Mocha and SASS](http://blog.joanboixados.com/building-a-boilerplate-for-a-koa-redux-react-application-including-webpack-mocha-and-sass/) - This article explains in detail how [this koa-redux-react-boilerplate](https://github.com/mezod/boilerplate-koa-redux-react) was built and the technologies it uses.
* [Typed React and Redux](http://jaysoo.ca/2015/09/26/typed-react-and-redux)
* [A cartoon intro to Redux](https://code-cartoons.com/a-cartoon-intro-to-redux-3afb775501a6#.8k7536uqu)
* [Join The Dark Side Of The Flux: Responding to Actions with Actors](http://jamesknelson.com/join-the-dark-side-of-the-flux-responding-to-actions-with-actors)
* [Can I dispatch multiple actions from Redux action creators?](http://jamesknelson.com/can-i-dispatch-multiple-actions-from-redux-action-creators)
* [Understanding Redux (or, How I Fell in Love with a JavaScript State Container)](http://www.youhavetolearncomputers.com/blog/2015/9/15/a-conceptual-overview-of-redux-or-how-i-fell-in-love-with-a-javascript-state-container)
* [Your First Immutable React & Redux App](http://reactjsnews.com/your-first-redux-app)
* [Getting Started with Redux - Egghead's video lessons from Dan Abramov](https://egghead.io/series/getting-started-with-redux)
* [Redux Testing Video Lessons - a few short Egghead video lessons (some free, some require a subscription)](https://egghead.io/series/react-testing-cookbook)
* [Implementing a smart Login Modal with Redux, reselect and ReactJS](https://medium.com/@dorsha/implement-login-modal-with-redux-reselect-and-reactjs-668c468bcbe3#.lnwisap8c)
* [How to Build a Todo App Using React, Redux, and Immutable.js](http://www.sitepoint.com/how-to-build-a-todo-app-using-react-redux-and-immutable-js)
* [Rethinking Redux](https://voice.kadira.io/rethinking-redux-f1e96daba60c#.hp5v516ie)
* [Managing Side Effects In React + Redux Using Sagas](http://jaysoo.ca/2016/01/03/managing-processes-in-redux-using-sagas)
* [Secure Your React and Redux App with JWT Authentication](https://auth0.com/blog/2016/01/04/secure-your-react-and-redux-app-with-jwt-authentication)
* [Getting started with Redux and GraphQL](https://medium.com/@thisbejim/getting-started-with-redux-and-graphql-8384b3b25c56#.3anuh1m7x)
* [Data Flows with Angular and Redux](http://www.sitepoint.com/data-flows-angular-2-redux)
* [Simple Routing with Redux and React](http://jamesknelson.com/simple-routing-redux-react)
* [Redux nowadays : From actions creators to sagas](https://riadbenguella.com/2015/12/28/redux-nowadays-from-actions-creators-to-sagas/)
* [Master Complex Redux Workflows with Sagas](http://konkle.us/master-complex-redux-workflows-with-sagas)
* [Angular Application Architecture - Building Flux Apps with Redux and Immutable.js](http://blog.jhades.org/angular-2-application-architecture-building-flux-like-apps-using-redux-and-immutable-js-js)
* [React, Redux and Immutable.js: Ingredients for Efficient Web Applications](http://www.toptal.com/react/react-redux-and-immutablejs)
* [An Introduction to React Redux (Part 1)](https://shellmonger.com/2016/02/16/an-introduction-to-react-redux-part-1)
* [An Introduction to React Redux (Part 2)](https://shellmonger.com/2016/02/19/an-introduction-to-react-redux-part-2)
* [Rules For Structuring (Redux) Applications](http://jaysoo.ca/2016/02/28/organizing-redux-application)
* [Redux for the very beginner](http://toranbillups.com/blog/archive/2016/01/22/redux-for-the-very-beginner)
* [Redux - Calling web service asynchronously](http://www.zohaib.me/redux-call-service-async/)
* [Animating with React, Redux, and d3](http://swizec.com/blog/animating-with-react-redux-and-d3/swizec/6775)
* [Build an Image Gallery Using React, Redux and redux-saga](http://joelhooks.com/blog/2016/03/20/build-an-image-gallery-using-redux-saga/)
* [Introducing redux-operations](https://medium.com/@matt.krick/introducing-redux-operations-332ab56e468b#.7e30nsxne)
* [Solving Redux’s shortcoming in 150 LOCs](https://medium.com/@matt.krick/solving-redux-s-shortcoming-in-150-locs-540979ce6cf9#.sw0s478j6)
* [The Anatomy Of A React Redux App](https://medium.com/@rajaraodv/the-anatomy-of-a-react-redux-app-759282368c5a#.h05vq2uaj)
* [Getting Started with React, Redux and Immutable: a Test-Driven Tutorial (Part 2)](http://www.theodo.fr/blog/2016/03/getting-started-with-react-redux-and-immutable-a-test-driven-tutorial-part-2/)
* [Leveling Up with React: Redux](https://css-tricks.com/learning-react-redux/)
* [Complete intro to react](http://btholt.github.io/complete-intro-to-react/)
* [Recreating Redux — Behind the magic curtain](https://medium.com/@nicktho/recreating-redux-behind-the-magic-curtain-c21edd542c9c#.a93sgufyi)
* [Let's Build a Redux Powered React Application](https://stormpath.com/blog/build-a-redux-powered-react-application/)
* [Deep Introduction to Redux - Seriese 1/3](https://www.codementor.io/reactjs/tutorial/intro-to-react-redux-pros)
* [Universal Rendering with Redux and React-Router - Seriese 2/3](https://www.codementor.io/reactjs/tutorial/redux-server-rendering-react-router-universal-web-app)
* [Unit Testing Redux Apps - Seriese 3/3](https://www.codementor.io/reactjs/tutorial/redux-unit-test-mocha-mocking)
* [Using Aurelia and Redux together for good times all around](https://zen.id.au/using-aurelia-and-redux-together-for-good-times-all-around/)
* [Comparing Redux and Relay](https://www.reindex.io/blog/redux-and-relay/)
* [Building React Applications with Idiomatic Redux](https://egghead.io/courses/building-react-applications-with-idiomatic-redux)
* [The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux)
* [深入浅出 Redux](https://github.com/berwin/Blog/issues/4)
* [Building Angular 2 applications with Immutable.js and Redux](http://houssein.me/redux/immutablejs/angular2/2016/07/04/angular2-with-immutablejs-and-redux.html)
* [Tutorial: Building Redux in TypeScript with Angular](http://blog.ng-book.com/introduction-to-redux-with-typescript-and-angular-2/)
* [Improving React and Redux performance with Reselect](http://blog.rangle.io/react-and-redux-performance-with-reselect/)
* [Recipes for Redux](http://blog.rangle.io/recipes-for-redux/)
* [Getting Started with Redux & Angular](http://blog.rangle.io/getting-started-with-redux-and-angular-2/)
* [Universal/Isomorphic React+Redux on a Swift Web Backend](https://el-tramo.be/blog/react-swift/)
* [Creating Reusable React-Redux Components Through Scoping](http://engineering.datadoghq.com/redux-doghouse--creating-reusable-react-redux-components-through-scoping/)
* [React+Redux系列教程](https://github.com/lewis617/react-redux-tutorial)
* [书籍：《React 与 Redux 开发实例精解》](https://lewis617.github.io/2016/11/20/r2-book/)
* [How to use Redux on highly scalable javascript applications?](https://medium.com/@alexmngn/how-to-use-redux-on-highly-scalable-javascript-applications-4e4b8cb5ef38#.irwibmm9a)
* [AngularJS to React/Redux, a Guide for AngularJS Experts Looking to Learn React/Redux](https://github.com/GoTeamEpsilon/angular-to-react-redux)
* [Redux in Action](https://www.manning.com/books/redux-in-action)
* [Redux in Motion](https://www.manning.com/livevideo/redux-in-motion)
---

### Boilerplate
* [**redux-minimal** - Minimalist react-redux starter kit which let's you build rich real world apps](http://redux-minimal.js.org/)
* [**Modern and Scalable React/Redux Boilerplate** - Flexible starter kit using Webpack 2 (tree-shaking) / React Hot Loader v3 / Code Splitting for React Router / PostCSS / CSS Modules / custom *Ducks pattern* app architecture / best practices / Sentry error tracking / Enzyme test environment](https://github.com/nicksp/redux-webpack-es6-boilerplate) :rocket:
* [**react-production-starter** - React boilerplate with isomorphic rendering, async react-router routes, async redux reducers, async data fetching, and code-splitting.](https://github.com/jaredpalmer/react-production-starter) :metal: :fire:
* [**mern.io** - Simple full-stack boilerplate to get started with building isomorphic/universal apps, handles api part and also offers a cli to generate the boilerplate](https://github.com/hashnode/mern-starter) :metal: :fire:
* [**universal-react-redux** - Opinionated Universal React/Redux/Webpack with HMR. Continually updated.](https://github.com/combine/universal-react-redux) :metal: :fire:
* [**react-slingshot** - React Redux Starter Kit with hot reloading, tests and example app](https://github.com/coryhouse/react-slingshot)
* [**react-redux-boilerplate** - React Redux Boilerplate](https://github.com/knowbody/react-redux-boilerplate)
* [**react-boilerplate** - React + Typescript + Sass boilerplate](https://github.com/Keats/react-boilerplate)
* [**react-redux-scaffold** - Combination of redux, react-router and ES6+ support](https://github.com/lcjnil/react-redux-scaffold)
* [**simple-redux-boilerplate** - Simple and guided React, Redux boilerplate w/ Transform HMR! :fire:](https://github.com/tsaiDavid/simple-redux-boilerplate)
* [**reactv** - React Redux example](https://github.com/Amorino/reactv)
* [**redux-boilerplate** - Boilerplate for Redux](https://github.com/ellbee/redux-boilerplate)
* [**react-redux-starter-kit** - Get started with React, Redux, and React-Router.](https://github.com/davezuko/react-redux-starter-kit)
* [**simplest-redux-example** - Simplest Redux + React example for beginners](https://github.com/jackielii/simplest-redux-example)
* [**redux-easy-boilerplate** - React Redux easy boilerplate](https://github.com/anorudes/redux-easy-boilerplate)
* [**dicty-redux** - Starter kit to bootstrap React and Redux (Flux) based web application](https://github.com/dictyBase/dicty-redux)
* [**3ree** - Boilerplate & Demo for Universal Realtime Apps built with React + Redux + RethinkDB + Express](https://github.com/GordyD/3ree)
* [**react_scaffolding** - React + React Router 1.0 + Redux + Webpack & Hot Module Replacement](https://github.com/rafaelchiti/react_scaffolding)
* [**express-redux-sample** - Express-Redux-PassportJs-MySQL Boilerplate](https://github.com/aybmab/express-redux-sample)
* [**redux-blog-example** - Redux-Webpack-Babel Blog Platform boilerplate](https://github.com/GetExpert/redux-blog-example)
* [**redux-undo-boilerplate** - a magical boilerplate with hot reloading and awesome error handling](https://github.com/omnidan/redux-undo-boilerplate)
* [**redux500** - The Redux version of isomorphic500](https://github.com/gpbl/redux500)
* [**redux-demo** - Redux port of SurviveJS - Webpack and React Kanban app](https://github.com/survivejs/redux-demo)
* [**react-redux-universal-hot-example** - A starter boilerplate for a universal webapp using express, react, redux, webpack, and react-hot-loader](https://github.com/erikras/react-redux-universal-hot-example) :metal:
* [**rde** - Reactive Live Programming Environment](https://github.com/levjj/rde)
* [**React Redux Starter Kit** - Yet another React and Redux based web application starter kit](https://github.com/cloudmu/react-redux-starter-kit)
* [**skeleton** - A simple project-stub to show the basic ideas. Also serves you as a quick start for your project (Mori + Redux)](https://github.com/sullenor/skeleton)
* [**browser-redux** - Building Chrome apps and cross-browser extensions with Redux and Webpack](https://github.com/zalmoxisus/browser-redux)
* [**react-for-hipsters-boilerplate** - Fresh boilerplate with brand new hot reloading confing and other hipster stuff](https://github.com/chicoxyzzy/react-for-hipsters-boilerplate)
* [**Documented Koa Redux React Webpack boilerplate**](https://github.com/mezod/boilerplate-koa-redux-react)- The building process of this boilerplate is deeply documented from 0 for learning purposes. [You can find the docs here](http://blog.joanboixados.com/building-a-boilerplate-for-a-koa-redux-react-application-including-webpack-mocha-and-sass/).
* [**err** - Electron, React, Redux-devtools boilerplate for building cross-platform apps.](https://github.com/tuommii/err)
* [**friends-app-redux** - React Redux Universal Hot Example](https://github.com/banzay/friends-app-redux)
* [**isomorphic-redux-app** - Redux Isomorphic App (with async content)](https://github.com/caljrimmer/isomorphic-redux-app)
* [**starter-kit** - Project boilerplate using React, Redux and Uniloc http://unicornstandard.com/packages/boilerplate.html](https://github.com/unicorn-standard/starter-kit)
* [**loopback-redux-react-boilerplate** - A boilerplate for a Redux-React application using LoopBack](https://github.com/tngan/loopback-redux-react-boilerplate)
* [**breko-hub** - **B**abel **Rea**ct **Ko**a **H**ot **U**niversal **B**oilerplate -- A simple, clean and consistent boilerplate for creating universal webapps with universal data fetching and SocketIO integration](https://github.com/tomatau/breko-hub)
* [**React Redux Cordova Boilerplate**](https://github.com/inderps/react-redux-cordova-boilerplate)
* [**react-boilerplate** - Performance orientated, offline-first boilerplate feat. hot-reloading, PostCSS and the best developer experience.](https://github.com/mxstbr/react-boilerplate)
* [**react-webpack-node** - Boilerplate for an universal React + Redux/alt Flux application using Webpack running on a node express server](https://github.com/choonkending/react-webpack-node)
* [**Hapi React Starter Kit** - Universal, Redux, Redis, Socket.io, Intl](https://github.com/Dindaleon/hapi-react-starter-kit)
* [**Universal Redux Template** - A clean, extensible react + redux boilerplate with universal rendering, testing and more](https://github.com/mz026/universal-redux-template)
* [**universal-js** - A universal Javascript starter kit inc. React, Redux, Redux Dev Tools, Universal Redux Router, CSS Modules, hot module reloading, Babel for ES2015+ and ESLint](https://github.com/colinmeinke/universal-js)
* [**redux-react-material-boilerplate** - Simple boilerplate inc. React, Redux, Hot reload and Material-ui](https://github.com/WapGeaR/redux-react-material-boilerplate)
* [**react-redux-starter** - React Redux Starter](https://github.com/exeto/react-redux-starter)
* [**Reduxible** - The Fast and Easy way to make a React + Redux apps](https://github.com/Pitzcarraldo/reduxible)
* [**react-workflow** - A large SPA boilerplate for web development built on top of Facebook's React library,use redux architecture](https://github.com/chen844033231/react-workflow)
* [**ReacToGo** - A simple ES6 boilerplate with Redux architecture and ImmutableJS: Hot Reload, React UI Comp, Firebase, Router](https://github.com/PBRT/reactogo)
* [**React/Redux simple CRUD** with persistent state and local async actions (add a manifest file and you get an offline webapp) ](https://github.com/cristianszwarc/react_crud_localStorage)
* [**StarHackIt** - An React/Redux Node full-stack starter kit with authentication and authorization code](https://github.com/FredericHeem/starhackit)
* [**React Seed** - A barebones scalable directory structure and package.json for facilitating new React + Redux projects. No fat to trim here!](https://github.com/andrewcoelho/react-seed)
* [**React/Redux with Auth boilerplate** - Very simple boilerplate, good for fast creating admin panels / dashboard. Included: React, Redux, ReduxForm, React-Router, Simple Authenticate, Hot Reload and Webpack (with babel) :fire:](https://github.com/WapGeaR/react-redux-boilerplate-auth)
* [**Docker + React/Redux + Node + PostgreSQL** - full stack boilerplate with fully dockerized workflows for development, deployment, testing](https://github.com/Producters/docker-node-react-starter)
* [**Redux universal boilerplate** - boilerplate for react universal application building on flux architecture based on redux implementation.](https://github.com/ufocoder/redux-universal-boilerplate)
* [**React Redux Universal Boilerplate** - An Universal ReactJS/Redux Boilerplate.](https://github.com/kiki-le-singe/react-redux-universal-boilerplate)
* [**react-hot-redux-firebase-starter** - Starter boilerplate for using React/Redux with Firebase 3.0 API, include the new React Hot Loader 3.0 :fire:](https://github.com/douglascorrea/react-hot-redux-firebase-starter)
* [**React Redux Firebase Boilerplate** - Designed for quickly spin up your apps with Firebase, using bunch of awesome new front-end technologies includes webpack build system, hot reloading, routing & sass support. :fire:](https://github.com/btomashvili/react-redux-firebase-boilerplate)
* [**React Universal Saga** - Universal React Starter Kit ft. Redux Saga](https://github.com/xkawi/react-universal-saga)
* [**React Redux SoundCloud Client** - Seed Project for a SoundCloud Client with working Login + Extension Seed Projects](https://github.com/rwieruch/react-redux-soundcloud)
* [**vortigern** - A universal boilerplate for building web applications w/ TypeScript, React, Redux and more.](https://github.com/barbar/vortigern)
* [**angular2-redux-contact-list** - Simple contact list built with Angular, Immutable.js and Redux](https://github.com/hdjirdeh/angular2-redux-contact-list)
* [**react-redux-seed** - 使用 React 与 Redux 实现 Universal 渲染的种子工程](https://github.com/lewis617/react-redux-seed)
* [**ARc** - A progressive React starter kit based on Atomic Design with redux, redux-saga and redux-form](https://arc.js.org)
* [**edux** - fast Redux without constants and switches. Actions and reducers are generated from single source.](https://github.com/dogada/edux)
* [**fast-redux** - Redux extension with O(1) speed and dynamic importing of reducers/actions.](https://github.com/dogada/fast-redux)
* [**zero-boilerplate-redux** - An example real-world Redux CRUD application with no boilerplate](https://github.com/jmeas/zero-boilerplate-redux)

---

### [React Native - A framework for building native apps using React](https://facebook.github.io/react-native)
* Examples
    * [CarteJaune - An open source Redux/ExponentJS (React Native) app leveraging redux-saga to keep track of your vaccinations](https://github.com/nikgraf/CarteJaune)
    * [noder-react-native - The mobile app of cnodejs.org written in React Native](https://github.com/soliury/noder-react-native)
    * [react-native-redux-counter](https://github.com/hzyIO/react-native-redux-counter)
    * [react-native-counter-ios-android](https://github.com/chentsulin/react-native-counter-ios-android)
    * [react-native-redux-groceries - An example app using React Native, Redux, Firebase, and AsyncStorage for offline data](https://github.com/bruz/react-native-redux-groceries)
    * [react-native-sound-cloud](https://github.com/fraserxu/soundredux-native)
    * [snowflake - mobile app starter: Login, Logout, Reset Password, Update Profile, Hot Reload](https://github.com/bartonhammond/snowflake)
    * [uestc-bbs-react-native - An iOS client for http://bbs.uestc.edu.cn/ written in React Native with Redux](https://github.com/just4fun/uestc-bbs-react-native)
    * [movies-redux - redux implementation of react-native movies example that is included in react-native source](https://github.com/nara/movies-redux)
    * [react-native-redux-todo-list - A sample todo list app developed by using react-native and redux](https://github.com/uiheros/react-native-redux-todo-list)

---

### [React - A JavaScript library for building user interfaces](http://facebook.github.io/react)
* Containers
    * [**reapop** - A React & Redux notifications system](https://github.com/LouisBarranqueiro/reapop)
    * [**react-redux-modal-provider** - Redux-powered abstract React modal state manager](https://github.com/myaskevich/react-redux-modal-provider)
    * [**react-redux-modal-flex** - Accessible modal dialog component for React, easy to install and use with Redux](https://github.com/tronghiep92/react-redux-modal-flex)

* Middlewares

   * [**redux-cheerio** - Make HTTP requests and then parse the responses with jQuery selectors using Cheerio](https://github.com/therewillbecode/redux-cheerio)
    * [**redux-reporter** - Report actions & metadata to 3rd party providers, extremely useful for analytics and error handling (New Relic, Sentry, Adobe DTM, Keen, etc.)](https://github.com/ezekielchentnik/redux-reporter)
    * [**redux-transduce** - Transducer utilities for Redux](https://github.com/acdlite/redux-transduce)
    * [**redux-actions** - Flux Standard Action utilities for Redux](https://github.com/acdlite/redux-actions)
    * [**redux-promise** - FSA-compliant promise middleware for Redux](https://github.com/acdlite/redux-promise)
    * [**redux-sync-promise** - Middleware for writing asynchronous actions in synchronous style](https://github.com/shanhaichik/redux-sync-promise)
    * [**redux-simple-promise** - FSA-compliant promise middleware for Redux with simple behaviour with minimal boilerplate declarations](https://github.com/alanrubin/redux-simple-promise)
    * [**redux-async** - FSA-compliant promise property middleware for Redux](https://github.com/symbiont-io/redux-async)
    * [**redux-async-queue** - Manage queues of thunk actions](https://github.com/zackargyle/redux-async-queue)
    * [**redux-async-initial-state** - Set initial Redux state asynchronously](https://github.com/KELiON/redux-async-initial-state)
    * [**redux-await** - Manage async redux actions sanely](https://github.com/kolodny/redux-await)
    * [**redux-rx** - RxJS utilities for Redux](https://github.com/acdlite/redux-rx)
    * [**reselect** - Selector library for Redux like in NuclearJS](https://github.com/reactjs/reselect)
    * [**react-redux** - React bindings for Redux](https://github.com/rackt/react-redux)
    * [**redux-react-router** - Redux bindings for React Router – keep your router state inside your Redux store](https://github.com/acdlite/redux-react-router)
    * [**redux-promise-middleware** - Redux middleware for resolving and rejecting promises](https://github.com/pburtchaell/redux-promise-middleware)
    * [**redux-thunk** - Thunk middleware for Redux](https://github.com/gaearon/redux-thunk)
    * [**redux-batched-updates** - Batch React updates that occur as a result of Redux dispatches, to prevent cascading renders.](https://github.com/acdlite/redux-batched-updates)
    * [**redux-combine-actions** - Redux middleware that allows you to easy combine actions and dispatch them sequentially](https://github.com/itsmepetrov/redux-combine-actions)
    * [**redux-catch-promise** - Extended replacement of redux-thunk middleware to supporting async-await functions and implement server-side rendering for React components with async state](https://github.com/DenisIzmaylov/redux-catch-promise)
    * [**redux-delegator** - Compose redux reducers in a structured way](https://github.com/lapanoid/redux-delegator)
    * [**routex** - Simple router for Redux universal applications. Can be used with React too](https://github.com/michalkvasnicak/routex)
    * [**redux-persist-store** - Persist and rehydrate a redux store](https://github.com/rt2zz/redux-persist-store)
    * [**adrenaline** - React bindings for Redux with Relay in mind](https://github.com/gyzerok/adrenaline)
    * [**redux-localstorage** - Store enhancer that syncs (a subset) of your Redux store state to localstorage.](https://github.com/elgerlambert/redux-localstorage)
    * [**redux-storage** - Persistence layer for redux with flexible backends](https://github.com/michaelcontento/redux-storage)
    * [**redux-pouchdb** - sync store state to pouchdb](https://github.com/vicentedealencar/redux-pouchdb)
    * [**redux-vstack-router** - Helpers to bind vstack-router to redux](https://github.com/vslinko/redux-vstack-router)
    * [**redux-create-store**](https://github.com/phated/redux-create-store)
    * [**redux-batched-subscribe** - Batch calls to subscribe handlers with a custom function, including debouncing or React batched updates.](https://github.com/tappleby/redux-batched-subscribe)
    * [**redux-logger** - Logger middleware for Redux](https://github.com/fcomb/redux-logger)
    * [**redux-node-logger** - A Redux Logger for Node Environments](https://github.com/low-ghost/redux-node-logger)
    * [**redux-diff-logger** - Diff logger between states for Redux](https://github.com/fcomb/redux-diff-logger)
    * [**redux-debug** - debug(...) middleware for Redux](https://github.com/lapwinglabs/redux-debug)
    * [**redux-requests** - Avoid issuing duplicate HTTP requests](https://github.com/idolize/redux-requests)
    * [**redux-owl** - Redux One Way Linking](https://github.com/rt2zz/redux-owl)
    * [**redux-act** - An opinionated lib to create actions and reducers for Redux](https://github.com/pauldijou/redux-act)
    * [**redux-act-async** - Reducing boilerplate when creating asynchronous actions in Redux](https://github.com/FredericHeem/redux-act-async)
    * [**redux-raven-middleware** - Redux middleware for sending error reports to Sentry through raven-js](https://github.com/ngokevin/redux-raven-middleware)
    * [**react-redux-persist-sentry-middleware** - Redux middleware for sending error reports along with persisted data as payload to Sentry through raven-js](https://github.com/rishantagarwal/react-redux-persist-sentry-middleware)
    * [**redux-routing** - Universal routing built on top of redux](https://github.com/callum/redux-routing)
    * [**redux-undo** - Simple undo/redo functionality for redux state containers](https://github.com/omnidan/redux-undo)
    * [**rn-redux-mixpanel** - Configurable Redux middleware that sends your actions & user profile data to Mixpanel](https://github.com/danscan/rn-redux-mixpanel)
    * [**redux-falcor** - Connect your redux front-end to your falcor back-end](https://github.com/ekosz/redux-falcor)
    * [**redux-analytics** - Trigger analytics events based on your event metadata](https://github.com/markdalgleish/redux-analytics)
    * [**redux-ignore** - Ignore redux actions by array or filter function](https://github.com/omnidan/redux-ignore)
    * [**redux-recycle** - Reset the redux state on certain actions](https://github.com/omnidan/redux-recycle)
    * [**re-notif**](https://github.com/indexiatech/re-notif) A notification center based on React & Redux.
    * [**redux-lunr** - Make your redux store searchable with Lunr.js](https://github.com/swennemans/redux-lunr)
    * [**redux-ensure-fsa** - Development middleware to check for FSA-compliant actions](https://github.com/meadow/redux-ensure-fsa)
    * [**redux-pagan** - internationalization via redux](https://github.com/alexkuz/redux-pagan)
    * [**redux-debounce**](//github.com/wyze/redux-debounce) - Debounce your actions!
    * [**redux-future** - FSA-compliant future monad middleware for redux](https://github.com/stoeffel/redux-future)
    * [**redux-io** - FSA-compliant io monad middleware for redux](https://github.com/stoeffel/redux-io)
    * [**redux-either** - FSA-compliant either monad middleware for redux](https://github.com/stoeffel/redux-either)
    * [**redux-timeout** - Trigger actions based on timeouts](https://github.com/gpfunk/redux-timeout)
    * [**redux-observable-middleware** - Redux middleware for subscribing to observables](https://github.com/d6u/redux-observable-middleware)
    * [**redux-observable** - RxJS 5-based middleware for Redux. Compose and cancel actions as epics.](https://github.com/redux-observable/redux-observable)
    * [**redux-deferred** - Redux middleware for jQuery Deferred Object](https://github.com/wyvernnot/redux-deferred)
    * [**redux-task** - A simple Side Effects manager for redux](https://github.com/sskyy/redux-task)
    * [**redux-gen** - Generator based middleware for redux](https://github.com/weo-edu/redux-gen)
    * [**redux-authentication** - Authentication component for Redux](https://github.com/Jackong/redux-authentication)
    * [**socket.io-redux** - Redux middleware to emit action via socket.io](https://github.com/sergiodxa/socket.io-redux)
    * [**redux-catch** - Error catcher middleware for Redux reducers and middlewares](https://github.com/sergiodxa/redux-catch)
    * [**redux-elm-middleware** - Elm middleware for redux](https://github.com/stoeffel/redux-elm-middleware)
    * [**redux-api-middleware** - Redux API middleware based on the real-world example](https://github.com/agraboso/redux-api-middleware)
    * [**redux-mediaquery** - Redux ActionCreator to put responsive-design breakpoints in your store](https://github.com/Yaska/redux-mediaquery)
    * [**redux-amrc** - Redux async middleware and reducer creator](https://github.com/lewis617/redux-amrc)
    * [**redux-fetch-middleware** - Redux middleware that help user to treat simple request via fetch api](https://github.com/zslucky/redux-fetch-middleware)
    * [**redux-url** - A Redux middleware for synchronizing the URL with the state](https://github.com/jedirandy/redux-url)
    * [**redux-most** - Most.js based middleware for Redux. Handle async actions with monadic streams & reactive programming.](https://github.com/joshburgess/redux-most)
    * [**redux-cookies-middleware** - a Redux middleware which syncs a subset of your Redux store state with cookies.](https://github.com/grofers/redux-cookies-middleware/)
    * [**redux-cycles** - Handle async actions with functional and reactive programming.](
    https://github.com/cyclejs-community/redux-cycles)
    * [**axios-promise-redux-middleware** - This is a tiny redux middleware which allows you to make http requests(using axios) by dispatching actions](https://www.npmjs.com/package/axios-promise-redux-middleware)


* Tools
    * [**actionware** - Redux with less boilerplate + error/busy status for every action](https://github.com/wellguimaraes/actionware)
    * [**entities-reducer** - High order reducer to handle updates to entities from normalizr actions](https://github.com/kwelch/entities-reducer)
    * [**reactotron** - Control, monitor, and instrument your React Native apps from the comfort of your TTY](https://github.com/skellock/reactotron)
    * [**redux-test-recorder** - Redux test recorder is a redux middleware + included component for automagically generating tests for your reducers based on the actions in your app](https://github.com/conorhastings/redux-test-recorder)
    * [**redux-devtools** - DevTools for Redux with hot reloading, action replay, and customizable UI](https://github.com/gaearon/redux-devtools)
    * [**react-router-redux** - Ruthlessly simple bindings to keep react-router and redux in sync](https://github.com/rackt/react-router-redux)
    * [**redux-tiny-router** - A Router made for Redux, stop using the router as a controller it's just state!](https://github.com/Agamennon/redux-tiny-router)
    * [**redux-devtools-gentest-plugin** - Generate mocha like tests from redux-devtools session](https://github.com/lapanoid/redux-devtools-gentest-plugin)
    * [**generator-redux** - CLI tools for Redux: next-gen functional Flux/React with devtools](https://github.com/banderson/generator-redux)
    * [**generator-reactapp** - Yeoman generator for react app with redux](https://github.com/Jackong/generator-reactapp)
    * [**generator-redux-app** - Scaffold out a redux app with counter example and react-router](https://github.com/chentsulin/generator-redux-app)
    * [**redux-loader** - A high order component for Redux. This components loads resources and passes them to the child components via props](https://github.com/sporto/redux-loader)
    * [**asyncdataloader-react** -AsyncDataLoader is a React Higher Order Component which takes responsibility of fetching data of the Wrapped Component and offers many options like showing an interface preview of the Wrapped Component while data is being fetched, refetch data after specified time.](https://github.com/harshitkumar31/asyncdataloader-react)
    * [**redux-rest** - Automatically create Flux action constants, action creators and Redux reducers for your REST API](https://github.com/Kvoti/redux-rest)
    * [**react-reach** - A library to communicate with Graphql through Redux](https://github.com/kennetpostigo/react-reach)
    * [**redux-api** - Flux REST API for redux infrastructure](https://github.com/lexich/redux-api)
    * [**redux-store-validator** - Add validation to your Redux reducers](https://github.com/alixander/redux-store-validator)
    * [**firedux** - Firebase + Redux for ReactJS](https://github.com/adjohnson916/firedux)
    * [**vstack-router** - Universal router](https://github.com/vslinko/vstack-router)
    * [**redux-ecommerce** - E-commerce flux with redux](https://github.com/Tom-Alexander/redux-ecommerce)
    * [**redux-form** - An ES7 decorator for forms using Redux and React](https://github.com/erikras/redux-form)
    * [**redux-form-validation** - Form validation for controlled & uncontrolled inputs](https://github.com/posabsolute/redux-form-validator)
    * [**simple-redux-form** - A tiny redux-form alternative Higher Order Component for forms](https://github.com/mihirsoni/simple-redux-form).
    * [**redux-slider-monitor** - A custom monitor for Redux DevTools to replay recorded Redux actions](https://github.com/calesce/redux-slider-monitor)
    * [**updeep** - Easily update nested frozen objects and arrays in a declarative and immutable manner](https://github.com/substantial/updeep)
    * [**redux-immutable** - Streamlines use of Immutable.js with Redux reducers.](https://github.com/gajus/redux-immutable)
    * [**redux-import-export-monitor** - A monitor for copying your serialized action log to the clipboard, as well as pasting it in from somewhere else](https://github.com/lapanoid/redux-import-export-monitor)
    * [**icedam** - Just-in-time immutability: freezes data sent to views.](https://github.com/winkler1/icedam)
    * [**react-inline-grid** - Predictable flexbox based grid for React using Redux and Immutable-js.](https://github.com/broucz/react-inline-grid)
    * [**redux-easy-actions** - Sugar library for creating Redux or Flux actions](https://github.com/grigory-leonenko/redux-easy-actions)
    * [**redux-mount** - Mount state data and change its state values on the fly](https://github.com/popc0rn/redux-mount)
    * [**redux-multi** - Dispatch multiple actions from one action creator](https://github.com/ashaffer/redux-multi)
    * [**immu** - A tiny, fail-fast, lazy, immutable Javascript objects library](https://github.com/scottcorgan/immu)
    * [**Generate standard action creators and reducers for CRUD applications**](https://github.com/Versent/redux-crud)
    * [**Redux & ImmutableJs** - Integration of Redux & ImmutableJs that 100% conforms Redux standards](https://github.com/indexiatech/redux-immutablejs)
    * [**redux-tcomb** - Immutable and type-checked state and actions for Redux](https://github.com/gcanti/redux-tcomb)
    * [**redux-react-router-transitions** - Attach react-router transitions to arbitrary actions](https://github.com/johanneslumpe/redux-react-router-transitions)
    * [**redux-optimist** - Optimistically apply actions that can be later commited or reverted.](https://github.com/ForbesLindesay/redux-optimist)
    * [**redux-devtools-diff-monitor** - Redux DevTools – Diff Monitor](https://github.com/whetstone/redux-devtools-diff-monitor)
    * [**redux-store-visualizer** - Visualize Redux store in real time](https://github.com/romseguy/redux-store-visualizer)
    * [**generator-redux** - CLI tools for Redux: next-gen functional Flux/React with devtools](https://github.com/banderson/generator-redux)
    * [**generator-reactapp** - Yeoman generator for react app with redux](https://github.com/Jackong/generator-reactapp)
    * [**redux-viewmodel** - ViewModel wrapping for Redux & React](https://github.com/tdzl2003/redux-viewmodel)
    * [**redux-utils** - Utility functions for Redux](https://github.com/newtack/redux-utils)
    * [**multireducer** - A utility to wrap many copies of a single Redux reducer into a single key-based reducer](https://github.com/erikras/multireducer)
    * [**subdivide** - User defined UI layout: Every pane can be subdivided and any widget assigned to any pane](https://github.com/philholden/subdivide)
    * [**replux** - Self contained components and enhancements for Redux](https://github.com/gregthebusker/replux)
    * [**redux-immutable-utils** - Utilities for using Immutable with Redux](https://github.com/aparticka/redux-immutable-utils)
    * [**recompose** - A microcomponentization toolkit for React](https://github.com/acdlite/recompose)
    * [**redux-lift** - Lifting for Redux](https://github.com/izaakschroeder/redux-lift)
    * [**redux-router5** - router5 integration with Redux](https://github.com/router5/redux-router5)
    * [**redux-devtools-extension** - Redux DevTools Extension](https://github.com/zalmoxisus/redux-devtools-extension)
    * [**universal-redux-router** - A very simple router for Redux and React that works on both server and client](https://github.com/colinmeinke/universal-redux-router)
    * [**redux-watch** - Watch/monitor for state changes on an object path](https://github.com/jprichardson/redux-watch)
    * [**redux-devtools-filterable-log-monitor** - Filterable tree view monitor for Redux DevTools](https://github.com/bvaughn/redux-devtools-filterable-log-monitor)
    * [**redux-flash-notification** -  A flash notification component for Redux](https://github.com/posabsolute/redux-flash-notification)
    * [**redux-saga** - An alternative side effect model for Redux apps](https://github.com/yelouafi/redux-saga)
    * [**remote-redux-devtools** - Use Redux DevTools remotely for React Native, hybrid, desktop and server side Redux apps](https://github.com/zalmoxisus/remote-redux-devtools)
    * [**redux-devtools-dispatch** - Dispatch your actions manually to test if your app reacts well](https://github.com/YoruNoHikage/redux-devtools-dispatch)
    * [**redux-loop** - Sequence your effects naturally and purely by returning them from your reducers](https://github.com/raisemarketplace/redux-loop)
    * [**redux-data-fx** - Declarative side effects for Redux](https://github.com/matthieu-beteille/redux-data-fx)
    * [**redux-orm** - A small, simple and immutable ORM to manage data in your Redux store](https://github.com/tommikaikkonen/redux-orm)
    * [**redux-bacon** - Utilities for attaching Bacon.js to Redux](https://github.com/aparticka/redux-bacon)
    * [**rereduce** - Reducer library for Redux](https://github.com/slorber/rereduce)
    * [**redoodle** - Enhances Redux integration with TypeScript with Typed Actions and typesafe reducers.](https://github.com/palantir/redoodle)
    * [**redux-decorators** - A ridiculously good syntax for working with Redux and TypeScript. Currently limited to Angular but could potentially be used elsewhere](https://github.com/KarlPurk/redux-decorators)
    * [**redux-test-reducer** - Simple and clean testing mechanism for Redux reducers](https://github.com/amsardesai/redux-test-reducer)
    * [**redux-devtools-inspector** - Another Redux DevTools Monitor](https://github.com/alexkuz/redux-devtools-inspector)
    * [**redux-ava** - Helpers for writing Redux tests in AVA](https://github.com/sotojuan/redux-ava)
    * [**redux-cli** - An opinionated CLI for building redux/react apps quicker](https://github.com/SpencerCDixon/redux-cli)
    * [**redux-saga-rxjs** - RxJS implementation of Saga pattern for redux](https://github.com/salsita/redux-saga-rxjs)
    * [**redux-actions-assertions** - Assertions for redux actions testing](https://github.com/dmitry-zaets/redux-actions-assertions)
    * [**redux-duck** - Helper function to create Redux modules using the ducks-modular-redux proposal](https://github.com/sergiodxa/redux-duck)
    * [**redux-dispatch-cli** - A CLI tool for Redux remote dispatch. Used in remote-redux-devtools](https://github.com/jhen0409/redux-dispatch-cli)
    * [**redux-immutable-reducer** - Immutable reducer states with Redux](https://github.com/zackargyle/redux-immutable-reducer)
    * [**redux-bootstrap** - configure React + React-Router + Redux + Immutable.js with one function!](https://github.com/redux-bootstrap/redux-bootstrap)
    * [**redux-director** - Redux bindings to director router](https://github.com/mandeepbrar/redux-director)
    * [**redux-q** - Provides a way to queue callbacks until an action is dispatched](https://github.com/ConciergeAuctions/redux-q)
    * [**redux-apist** - Creator API actions for redux-thunk](https://github.com/exeto/redux-apist)
    * [**reswitch** — Write reducers with less boilerplate](https://github.com/chiefGui/reswitch)
    * [**redux-autoform** - Create Redux-Forms dynamically out of metadata](https://github.com/redux-autoform/redux-autoform)
    * [**redux-ship** - Composable, testable and typable side effects](https://github.com/clarus/redux-ship)
    * [**entman** - A simple library to manage normalizr entities in a Redux store](https://github.com/Drawbotics/entman)
    * [**yax** - Yet another store using redux and inspired by vuex](https://github.com/d-band/yax)
    * [**listate** - Library to listen/observe/watch changes of Redux store state](https://github.com/gamtiq/listate)
    * [**redux-reducer-async** - Create redux reducers for async behaviors of multiple actions.](https://github.com/AndersDJohnson/redux-reducer-async)
    * [**redux-autoreducers** - Redux Auto reducers generator.](https://github.com/oxyno-zeta/redux-autoreducers)
    * [**redux-resource** - Lightweight remote resource management for Redux.](https://github.com/jmeas/redux-resource)


* Frameworks
    * [**Jumpsuit** - A powerful & efficient React framework. Jump in. Zip up. Build great apps.](https://github.com/jumpsuit/jumpsuit)
    * [**Jumpstate** - Simple and powerful state management for Redux](https://github.com/jumpsuit/jumpstate)
    * [**dva** - Front-end framework based on react, redux, react-redux, react-router and redux-saga.](https://github.com/sorrycc/dva)
    * [**Vdux** - World's smallest framework.  Stateless Virtual DOM <-> Redux](https://github.com/ashaffer/vdux)
    * [**Esex** - Full-stack Universal JavaScript Framework (Redux+RxJs)](https://github.com/esex/esex)
    * [**Ripster**](https://github.com/vslinko/ripster)
    * [**Este** - The most complete minimal dev stack / boilerplate for React & Redux universal web apps](https://github.com/este/este)
    * [**stardux** - Functional DOM containers based on starplate, IncrementalDOM, and redux](https://github.com/littlstar/stardux)
    * [**nux** - A Push-Based Functional Reactive Web Application Framework](https://github.com/marknutter/nux)
    * [**Keo** - Plain functions for a more functional Deku approach to creating React components, with functional goodies such as compose, memoize, etc... for free](https://github.com/Wildhoney/Keo)
    * [**plait** - A minimal JavaScript framework for building reactive web components](https://github.com/wildlyinaccurate/plait)
    * [**reactuate** — A React/Redux stack (not a boilerplate!) with a focus on Domain-Driven Design](https://github.com/reactuate/reactuate)
    * [**meatier** - Like meteor, but meatier](https://github.com/mattkrick/meatier)
    * [**relax** - New generation CMS on top of React, Redux and GraphQL](https://github.com/relax/relax)
    * [**lovli.js** - A boilerplate for developing react+redux applications with rethinkdb/horizon as realtime database and express for the server](https://github.com/flipace/lovli.js)
    * [**kea** - Well-readable, self-documenting and easily refactorable framework that brings your data to life! Comes with scaffolding tools](https://github.com/mariusandra/kea-logic) :bird:
    * [**Feeble** - A framework built on top of React/Redux/redux-saga which aims to make building React/Redux applications easier and better.](https://github.com/tianche/feeble)
    * [**Conventional-Redux** - A wrapper for react-redux which provides API based on convention over configuration pattern.](https://github.com/mjaneczek/conventional-redux)
    * [**redux-react-i18n** - An i18n solution for redux/react✌🏿✊🏽🤘🏻](https://github.com/derzunov/redux-react-i18n)
    * [**redux-action-host** - Redux middleware to add the hostname of the originating computer to action metadata](https://github.com/sabrehagen/redux-action-host)
    * [**Mirror** - A simple and powerful React framework with minimal API and zero boilerplate](https://github.com/mirrorjs/mirror)
    * [**Rematch** - Redux best practices without the boilerplate](https://github.com/rematch/rematch)

---

### [Examples](examples/README.md)

---

### Similar libraries
   * [**flux-ts** - A small flux implementation heavily inspired by redux](https://github.com/BobBuehler/flux-ts)
   * [**chopped-redux** - A very small Flux implementation based on Redux](https://github.com/acstll/chopped-redux)
   * [**fluxette** - Minimalist, functional, and concise Flux](https://github.com/edge/fluxette)
   * [**rx-redux** - A reimplementation of redux using RxJS](https://github.com/jas-chen/rx-redux)
   * [**understate** - A simple state manager](https://github.com/johnhenry/understate)
   * [**refer** - Redux-like library for handling global state on functional style](https://github.com/Lucifier129/refer)
   * [**bobflux** - Bobflux is pure functional implementation of FLUX pattern and is fitted to Bobril](https://github.com/karelsteinmetz/bobflux)
   * [**mobx** - Simple, scalable state management](https://github.com/mobxjs/mobx)

---

### [Deku - Functional view library for building UI components as an alternative to React](https://github.com/dekujs/deku)
* Examples
    * [Deku + Express + Redux + Crossroads Router](https://github.com/nivanson/deku-redux-universal-hot-example)
    * [deku-redux - Bindings for redux in deku (Standalone plugin)](https://github.com/troch/deku-redux)
)

---

### [Incremental DOM - Incremental DOM is a library for building up DOM trees and updating them in-place when data changes](http://google.github.io/incremental-dom)
* Examples
    * [Incremental DOM + Redux Flux = Todo App](https://github.com/joshthecoder/idom-redux-todomvc-app)

---

### [WinJS - Windows Library for JavaScript](http://try.buildwinjs.com)
* Examples
    * [react-redux-winjs-example](https://github.com/unindented/react-redux-winjs-example)

---

### [AngularJS - HTML enhanced for web apps](https://angularjs.org)
* Examples
    * [AngularJS + Typescript + Redux](https://github.com/wbuchwalter/tsRedux)
    * [ng-redux - Standalone plugin](https://github.com/wbuchwalter/ng-redux)
    * [redux-ui-router - ngRedux middleware for AngularJS UI Router](https://github.com/neilff/redux-ui-router)
    * [Todo app with ng-redux • ES6 • Webpack](https://github.com/r-park/todo-angular-redux)
    * [https://github.com/InfomediaLtd/angular2-redux-example](https://github.com/InfomediaLtd/angular2-redux-example)
    * [https://github.com/tomusdrw/angular2-redux-example](https://github.com/tomusdrw/angular2-redux-example)

---

### [Angular - One framework. Mobile and desktop](https://angular.io/)
* Examples
    * [angular2-redux-example - Example project for using pure Redux with Angular and TypeScript](https://github.com/InfomediaLtd/angular2-redux-example)
    * [@angular-redux/store - Angular bindings for Redux](https://github.com/angular-redux/store)
    * [angular2-redux - Wrapper components for using Redux in an Angular application](https://github.com/InfomediaLtd/angular2-redux)
    * [ng2redux - Angular bindings for Redux implemented with TypeScript and decorators](https://github.com/forforeach/ng2redux)

---

### [Vue - A library for building modern web interfaces](http://vuejs.org)
* Examples
    * [Revue - Redux binding for Vue](https://github.com/revue/revue)
    * [Vue + Redux](https://github.com/yang-wei/vue-flux)
    * [Meteor + Vue + Redux](https://github.com/zhongqf/meteor-vue-redux-example)

---

### [Polymer - Build modern apps using web components](https://www.polymer-project.org)
* Examples
    * [polymer-redux](https://github.com/tur-nr/polymer-redux)
    * [redux-store-element](https://github.com/lastmjs/redux-store-element)

---

### [Ember - A framework for creating ambitious web applications](http://emberjs.com)
* Examples

---

### [Meteor - Build apps that are a delight to use, faster than you ever thought possible](https://www.meteor.com)
* Examples
   * [meteor-react-redux-example](https://github.com/zhongqf/meteor-react-redux-example)
   * [meteor-flux-leaderboard](https://github.com/AdamBrodzinski/meteor-flux-leaderboard/tree/redux)

---

### [Mithril - A Javascript Framework for Building Brilliant Applications](http://mithril.js.org/)
* Examples
    * [mithril-redux-starter-hmr](https://github.com/mijime/mithril-redux-starter-hmr)

---


### [Backbone - Give your JS App some Backbone with Models, Views, Collections, and Events](http://backbonejs.org/)
* Tools
    * [backbone-redux — The easy way to keep your backbone collections and redux store in sync](https://github.com/redbooth/backbone-redux)

---

### [Aurelia - is a next gen JavaScript client framework for mobile, desktop and web that leverages simple conventions to empower your creativity](http://aurelia.io)
* Examples
    * [aurelia-redux-todo - An implementation of the Redux todo demo app using Aurelia](https://github.com/voidberg/aurelia-redux-todo)
    * [Managing State in Aurelia: How to Use Aurelia with Redux](https://www.sitepoint.com/managing-state-aurelia-with-redux/)

___

### [Riot - A React-like user interface micro-library](http://riotjs.com)
* Examples
    * [riotredux-budget](https://github.com/remyhonig/riotredux-budget)
    * [app-skeleton](https://github.com/zesty-io/app-skeleton)

___

### [Electron - Build cross platform desktop apps with web technologies](http://electron.atom.io/)
* [electron-react-boilerplate (Electron + Redux + Hot Reload)](https://github.com/chentsulin/electron-react-boilerplate)

___

### [A-Frame - A web framework for building VR experiences](https://aframe.io)
* [aframe-redux-component](https://github.com/ngokevin/kframe/tree/master/components/redux)

___

### Chrome Extensions
* [Redux Chrome Extension](https://github.com/Dharmoslap/redux-chrome-extension)
* [React Chrome Extension Boilerplate (Webpack + Redux + Babel and etc](https://github.com/jhen0409/react-chrome-extension-boilerplate)

* Examples
    * [Pumgrana Plugin](https://github.com/Pumgrana/plugin)

## Ruby on Rails Resources
* [React Webpack Rails Tutorial Using Redux](https://github.com/shakacode/react-webpack-rails-tutorial)
* [react_on_rails gem](https://github.com/shakacode/react_on_rails)

## Other languages

* .NET
    * [https://github.com/GuillaumeSalles/redux.NET](https://github.com/GuillaumeSalles/redux.NET)
    * [https://github.com/pshomov/reducto](https://github.com/pshomov/reducto)

* Java
    * [https://github.com/glung/redux-java](https://github.com/glung/redux-java)
    * [https://github.com/trikita/jedux](https://github.com/trikita/jedux)
    * [https://github.com/izumin5210/Droidux](https://github.com/izumin5210/Droidux)

* Swift
    * [https://github.com/ReSwift/reduxSwift](https://github.com/ReSwift/reduxSwift)
    * [https://github.com/Swift-Flow/Swift-Flow](https://github.com/Swift-Flow/Swift-Flow)
    * [https://github.com/ReSwift/ReSwift](https://github.com/ReSwift/ReSwift) and [docs](http://reswift.github.io/ReSwift/master)

* Purescript
    * [https://github.com/brakmic/purescript-redux](https://github.com/brakmic/purescript-redux)
    * [https://github.com/faber/purescript-purdux](https://github.com/faber/purescript-purdux)
