package redisenterprise

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/redisenterprise/mgmt/2020-10-01-preview/redisenterprise"

// AccessKeys the secret access keys used for authenticating connections to redis
type AccessKeys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - READ-ONLY; The current primary key that clients can use to authenticate
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - READ-ONLY; The current secondary key that clients can use to authenticate
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessKeys.
func (ak AccessKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Cluster describes the RedisEnterprise cluster
type Cluster struct {
	autorest.Response `json:"-"`
	// Sku - The SKU to create, which affects price, performance, and features.
	Sku *Sku `json:"sku,omitempty"`
	// Zones - The zones where this cluster will be deployed.
	Zones *[]string `json:"zones,omitempty"`
	// ClusterProperties - Other properties of the cluster.
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.Zones != nil {
		objectMap["zones"] = c.Zones
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				c.Zones = &zones
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterList the response of a list-all operation.
type ClusterList struct {
	autorest.Response `json:"-"`
	// Value - List of clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterList.
func (cl ClusterList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cl.Value != nil {
		objectMap["value"] = cl.Value
	}
	return json.Marshal(objectMap)
}

// ClusterListIterator provides access to a complete listing of Cluster values.
type ClusterListIterator struct {
	i    int
	page ClusterListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListIterator) Response() ClusterList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListIterator type.
func NewClusterListIterator(page ClusterListPage) ClusterListIterator {
	return ClusterListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ClusterList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ClusterList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// clusterListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ClusterList) clusterListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ClusterListPage contains a page of Cluster values.
type ClusterListPage struct {
	fn func(context.Context, ClusterList) (ClusterList, error)
	cl ClusterList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListPage) Response() ClusterList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListPage) Values() []Cluster {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ClusterListPage type.
func NewClusterListPage(cur ClusterList, getNextPage func(context.Context, ClusterList) (ClusterList, error)) ClusterListPage {
	return ClusterListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ClusterProperties properties of RedisEnterprise clusters, as opposed to general resource properties like
// location, tags
type ClusterProperties struct {
	// MinimumTLSVersion - The minimum TLS version for the cluster to support, e.g. '1.2'
	MinimumTLSVersion *string `json:"minimumTlsVersion,omitempty"`
	// HostName - READ-ONLY; DNS name of the cluster endpoint
	HostName *string `json:"hostName,omitempty"`
	// ProvisioningState - READ-ONLY; Current provisioning status of the cluster. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; Current resource status of the cluster. Possible values include: 'ResourceStateRunning', 'ResourceStateCreating', 'ResourceStateCreateFailed', 'ResourceStateUpdating', 'ResourceStateUpdateFailed', 'ResourceStateDeleting', 'ResourceStateDeleteFailed', 'ResourceStateEnabling', 'ResourceStateEnableFailed', 'ResourceStateDisabling', 'ResourceStateDisableFailed', 'ResourceStateDisabled'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// RedisVersion - READ-ONLY; Version of redis the cluster supports, e.g. '6'
	RedisVersion *string `json:"redisVersion,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections associated with the specified RedisEnterprise cluster
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.MinimumTLSVersion != nil {
		objectMap["minimumTlsVersion"] = cp.MinimumTLSVersion
	}
	return json.Marshal(objectMap)
}

// ClusterUpdate a partial update to the RedisEnterprise cluster
type ClusterUpdate struct {
	// Sku - The SKU to create, which affects price, performance, and features.
	Sku *Sku `json:"sku,omitempty"`
	// ClusterProperties - Other properties of the cluster.
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterUpdate.
func (cu ClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cu.Sku != nil {
		objectMap["sku"] = cu.Sku
	}
	if cu.ClusterProperties != nil {
		objectMap["properties"] = cu.ClusterProperties
	}
	if cu.Tags != nil {
		objectMap["tags"] = cu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdate struct.
func (cu *ClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				cu.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cu.Tags = tags
			}
		}
	}

	return nil
}

// CreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateFuture.Result.
func (future *CreateFuture) result(client Client) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.CreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.CreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redisenterprise.CreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Database describes a database on the RedisEnterprise cluster
type Database struct {
	autorest.Response `json:"-"`
	// DatabaseProperties - Other properties of the database.
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseList the response of a list-all operation.
type DatabaseList struct {
	autorest.Response `json:"-"`
	// Value - List of databases
	Value *[]Database `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseList.
func (dl DatabaseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dl.Value != nil {
		objectMap["value"] = dl.Value
	}
	return json.Marshal(objectMap)
}

// DatabaseListIterator provides access to a complete listing of Database values.
type DatabaseListIterator struct {
	i    int
	page DatabaseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseListIterator) Response() DatabaseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseListIterator) Value() Database {
	if !iter.page.NotDone() {
		return Database{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseListIterator type.
func NewDatabaseListIterator(page DatabaseListPage) DatabaseListIterator {
	return DatabaseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dl DatabaseList) IsEmpty() bool {
	return dl.Value == nil || len(*dl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dl DatabaseList) hasNextLink() bool {
	return dl.NextLink != nil && len(*dl.NextLink) != 0
}

// databaseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dl DatabaseList) databaseListPreparer(ctx context.Context) (*http.Request, error) {
	if !dl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dl.NextLink)))
}

// DatabaseListPage contains a page of Database values.
type DatabaseListPage struct {
	fn func(context.Context, DatabaseList) (DatabaseList, error)
	dl DatabaseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dl)
		if err != nil {
			return err
		}
		page.dl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseListPage) NotDone() bool {
	return !page.dl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseListPage) Response() DatabaseList {
	return page.dl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseListPage) Values() []Database {
	if page.dl.IsEmpty() {
		return nil
	}
	return *page.dl.Value
}

// Creates a new instance of the DatabaseListPage type.
func NewDatabaseListPage(cur DatabaseList, getNextPage func(context.Context, DatabaseList) (DatabaseList, error)) DatabaseListPage {
	return DatabaseListPage{
		fn: getNextPage,
		dl: cur,
	}
}

// DatabaseProperties properties of RedisEnterprise databases, as opposed to general resource properties
// like location, tags
type DatabaseProperties struct {
	// ClientProtocol - Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted. Possible values include: 'Encrypted', 'Plaintext'
	ClientProtocol Protocol `json:"clientProtocol,omitempty"`
	// Port - TCP port of the database endpoint. Specified at create time. Defaults to an available port.
	Port *int32 `json:"port,omitempty"`
	// ProvisioningState - READ-ONLY; Current provisioning status of the database. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; Current resource status of the database. Possible values include: 'ResourceStateRunning', 'ResourceStateCreating', 'ResourceStateCreateFailed', 'ResourceStateUpdating', 'ResourceStateUpdateFailed', 'ResourceStateDeleting', 'ResourceStateDeleteFailed', 'ResourceStateEnabling', 'ResourceStateEnableFailed', 'ResourceStateDisabling', 'ResourceStateDisableFailed', 'ResourceStateDisabled'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// ClusteringPolicy - Clustering policy - default is OSSCluster. Specified at create time. Possible values include: 'EnterpriseCluster', 'OSSCluster'
	ClusteringPolicy ClusteringPolicy `json:"clusteringPolicy,omitempty"`
	// EvictionPolicy - Redis eviction policy - default is VolatileLRU. Possible values include: 'AllKeysLFU', 'AllKeysLRU', 'AllKeysRandom', 'VolatileLRU', 'VolatileLFU', 'VolatileTTL', 'VolatileRandom', 'NoEviction'
	EvictionPolicy EvictionPolicy `json:"evictionPolicy,omitempty"`
	// Modules - Optional set of redis modules to enable in this database - modules can only be added at creation time.
	Modules *[]Module `json:"modules,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.ClientProtocol != "" {
		objectMap["clientProtocol"] = dp.ClientProtocol
	}
	if dp.Port != nil {
		objectMap["port"] = dp.Port
	}
	if dp.ClusteringPolicy != "" {
		objectMap["clusteringPolicy"] = dp.ClusteringPolicy
	}
	if dp.EvictionPolicy != "" {
		objectMap["evictionPolicy"] = dp.EvictionPolicy
	}
	if dp.Modules != nil {
		objectMap["modules"] = dp.Modules
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateFuture.Result.
func (future *DatabasesCreateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.DatabasesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesCreateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesExportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesExportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesExportFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesExportFuture.Result.
func (future *DatabasesExportFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesExportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.DatabasesExportFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesImportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesImportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesImportFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesImportFuture.Result.
func (future *DatabasesImportFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesImportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.DatabasesImportFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesRegenerateKeyFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesRegenerateKeyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (AccessKeys, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesRegenerateKeyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesRegenerateKeyFuture.Result.
func (future *DatabasesRegenerateKeyFuture) result(client DatabasesClient) (ak AccessKeys, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesRegenerateKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ak.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.DatabasesRegenerateKeyFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ak.Response.Response, err = future.GetResult(sender); err == nil && ak.Response.Response.StatusCode != http.StatusNoContent {
		ak, err = client.RegenerateKeyResponder(ak.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesRegenerateKeyFuture", "Result", ak.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpdateFuture.Result.
func (future *DatabasesUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redisenterprise.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseUpdate a partial update to the RedisEnterprise database
type DatabaseUpdate struct {
	// DatabaseProperties - Properties of the database.
	*DatabaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		}
	}

	return nil
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteFuture.Result.
func (future *DeleteFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.DeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.DeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExportClusterParameters parameters for a Redis Enterprise export operation.
type ExportClusterParameters struct {
	// SasURI - SAS Uri for the target directory to export to
	SasURI *string `json:"sasUri,omitempty"`
}

// ImportClusterParameters parameters for a Redis Enterprise import operation.
type ImportClusterParameters struct {
	// SasURI - SAS Uri for the target blob to import from
	SasURI *string `json:"sasUri,omitempty"`
}

// Module specifies configuration of a redis module
type Module struct {
	// Name - The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'
	Name *string `json:"name,omitempty"`
	// Args - Configuration options for the module, e.g. 'ERROR_RATE 0.00 INITIAL_SIZE 400'.
	Args *string `json:"args,omitempty"`
	// Version - READ-ONLY; The version of the module, e.g. '1.0'.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for Module.
func (mVar Module) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Name != nil {
		objectMap["name"] = mVar.Name
	}
	if mVar.Args != nil {
		objectMap["args"] = mVar.Args
	}
	return json.Marshal(objectMap)
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'User', 'System', 'Usersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'Internal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationStatus the status of a long-running operation.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - The operation's unique id.
	ID *string `json:"id,omitempty"`
	// Name - The operation's name.
	Name *string `json:"name,omitempty"`
	// StartTime - The start time of the operation.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The end time of the operation.
	EndTime *string `json:"endTime,omitempty"`
	// Status - The current status of the operation.
	Status *string `json:"status,omitempty"`
	// Error - Error response describing why the operation failed.
	Error *ErrorResponse `json:"error,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'Succeeded', 'Creating', 'Deleting', 'Failed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsPutFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsPutFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsPutFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsPutFuture.Result.
func (future *PrivateEndpointConnectionsPutFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.PrivateEndpointConnectionsPutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.PrivateEndpointConnectionsPutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.PutResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redisenterprise.PrivateEndpointConnectionsPutFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'Pending', 'Approved', 'Rejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RegenerateKeyParameters specifies which access keys to reset to a new random value.
type RegenerateKeyParameters struct {
	// KeyType - Which access key to regenerate. Possible values include: 'Primary', 'Secondary'
	KeyType AccessKeyType `json:"keyType,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Sku SKU parameters supplied to the create RedisEnterprise operation.
type Sku struct {
	// Name - The type of RedisEnterprise cluster to deploy. Possible values: (Enterprise_E10, EnterpriseFlash_F300 etc.). Possible values include: 'EnterpriseE10', 'EnterpriseE20', 'EnterpriseE50', 'EnterpriseE100', 'EnterpriseFlashF300', 'EnterpriseFlashF700', 'EnterpriseFlashF1500'
	Name SkuName `json:"name,omitempty"`
	// Capacity - The size of the RedisEnterprise cluster. Defaults to 2 or 3 depending on SKU. Valid values are (2, 4, 6, ...) for Enterprise SKUs and (3, 9, 15, ...) for Flash SKUs.
	Capacity *int32 `json:"capacity,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UpdateFuture.Result.
func (future *UpdateFuture) result(client Client) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.UpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redisenterprise.UpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redisenterprise.UpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}
