package redisenterprise

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessKeyType enumerates the values for access key type.
type AccessKeyType string

const (
	// Primary ...
	Primary AccessKeyType = "Primary"
	// Secondary ...
	Secondary AccessKeyType = "Secondary"
)

// PossibleAccessKeyTypeValues returns an array of possible values for the AccessKeyType const type.
func PossibleAccessKeyTypeValues() []AccessKeyType {
	return []AccessKeyType{Primary, Secondary}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// Internal ...
	Internal ActionType = "Internal"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{Internal}
}

// ClusteringPolicy enumerates the values for clustering policy.
type ClusteringPolicy string

const (
	// EnterpriseCluster ...
	EnterpriseCluster ClusteringPolicy = "EnterpriseCluster"
	// OSSCluster ...
	OSSCluster ClusteringPolicy = "OSSCluster"
)

// PossibleClusteringPolicyValues returns an array of possible values for the ClusteringPolicy const type.
func PossibleClusteringPolicyValues() []ClusteringPolicy {
	return []ClusteringPolicy{EnterpriseCluster, OSSCluster}
}

// EvictionPolicy enumerates the values for eviction policy.
type EvictionPolicy string

const (
	// AllKeysLFU ...
	AllKeysLFU EvictionPolicy = "AllKeysLFU"
	// AllKeysLRU ...
	AllKeysLRU EvictionPolicy = "AllKeysLRU"
	// AllKeysRandom ...
	AllKeysRandom EvictionPolicy = "AllKeysRandom"
	// NoEviction ...
	NoEviction EvictionPolicy = "NoEviction"
	// VolatileLFU ...
	VolatileLFU EvictionPolicy = "VolatileLFU"
	// VolatileLRU ...
	VolatileLRU EvictionPolicy = "VolatileLRU"
	// VolatileRandom ...
	VolatileRandom EvictionPolicy = "VolatileRandom"
	// VolatileTTL ...
	VolatileTTL EvictionPolicy = "VolatileTTL"
)

// PossibleEvictionPolicyValues returns an array of possible values for the EvictionPolicy const type.
func PossibleEvictionPolicyValues() []EvictionPolicy {
	return []EvictionPolicy{AllKeysLFU, AllKeysLRU, AllKeysRandom, NoEviction, VolatileLFU, VolatileLRU, VolatileRandom, VolatileTTL}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// System ...
	System Origin = "system"
	// User ...
	User Origin = "user"
	// Usersystem ...
	Usersystem Origin = "user,system"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{System, User, Usersystem}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// Creating ...
	Creating PrivateEndpointConnectionProvisioningState = "Creating"
	// Deleting ...
	Deleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// Failed ...
	Failed PrivateEndpointConnectionProvisioningState = "Failed"
	// Succeeded ...
	Succeeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{Creating, Deleting, Failed, Succeeded}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// Approved ...
	Approved PrivateEndpointServiceConnectionStatus = "Approved"
	// Pending ...
	Pending PrivateEndpointServiceConnectionStatus = "Pending"
	// Rejected ...
	Rejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{Approved, Pending, Rejected}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// Encrypted ...
	Encrypted Protocol = "Encrypted"
	// Plaintext ...
	Plaintext Protocol = "Plaintext"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{Encrypted, Plaintext}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ResourceState enumerates the values for resource state.
type ResourceState string

const (
	// ResourceStateCreateFailed ...
	ResourceStateCreateFailed ResourceState = "CreateFailed"
	// ResourceStateCreating ...
	ResourceStateCreating ResourceState = "Creating"
	// ResourceStateDeleteFailed ...
	ResourceStateDeleteFailed ResourceState = "DeleteFailed"
	// ResourceStateDeleting ...
	ResourceStateDeleting ResourceState = "Deleting"
	// ResourceStateDisabled ...
	ResourceStateDisabled ResourceState = "Disabled"
	// ResourceStateDisableFailed ...
	ResourceStateDisableFailed ResourceState = "DisableFailed"
	// ResourceStateDisabling ...
	ResourceStateDisabling ResourceState = "Disabling"
	// ResourceStateEnableFailed ...
	ResourceStateEnableFailed ResourceState = "EnableFailed"
	// ResourceStateEnabling ...
	ResourceStateEnabling ResourceState = "Enabling"
	// ResourceStateRunning ...
	ResourceStateRunning ResourceState = "Running"
	// ResourceStateUpdateFailed ...
	ResourceStateUpdateFailed ResourceState = "UpdateFailed"
	// ResourceStateUpdating ...
	ResourceStateUpdating ResourceState = "Updating"
)

// PossibleResourceStateValues returns an array of possible values for the ResourceState const type.
func PossibleResourceStateValues() []ResourceState {
	return []ResourceState{ResourceStateCreateFailed, ResourceStateCreating, ResourceStateDeleteFailed, ResourceStateDeleting, ResourceStateDisabled, ResourceStateDisableFailed, ResourceStateDisabling, ResourceStateEnableFailed, ResourceStateEnabling, ResourceStateRunning, ResourceStateUpdateFailed, ResourceStateUpdating}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// EnterpriseE10 ...
	EnterpriseE10 SkuName = "Enterprise_E10"
	// EnterpriseE100 ...
	EnterpriseE100 SkuName = "Enterprise_E100"
	// EnterpriseE20 ...
	EnterpriseE20 SkuName = "Enterprise_E20"
	// EnterpriseE50 ...
	EnterpriseE50 SkuName = "Enterprise_E50"
	// EnterpriseFlashF1500 ...
	EnterpriseFlashF1500 SkuName = "EnterpriseFlash_F1500"
	// EnterpriseFlashF300 ...
	EnterpriseFlashF300 SkuName = "EnterpriseFlash_F300"
	// EnterpriseFlashF700 ...
	EnterpriseFlashF700 SkuName = "EnterpriseFlash_F700"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{EnterpriseE10, EnterpriseE100, EnterpriseE20, EnterpriseE50, EnterpriseFlashF1500, EnterpriseFlashF300, EnterpriseFlashF700}
}
