package operationalinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// BillingType enumerates the values for billing type.
type BillingType string

const (
	// BillingTypeCluster ...
	BillingTypeCluster BillingType = "Cluster"
	// BillingTypeWorkspaces ...
	BillingTypeWorkspaces BillingType = "Workspaces"
)

// PossibleBillingTypeValues returns an array of possible values for the BillingType const type.
func PossibleBillingTypeValues() []BillingType {
	return []BillingType{BillingTypeCluster, BillingTypeWorkspaces}
}

// ClusterEntityStatus enumerates the values for cluster entity status.
type ClusterEntityStatus string

const (
	// Canceled ...
	Canceled ClusterEntityStatus = "Canceled"
	// Creating ...
	Creating ClusterEntityStatus = "Creating"
	// Deleting ...
	Deleting ClusterEntityStatus = "Deleting"
	// Failed ...
	Failed ClusterEntityStatus = "Failed"
	// ProvisioningAccount ...
	ProvisioningAccount ClusterEntityStatus = "ProvisioningAccount"
	// Succeeded ...
	Succeeded ClusterEntityStatus = "Succeeded"
	// Updating ...
	Updating ClusterEntityStatus = "Updating"
)

// PossibleClusterEntityStatusValues returns an array of possible values for the ClusterEntityStatus const type.
func PossibleClusterEntityStatusValues() []ClusterEntityStatus {
	return []ClusterEntityStatus{Canceled, Creating, Deleting, Failed, ProvisioningAccount, Succeeded, Updating}
}

// ClusterSkuNameEnum enumerates the values for cluster sku name enum.
type ClusterSkuNameEnum string

const (
	// CapacityReservation ...
	CapacityReservation ClusterSkuNameEnum = "CapacityReservation"
)

// PossibleClusterSkuNameEnumValues returns an array of possible values for the ClusterSkuNameEnum const type.
func PossibleClusterSkuNameEnumValues() []ClusterSkuNameEnum {
	return []ClusterSkuNameEnum{CapacityReservation}
}

// ColumnDataTypeHintEnum enumerates the values for column data type hint enum.
type ColumnDataTypeHintEnum string

const (
	// ArmPath An Azure Resource Model (ARM) path:
	// /subscriptions/{...}/resourceGroups/{...}/providers/Microsoft.{...}/{...}/{...}/{...}...
	ArmPath ColumnDataTypeHintEnum = "armPath"
	// GUID A standard 128-bit GUID following the standard shape, xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
	GUID ColumnDataTypeHintEnum = "guid"
	// IP A standard V4/V6 ip address following the standard shape, x.x.x.x/y:y:y:y:y:y:y:y
	IP ColumnDataTypeHintEnum = "ip"
	// URI A string that matches the pattern of a URI, for example,
	// scheme://username:password@host:1234/this/is/a/path?k1=v1&k2=v2#fragment
	URI ColumnDataTypeHintEnum = "uri"
)

// PossibleColumnDataTypeHintEnumValues returns an array of possible values for the ColumnDataTypeHintEnum const type.
func PossibleColumnDataTypeHintEnumValues() []ColumnDataTypeHintEnum {
	return []ColumnDataTypeHintEnum{ArmPath, GUID, IP, URI}
}

// ColumnTypeEnum enumerates the values for column type enum.
type ColumnTypeEnum string

const (
	// ColumnTypeEnumBoolean ...
	ColumnTypeEnumBoolean ColumnTypeEnum = "boolean"
	// ColumnTypeEnumDateTime ...
	ColumnTypeEnumDateTime ColumnTypeEnum = "dateTime"
	// ColumnTypeEnumDynamic ...
	ColumnTypeEnumDynamic ColumnTypeEnum = "dynamic"
	// ColumnTypeEnumGUID ...
	ColumnTypeEnumGUID ColumnTypeEnum = "guid"
	// ColumnTypeEnumInt ...
	ColumnTypeEnumInt ColumnTypeEnum = "int"
	// ColumnTypeEnumLong ...
	ColumnTypeEnumLong ColumnTypeEnum = "long"
	// ColumnTypeEnumReal ...
	ColumnTypeEnumReal ColumnTypeEnum = "real"
	// ColumnTypeEnumString ...
	ColumnTypeEnumString ColumnTypeEnum = "string"
)

// PossibleColumnTypeEnumValues returns an array of possible values for the ColumnTypeEnum const type.
func PossibleColumnTypeEnumValues() []ColumnTypeEnum {
	return []ColumnTypeEnum{ColumnTypeEnumBoolean, ColumnTypeEnumDateTime, ColumnTypeEnumDynamic, ColumnTypeEnumGUID, ColumnTypeEnumInt, ColumnTypeEnumLong, ColumnTypeEnumReal, ColumnTypeEnumString}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// DataIngestionStatus enumerates the values for data ingestion status.
type DataIngestionStatus string

const (
	// ApproachingQuota 80% of daily cap quota reached.
	ApproachingQuota DataIngestionStatus = "ApproachingQuota"
	// ForceOff Ingestion stopped following service setting change.
	ForceOff DataIngestionStatus = "ForceOff"
	// ForceOn Ingestion started following service setting change.
	ForceOn DataIngestionStatus = "ForceOn"
	// OverQuota Reached daily cap quota, ingestion stopped.
	OverQuota DataIngestionStatus = "OverQuota"
	// RespectQuota Ingestion enabled following daily cap quota reset, or subscription enablement.
	RespectQuota DataIngestionStatus = "RespectQuota"
	// SubscriptionSuspended Ingestion stopped following suspended subscription.
	SubscriptionSuspended DataIngestionStatus = "SubscriptionSuspended"
)

// PossibleDataIngestionStatusValues returns an array of possible values for the DataIngestionStatus const type.
func PossibleDataIngestionStatusValues() []DataIngestionStatus {
	return []DataIngestionStatus{ApproachingQuota, ForceOff, ForceOn, OverQuota, RespectQuota, SubscriptionSuspended}
}

// DataSourceKind enumerates the values for data source kind.
type DataSourceKind string

const (
	// ApplicationInsights ...
	ApplicationInsights DataSourceKind = "ApplicationInsights"
	// AzureActivityLog ...
	AzureActivityLog DataSourceKind = "AzureActivityLog"
	// AzureAuditLog ...
	AzureAuditLog DataSourceKind = "AzureAuditLog"
	// ChangeTrackingContentLocation ...
	ChangeTrackingContentLocation DataSourceKind = "ChangeTrackingContentLocation"
	// ChangeTrackingCustomPath ...
	ChangeTrackingCustomPath DataSourceKind = "ChangeTrackingCustomPath"
	// ChangeTrackingDataTypeConfiguration ...
	ChangeTrackingDataTypeConfiguration DataSourceKind = "ChangeTrackingDataTypeConfiguration"
	// ChangeTrackingDefaultRegistry ...
	ChangeTrackingDefaultRegistry DataSourceKind = "ChangeTrackingDefaultRegistry"
	// ChangeTrackingLinuxPath ...
	ChangeTrackingLinuxPath DataSourceKind = "ChangeTrackingLinuxPath"
	// ChangeTrackingPath ...
	ChangeTrackingPath DataSourceKind = "ChangeTrackingPath"
	// ChangeTrackingRegistry ...
	ChangeTrackingRegistry DataSourceKind = "ChangeTrackingRegistry"
	// ChangeTrackingServices ...
	ChangeTrackingServices DataSourceKind = "ChangeTrackingServices"
	// CustomLog ...
	CustomLog DataSourceKind = "CustomLog"
	// CustomLogCollection ...
	CustomLogCollection DataSourceKind = "CustomLogCollection"
	// DNSAnalytics ...
	DNSAnalytics DataSourceKind = "DnsAnalytics"
	// GenericDataSource ...
	GenericDataSource DataSourceKind = "GenericDataSource"
	// IISLogs ...
	IISLogs DataSourceKind = "IISLogs"
	// ImportComputerGroup ...
	ImportComputerGroup DataSourceKind = "ImportComputerGroup"
	// Itsm ...
	Itsm DataSourceKind = "Itsm"
	// LinuxChangeTrackingPath ...
	LinuxChangeTrackingPath DataSourceKind = "LinuxChangeTrackingPath"
	// LinuxPerformanceCollection ...
	LinuxPerformanceCollection DataSourceKind = "LinuxPerformanceCollection"
	// LinuxPerformanceObject ...
	LinuxPerformanceObject DataSourceKind = "LinuxPerformanceObject"
	// LinuxSyslog ...
	LinuxSyslog DataSourceKind = "LinuxSyslog"
	// LinuxSyslogCollection ...
	LinuxSyslogCollection DataSourceKind = "LinuxSyslogCollection"
	// NetworkMonitoring ...
	NetworkMonitoring DataSourceKind = "NetworkMonitoring"
	// Office365 ...
	Office365 DataSourceKind = "Office365"
	// SecurityCenterSecurityWindowsBaselineConfiguration ...
	SecurityCenterSecurityWindowsBaselineConfiguration DataSourceKind = "SecurityCenterSecurityWindowsBaselineConfiguration"
	// SecurityEventCollectionConfiguration ...
	SecurityEventCollectionConfiguration DataSourceKind = "SecurityEventCollectionConfiguration"
	// SecurityInsightsSecurityEventCollectionConfiguration ...
	SecurityInsightsSecurityEventCollectionConfiguration DataSourceKind = "SecurityInsightsSecurityEventCollectionConfiguration"
	// SecurityWindowsBaselineConfiguration ...
	SecurityWindowsBaselineConfiguration DataSourceKind = "SecurityWindowsBaselineConfiguration"
	// SQLDataClassification ...
	SQLDataClassification DataSourceKind = "SqlDataClassification"
	// WindowsEvent ...
	WindowsEvent DataSourceKind = "WindowsEvent"
	// WindowsPerformanceCounter ...
	WindowsPerformanceCounter DataSourceKind = "WindowsPerformanceCounter"
	// WindowsTelemetry ...
	WindowsTelemetry DataSourceKind = "WindowsTelemetry"
)

// PossibleDataSourceKindValues returns an array of possible values for the DataSourceKind const type.
func PossibleDataSourceKindValues() []DataSourceKind {
	return []DataSourceKind{ApplicationInsights, AzureActivityLog, AzureAuditLog, ChangeTrackingContentLocation, ChangeTrackingCustomPath, ChangeTrackingDataTypeConfiguration, ChangeTrackingDefaultRegistry, ChangeTrackingLinuxPath, ChangeTrackingPath, ChangeTrackingRegistry, ChangeTrackingServices, CustomLog, CustomLogCollection, DNSAnalytics, GenericDataSource, IISLogs, ImportComputerGroup, Itsm, LinuxChangeTrackingPath, LinuxPerformanceCollection, LinuxPerformanceObject, LinuxSyslog, LinuxSyslogCollection, NetworkMonitoring, Office365, SecurityCenterSecurityWindowsBaselineConfiguration, SecurityEventCollectionConfiguration, SecurityInsightsSecurityEventCollectionConfiguration, SecurityWindowsBaselineConfiguration, SQLDataClassification, WindowsEvent, WindowsPerformanceCounter, WindowsTelemetry}
}

// DataSourceType enumerates the values for data source type.
type DataSourceType string

const (
	// Alerts ...
	Alerts DataSourceType = "Alerts"
	// AzureWatson ...
	AzureWatson DataSourceType = "AzureWatson"
	// CustomLogs ...
	CustomLogs DataSourceType = "CustomLogs"
	// Ingestion ...
	Ingestion DataSourceType = "Ingestion"
	// Query ...
	Query DataSourceType = "Query"
)

// PossibleDataSourceTypeValues returns an array of possible values for the DataSourceType const type.
func PossibleDataSourceTypeValues() []DataSourceType {
	return []DataSourceType{Alerts, AzureWatson, CustomLogs, Ingestion, Query}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeApplication ...
	IdentityTypeApplication IdentityType = "application"
	// IdentityTypeKey ...
	IdentityTypeKey IdentityType = "key"
	// IdentityTypeManagedIdentity ...
	IdentityTypeManagedIdentity IdentityType = "managedIdentity"
	// IdentityTypeUser ...
	IdentityTypeUser IdentityType = "user"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeApplication, IdentityTypeKey, IdentityTypeManagedIdentity, IdentityTypeUser}
}

// IdentityTypeForCluster enumerates the values for identity type for cluster.
type IdentityTypeForCluster string

const (
	// None ...
	None IdentityTypeForCluster = "None"
	// SystemAssigned ...
	SystemAssigned IdentityTypeForCluster = "SystemAssigned"
	// UserAssigned ...
	UserAssigned IdentityTypeForCluster = "UserAssigned"
)

// PossibleIdentityTypeForClusterValues returns an array of possible values for the IdentityTypeForCluster const type.
func PossibleIdentityTypeForClusterValues() []IdentityTypeForCluster {
	return []IdentityTypeForCluster{None, SystemAssigned, UserAssigned}
}

// LinkedServiceEntityStatus enumerates the values for linked service entity status.
type LinkedServiceEntityStatus string

const (
	// LinkedServiceEntityStatusDeleting ...
	LinkedServiceEntityStatusDeleting LinkedServiceEntityStatus = "Deleting"
	// LinkedServiceEntityStatusProvisioningAccount ...
	LinkedServiceEntityStatusProvisioningAccount LinkedServiceEntityStatus = "ProvisioningAccount"
	// LinkedServiceEntityStatusSucceeded ...
	LinkedServiceEntityStatusSucceeded LinkedServiceEntityStatus = "Succeeded"
	// LinkedServiceEntityStatusUpdating ...
	LinkedServiceEntityStatusUpdating LinkedServiceEntityStatus = "Updating"
)

// PossibleLinkedServiceEntityStatusValues returns an array of possible values for the LinkedServiceEntityStatus const type.
func PossibleLinkedServiceEntityStatusValues() []LinkedServiceEntityStatus {
	return []LinkedServiceEntityStatus{LinkedServiceEntityStatusDeleting, LinkedServiceEntityStatusProvisioningAccount, LinkedServiceEntityStatusSucceeded, LinkedServiceEntityStatusUpdating}
}

// ProvisioningStateEnum enumerates the values for provisioning state enum.
type ProvisioningStateEnum string

const (
	// ProvisioningStateEnumInProgress Table schema is stable and without changes, table data is being updated.
	ProvisioningStateEnumInProgress ProvisioningStateEnum = "InProgress"
	// ProvisioningStateEnumSucceeded Table state is stable and without changes, table is unlocked and open for
	// new updates.
	ProvisioningStateEnumSucceeded ProvisioningStateEnum = "Succeeded"
	// ProvisioningStateEnumUpdating Table schema is still being built and updated, table is currently locked
	// for any changes till the procedure is done.
	ProvisioningStateEnumUpdating ProvisioningStateEnum = "Updating"
)

// PossibleProvisioningStateEnumValues returns an array of possible values for the ProvisioningStateEnum const type.
func PossibleProvisioningStateEnumValues() []ProvisioningStateEnum {
	return []ProvisioningStateEnum{ProvisioningStateEnumInProgress, ProvisioningStateEnumSucceeded, ProvisioningStateEnumUpdating}
}

// PublicNetworkAccessType enumerates the values for public network access type.
type PublicNetworkAccessType string

const (
	// Disabled Disables public connectivity to Log Analytics through public DNS.
	Disabled PublicNetworkAccessType = "Disabled"
	// Enabled Enables connectivity to Log Analytics through public DNS.
	Enabled PublicNetworkAccessType = "Enabled"
)

// PossiblePublicNetworkAccessTypeValues returns an array of possible values for the PublicNetworkAccessType const type.
func PossiblePublicNetworkAccessTypeValues() []PublicNetworkAccessType {
	return []PublicNetworkAccessType{Disabled, Enabled}
}

// PurgeState enumerates the values for purge state.
type PurgeState string

const (
	// Completed ...
	Completed PurgeState = "completed"
	// Pending ...
	Pending PurgeState = "pending"
)

// PossiblePurgeStateValues returns an array of possible values for the PurgeState const type.
func PossiblePurgeStateValues() []PurgeState {
	return []PurgeState{Completed, Pending}
}

// SearchSortEnum enumerates the values for search sort enum.
type SearchSortEnum string

const (
	// Asc ...
	Asc SearchSortEnum = "asc"
	// Desc ...
	Desc SearchSortEnum = "desc"
)

// PossibleSearchSortEnumValues returns an array of possible values for the SearchSortEnum const type.
func PossibleSearchSortEnumValues() []SearchSortEnum {
	return []SearchSortEnum{Asc, Desc}
}

// SkuNameEnum enumerates the values for sku name enum.
type SkuNameEnum string

const (
	// SkuNameEnumCapacityReservation ...
	SkuNameEnumCapacityReservation SkuNameEnum = "CapacityReservation"
	// SkuNameEnumFree ...
	SkuNameEnumFree SkuNameEnum = "Free"
	// SkuNameEnumPerGB2018 ...
	SkuNameEnumPerGB2018 SkuNameEnum = "PerGB2018"
	// SkuNameEnumPerNode ...
	SkuNameEnumPerNode SkuNameEnum = "PerNode"
	// SkuNameEnumPremium ...
	SkuNameEnumPremium SkuNameEnum = "Premium"
	// SkuNameEnumStandalone ...
	SkuNameEnumStandalone SkuNameEnum = "Standalone"
	// SkuNameEnumStandard ...
	SkuNameEnumStandard SkuNameEnum = "Standard"
)

// PossibleSkuNameEnumValues returns an array of possible values for the SkuNameEnum const type.
func PossibleSkuNameEnumValues() []SkuNameEnum {
	return []SkuNameEnum{SkuNameEnumCapacityReservation, SkuNameEnumFree, SkuNameEnumPerGB2018, SkuNameEnumPerNode, SkuNameEnumPremium, SkuNameEnumStandalone, SkuNameEnumStandard}
}

// SourceEnum enumerates the values for source enum.
type SourceEnum string

const (
	// Customer Tables created by the owner of the Workspace, and only found in this Workspace.
	Customer SourceEnum = "customer"
	// Microsoft Tables provisioned by the system, as collected via Diagnostic Settings, the Agents, or any
	// other standard data collection means.
	Microsoft SourceEnum = "microsoft"
)

// PossibleSourceEnumValues returns an array of possible values for the SourceEnum const type.
func PossibleSourceEnumValues() []SourceEnum {
	return []SourceEnum{Customer, Microsoft}
}

// StorageInsightState enumerates the values for storage insight state.
type StorageInsightState string

const (
	// ERROR ...
	ERROR StorageInsightState = "ERROR"
	// OK ...
	OK StorageInsightState = "OK"
)

// PossibleStorageInsightStateValues returns an array of possible values for the StorageInsightState const type.
func PossibleStorageInsightStateValues() []StorageInsightState {
	return []StorageInsightState{ERROR, OK}
}

// TablePlanEnum enumerates the values for table plan enum.
type TablePlanEnum string

const (
	// Analytics Logs  that allow monitoring and analytics.
	Analytics TablePlanEnum = "Analytics"
	// Basic Logs  that are adjusted to support high volume low value verbose logs.
	Basic TablePlanEnum = "Basic"
)

// PossibleTablePlanEnumValues returns an array of possible values for the TablePlanEnum const type.
func PossibleTablePlanEnumValues() []TablePlanEnum {
	return []TablePlanEnum{Analytics, Basic}
}

// TableSubTypeEnum enumerates the values for table sub type enum.
type TableSubTypeEnum string

const (
	// Any The default subtype with which built-in tables are created.
	Any TableSubTypeEnum = "Any"
	// Classic Indicates a table created through the Data Collector API or with the custom logs feature of the
	// MMA agent, or any table against which Custom Fields were created.
	Classic TableSubTypeEnum = "Classic"
	// DataCollectionRuleBased A table eligible to have data sent into it via any of the means supported by
	// Data Collection Rules: the Data Collection Endpoint API, ingestion-time transformations, or any other
	// mechanism provided by Data Collection Rules
	DataCollectionRuleBased TableSubTypeEnum = "DataCollectionRuleBased"
)

// PossibleTableSubTypeEnumValues returns an array of possible values for the TableSubTypeEnum const type.
func PossibleTableSubTypeEnumValues() []TableSubTypeEnum {
	return []TableSubTypeEnum{Any, Classic, DataCollectionRuleBased}
}

// TableTypeEnum enumerates the values for table type enum.
type TableTypeEnum string

const (
	// TableTypeEnumCustomLog Custom log table.
	TableTypeEnumCustomLog TableTypeEnum = "CustomLog"
	// TableTypeEnumMicrosoft Standard data collected by Azure Monitor.
	TableTypeEnumMicrosoft TableTypeEnum = "Microsoft"
	// TableTypeEnumRestoredLogs Restored data.
	TableTypeEnumRestoredLogs TableTypeEnum = "RestoredLogs"
	// TableTypeEnumSearchResults Data collected by a search job.
	TableTypeEnumSearchResults TableTypeEnum = "SearchResults"
)

// PossibleTableTypeEnumValues returns an array of possible values for the TableTypeEnum const type.
func PossibleTableTypeEnumValues() []TableTypeEnum {
	return []TableTypeEnum{TableTypeEnumCustomLog, TableTypeEnumMicrosoft, TableTypeEnumRestoredLogs, TableTypeEnumSearchResults}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeEventHub ...
	TypeEventHub Type = "EventHub"
	// TypeStorageAccount ...
	TypeStorageAccount Type = "StorageAccount"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeEventHub, TypeStorageAccount}
}

// WorkspaceEntityStatus enumerates the values for workspace entity status.
type WorkspaceEntityStatus string

const (
	// WorkspaceEntityStatusCanceled ...
	WorkspaceEntityStatusCanceled WorkspaceEntityStatus = "Canceled"
	// WorkspaceEntityStatusCreating ...
	WorkspaceEntityStatusCreating WorkspaceEntityStatus = "Creating"
	// WorkspaceEntityStatusDeleting ...
	WorkspaceEntityStatusDeleting WorkspaceEntityStatus = "Deleting"
	// WorkspaceEntityStatusFailed ...
	WorkspaceEntityStatusFailed WorkspaceEntityStatus = "Failed"
	// WorkspaceEntityStatusProvisioningAccount ...
	WorkspaceEntityStatusProvisioningAccount WorkspaceEntityStatus = "ProvisioningAccount"
	// WorkspaceEntityStatusSucceeded ...
	WorkspaceEntityStatusSucceeded WorkspaceEntityStatus = "Succeeded"
	// WorkspaceEntityStatusUpdating ...
	WorkspaceEntityStatusUpdating WorkspaceEntityStatus = "Updating"
)

// PossibleWorkspaceEntityStatusValues returns an array of possible values for the WorkspaceEntityStatus const type.
func PossibleWorkspaceEntityStatusValues() []WorkspaceEntityStatus {
	return []WorkspaceEntityStatus{WorkspaceEntityStatusCanceled, WorkspaceEntityStatusCreating, WorkspaceEntityStatusDeleting, WorkspaceEntityStatusFailed, WorkspaceEntityStatusProvisioningAccount, WorkspaceEntityStatusSucceeded, WorkspaceEntityStatusUpdating}
}

// WorkspaceSkuNameEnum enumerates the values for workspace sku name enum.
type WorkspaceSkuNameEnum string

const (
	// WorkspaceSkuNameEnumCapacityReservation ...
	WorkspaceSkuNameEnumCapacityReservation WorkspaceSkuNameEnum = "CapacityReservation"
	// WorkspaceSkuNameEnumFree ...
	WorkspaceSkuNameEnumFree WorkspaceSkuNameEnum = "Free"
	// WorkspaceSkuNameEnumLACluster ...
	WorkspaceSkuNameEnumLACluster WorkspaceSkuNameEnum = "LACluster"
	// WorkspaceSkuNameEnumPerGB2018 ...
	WorkspaceSkuNameEnumPerGB2018 WorkspaceSkuNameEnum = "PerGB2018"
	// WorkspaceSkuNameEnumPerNode ...
	WorkspaceSkuNameEnumPerNode WorkspaceSkuNameEnum = "PerNode"
	// WorkspaceSkuNameEnumPremium ...
	WorkspaceSkuNameEnumPremium WorkspaceSkuNameEnum = "Premium"
	// WorkspaceSkuNameEnumStandalone ...
	WorkspaceSkuNameEnumStandalone WorkspaceSkuNameEnum = "Standalone"
	// WorkspaceSkuNameEnumStandard ...
	WorkspaceSkuNameEnumStandard WorkspaceSkuNameEnum = "Standard"
)

// PossibleWorkspaceSkuNameEnumValues returns an array of possible values for the WorkspaceSkuNameEnum const type.
func PossibleWorkspaceSkuNameEnumValues() []WorkspaceSkuNameEnum {
	return []WorkspaceSkuNameEnum{WorkspaceSkuNameEnumCapacityReservation, WorkspaceSkuNameEnumFree, WorkspaceSkuNameEnumLACluster, WorkspaceSkuNameEnumPerGB2018, WorkspaceSkuNameEnumPerNode, WorkspaceSkuNameEnumPremium, WorkspaceSkuNameEnumStandalone, WorkspaceSkuNameEnumStandard}
}
