package migrate

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CleanupState enumerates the values for cleanup state.
type CleanupState string

const (
	// Completed ...
	Completed CleanupState = "Completed"
	// Failed ...
	Failed CleanupState = "Failed"
	// InProgress ...
	InProgress CleanupState = "InProgress"
	// None ...
	None CleanupState = "None"
	// Started ...
	Started CleanupState = "Started"
)

// PossibleCleanupStateValues returns an array of possible values for the CleanupState const type.
func PossibleCleanupStateValues() []CleanupState {
	return []CleanupState{Completed, Failed, InProgress, None, Started}
}

// ContainerElementKind enumerates the values for container element kind.
type ContainerElementKind string

const (
	// ContainerElementKindActionImport ...
	ContainerElementKindActionImport ContainerElementKind = "ActionImport"
	// ContainerElementKindEntitySet ...
	ContainerElementKindEntitySet ContainerElementKind = "EntitySet"
	// ContainerElementKindFunctionImport ...
	ContainerElementKindFunctionImport ContainerElementKind = "FunctionImport"
	// ContainerElementKindNone ...
	ContainerElementKindNone ContainerElementKind = "None"
	// ContainerElementKindSingleton ...
	ContainerElementKindSingleton ContainerElementKind = "Singleton"
)

// PossibleContainerElementKindValues returns an array of possible values for the ContainerElementKind const type.
func PossibleContainerElementKindValues() []ContainerElementKind {
	return []ContainerElementKind{ContainerElementKindActionImport, ContainerElementKindEntitySet, ContainerElementKindFunctionImport, ContainerElementKindNone, ContainerElementKindSingleton}
}

// ExpressionKind enumerates the values for expression kind.
type ExpressionKind string

const (
	// ExpressionKindAnnotationPath ...
	ExpressionKindAnnotationPath ExpressionKind = "AnnotationPath"
	// ExpressionKindBinaryConstant ...
	ExpressionKindBinaryConstant ExpressionKind = "BinaryConstant"
	// ExpressionKindBooleanConstant ...
	ExpressionKindBooleanConstant ExpressionKind = "BooleanConstant"
	// ExpressionKindCast ...
	ExpressionKindCast ExpressionKind = "Cast"
	// ExpressionKindCollection ...
	ExpressionKindCollection ExpressionKind = "Collection"
	// ExpressionKindDateConstant ...
	ExpressionKindDateConstant ExpressionKind = "DateConstant"
	// ExpressionKindDateTimeOffsetConstant ...
	ExpressionKindDateTimeOffsetConstant ExpressionKind = "DateTimeOffsetConstant"
	// ExpressionKindDecimalConstant ...
	ExpressionKindDecimalConstant ExpressionKind = "DecimalConstant"
	// ExpressionKindDurationConstant ...
	ExpressionKindDurationConstant ExpressionKind = "DurationConstant"
	// ExpressionKindEnumMember ...
	ExpressionKindEnumMember ExpressionKind = "EnumMember"
	// ExpressionKindFloatingConstant ...
	ExpressionKindFloatingConstant ExpressionKind = "FloatingConstant"
	// ExpressionKindFunctionApplication ...
	ExpressionKindFunctionApplication ExpressionKind = "FunctionApplication"
	// ExpressionKindGUIDConstant ...
	ExpressionKindGUIDConstant ExpressionKind = "GuidConstant"
	// ExpressionKindIf ...
	ExpressionKindIf ExpressionKind = "If"
	// ExpressionKindIntegerConstant ...
	ExpressionKindIntegerConstant ExpressionKind = "IntegerConstant"
	// ExpressionKindIsType ...
	ExpressionKindIsType ExpressionKind = "IsType"
	// ExpressionKindLabeled ...
	ExpressionKindLabeled ExpressionKind = "Labeled"
	// ExpressionKindLabeledExpressionReference ...
	ExpressionKindLabeledExpressionReference ExpressionKind = "LabeledExpressionReference"
	// ExpressionKindNavigationPropertyPath ...
	ExpressionKindNavigationPropertyPath ExpressionKind = "NavigationPropertyPath"
	// ExpressionKindNone ...
	ExpressionKindNone ExpressionKind = "None"
	// ExpressionKindNull ...
	ExpressionKindNull ExpressionKind = "Null"
	// ExpressionKindPath ...
	ExpressionKindPath ExpressionKind = "Path"
	// ExpressionKindPropertyPath ...
	ExpressionKindPropertyPath ExpressionKind = "PropertyPath"
	// ExpressionKindRecord ...
	ExpressionKindRecord ExpressionKind = "Record"
	// ExpressionKindStringConstant ...
	ExpressionKindStringConstant ExpressionKind = "StringConstant"
	// ExpressionKindTimeOfDayConstant ...
	ExpressionKindTimeOfDayConstant ExpressionKind = "TimeOfDayConstant"
)

// PossibleExpressionKindValues returns an array of possible values for the ExpressionKind const type.
func PossibleExpressionKindValues() []ExpressionKind {
	return []ExpressionKind{ExpressionKindAnnotationPath, ExpressionKindBinaryConstant, ExpressionKindBooleanConstant, ExpressionKindCast, ExpressionKindCollection, ExpressionKindDateConstant, ExpressionKindDateTimeOffsetConstant, ExpressionKindDecimalConstant, ExpressionKindDurationConstant, ExpressionKindEnumMember, ExpressionKindFloatingConstant, ExpressionKindFunctionApplication, ExpressionKindGUIDConstant, ExpressionKindIf, ExpressionKindIntegerConstant, ExpressionKindIsType, ExpressionKindLabeled, ExpressionKindLabeledExpressionReference, ExpressionKindNavigationPropertyPath, ExpressionKindNone, ExpressionKindNull, ExpressionKindPath, ExpressionKindPropertyPath, ExpressionKindRecord, ExpressionKindStringConstant, ExpressionKindTimeOfDayConstant}
}

// ExpressionKind1 enumerates the values for expression kind 1.
type ExpressionKind1 string

const (
	// ExpressionKind1AnnotationPath ...
	ExpressionKind1AnnotationPath ExpressionKind1 = "AnnotationPath"
	// ExpressionKind1BinaryConstant ...
	ExpressionKind1BinaryConstant ExpressionKind1 = "BinaryConstant"
	// ExpressionKind1BooleanConstant ...
	ExpressionKind1BooleanConstant ExpressionKind1 = "BooleanConstant"
	// ExpressionKind1Cast ...
	ExpressionKind1Cast ExpressionKind1 = "Cast"
	// ExpressionKind1Collection ...
	ExpressionKind1Collection ExpressionKind1 = "Collection"
	// ExpressionKind1DateConstant ...
	ExpressionKind1DateConstant ExpressionKind1 = "DateConstant"
	// ExpressionKind1DateTimeOffsetConstant ...
	ExpressionKind1DateTimeOffsetConstant ExpressionKind1 = "DateTimeOffsetConstant"
	// ExpressionKind1DecimalConstant ...
	ExpressionKind1DecimalConstant ExpressionKind1 = "DecimalConstant"
	// ExpressionKind1DurationConstant ...
	ExpressionKind1DurationConstant ExpressionKind1 = "DurationConstant"
	// ExpressionKind1EnumMember ...
	ExpressionKind1EnumMember ExpressionKind1 = "EnumMember"
	// ExpressionKind1FloatingConstant ...
	ExpressionKind1FloatingConstant ExpressionKind1 = "FloatingConstant"
	// ExpressionKind1FunctionApplication ...
	ExpressionKind1FunctionApplication ExpressionKind1 = "FunctionApplication"
	// ExpressionKind1GUIDConstant ...
	ExpressionKind1GUIDConstant ExpressionKind1 = "GuidConstant"
	// ExpressionKind1If ...
	ExpressionKind1If ExpressionKind1 = "If"
	// ExpressionKind1IntegerConstant ...
	ExpressionKind1IntegerConstant ExpressionKind1 = "IntegerConstant"
	// ExpressionKind1IsType ...
	ExpressionKind1IsType ExpressionKind1 = "IsType"
	// ExpressionKind1Labeled ...
	ExpressionKind1Labeled ExpressionKind1 = "Labeled"
	// ExpressionKind1LabeledExpressionReference ...
	ExpressionKind1LabeledExpressionReference ExpressionKind1 = "LabeledExpressionReference"
	// ExpressionKind1NavigationPropertyPath ...
	ExpressionKind1NavigationPropertyPath ExpressionKind1 = "NavigationPropertyPath"
	// ExpressionKind1None ...
	ExpressionKind1None ExpressionKind1 = "None"
	// ExpressionKind1Null ...
	ExpressionKind1Null ExpressionKind1 = "Null"
	// ExpressionKind1Path ...
	ExpressionKind1Path ExpressionKind1 = "Path"
	// ExpressionKind1PropertyPath ...
	ExpressionKind1PropertyPath ExpressionKind1 = "PropertyPath"
	// ExpressionKind1Record ...
	ExpressionKind1Record ExpressionKind1 = "Record"
	// ExpressionKind1StringConstant ...
	ExpressionKind1StringConstant ExpressionKind1 = "StringConstant"
	// ExpressionKind1TimeOfDayConstant ...
	ExpressionKind1TimeOfDayConstant ExpressionKind1 = "TimeOfDayConstant"
)

// PossibleExpressionKind1Values returns an array of possible values for the ExpressionKind1 const type.
func PossibleExpressionKind1Values() []ExpressionKind1 {
	return []ExpressionKind1{ExpressionKind1AnnotationPath, ExpressionKind1BinaryConstant, ExpressionKind1BooleanConstant, ExpressionKind1Cast, ExpressionKind1Collection, ExpressionKind1DateConstant, ExpressionKind1DateTimeOffsetConstant, ExpressionKind1DecimalConstant, ExpressionKind1DurationConstant, ExpressionKind1EnumMember, ExpressionKind1FloatingConstant, ExpressionKind1FunctionApplication, ExpressionKind1GUIDConstant, ExpressionKind1If, ExpressionKind1IntegerConstant, ExpressionKind1IsType, ExpressionKind1Labeled, ExpressionKind1LabeledExpressionReference, ExpressionKind1NavigationPropertyPath, ExpressionKind1None, ExpressionKind1Null, ExpressionKind1Path, ExpressionKind1PropertyPath, ExpressionKind1Record, ExpressionKind1StringConstant, ExpressionKind1TimeOfDayConstant}
}

// Goal enumerates the values for goal.
type Goal string

const (
	// Databases ...
	Databases Goal = "Databases"
	// Servers ...
	Servers Goal = "Servers"
)

// PossibleGoalValues returns an array of possible values for the Goal const type.
func PossibleGoalValues() []Goal {
	return []Goal{Databases, Servers}
}

// Goal1 enumerates the values for goal 1.
type Goal1 string

const (
	// Goal1Databases ...
	Goal1Databases Goal1 = "Databases"
	// Goal1Servers ...
	Goal1Servers Goal1 = "Servers"
)

// PossibleGoal1Values returns an array of possible values for the Goal1 const type.
func PossibleGoal1Values() []Goal1 {
	return []Goal1{Goal1Databases, Goal1Servers}
}

// InstanceType enumerates the values for instance type.
type InstanceType string

const (
	// InstanceTypeDatabases ...
	InstanceTypeDatabases InstanceType = "Databases"
	// InstanceTypeMigrateEventProperties ...
	InstanceTypeMigrateEventProperties InstanceType = "MigrateEventProperties"
	// InstanceTypeServers ...
	InstanceTypeServers InstanceType = "Servers"
)

// PossibleInstanceTypeValues returns an array of possible values for the InstanceType const type.
func PossibleInstanceTypeValues() []InstanceType {
	return []InstanceType{InstanceTypeDatabases, InstanceTypeMigrateEventProperties, InstanceTypeServers}
}

// InstanceTypeBasicProjectSummary enumerates the values for instance type basic project summary.
type InstanceTypeBasicProjectSummary string

const (
	// InstanceTypeBasicProjectSummaryInstanceTypeDatabases ...
	InstanceTypeBasicProjectSummaryInstanceTypeDatabases InstanceTypeBasicProjectSummary = "Databases"
	// InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary ...
	InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary InstanceTypeBasicProjectSummary = "ProjectSummary"
	// InstanceTypeBasicProjectSummaryInstanceTypeServers ...
	InstanceTypeBasicProjectSummaryInstanceTypeServers InstanceTypeBasicProjectSummary = "Servers"
)

// PossibleInstanceTypeBasicProjectSummaryValues returns an array of possible values for the InstanceTypeBasicProjectSummary const type.
func PossibleInstanceTypeBasicProjectSummaryValues() []InstanceTypeBasicProjectSummary {
	return []InstanceTypeBasicProjectSummary{InstanceTypeBasicProjectSummaryInstanceTypeDatabases, InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary, InstanceTypeBasicProjectSummaryInstanceTypeServers}
}

// InstanceTypeBasicSolutionSummary enumerates the values for instance type basic solution summary.
type InstanceTypeBasicSolutionSummary string

const (
	// InstanceTypeBasicSolutionSummaryInstanceTypeDatabases ...
	InstanceTypeBasicSolutionSummaryInstanceTypeDatabases InstanceTypeBasicSolutionSummary = "Databases"
	// InstanceTypeBasicSolutionSummaryInstanceTypeServers ...
	InstanceTypeBasicSolutionSummaryInstanceTypeServers InstanceTypeBasicSolutionSummary = "Servers"
	// InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary ...
	InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary InstanceTypeBasicSolutionSummary = "SolutionSummary"
)

// PossibleInstanceTypeBasicSolutionSummaryValues returns an array of possible values for the InstanceTypeBasicSolutionSummary const type.
func PossibleInstanceTypeBasicSolutionSummaryValues() []InstanceTypeBasicSolutionSummary {
	return []InstanceTypeBasicSolutionSummary{InstanceTypeBasicSolutionSummaryInstanceTypeDatabases, InstanceTypeBasicSolutionSummaryInstanceTypeServers, InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindAggregatedCollectionPropertyNode ...
	KindAggregatedCollectionPropertyNode Kind = "AggregatedCollectionPropertyNode"
	// KindAll ...
	KindAll Kind = "All"
	// KindAny ...
	KindAny Kind = "Any"
	// KindBinaryOperator ...
	KindBinaryOperator Kind = "BinaryOperator"
	// KindCollectionComplexNode ...
	KindCollectionComplexNode Kind = "CollectionComplexNode"
	// KindCollectionConstant ...
	KindCollectionConstant Kind = "CollectionConstant"
	// KindCollectionFunctionCall ...
	KindCollectionFunctionCall Kind = "CollectionFunctionCall"
	// KindCollectionNavigationNode ...
	KindCollectionNavigationNode Kind = "CollectionNavigationNode"
	// KindCollectionOpenPropertyAccess ...
	KindCollectionOpenPropertyAccess Kind = "CollectionOpenPropertyAccess"
	// KindCollectionPropertyAccess ...
	KindCollectionPropertyAccess Kind = "CollectionPropertyAccess"
	// KindCollectionPropertyNode ...
	KindCollectionPropertyNode Kind = "CollectionPropertyNode"
	// KindCollectionResourceCast ...
	KindCollectionResourceCast Kind = "CollectionResourceCast"
	// KindCollectionResourceFunctionCall ...
	KindCollectionResourceFunctionCall Kind = "CollectionResourceFunctionCall"
	// KindConstant ...
	KindConstant Kind = "Constant"
	// KindConvert ...
	KindConvert Kind = "Convert"
	// KindCount ...
	KindCount Kind = "Count"
	// KindEntitySet ...
	KindEntitySet Kind = "EntitySet"
	// KindIn ...
	KindIn Kind = "In"
	// KindKeyLookup ...
	KindKeyLookup Kind = "KeyLookup"
	// KindNamedFunctionParameter ...
	KindNamedFunctionParameter Kind = "NamedFunctionParameter"
	// KindNone ...
	KindNone Kind = "None"
	// KindNonResourceRangeVariableReference ...
	KindNonResourceRangeVariableReference Kind = "NonResourceRangeVariableReference"
	// KindParameterAlias ...
	KindParameterAlias Kind = "ParameterAlias"
	// KindResourceRangeVariableReference ...
	KindResourceRangeVariableReference Kind = "ResourceRangeVariableReference"
	// KindSearchTerm ...
	KindSearchTerm Kind = "SearchTerm"
	// KindSingleComplexNode ...
	KindSingleComplexNode Kind = "SingleComplexNode"
	// KindSingleNavigationNode ...
	KindSingleNavigationNode Kind = "SingleNavigationNode"
	// KindSingleResourceCast ...
	KindSingleResourceCast Kind = "SingleResourceCast"
	// KindSingleResourceFunctionCall ...
	KindSingleResourceFunctionCall Kind = "SingleResourceFunctionCall"
	// KindSingleValueCast ...
	KindSingleValueCast Kind = "SingleValueCast"
	// KindSingleValueFunctionCall ...
	KindSingleValueFunctionCall Kind = "SingleValueFunctionCall"
	// KindSingleValueOpenPropertyAccess ...
	KindSingleValueOpenPropertyAccess Kind = "SingleValueOpenPropertyAccess"
	// KindSingleValuePropertyAccess ...
	KindSingleValuePropertyAccess Kind = "SingleValuePropertyAccess"
	// KindUnaryOperator ...
	KindUnaryOperator Kind = "UnaryOperator"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindAggregatedCollectionPropertyNode, KindAll, KindAny, KindBinaryOperator, KindCollectionComplexNode, KindCollectionConstant, KindCollectionFunctionCall, KindCollectionNavigationNode, KindCollectionOpenPropertyAccess, KindCollectionPropertyAccess, KindCollectionPropertyNode, KindCollectionResourceCast, KindCollectionResourceFunctionCall, KindConstant, KindConvert, KindCount, KindEntitySet, KindIn, KindKeyLookup, KindNamedFunctionParameter, KindNone, KindNonResourceRangeVariableReference, KindParameterAlias, KindResourceRangeVariableReference, KindSearchTerm, KindSingleComplexNode, KindSingleNavigationNode, KindSingleResourceCast, KindSingleResourceFunctionCall, KindSingleValueCast, KindSingleValueFunctionCall, KindSingleValueOpenPropertyAccess, KindSingleValuePropertyAccess, KindUnaryOperator}
}

// Kind1 enumerates the values for kind 1.
type Kind1 string

const (
	// Aggregate ...
	Aggregate Kind1 = "Aggregate"
	// Compute ...
	Compute Kind1 = "Compute"
	// Filter ...
	Filter Kind1 = "Filter"
	// GroupBy ...
	GroupBy Kind1 = "GroupBy"
)

// PossibleKind1Values returns an array of possible values for the Kind1 const type.
func PossibleKind1Values() []Kind1 {
	return []Kind1{Aggregate, Compute, Filter, GroupBy}
}

// OnDelete enumerates the values for on delete.
type OnDelete string

const (
	// OnDeleteCascade ...
	OnDeleteCascade OnDelete = "Cascade"
	// OnDeleteNone ...
	OnDeleteNone OnDelete = "None"
)

// PossibleOnDeleteValues returns an array of possible values for the OnDelete const type.
func PossibleOnDeleteValues() []OnDelete {
	return []OnDelete{OnDeleteCascade, OnDeleteNone}
}

// PropertyKind enumerates the values for property kind.
type PropertyKind string

const (
	// PropertyKindNavigation ...
	PropertyKindNavigation PropertyKind = "Navigation"
	// PropertyKindNone ...
	PropertyKindNone PropertyKind = "None"
	// PropertyKindStructural ...
	PropertyKindStructural PropertyKind = "Structural"
)

// PossiblePropertyKindValues returns an array of possible values for the PropertyKind const type.
func PossiblePropertyKindValues() []PropertyKind {
	return []PropertyKind{PropertyKindNavigation, PropertyKindNone, PropertyKindStructural}
}

// PropertyKind1 enumerates the values for property kind 1.
type PropertyKind1 string

const (
	// PropertyKind1Navigation ...
	PropertyKind1Navigation PropertyKind1 = "Navigation"
	// PropertyKind1None ...
	PropertyKind1None PropertyKind1 = "None"
	// PropertyKind1Structural ...
	PropertyKind1Structural PropertyKind1 = "Structural"
)

// PossiblePropertyKind1Values returns an array of possible values for the PropertyKind1 const type.
func PossiblePropertyKind1Values() []PropertyKind1 {
	return []PropertyKind1{PropertyKind1Navigation, PropertyKind1None, PropertyKind1Structural}
}

// PropertyKind2 enumerates the values for property kind 2.
type PropertyKind2 string

const (
	// PropertyKind2Navigation ...
	PropertyKind2Navigation PropertyKind2 = "Navigation"
	// PropertyKind2None ...
	PropertyKind2None PropertyKind2 = "None"
	// PropertyKind2Structural ...
	PropertyKind2Structural PropertyKind2 = "Structural"
)

// PossiblePropertyKind2Values returns an array of possible values for the PropertyKind2 const type.
func PossiblePropertyKind2Values() []PropertyKind2 {
	return []PropertyKind2{PropertyKind2Navigation, PropertyKind2None, PropertyKind2Structural}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateMoving ...
	ProvisioningStateMoving ProvisioningState = "Moving"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateMoving, ProvisioningStateSucceeded}
}

// Purpose enumerates the values for purpose.
type Purpose string

const (
	// Assessment ...
	Assessment Purpose = "Assessment"
	// Discovery ...
	Discovery Purpose = "Discovery"
	// Migration ...
	Migration Purpose = "Migration"
)

// PossiblePurposeValues returns an array of possible values for the Purpose const type.
func PossiblePurposeValues() []Purpose {
	return []Purpose{Assessment, Discovery, Migration}
}

// RefreshSummaryState enumerates the values for refresh summary state.
type RefreshSummaryState string

const (
	// RefreshSummaryStateCompleted ...
	RefreshSummaryStateCompleted RefreshSummaryState = "Completed"
	// RefreshSummaryStateFailed ...
	RefreshSummaryStateFailed RefreshSummaryState = "Failed"
	// RefreshSummaryStateInProgress ...
	RefreshSummaryStateInProgress RefreshSummaryState = "InProgress"
	// RefreshSummaryStateStarted ...
	RefreshSummaryStateStarted RefreshSummaryState = "Started"
)

// PossibleRefreshSummaryStateValues returns an array of possible values for the RefreshSummaryState const type.
func PossibleRefreshSummaryStateValues() []RefreshSummaryState {
	return []RefreshSummaryState{RefreshSummaryStateCompleted, RefreshSummaryStateFailed, RefreshSummaryStateInProgress, RefreshSummaryStateStarted}
}

// RefreshSummaryState1 enumerates the values for refresh summary state 1.
type RefreshSummaryState1 string

const (
	// RefreshSummaryState1Completed ...
	RefreshSummaryState1Completed RefreshSummaryState1 = "Completed"
	// RefreshSummaryState1Failed ...
	RefreshSummaryState1Failed RefreshSummaryState1 = "Failed"
	// RefreshSummaryState1InProgress ...
	RefreshSummaryState1InProgress RefreshSummaryState1 = "InProgress"
	// RefreshSummaryState1Started ...
	RefreshSummaryState1Started RefreshSummaryState1 = "Started"
)

// PossibleRefreshSummaryState1Values returns an array of possible values for the RefreshSummaryState1 const type.
func PossibleRefreshSummaryState1Values() []RefreshSummaryState1 {
	return []RefreshSummaryState1{RefreshSummaryState1Completed, RefreshSummaryState1Failed, RefreshSummaryState1InProgress, RefreshSummaryState1Started}
}

// SchemaElementKind enumerates the values for schema element kind.
type SchemaElementKind string

const (
	// SchemaElementKindAction ...
	SchemaElementKindAction SchemaElementKind = "Action"
	// SchemaElementKindEntityContainer ...
	SchemaElementKindEntityContainer SchemaElementKind = "EntityContainer"
	// SchemaElementKindFunction ...
	SchemaElementKindFunction SchemaElementKind = "Function"
	// SchemaElementKindNone ...
	SchemaElementKindNone SchemaElementKind = "None"
	// SchemaElementKindTerm ...
	SchemaElementKindTerm SchemaElementKind = "Term"
	// SchemaElementKindTypeDefinition ...
	SchemaElementKindTypeDefinition SchemaElementKind = "TypeDefinition"
)

// PossibleSchemaElementKindValues returns an array of possible values for the SchemaElementKind const type.
func PossibleSchemaElementKindValues() []SchemaElementKind {
	return []SchemaElementKind{SchemaElementKindAction, SchemaElementKindEntityContainer, SchemaElementKindFunction, SchemaElementKindNone, SchemaElementKindTerm, SchemaElementKindTypeDefinition}
}

// SchemaElementKind1 enumerates the values for schema element kind 1.
type SchemaElementKind1 string

const (
	// SchemaElementKind1Action ...
	SchemaElementKind1Action SchemaElementKind1 = "Action"
	// SchemaElementKind1EntityContainer ...
	SchemaElementKind1EntityContainer SchemaElementKind1 = "EntityContainer"
	// SchemaElementKind1Function ...
	SchemaElementKind1Function SchemaElementKind1 = "Function"
	// SchemaElementKind1None ...
	SchemaElementKind1None SchemaElementKind1 = "None"
	// SchemaElementKind1Term ...
	SchemaElementKind1Term SchemaElementKind1 = "Term"
	// SchemaElementKind1TypeDefinition ...
	SchemaElementKind1TypeDefinition SchemaElementKind1 = "TypeDefinition"
)

// PossibleSchemaElementKind1Values returns an array of possible values for the SchemaElementKind1 const type.
func PossibleSchemaElementKind1Values() []SchemaElementKind1 {
	return []SchemaElementKind1{SchemaElementKind1Action, SchemaElementKind1EntityContainer, SchemaElementKind1Function, SchemaElementKind1None, SchemaElementKind1Term, SchemaElementKind1TypeDefinition}
}

// SchemaElementKind2 enumerates the values for schema element kind 2.
type SchemaElementKind2 string

const (
	// SchemaElementKind2Action ...
	SchemaElementKind2Action SchemaElementKind2 = "Action"
	// SchemaElementKind2EntityContainer ...
	SchemaElementKind2EntityContainer SchemaElementKind2 = "EntityContainer"
	// SchemaElementKind2Function ...
	SchemaElementKind2Function SchemaElementKind2 = "Function"
	// SchemaElementKind2None ...
	SchemaElementKind2None SchemaElementKind2 = "None"
	// SchemaElementKind2Term ...
	SchemaElementKind2Term SchemaElementKind2 = "Term"
	// SchemaElementKind2TypeDefinition ...
	SchemaElementKind2TypeDefinition SchemaElementKind2 = "TypeDefinition"
)

// PossibleSchemaElementKind2Values returns an array of possible values for the SchemaElementKind2 const type.
func PossibleSchemaElementKind2Values() []SchemaElementKind2 {
	return []SchemaElementKind2{SchemaElementKind2Action, SchemaElementKind2EntityContainer, SchemaElementKind2Function, SchemaElementKind2None, SchemaElementKind2Term, SchemaElementKind2TypeDefinition}
}

// Status enumerates the values for status.
type Status string

const (
	// Active ...
	Active Status = "Active"
	// Inactive ...
	Inactive Status = "Inactive"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Active, Inactive}
}

// Tool enumerates the values for tool.
type Tool string

const (
	// Carbonite ...
	Carbonite Tool = "Carbonite"
	// Cloudamize ...
	Cloudamize Tool = "Cloudamize"
	// CorentTech ...
	CorentTech Tool = "CorentTech"
	// DatabaseMigrationService ...
	DatabaseMigrationService Tool = "DatabaseMigrationService"
	// DataMigrationAssistant ...
	DataMigrationAssistant Tool = "DataMigrationAssistant"
	// ServerAssessment ...
	ServerAssessment Tool = "ServerAssessment"
	// ServerAssessmentV1 ...
	ServerAssessmentV1 Tool = "ServerAssessmentV1"
	// ServerDiscovery ...
	ServerDiscovery Tool = "ServerDiscovery"
	// ServerMigration ...
	ServerMigration Tool = "ServerMigration"
	// ServerMigrationReplication ...
	ServerMigrationReplication Tool = "ServerMigration_Replication"
	// Turbonomic ...
	Turbonomic Tool = "Turbonomic"
	// Zerto ...
	Zerto Tool = "Zerto"
)

// PossibleToolValues returns an array of possible values for the Tool const type.
func PossibleToolValues() []Tool {
	return []Tool{Carbonite, Cloudamize, CorentTech, DatabaseMigrationService, DataMigrationAssistant, ServerAssessment, ServerAssessmentV1, ServerDiscovery, ServerMigration, ServerMigrationReplication, Turbonomic, Zerto}
}

// Tool1 enumerates the values for tool 1.
type Tool1 string

const (
	// Tool1Carbonite ...
	Tool1Carbonite Tool1 = "Carbonite"
	// Tool1Cloudamize ...
	Tool1Cloudamize Tool1 = "Cloudamize"
	// Tool1CorentTech ...
	Tool1CorentTech Tool1 = "CorentTech"
	// Tool1DatabaseMigrationService ...
	Tool1DatabaseMigrationService Tool1 = "DatabaseMigrationService"
	// Tool1DataMigrationAssistant ...
	Tool1DataMigrationAssistant Tool1 = "DataMigrationAssistant"
	// Tool1ServerAssessment ...
	Tool1ServerAssessment Tool1 = "ServerAssessment"
	// Tool1ServerAssessmentV1 ...
	Tool1ServerAssessmentV1 Tool1 = "ServerAssessmentV1"
	// Tool1ServerDiscovery ...
	Tool1ServerDiscovery Tool1 = "ServerDiscovery"
	// Tool1ServerMigration ...
	Tool1ServerMigration Tool1 = "ServerMigration"
	// Tool1ServerMigrationReplication ...
	Tool1ServerMigrationReplication Tool1 = "ServerMigration_Replication"
	// Tool1Turbonomic ...
	Tool1Turbonomic Tool1 = "Turbonomic"
	// Tool1Zerto ...
	Tool1Zerto Tool1 = "Zerto"
)

// PossibleTool1Values returns an array of possible values for the Tool1 const type.
func PossibleTool1Values() []Tool1 {
	return []Tool1{Tool1Carbonite, Tool1Cloudamize, Tool1CorentTech, Tool1DatabaseMigrationService, Tool1DataMigrationAssistant, Tool1ServerAssessment, Tool1ServerAssessmentV1, Tool1ServerDiscovery, Tool1ServerMigration, Tool1ServerMigrationReplication, Tool1Turbonomic, Tool1Zerto}
}

// TypeKind enumerates the values for type kind.
type TypeKind string

const (
	// TypeKindCollection ...
	TypeKindCollection TypeKind = "Collection"
	// TypeKindComplex ...
	TypeKindComplex TypeKind = "Complex"
	// TypeKindEntity ...
	TypeKindEntity TypeKind = "Entity"
	// TypeKindEntityReference ...
	TypeKindEntityReference TypeKind = "EntityReference"
	// TypeKindEnum ...
	TypeKindEnum TypeKind = "Enum"
	// TypeKindNone ...
	TypeKindNone TypeKind = "None"
	// TypeKindPath ...
	TypeKindPath TypeKind = "Path"
	// TypeKindPrimitive ...
	TypeKindPrimitive TypeKind = "Primitive"
	// TypeKindTypeDefinition ...
	TypeKindTypeDefinition TypeKind = "TypeDefinition"
	// TypeKindUntyped ...
	TypeKindUntyped TypeKind = "Untyped"
)

// PossibleTypeKindValues returns an array of possible values for the TypeKind const type.
func PossibleTypeKindValues() []TypeKind {
	return []TypeKind{TypeKindCollection, TypeKindComplex, TypeKindEntity, TypeKindEntityReference, TypeKindEnum, TypeKindNone, TypeKindPath, TypeKindPrimitive, TypeKindTypeDefinition, TypeKindUntyped}
}

// TypeKind1 enumerates the values for type kind 1.
type TypeKind1 string

const (
	// TypeKind1Collection ...
	TypeKind1Collection TypeKind1 = "Collection"
	// TypeKind1Complex ...
	TypeKind1Complex TypeKind1 = "Complex"
	// TypeKind1Entity ...
	TypeKind1Entity TypeKind1 = "Entity"
	// TypeKind1EntityReference ...
	TypeKind1EntityReference TypeKind1 = "EntityReference"
	// TypeKind1Enum ...
	TypeKind1Enum TypeKind1 = "Enum"
	// TypeKind1None ...
	TypeKind1None TypeKind1 = "None"
	// TypeKind1Path ...
	TypeKind1Path TypeKind1 = "Path"
	// TypeKind1Primitive ...
	TypeKind1Primitive TypeKind1 = "Primitive"
	// TypeKind1TypeDefinition ...
	TypeKind1TypeDefinition TypeKind1 = "TypeDefinition"
	// TypeKind1Untyped ...
	TypeKind1Untyped TypeKind1 = "Untyped"
)

// PossibleTypeKind1Values returns an array of possible values for the TypeKind1 const type.
func PossibleTypeKind1Values() []TypeKind1 {
	return []TypeKind1{TypeKind1Collection, TypeKind1Complex, TypeKind1Entity, TypeKind1EntityReference, TypeKind1Enum, TypeKind1None, TypeKind1Path, TypeKind1Primitive, TypeKind1TypeDefinition, TypeKind1Untyped}
}
