package labservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VirtualMachinesClient is the client for the VirtualMachines methods of the Labservices service.
type VirtualMachinesClient struct {
	BaseClient
}

// NewVirtualMachinesClient creates an instance of the VirtualMachinesClient client.
func NewVirtualMachinesClient(subscriptionID string) VirtualMachinesClient {
	return NewVirtualMachinesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVirtualMachinesClientWithBaseURI creates an instance of the VirtualMachinesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewVirtualMachinesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachinesClient {
	return VirtualMachinesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get returns the properties for a lab virtual machine.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// virtualMachineName - the ID of the virtual machine that uniquely identifies it within the containing lab.
// Used in resource URIs.
func (client VirtualMachinesClient) Get(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (result VirtualMachine, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: virtualMachineName,
			Constraints: []validation.Constraint{{Target: "virtualMachineName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "virtualMachineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "virtualMachineName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.VirtualMachinesClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, labName, virtualMachineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VirtualMachinesClient) GetPreparer(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":            autorest.Encode("path", labName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"virtualMachineName": autorest.Encode("path", virtualMachineName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/virtualMachines/{virtualMachineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachinesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VirtualMachinesClient) GetResponder(resp *http.Response) (result VirtualMachine, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByLab returns a list of all virtual machines for a lab.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// filter - the filter to apply to the operation.
func (client VirtualMachinesClient) ListByLab(ctx context.Context, resourceGroupName string, labName string, filter string) (result PagedVirtualMachinesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.ListByLab")
		defer func() {
			sc := -1
			if result.pvm.Response.Response != nil {
				sc = result.pvm.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.VirtualMachinesClient", "ListByLab", err.Error())
	}

	result.fn = client.listByLabNextResults
	req, err := client.ListByLabPreparer(ctx, resourceGroupName, labName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "ListByLab", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByLabSender(req)
	if err != nil {
		result.pvm.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "ListByLab", resp, "Failure sending request")
		return
	}

	result.pvm, err = client.ListByLabResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "ListByLab", resp, "Failure responding to request")
		return
	}
	if result.pvm.hasNextLink() && result.pvm.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByLabPreparer prepares the ListByLab request.
func (client VirtualMachinesClient) ListByLabPreparer(ctx context.Context, resourceGroupName string, labName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":           autorest.Encode("path", labName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/virtualMachines", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByLabSender sends the ListByLab request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachinesClient) ListByLabSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByLabResponder handles the response to the ListByLab request. The method always
// closes the http.Response Body.
func (client VirtualMachinesClient) ListByLabResponder(resp *http.Response) (result PagedVirtualMachines, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByLabNextResults retrieves the next set of results, if any.
func (client VirtualMachinesClient) listByLabNextResults(ctx context.Context, lastResults PagedVirtualMachines) (result PagedVirtualMachines, err error) {
	req, err := lastResults.pagedVirtualMachinesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "listByLabNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByLabSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "listByLabNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByLabResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "listByLabNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByLabComplete enumerates all values, automatically crossing page boundaries as required.
func (client VirtualMachinesClient) ListByLabComplete(ctx context.Context, resourceGroupName string, labName string, filter string) (result PagedVirtualMachinesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.ListByLab")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByLab(ctx, resourceGroupName, labName, filter)
	return
}

// Redeploy action to redeploy a lab virtual machine to a different compute node. For troubleshooting connectivity.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// virtualMachineName - the ID of the virtual machine that uniquely identifies it within the containing lab.
// Used in resource URIs.
func (client VirtualMachinesClient) Redeploy(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (result VirtualMachinesRedeployFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.Redeploy")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: virtualMachineName,
			Constraints: []validation.Constraint{{Target: "virtualMachineName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "virtualMachineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "virtualMachineName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.VirtualMachinesClient", "Redeploy", err.Error())
	}

	req, err := client.RedeployPreparer(ctx, resourceGroupName, labName, virtualMachineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Redeploy", nil, "Failure preparing request")
		return
	}

	result, err = client.RedeploySender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Redeploy", result.Response(), "Failure sending request")
		return
	}

	return
}

// RedeployPreparer prepares the Redeploy request.
func (client VirtualMachinesClient) RedeployPreparer(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":            autorest.Encode("path", labName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"virtualMachineName": autorest.Encode("path", virtualMachineName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/virtualMachines/{virtualMachineName}/redeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RedeploySender sends the Redeploy request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachinesClient) RedeploySender(req *http.Request) (future VirtualMachinesRedeployFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// RedeployResponder handles the response to the Redeploy request. The method always
// closes the http.Response Body.
func (client VirtualMachinesClient) RedeployResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Reimage re-image a lab virtual machine. The virtual machine will be deleted and recreated using the latest published
// snapshot of the reference environment of the lab.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// virtualMachineName - the ID of the virtual machine that uniquely identifies it within the containing lab.
// Used in resource URIs.
func (client VirtualMachinesClient) Reimage(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (result VirtualMachinesReimageFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.Reimage")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: virtualMachineName,
			Constraints: []validation.Constraint{{Target: "virtualMachineName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "virtualMachineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "virtualMachineName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.VirtualMachinesClient", "Reimage", err.Error())
	}

	req, err := client.ReimagePreparer(ctx, resourceGroupName, labName, virtualMachineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Reimage", nil, "Failure preparing request")
		return
	}

	result, err = client.ReimageSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Reimage", result.Response(), "Failure sending request")
		return
	}

	return
}

// ReimagePreparer prepares the Reimage request.
func (client VirtualMachinesClient) ReimagePreparer(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":            autorest.Encode("path", labName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"virtualMachineName": autorest.Encode("path", virtualMachineName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/virtualMachines/{virtualMachineName}/reimage", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReimageSender sends the Reimage request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachinesClient) ReimageSender(req *http.Request) (future VirtualMachinesReimageFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ReimageResponder handles the response to the Reimage request. The method always
// closes the http.Response Body.
func (client VirtualMachinesClient) ReimageResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ResetPassword resets a lab virtual machine password.
// Parameters:
// body - the request body.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// virtualMachineName - the ID of the virtual machine that uniquely identifies it within the containing lab.
// Used in resource URIs.
func (client VirtualMachinesClient) ResetPassword(ctx context.Context, body ResetPasswordBody, resourceGroupName string, labName string, virtualMachineName string) (result VirtualMachinesResetPasswordFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.ResetPassword")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.Username", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "body.Password", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: virtualMachineName,
			Constraints: []validation.Constraint{{Target: "virtualMachineName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "virtualMachineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "virtualMachineName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.VirtualMachinesClient", "ResetPassword", err.Error())
	}

	req, err := client.ResetPasswordPreparer(ctx, body, resourceGroupName, labName, virtualMachineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "ResetPassword", nil, "Failure preparing request")
		return
	}

	result, err = client.ResetPasswordSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "ResetPassword", result.Response(), "Failure sending request")
		return
	}

	return
}

// ResetPasswordPreparer prepares the ResetPassword request.
func (client VirtualMachinesClient) ResetPasswordPreparer(ctx context.Context, body ResetPasswordBody, resourceGroupName string, labName string, virtualMachineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":            autorest.Encode("path", labName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"virtualMachineName": autorest.Encode("path", virtualMachineName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/virtualMachines/{virtualMachineName}/resetPassword", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResetPasswordSender sends the ResetPassword request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachinesClient) ResetPasswordSender(req *http.Request) (future VirtualMachinesResetPasswordFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ResetPasswordResponder handles the response to the ResetPassword request. The method always
// closes the http.Response Body.
func (client VirtualMachinesClient) ResetPasswordResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Start action to start a lab virtual machine.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// virtualMachineName - the ID of the virtual machine that uniquely identifies it within the containing lab.
// Used in resource URIs.
func (client VirtualMachinesClient) Start(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (result VirtualMachinesStartFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.Start")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: virtualMachineName,
			Constraints: []validation.Constraint{{Target: "virtualMachineName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "virtualMachineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "virtualMachineName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.VirtualMachinesClient", "Start", err.Error())
	}

	req, err := client.StartPreparer(ctx, resourceGroupName, labName, virtualMachineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Start", nil, "Failure preparing request")
		return
	}

	result, err = client.StartSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Start", result.Response(), "Failure sending request")
		return
	}

	return
}

// StartPreparer prepares the Start request.
func (client VirtualMachinesClient) StartPreparer(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":            autorest.Encode("path", labName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"virtualMachineName": autorest.Encode("path", virtualMachineName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/virtualMachines/{virtualMachineName}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StartSender sends the Start request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachinesClient) StartSender(req *http.Request) (future VirtualMachinesStartFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// StartResponder handles the response to the Start request. The method always
// closes the http.Response Body.
func (client VirtualMachinesClient) StartResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Stop action to stop a lab virtual machine.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// virtualMachineName - the ID of the virtual machine that uniquely identifies it within the containing lab.
// Used in resource URIs.
func (client VirtualMachinesClient) Stop(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (result VirtualMachinesStopFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesClient.Stop")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: virtualMachineName,
			Constraints: []validation.Constraint{{Target: "virtualMachineName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "virtualMachineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "virtualMachineName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.VirtualMachinesClient", "Stop", err.Error())
	}

	req, err := client.StopPreparer(ctx, resourceGroupName, labName, virtualMachineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Stop", nil, "Failure preparing request")
		return
	}

	result, err = client.StopSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesClient", "Stop", result.Response(), "Failure sending request")
		return
	}

	return
}

// StopPreparer prepares the Stop request.
func (client VirtualMachinesClient) StopPreparer(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":            autorest.Encode("path", labName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"virtualMachineName": autorest.Encode("path", virtualMachineName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/virtualMachines/{virtualMachineName}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StopSender sends the Stop request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachinesClient) StopSender(req *http.Request) (future VirtualMachinesStopFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// StopResponder handles the response to the Stop request. The method always
// closes the http.Response Body.
func (client VirtualMachinesClient) StopResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
