package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessPolicyUpdateKind enumerates the values for access policy update kind.
type AccessPolicyUpdateKind string

const (
	// AccessPolicyUpdateKindAdd ...
	AccessPolicyUpdateKindAdd AccessPolicyUpdateKind = "add"
	// AccessPolicyUpdateKindRemove ...
	AccessPolicyUpdateKindRemove AccessPolicyUpdateKind = "remove"
	// AccessPolicyUpdateKindReplace ...
	AccessPolicyUpdateKindReplace AccessPolicyUpdateKind = "replace"
)

// PossibleAccessPolicyUpdateKindValues returns an array of possible values for the AccessPolicyUpdateKind const type.
func PossibleAccessPolicyUpdateKindValues() []AccessPolicyUpdateKind {
	return []AccessPolicyUpdateKind{AccessPolicyUpdateKindAdd, AccessPolicyUpdateKindRemove, AccessPolicyUpdateKindReplace}
}

// ActionsRequired enumerates the values for actions required.
type ActionsRequired string

const (
	// ActionsRequiredNone ...
	ActionsRequiredNone ActionsRequired = "None"
)

// PossibleActionsRequiredValues returns an array of possible values for the ActionsRequired const type.
func PossibleActionsRequiredValues() []ActionsRequired {
	return []ActionsRequired{ActionsRequiredNone}
}

// CertificatePermissions enumerates the values for certificate permissions.
type CertificatePermissions string

const (
	// CertificatePermissionsAll ...
	CertificatePermissionsAll CertificatePermissions = "all"
	// CertificatePermissionsBackup ...
	CertificatePermissionsBackup CertificatePermissions = "backup"
	// CertificatePermissionsCreate ...
	CertificatePermissionsCreate CertificatePermissions = "create"
	// CertificatePermissionsDelete ...
	CertificatePermissionsDelete CertificatePermissions = "delete"
	// CertificatePermissionsDeleteissuers ...
	CertificatePermissionsDeleteissuers CertificatePermissions = "deleteissuers"
	// CertificatePermissionsGet ...
	CertificatePermissionsGet CertificatePermissions = "get"
	// CertificatePermissionsGetissuers ...
	CertificatePermissionsGetissuers CertificatePermissions = "getissuers"
	// CertificatePermissionsImport ...
	CertificatePermissionsImport CertificatePermissions = "import"
	// CertificatePermissionsList ...
	CertificatePermissionsList CertificatePermissions = "list"
	// CertificatePermissionsListissuers ...
	CertificatePermissionsListissuers CertificatePermissions = "listissuers"
	// CertificatePermissionsManagecontacts ...
	CertificatePermissionsManagecontacts CertificatePermissions = "managecontacts"
	// CertificatePermissionsManageissuers ...
	CertificatePermissionsManageissuers CertificatePermissions = "manageissuers"
	// CertificatePermissionsPurge ...
	CertificatePermissionsPurge CertificatePermissions = "purge"
	// CertificatePermissionsRecover ...
	CertificatePermissionsRecover CertificatePermissions = "recover"
	// CertificatePermissionsRestore ...
	CertificatePermissionsRestore CertificatePermissions = "restore"
	// CertificatePermissionsSetissuers ...
	CertificatePermissionsSetissuers CertificatePermissions = "setissuers"
	// CertificatePermissionsUpdate ...
	CertificatePermissionsUpdate CertificatePermissions = "update"
)

// PossibleCertificatePermissionsValues returns an array of possible values for the CertificatePermissions const type.
func PossibleCertificatePermissionsValues() []CertificatePermissions {
	return []CertificatePermissions{CertificatePermissionsAll, CertificatePermissionsBackup, CertificatePermissionsCreate, CertificatePermissionsDelete, CertificatePermissionsDeleteissuers, CertificatePermissionsGet, CertificatePermissionsGetissuers, CertificatePermissionsImport, CertificatePermissionsList, CertificatePermissionsListissuers, CertificatePermissionsManagecontacts, CertificatePermissionsManageissuers, CertificatePermissionsPurge, CertificatePermissionsRecover, CertificatePermissionsRestore, CertificatePermissionsSetissuers, CertificatePermissionsUpdate}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "default"
	// CreateModeRecover ...
	CreateModeRecover CreateMode = "recover"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeDefault, CreateModeRecover}
}

// DeletionRecoveryLevel enumerates the values for deletion recovery level.
type DeletionRecoveryLevel string

const (
	// DeletionRecoveryLevelPurgeable ...
	DeletionRecoveryLevelPurgeable DeletionRecoveryLevel = "Purgeable"
	// DeletionRecoveryLevelRecoverable ...
	DeletionRecoveryLevelRecoverable DeletionRecoveryLevel = "Recoverable"
	// DeletionRecoveryLevelRecoverableProtectedSubscription ...
	DeletionRecoveryLevelRecoverableProtectedSubscription DeletionRecoveryLevel = "Recoverable+ProtectedSubscription"
	// DeletionRecoveryLevelRecoverablePurgeable ...
	DeletionRecoveryLevelRecoverablePurgeable DeletionRecoveryLevel = "Recoverable+Purgeable"
)

// PossibleDeletionRecoveryLevelValues returns an array of possible values for the DeletionRecoveryLevel const type.
func PossibleDeletionRecoveryLevelValues() []DeletionRecoveryLevel {
	return []DeletionRecoveryLevel{DeletionRecoveryLevelPurgeable, DeletionRecoveryLevelRecoverable, DeletionRecoveryLevelRecoverableProtectedSubscription, DeletionRecoveryLevelRecoverablePurgeable}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeApplication ...
	IdentityTypeApplication IdentityType = "Application"
	// IdentityTypeKey ...
	IdentityTypeKey IdentityType = "Key"
	// IdentityTypeManagedIdentity ...
	IdentityTypeManagedIdentity IdentityType = "ManagedIdentity"
	// IdentityTypeUser ...
	IdentityTypeUser IdentityType = "User"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeApplication, IdentityTypeKey, IdentityTypeManagedIdentity, IdentityTypeUser}
}

// JSONWebKeyCurveName enumerates the values for json web key curve name.
type JSONWebKeyCurveName string

const (
	// JSONWebKeyCurveNameP256 ...
	JSONWebKeyCurveNameP256 JSONWebKeyCurveName = "P-256"
	// JSONWebKeyCurveNameP256K ...
	JSONWebKeyCurveNameP256K JSONWebKeyCurveName = "P-256K"
	// JSONWebKeyCurveNameP384 ...
	JSONWebKeyCurveNameP384 JSONWebKeyCurveName = "P-384"
	// JSONWebKeyCurveNameP521 ...
	JSONWebKeyCurveNameP521 JSONWebKeyCurveName = "P-521"
)

// PossibleJSONWebKeyCurveNameValues returns an array of possible values for the JSONWebKeyCurveName const type.
func PossibleJSONWebKeyCurveNameValues() []JSONWebKeyCurveName {
	return []JSONWebKeyCurveName{JSONWebKeyCurveNameP256, JSONWebKeyCurveNameP256K, JSONWebKeyCurveNameP384, JSONWebKeyCurveNameP521}
}

// JSONWebKeyOperation enumerates the values for json web key operation.
type JSONWebKeyOperation string

const (
	// JSONWebKeyOperationDecrypt ...
	JSONWebKeyOperationDecrypt JSONWebKeyOperation = "decrypt"
	// JSONWebKeyOperationEncrypt ...
	JSONWebKeyOperationEncrypt JSONWebKeyOperation = "encrypt"
	// JSONWebKeyOperationImport ...
	JSONWebKeyOperationImport JSONWebKeyOperation = "import"
	// JSONWebKeyOperationSign ...
	JSONWebKeyOperationSign JSONWebKeyOperation = "sign"
	// JSONWebKeyOperationUnwrapKey ...
	JSONWebKeyOperationUnwrapKey JSONWebKeyOperation = "unwrapKey"
	// JSONWebKeyOperationVerify ...
	JSONWebKeyOperationVerify JSONWebKeyOperation = "verify"
	// JSONWebKeyOperationWrapKey ...
	JSONWebKeyOperationWrapKey JSONWebKeyOperation = "wrapKey"
)

// PossibleJSONWebKeyOperationValues returns an array of possible values for the JSONWebKeyOperation const type.
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return []JSONWebKeyOperation{JSONWebKeyOperationDecrypt, JSONWebKeyOperationEncrypt, JSONWebKeyOperationImport, JSONWebKeyOperationSign, JSONWebKeyOperationUnwrapKey, JSONWebKeyOperationVerify, JSONWebKeyOperationWrapKey}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// JSONWebKeyTypeEC ...
	JSONWebKeyTypeEC JSONWebKeyType = "EC"
	// JSONWebKeyTypeECHSM ...
	JSONWebKeyTypeECHSM JSONWebKeyType = "EC-HSM"
	// JSONWebKeyTypeRSA ...
	JSONWebKeyTypeRSA JSONWebKeyType = "RSA"
	// JSONWebKeyTypeRSAHSM ...
	JSONWebKeyTypeRSAHSM JSONWebKeyType = "RSA-HSM"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{JSONWebKeyTypeEC, JSONWebKeyTypeECHSM, JSONWebKeyTypeRSA, JSONWebKeyTypeRSAHSM}
}

// KeyPermissions enumerates the values for key permissions.
type KeyPermissions string

const (
	// KeyPermissionsAll ...
	KeyPermissionsAll KeyPermissions = "all"
	// KeyPermissionsBackup ...
	KeyPermissionsBackup KeyPermissions = "backup"
	// KeyPermissionsCreate ...
	KeyPermissionsCreate KeyPermissions = "create"
	// KeyPermissionsDecrypt ...
	KeyPermissionsDecrypt KeyPermissions = "decrypt"
	// KeyPermissionsDelete ...
	KeyPermissionsDelete KeyPermissions = "delete"
	// KeyPermissionsEncrypt ...
	KeyPermissionsEncrypt KeyPermissions = "encrypt"
	// KeyPermissionsGet ...
	KeyPermissionsGet KeyPermissions = "get"
	// KeyPermissionsImport ...
	KeyPermissionsImport KeyPermissions = "import"
	// KeyPermissionsList ...
	KeyPermissionsList KeyPermissions = "list"
	// KeyPermissionsPurge ...
	KeyPermissionsPurge KeyPermissions = "purge"
	// KeyPermissionsRecover ...
	KeyPermissionsRecover KeyPermissions = "recover"
	// KeyPermissionsRestore ...
	KeyPermissionsRestore KeyPermissions = "restore"
	// KeyPermissionsSign ...
	KeyPermissionsSign KeyPermissions = "sign"
	// KeyPermissionsUnwrapKey ...
	KeyPermissionsUnwrapKey KeyPermissions = "unwrapKey"
	// KeyPermissionsUpdate ...
	KeyPermissionsUpdate KeyPermissions = "update"
	// KeyPermissionsVerify ...
	KeyPermissionsVerify KeyPermissions = "verify"
	// KeyPermissionsWrapKey ...
	KeyPermissionsWrapKey KeyPermissions = "wrapKey"
)

// PossibleKeyPermissionsValues returns an array of possible values for the KeyPermissions const type.
func PossibleKeyPermissionsValues() []KeyPermissions {
	return []KeyPermissions{KeyPermissionsAll, KeyPermissionsBackup, KeyPermissionsCreate, KeyPermissionsDecrypt, KeyPermissionsDelete, KeyPermissionsEncrypt, KeyPermissionsGet, KeyPermissionsImport, KeyPermissionsList, KeyPermissionsPurge, KeyPermissionsRecover, KeyPermissionsRestore, KeyPermissionsSign, KeyPermissionsUnwrapKey, KeyPermissionsUpdate, KeyPermissionsVerify, KeyPermissionsWrapKey}
}

// ManagedHsmSkuName enumerates the values for managed hsm sku name.
type ManagedHsmSkuName string

const (
	// ManagedHsmSkuNameCustomB32 ...
	ManagedHsmSkuNameCustomB32 ManagedHsmSkuName = "Custom_B32"
	// ManagedHsmSkuNameStandardB1 ...
	ManagedHsmSkuNameStandardB1 ManagedHsmSkuName = "Standard_B1"
)

// PossibleManagedHsmSkuNameValues returns an array of possible values for the ManagedHsmSkuName const type.
func PossibleManagedHsmSkuNameValues() []ManagedHsmSkuName {
	return []ManagedHsmSkuName{ManagedHsmSkuNameCustomB32, ManagedHsmSkuNameStandardB1}
}

// NetworkRuleAction enumerates the values for network rule action.
type NetworkRuleAction string

const (
	// NetworkRuleActionAllow ...
	NetworkRuleActionAllow NetworkRuleAction = "Allow"
	// NetworkRuleActionDeny ...
	NetworkRuleActionDeny NetworkRuleAction = "Deny"
)

// PossibleNetworkRuleActionValues returns an array of possible values for the NetworkRuleAction const type.
func PossibleNetworkRuleActionValues() []NetworkRuleAction {
	return []NetworkRuleAction{NetworkRuleActionAllow, NetworkRuleActionDeny}
}

// NetworkRuleBypassOptions enumerates the values for network rule bypass options.
type NetworkRuleBypassOptions string

const (
	// NetworkRuleBypassOptionsAzureServices ...
	NetworkRuleBypassOptionsAzureServices NetworkRuleBypassOptions = "AzureServices"
	// NetworkRuleBypassOptionsNone ...
	NetworkRuleBypassOptionsNone NetworkRuleBypassOptions = "None"
)

// PossibleNetworkRuleBypassOptionsValues returns an array of possible values for the NetworkRuleBypassOptions const type.
func PossibleNetworkRuleBypassOptionsValues() []NetworkRuleBypassOptions {
	return []NetworkRuleBypassOptions{NetworkRuleBypassOptionsAzureServices, NetworkRuleBypassOptionsNone}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateDisconnected ...
	PrivateEndpointConnectionProvisioningStateDisconnected PrivateEndpointConnectionProvisioningState = "Disconnected"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
	// PrivateEndpointConnectionProvisioningStateUpdating ...
	PrivateEndpointConnectionProvisioningStateUpdating PrivateEndpointConnectionProvisioningState = "Updating"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateDisconnected, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded, PrivateEndpointConnectionProvisioningStateUpdating}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// PrivateEndpointServiceConnectionStatusApproved ...
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	// PrivateEndpointServiceConnectionStatusDisconnected ...
	PrivateEndpointServiceConnectionStatusDisconnected PrivateEndpointServiceConnectionStatus = "Disconnected"
	// PrivateEndpointServiceConnectionStatusPending ...
	PrivateEndpointServiceConnectionStatusPending PrivateEndpointServiceConnectionStatus = "Pending"
	// PrivateEndpointServiceConnectionStatusRejected ...
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{PrivateEndpointServiceConnectionStatusApproved, PrivateEndpointServiceConnectionStatusDisconnected, PrivateEndpointServiceConnectionStatusPending, PrivateEndpointServiceConnectionStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateActivated The managed HSM pool is ready for normal use.
	ProvisioningStateActivated ProvisioningState = "Activated"
	// ProvisioningStateDeleting The managed HSM Pool is currently being deleted.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed Provisioning of the managed HSM Pool has failed.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning The managed HSM Pool is currently being provisioned.
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateRestoring The managed HSM pool is being restored from full HSM backup.
	ProvisioningStateRestoring ProvisioningState = "Restoring"
	// ProvisioningStateSecurityDomainRestore The managed HSM pool is waiting for a security domain restore
	// action.
	ProvisioningStateSecurityDomainRestore ProvisioningState = "SecurityDomainRestore"
	// ProvisioningStateSucceeded The managed HSM Pool has been full provisioned.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating The managed HSM Pool is currently being updated.
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateActivated, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateRestoring, ProvisioningStateSecurityDomainRestore, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// ReasonAccountNameInvalid ...
	ReasonAccountNameInvalid Reason = "AccountNameInvalid"
	// ReasonAlreadyExists ...
	ReasonAlreadyExists Reason = "AlreadyExists"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{ReasonAccountNameInvalid, ReasonAlreadyExists}
}

// SecretPermissions enumerates the values for secret permissions.
type SecretPermissions string

const (
	// SecretPermissionsAll ...
	SecretPermissionsAll SecretPermissions = "all"
	// SecretPermissionsBackup ...
	SecretPermissionsBackup SecretPermissions = "backup"
	// SecretPermissionsDelete ...
	SecretPermissionsDelete SecretPermissions = "delete"
	// SecretPermissionsGet ...
	SecretPermissionsGet SecretPermissions = "get"
	// SecretPermissionsList ...
	SecretPermissionsList SecretPermissions = "list"
	// SecretPermissionsPurge ...
	SecretPermissionsPurge SecretPermissions = "purge"
	// SecretPermissionsRecover ...
	SecretPermissionsRecover SecretPermissions = "recover"
	// SecretPermissionsRestore ...
	SecretPermissionsRestore SecretPermissions = "restore"
	// SecretPermissionsSet ...
	SecretPermissionsSet SecretPermissions = "set"
)

// PossibleSecretPermissionsValues returns an array of possible values for the SecretPermissions const type.
func PossibleSecretPermissionsValues() []SecretPermissions {
	return []SecretPermissions{SecretPermissionsAll, SecretPermissionsBackup, SecretPermissionsDelete, SecretPermissionsGet, SecretPermissionsList, SecretPermissionsPurge, SecretPermissionsRecover, SecretPermissionsRestore, SecretPermissionsSet}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNamePremium ...
	SkuNamePremium SkuName = "premium"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNamePremium, SkuNameStandard}
}

// StoragePermissions enumerates the values for storage permissions.
type StoragePermissions string

const (
	// StoragePermissionsAll ...
	StoragePermissionsAll StoragePermissions = "all"
	// StoragePermissionsBackup ...
	StoragePermissionsBackup StoragePermissions = "backup"
	// StoragePermissionsDelete ...
	StoragePermissionsDelete StoragePermissions = "delete"
	// StoragePermissionsDeletesas ...
	StoragePermissionsDeletesas StoragePermissions = "deletesas"
	// StoragePermissionsGet ...
	StoragePermissionsGet StoragePermissions = "get"
	// StoragePermissionsGetsas ...
	StoragePermissionsGetsas StoragePermissions = "getsas"
	// StoragePermissionsList ...
	StoragePermissionsList StoragePermissions = "list"
	// StoragePermissionsListsas ...
	StoragePermissionsListsas StoragePermissions = "listsas"
	// StoragePermissionsPurge ...
	StoragePermissionsPurge StoragePermissions = "purge"
	// StoragePermissionsRecover ...
	StoragePermissionsRecover StoragePermissions = "recover"
	// StoragePermissionsRegeneratekey ...
	StoragePermissionsRegeneratekey StoragePermissions = "regeneratekey"
	// StoragePermissionsRestore ...
	StoragePermissionsRestore StoragePermissions = "restore"
	// StoragePermissionsSet ...
	StoragePermissionsSet StoragePermissions = "set"
	// StoragePermissionsSetsas ...
	StoragePermissionsSetsas StoragePermissions = "setsas"
	// StoragePermissionsUpdate ...
	StoragePermissionsUpdate StoragePermissions = "update"
)

// PossibleStoragePermissionsValues returns an array of possible values for the StoragePermissions const type.
func PossibleStoragePermissionsValues() []StoragePermissions {
	return []StoragePermissions{StoragePermissionsAll, StoragePermissionsBackup, StoragePermissionsDelete, StoragePermissionsDeletesas, StoragePermissionsGet, StoragePermissionsGetsas, StoragePermissionsList, StoragePermissionsListsas, StoragePermissionsPurge, StoragePermissionsRecover, StoragePermissionsRegeneratekey, StoragePermissionsRestore, StoragePermissionsSet, StoragePermissionsSetsas, StoragePermissionsUpdate}
}

// VaultProvisioningState enumerates the values for vault provisioning state.
type VaultProvisioningState string

const (
	// VaultProvisioningStateRegisteringDNS ...
	VaultProvisioningStateRegisteringDNS VaultProvisioningState = "RegisteringDns"
	// VaultProvisioningStateSucceeded ...
	VaultProvisioningStateSucceeded VaultProvisioningState = "Succeeded"
)

// PossibleVaultProvisioningStateValues returns an array of possible values for the VaultProvisioningState const type.
func PossibleVaultProvisioningStateValues() []VaultProvisioningState {
	return []VaultProvisioningState{VaultProvisioningStateRegisteringDNS, VaultProvisioningStateSucceeded}
}
