package graphrbac

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ConsentType enumerates the values for consent type.
type ConsentType string

const (
	// AllPrincipals ...
	AllPrincipals ConsentType = "AllPrincipals"
	// Principal ...
	Principal ConsentType = "Principal"
)

// PossibleConsentTypeValues returns an array of possible values for the ConsentType const type.
func PossibleConsentTypeValues() []ConsentType {
	return []ConsentType{AllPrincipals, Principal}
}

// GroupMembershipClaimTypes enumerates the values for group membership claim types.
type GroupMembershipClaimTypes string

const (
	// All ...
	All GroupMembershipClaimTypes = "All"
	// None ...
	None GroupMembershipClaimTypes = "None"
	// SecurityGroup ...
	SecurityGroup GroupMembershipClaimTypes = "SecurityGroup"
)

// PossibleGroupMembershipClaimTypesValues returns an array of possible values for the GroupMembershipClaimTypes const type.
func PossibleGroupMembershipClaimTypesValues() []GroupMembershipClaimTypes {
	return []GroupMembershipClaimTypes{All, None, SecurityGroup}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// ObjectTypeApplication ...
	ObjectTypeApplication ObjectType = "Application"
	// ObjectTypeDirectoryObject ...
	ObjectTypeDirectoryObject ObjectType = "DirectoryObject"
	// ObjectTypeGroup ...
	ObjectTypeGroup ObjectType = "Group"
	// ObjectTypeServicePrincipal ...
	ObjectTypeServicePrincipal ObjectType = "ServicePrincipal"
	// ObjectTypeUser ...
	ObjectTypeUser ObjectType = "User"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{ObjectTypeApplication, ObjectTypeDirectoryObject, ObjectTypeGroup, ObjectTypeServicePrincipal, ObjectTypeUser}
}

// UserType enumerates the values for user type.
type UserType string

const (
	// Guest ...
	Guest UserType = "Guest"
	// Member ...
	Member UserType = "Member"
)

// PossibleUserTypeValues returns an array of possible values for the UserType const type.
func PossibleUserTypeValues() []UserType {
	return []UserType{Guest, Member}
}
